/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;

class FlushListener {
    final ConcurrentMap<String, FlushAcknowledgementHolder> awaitingFlushed = new ConcurrentHashMap<String, FlushAcknowledgementHolder>();
    final RunOnce onClear = new RunOnce(() -> {
        Iterator latches = this.awaitingFlushed.entrySet().iterator();
        while (latches.hasNext()) {
            ((FlushAcknowledgementHolder)latches.next().getValue()).latch.countDown();
            latches.remove();
        }
    });

    FlushListener() {
    }

    @Nullable
    FlushAcknowledgement waitForFlush(String flushId, Duration timeout) throws Exception {
        if (this.onClear.hasRun()) {
            return null;
        }
        FlushAcknowledgementHolder holder = this.awaitingFlushed.computeIfAbsent(flushId, key -> new FlushAcknowledgementHolder(flushId));
        if (holder.latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            if (holder.flushException != null) {
                throw holder.flushException;
            }
            return holder.flushAcknowledgement;
        }
        return null;
    }

    void acknowledgeFlush(FlushAcknowledgement flushAcknowledgement, @Nullable Exception exception) {
        String flushId = flushAcknowledgement.getId();
        FlushAcknowledgementHolder holder = this.awaitingFlushed.computeIfAbsent(flushId, key -> new FlushAcknowledgementHolder(flushId));
        holder.flushAcknowledgement = flushAcknowledgement;
        holder.flushException = exception;
        holder.latch.countDown();
    }

    void clear(String flushId) {
        this.awaitingFlushed.remove(flushId);
    }

    void clear() {
        this.onClear.run();
    }

    private static class FlushAcknowledgementHolder {
        private final CountDownLatch latch;
        private volatile FlushAcknowledgement flushAcknowledgement;
        private volatile Exception flushException;

        private FlushAcknowledgementHolder(String flushId) {
            this.flushAcknowledgement = new FlushAcknowledgement(flushId, Long.valueOf(0L));
            this.latch = new CountDownLatch(1);
        }
    }
}

