/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetJobsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}", RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/anomaly_detectors", RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors")));
    }

    public String getName() {
        return "ml_get_jobs_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId)) {
            jobId = "_all";
        }
        GetJobsAction.Request request = new GetJobsAction.Request(jobId);
        if (restRequest.hasParam("allow_no_jobs")) {
            LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_jobs", "allow_no_match");
        }
        request.setAllowNoMatch(restRequest.paramAsBoolean("allow_no_match", restRequest.paramAsBoolean("allow_no_jobs", request.allowNoMatch())));
        return channel -> client.execute((ActionType)GetJobsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

