/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import java.util.List;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.http.nio.NioHttpResponse;
import org.elasticsearch.monitor.jvm.JvmInfo;

@ChannelHandler.Sharable
public class NioHttpResponseCreator
extends MessageToMessageEncoder<NioHttpResponse> {
    private static final String DO_NOT_SPLIT = "es.unsafe.do_not_split_http_responses";
    private static final boolean DO_NOT_SPLIT_HTTP_RESPONSES = Booleans.parseBoolean((String)System.getProperty("es.unsafe.do_not_split_http_responses"), (boolean)false);
    private static final int SPLIT_THRESHOLD = (int)((double)NioHttpResponseCreator.suggestedMaxAllocationSize() * 0.99);

    protected void encode(ChannelHandlerContext ctx, NioHttpResponse msg, List<Object> out) {
        if (DO_NOT_SPLIT_HTTP_RESPONSES || msg.content().readableBytes() <= SPLIT_THRESHOLD) {
            out.add(msg.retain());
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(msg.protocolVersion(), msg.status(), msg.headers());
            out.add(response);
            ByteBuf content = msg.content();
            while (content.readableBytes() > SPLIT_THRESHOLD) {
                out.add(new DefaultHttpContent(content.readRetainedSlice(SPLIT_THRESHOLD)));
            }
            out.add(new DefaultLastHttpContent(content.readRetainedSlice(content.readableBytes())));
        }
    }

    private static long suggestedMaxAllocationSize() {
        return Math.max(Math.max(JvmInfo.jvmInfo().getG1RegionSize(), 0L) >> 2, 262144L);
    }
}

