/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;

public class PutPipelineRequest
extends ActionRequest {
    private final String id;
    private final String source;
    private final XContentType xContentType;

    public PutPipelineRequest(String id, String source, XContentType xContentType) {
        this.id = id;
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public PutPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readString();
        this.xContentType = (XContentType)in.readEnum(XContentType.class);
    }

    public String id() {
        return this.id;
    }

    public String source() {
        return this.source;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeString(this.source);
        out.writeEnum((Enum)this.xContentType);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PutPipelineRequest that = (PutPipelineRequest)((Object)o);
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && this.xContentType == that.xContentType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.xContentType);
    }
}

