/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.constantkeyword.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class ConstantKeywordFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "constant_keyword";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private static ConstantKeywordFieldMapper toType(FieldMapper in) {
        return (ConstantKeywordFieldMapper)in;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    ConstantKeywordFieldMapper(String simpleName, MappedFieldType mappedFieldType) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    protected ConstantKeywordFieldMapper clone() {
        return (ConstantKeywordFieldMapper)super.clone();
    }

    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value;
        if (context.externalValueSet()) {
            value = context.externalValue().toString();
        } else {
            XContentParser parser = context.parser();
            value = parser.textOrNull();
        }
        if (value == null) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] doesn't accept [null] values");
        }
        if (this.fieldType().value == null) {
            ConstantKeywordFieldType newFieldType = new ConstantKeywordFieldType(this.fieldType().name(), value, this.fieldType().meta());
            ConstantKeywordFieldMapper update = new ConstantKeywordFieldMapper(this.simpleName(), (MappedFieldType)newFieldType);
            context.addDynamicMapper((Mapper)update);
        } else if (!Objects.equals(this.fieldType().value, value)) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] only accepts values that are equal to the value defined in the mappings [" + this.fieldType().value() + "], but got [" + value + "]");
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        private final String value;

        public ConstantKeywordFieldType(String name, String value, Map<String, String> meta) {
            super(name, meta);
            this.value = value;
        }

        public ConstantKeywordFieldType(String name, String value) {
            this(name, value, Collections.emptyMap());
        }

        public String value() {
            return this.value;
        }

        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "keyword";
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(this.value, this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.value == null ? lookup -> Collections.emptyList() : lookup -> Collections.singletonList(this.value);
        }

        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            if (this.value == null) {
                return false;
            }
            return Regex.simpleMatch((String)pattern, (String)this.value, (boolean)caseInsensitive);
        }

        public Query existsQuery(QueryShardContext context) {
            return this.value != null ? new MatchAllDocsQuery() : new MatchNoDocsQuery();
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            BytesRef valueAsBytesRef = new BytesRef((CharSequence)this.value);
            if (lowerTerm != null && BytesRefs.toBytesRef((Object)lowerTerm).compareTo(valueAsBytesRef) >= (includeLower ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            if (upperTerm != null && valueAsBytesRef.compareTo(BytesRefs.toBytesRef((Object)upperTerm)) >= (includeUpper ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
            String prefix;
            int cp;
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            String termAsString = BytesRefs.toString((Object)value);
            int maxEdits = fuzziness.asDistance(termAsString);
            int[] termText = new int[termAsString.codePointCount(0, termAsString.length())];
            int j = 0;
            for (int i = 0; i < termAsString.length(); i += Character.charCount(cp)) {
                termText[j++] = cp = termAsString.codePointAt(i);
            }
            int termLength = termText.length;
            String suffix = UnicodeUtil.newString((int[])termText, (int)(prefixLength = Math.min(prefixLength, termLength)), (int)(termText.length - prefixLength));
            LevenshteinAutomata builder = new LevenshteinAutomata(suffix, transpositions);
            Automaton automaton = builder.toAutomaton(maxEdits, prefix = UnicodeUtil.newString((int[])termText, (int)0, (int)prefixLength));
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            Automaton automaton = new RegExp(value, syntaxFlags, matchFlags).toAutomaton(maxDeterminizedStates);
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> value = new ParametrizedFieldMapper.Parameter("value", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Number) && !(o instanceof CharSequence)) {
                throw new MapperParsingException("Property [value] on field [" + n + "] must be a number or a string, but got [" + o + "]");
            }
            return o.toString();
        }, m -> ConstantKeywordFieldType.access$100(ConstantKeywordFieldMapper.toType(m).fieldType()));
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
            this.value.setSerializerCheck((id, ic, v) -> v != null);
            this.value.setMergeValidator((previous, current) -> previous == null || Objects.equals(previous, current));
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.value, this.meta);
        }

        public ConstantKeywordFieldMapper build(Mapper.BuilderContext context) {
            return new ConstantKeywordFieldMapper(this.name, (MappedFieldType)new ConstantKeywordFieldType(this.buildFullName(context), (String)this.value.getValue(), (Map)this.meta.getValue()));
        }
    }
}

