/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.IndexInputStats;

public abstract class BaseSearchableSnapshotIndexInput
extends BufferedIndexInput {
    protected final BlobContainer blobContainer;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final IOContext context;
    protected final IndexInputStats stats;
    protected final long offset;
    protected final long length;
    protected volatile boolean isClone;
    private AtomicBoolean closed;

    public BaseSearchableSnapshotIndexInput(String resourceDesc, BlobContainer blobContainer, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long length) {
        super(resourceDesc, context);
        this.blobContainer = Objects.requireNonNull(blobContainer);
        this.fileInfo = Objects.requireNonNull(fileInfo);
        this.context = Objects.requireNonNull(context);
        assert (!fileInfo.metadata().hashEqualsContents()) : "this method should only be used with blobs that are NOT stored in metadata's hash field (fileInfo: " + fileInfo + ')';
        this.stats = Objects.requireNonNull(stats);
        this.offset = offset;
        this.length = length;
        this.closed = new AtomicBoolean(false);
        this.isClone = false;
    }

    public BaseSearchableSnapshotIndexInput(String resourceDesc, BlobContainer blobContainer, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long length, int bufferSize) {
        this(resourceDesc, blobContainer, fileInfo, context, stats, offset, length);
        this.setBufferSize(bufferSize);
    }

    public final long length() {
        return this.length;
    }

    public BaseSearchableSnapshotIndexInput clone() {
        BaseSearchableSnapshotIndexInput clone = (BaseSearchableSnapshotIndexInput)super.clone();
        clone.closed = new AtomicBoolean(false);
        clone.isClone = true;
        return clone;
    }

    protected void ensureOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException(this.toString() + " is closed");
        }
    }

    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (!this.isClone) {
                this.stats.incrementCloseCount();
            }
            this.innerClose();
        }
    }

    public abstract void innerClose() throws IOException;

    protected final boolean assertCurrentThreadMayAccessBlobStore() {
        String threadName = Thread.currentThread().getName();
        assert (threadName.contains("[snapshot]") || threadName.contains("[generic]") || threadName.contains("[search]") || threadName.contains("[search_throttled]") || threadName.contains("[searchable_snapshots_cache_fetch_async]") || threadName.contains("[searchable_snapshots_cache_prewarming]") || threadName.startsWith("TEST-") || threadName.startsWith("LuceneTestCase")) : "current thread [" + Thread.currentThread() + "] may not read " + this.fileInfo;
        return true;
    }
}

