/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.indices.recovery.RecoveryState;

public final class SearchableSnapshotRecoveryState
extends RecoveryState {
    private boolean preWarmComplete;

    public SearchableSnapshotRecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, @Nullable DiscoveryNode sourceNode) {
        super(shardRouting, targetNode, sourceNode, (RecoveryState.Index)new Index());
    }

    public synchronized RecoveryState setStage(RecoveryState.Stage stage) {
        if (this.getStage() == RecoveryState.Stage.DONE) {
            return this;
        }
        if (!this.preWarmComplete && stage == RecoveryState.Stage.DONE) {
            this.validateCurrentStage(RecoveryState.Stage.FINALIZE);
            return this;
        }
        return super.setStage(stage);
    }

    public synchronized void setPreWarmComplete() {
        if (this.getStage() == RecoveryState.Stage.FINALIZE) {
            super.setStage(RecoveryState.Stage.DONE);
        }
        Index index = (Index)this.getIndex();
        index.stopTimer();
        this.preWarmComplete = true;
    }

    public synchronized boolean isPreWarmComplete() {
        return this.preWarmComplete;
    }

    public synchronized void ignoreFile(String name) {
        Index index = (Index)this.getIndex();
        index.addFileToIgnore(name);
    }

    private static class SearchableSnapshotRecoveryFilesDetails
    extends RecoveryState.RecoveryFilesDetails {
        private SearchableSnapshotRecoveryFilesDetails() {
        }

        public void addFileDetails(String name, long length, boolean reused) {
            RecoveryState.FileDetail fileDetail = this.fileDetails.computeIfAbsent(name, n -> new RecoveryState.FileDetail(name, length, reused));
            assert (fileDetail == null || fileDetail.name().equals(name) && fileDetail.length() == length) : "The file " + name + " was reported multiple times with different lengths: [" + fileDetail.length() + "] and [" + length + "]";
        }

        public void clear() {
            this.complete = false;
        }
    }

    private static final class Index
    extends RecoveryState.Index {
        private final Set<String> filesToIgnore = new HashSet<String>();

        private Index() {
            super((RecoveryState.RecoveryFilesDetails)new SearchableSnapshotRecoveryFilesDetails());
            super.start();
        }

        private synchronized void addFileToIgnore(String name) {
            this.filesToIgnore.add(name);
        }

        public synchronized void addFileDetail(String name, long length, boolean reused) {
            if (this.filesToIgnore.contains(name)) {
                return;
            }
            super.addFileDetail(name, length, reused);
        }

        public synchronized void start() {
        }

        public synchronized void stop() {
        }

        public synchronized void reset() {
        }

        private synchronized void stopTimer() {
            super.stop();
        }
    }
}

