/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.xpack.searchablesnapshots.cache.CacheService;

public class NodeEnvironmentCacheCleaner
implements Runnable {
    private final NodeEnvironment nodeEnvironment;

    public NodeEnvironmentCacheCleaner(NodeEnvironment nodeEnvironment) {
        this.nodeEnvironment = nodeEnvironment;
    }

    @Override
    public void run() {
        try {
            for (NodeEnvironment.NodePath nodePath : this.nodeEnvironment.nodePaths()) {
                for (String indexUUID : this.nodeEnvironment.availableIndexFoldersForPath(nodePath)) {
                    for (ShardId shardId : this.nodeEnvironment.findAllShardIds(new Index("_unknown_", indexUUID))) {
                        Path shardDataPath = nodePath.resolve(shardId);
                        ShardPath shardPath = new ShardPath(false, shardDataPath, shardDataPath, shardId);
                        Path shardCachePath = CacheService.getShardCachePath(shardPath);
                        if (!Files.isDirectory(shardCachePath, new LinkOption[0])) continue;
                        IOUtils.rm((Path[])new Path[]{shardCachePath});
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

