/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;

public class TransportGetStatusAction
extends TransportMasterNodeAction<GetStatusAction.Request, GetStatusAction.Response> {
    @Inject
    public TransportGetStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/operation_mode/get", transportService, clusterService, threadPool, actionFilters, GetStatusAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetStatusAction.Response read(StreamInput in) throws IOException {
        return new GetStatusAction.Response(in);
    }

    protected void masterOperation(GetStatusAction.Request request, ClusterState state, ActionListener<GetStatusAction.Response> listener) {
        IndexLifecycleMetadata metadata = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
        GetStatusAction.Response response = metadata == null ? new GetStatusAction.Response(OperationMode.RUNNING) : new GetStatusAction.Response(metadata.getOperationMode());
        listener.onResponse((Object)response);
    }

    protected ClusterBlockException checkBlock(GetStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

