/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportRetryAction
extends TransportMasterNodeAction<RetryAction.Request, RetryAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportRetryAction.class);
    IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportRetryAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/retry", transportService, clusterService, threadPool, actionFilters, RetryAction.Request::new, indexNameExpressionResolver);
        this.indexLifecycleService = indexLifecycleService;
    }

    protected String executor() {
        return "same";
    }

    protected RetryAction.Response read(StreamInput in) throws IOException {
        return new RetryAction.Response(in);
    }

    protected void masterOperation(final RetryAction.Request request, ClusterState state, ActionListener<RetryAction.Response> listener) {
        this.clusterService.submitStateUpdateTask("ilm-re-run", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<RetryAction.Response>((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportRetryAction.this.indexLifecycleService.moveClusterStateToPreviouslyFailedStep(currentState, request.indices());
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                for (String index : request.indices()) {
                    IndexMetadata idxMeta = newState.metadata().index(index);
                    LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
                    Step.StepKey retryStep = new Step.StepKey(lifecycleState.getPhase(), lifecycleState.getAction(), lifecycleState.getStep());
                    if (idxMeta == null) {
                        logger.debug("index [" + index + "] has been deleted after moving to step [" + lifecycleState.getStep() + "], skipping async action check");
                        return;
                    }
                    TransportRetryAction.this.indexLifecycleService.maybeRunAsyncAction(newState, idxMeta, retryStep);
                }
            }

            protected RetryAction.Response newResponse(boolean acknowledged) {
                return new RetryAction.Response(acknowledged);
            }
        });
    }

    protected ClusterBlockException checkBlock(RetryAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

