/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;

public class TransportExecuteSnapshotLifecycleAction
extends TransportMasterNodeAction<ExecuteSnapshotLifecycleAction.Request, ExecuteSnapshotLifecycleAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportExecuteSnapshotLifecycleAction.class);
    private final Client client;
    private final SnapshotHistoryStore historyStore;

    @Inject
    public TransportExecuteSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, SnapshotHistoryStore historyStore) {
        super("cluster:admin/slm/execute", transportService, clusterService, threadPool, actionFilters, ExecuteSnapshotLifecycleAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.historyStore = historyStore;
    }

    protected String executor() {
        return "generic";
    }

    protected ExecuteSnapshotLifecycleAction.Response read(StreamInput in) throws IOException {
        return new ExecuteSnapshotLifecycleAction.Response(in);
    }

    protected void masterOperation(ExecuteSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<ExecuteSnapshotLifecycleAction.Response> listener) {
        try {
            String policyId = request.getLifecycleId();
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
            if (snapMeta == null) {
                listener.onFailure((Exception)new IllegalArgumentException("no such snapshot lifecycle policy [" + policyId + "]"));
                return;
            }
            SnapshotLifecyclePolicyMetadata policyMetadata = (SnapshotLifecyclePolicyMetadata)snapMeta.getSnapshotConfigurations().get(policyId);
            if (policyMetadata == null) {
                listener.onFailure((Exception)new IllegalArgumentException("no such snapshot lifecycle policy [" + policyId + "]"));
                return;
            }
            Optional<String> snapshotName = SnapshotLifecycleTask.maybeTakeSnapshot(SnapshotLifecycleService.getJobId(policyMetadata), this.client, this.clusterService, this.historyStore);
            if (snapshotName.isPresent()) {
                listener.onResponse((Object)new ExecuteSnapshotLifecycleAction.Response(snapshotName.get()));
            } else {
                listener.onFailure((Exception)new ElasticsearchException("failed to execute snapshot lifecycle policy [" + policyId + "]", new Object[0]));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected ClusterBlockException checkBlock(ExecuteSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

