/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.payload;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.execution.payload.AbstractPayload;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.session.Payload;

public class EventPayload
extends AbstractPayload {
    private final List<EqlSearchResponse.Event> values;

    public EventPayload(SearchResponse response) {
        super(response.isTimedOut(), response.getTook());
        List<SearchHit> hits = RuntimeUtils.searchHits(response);
        this.values = new ArrayList<EqlSearchResponse.Event>(hits.size());
        for (SearchHit hit : hits) {
            this.values.add(new EqlSearchResponse.Event(hit.getIndex(), hit.getId(), hit.getSourceRef()));
        }
    }

    @Override
    public Payload.Type resultType() {
        return Payload.Type.EVENT;
    }

    public List<EqlSearchResponse.Event> values() {
        return this.values;
    }
}

