/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.planner;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRMatch;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringContains;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveNotEquals;
import org.elasticsearch.xpack.eql.planner.EqlTranslatorHandler;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseSensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslator;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.planner.TranslatorHandler;
import org.elasticsearch.xpack.ql.querydsl.query.NotQuery;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.querydsl.query.ScriptQuery;
import org.elasticsearch.xpack.ql.querydsl.query.TermQuery;
import org.elasticsearch.xpack.ql.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.ql.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

final class QueryTranslator {
    public static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = Arrays.asList(new ExpressionTranslator[]{new InsensitiveBinaryComparisons(), new ExpressionTranslators.BinaryComparisons(), new ExpressionTranslators.Ranges(), new BinaryLogic(), new ExpressionTranslators.IsNotNulls(), new ExpressionTranslators.IsNulls(), new ExpressionTranslators.Nots(), new ExpressionTranslators.Likes(), new ExpressionTranslators.InComparisons(), new CaseSensitiveScalarFunctions(), new Scalars()});

    QueryTranslator() {
    }

    public static Query toQuery(Expression e) {
        return QueryTranslator.toQuery(e, (TranslatorHandler)new EqlTranslatorHandler());
    }

    public static Query toQuery(Expression e, TranslatorHandler handler) {
        Query translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, handler);
            if (translation == null) continue;
            return translation;
        }
        throw new QlIllegalArgumentException("Don't know how to translate {} {}", new Object[]{e.nodeName(), e});
    }

    public static Object valueOf(Expression e) {
        if (e.foldable()) {
            return e.fold();
        }
        throw new QlIllegalArgumentException("Cannot determine value for {}", new Object[]{e});
    }

    public static class CaseSensitiveScalarFunctions
    extends ExpressionTranslator<CaseSensitiveScalarFunction> {
        protected Query asQuery(CaseSensitiveScalarFunction f, TranslatorHandler handler) {
            return f.isCaseSensitive() ? CaseSensitiveScalarFunctions.doTranslate(f, handler) : null;
        }

        public static Query doTranslate(CaseSensitiveScalarFunction f, TranslatorHandler handler) {
            Expression field = null;
            Expression constant = null;
            if (f instanceof StringContains) {
                StringContains sc = (StringContains)f;
                field = sc.string();
                constant = sc.substring();
            } else if (f instanceof EndsWith) {
                EndsWith ew = (EndsWith)f;
                field = ew.input();
                constant = ew.pattern();
            } else {
                return null;
            }
            if (field instanceof FieldAttribute && constant.foldable()) {
                String targetFieldName = handler.nameOf((Expression)((FieldAttribute)field).exactAttribute());
                String substring = (String)constant.fold();
                String query = "*" + substring + (f instanceof StringContains ? "*" : "");
                return new WildcardQuery(f.source(), targetFieldName, query);
            }
            return null;
        }
    }

    public static class Scalars
    extends ExpressionTranslator<ScalarFunction> {
        protected Query asQuery(ScalarFunction f, TranslatorHandler handler) {
            return Scalars.doTranslate(f, handler);
        }

        public static Query doTranslate(ScalarFunction f, TranslatorHandler handler) {
            CIDRMatch cm;
            Query q = ExpressionTranslators.Scalars.doKnownTranslate((ScalarFunction)f, (TranslatorHandler)handler);
            if (q != null) {
                return q;
            }
            if (f instanceof CIDRMatch && (cm = (CIDRMatch)f).input() instanceof FieldAttribute && Expressions.foldable(cm.addresses())) {
                String targetFieldName = handler.nameOf((Expression)((FieldAttribute)cm.input()).exactAttribute());
                LinkedHashSet<Object> set = new LinkedHashSet<Object>(CollectionUtils.mapSize((int)cm.addresses().size()));
                for (Expression e : cm.addresses()) {
                    set.add(QueryTranslator.valueOf(e));
                }
                return new TermsQuery(f.source(), targetFieldName, set);
            }
            return handler.wrapFunctionQuery(f, (Expression)f, (Query)new ScriptQuery(f.source(), f.asScript()));
        }
    }

    public static class BinaryLogic
    extends ExpressionTranslator<org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic> {
        protected Query asQuery(org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic e, TranslatorHandler handler) {
            if (e instanceof And) {
                return ExpressionTranslators.and((Source)e.source(), (Query)QueryTranslator.toQuery(e.left(), handler), (Query)QueryTranslator.toQuery(e.right(), handler));
            }
            if (e instanceof Or) {
                return ExpressionTranslators.or((Source)e.source(), (Query)QueryTranslator.toQuery(e.left(), handler), (Query)QueryTranslator.toQuery(e.right(), handler));
            }
            return null;
        }
    }

    public static class InsensitiveBinaryComparisons
    extends ExpressionTranslator<InsensitiveBinaryComparison> {
        protected Query asQuery(InsensitiveBinaryComparison bc, TranslatorHandler handler) {
            return InsensitiveBinaryComparisons.doTranslate(bc, handler);
        }

        public static Query doTranslate(InsensitiveBinaryComparison bc, TranslatorHandler handler) {
            InsensitiveBinaryComparisons.checkInsensitiveComparison(bc);
            return handler.wrapFunctionQuery((ScalarFunction)bc, bc.left(), InsensitiveBinaryComparisons.translate(bc, handler));
        }

        public static void checkInsensitiveComparison(InsensitiveBinaryComparison bc) {
            Check.isTrue((boolean)bc.right().foldable(), (String)"Line {}:{}: Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name((Expression)bc.right()), bc.symbol()});
        }

        private static Query translate(InsensitiveBinaryComparison bc, TranslatorHandler handler) {
            Source source = bc.source();
            String name = handler.nameOf(bc.left());
            Object value = QueryTranslator.valueOf(bc.right());
            if (bc instanceof InsensitiveEquals || bc instanceof InsensitiveNotEquals) {
                if (bc.left() instanceof FieldAttribute) {
                    name = ((FieldAttribute)bc.left()).exactAttribute().name();
                }
                TermQuery query = new TermQuery(source, name, value, true);
                if (bc instanceof InsensitiveNotEquals) {
                    query = new NotQuery(source, (Query)query);
                }
                return query;
            }
            throw new QlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", new Object[]{bc.right().nodeString(), bc});
        }
    }
}

