/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.querydsl.container;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.eql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.eql.querydsl.container.FieldExtractorRegistry;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ConstantInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class QueryContainer {
    private final FieldExtractorRegistry extractorRegistry = new FieldExtractorRegistry();
    private final Query query;
    private final AttributeMap<Expression> attributes;
    private final List<Tuple<FieldExtraction, String>> fields;
    private final Map<String, Sort> sort;
    private final boolean trackHits;
    private final boolean includeFrozen;
    private final Limit limit;

    public QueryContainer() {
        this(null, Collections.emptyList(), (AttributeMap<Expression>)AttributeMap.emptyAttributeMap(), Collections.emptyMap(), false, false, null);
    }

    private QueryContainer(Query query, List<Tuple<FieldExtraction, String>> fields, AttributeMap<Expression> attributes, Map<String, Sort> sort, boolean trackHits, boolean includeFrozen, Limit limit) {
        this.query = query;
        this.fields = fields;
        this.sort = sort;
        this.attributes = attributes;
        this.trackHits = trackHits;
        this.includeFrozen = includeFrozen;
        this.limit = limit;
    }

    public QueryContainer withFrozen() {
        throw new UnsupportedOperationException();
    }

    public Query query() {
        return this.query;
    }

    public List<Tuple<FieldExtraction, String>> fields() {
        return this.fields;
    }

    public Map<String, Sort> sort() {
        return this.sort;
    }

    public boolean shouldTrackHits() {
        return this.trackHits;
    }

    public Limit limit() {
        return this.limit;
    }

    public QueryContainer with(Query q) {
        return new QueryContainer(q, this.fields, this.attributes, this.sort, this.trackHits, this.includeFrozen, this.limit);
    }

    public QueryContainer with(Limit limit) {
        return new QueryContainer(this.query, this.fields, this.attributes, this.sort, this.trackHits, this.includeFrozen, limit);
    }

    public QueryContainer addColumn(Attribute attr) {
        Expression expression = (Expression)this.attributes.getOrDefault((Object)attr, (Object)attr);
        Tuple<QueryContainer, FieldExtraction> tuple = this.asFieldExtraction(attr);
        return ((QueryContainer)tuple.v1()).addColumn((FieldExtraction)tuple.v2(), Expressions.id((Expression)expression));
    }

    private Tuple<QueryContainer, FieldExtraction> asFieldExtraction(Attribute attr) {
        Expression expression = (Expression)this.attributes.getOrDefault((Object)attr, (Object)attr);
        if (expression instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)expression;
            if (fa.isNested()) {
                throw new UnsupportedOperationException("Nested not yet supported");
            }
            return new Tuple((Object)this, (Object)this.extractorRegistry.fieldExtraction(expression));
        }
        if (expression.foldable()) {
            return new Tuple((Object)this, (Object)new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, expression.fold())));
        }
        throw new EqlIllegalArgumentException("Unknown output attribute {}", attr);
    }

    public QueryContainer addSort(String expressionId, Sort sortable) {
        LinkedHashMap<String, Sort> newSort = new LinkedHashMap<String, Sort>(this.sort);
        newSort.put(expressionId, sortable);
        return new QueryContainer(this.query, this.fields, this.attributes, newSort, this.trackHits, this.includeFrozen, this.limit);
    }

    public QueryContainer addColumn(FieldExtraction ref, String id) {
        return new QueryContainer(this.query, CollectionUtils.combine(this.fields, (Object[])new Tuple[]{new Tuple((Object)ref, (Object)id)}), this.attributes, this.sort, this.trackHits, this.includeFrozen, this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.attributes, this.fields, this.trackHits, this.includeFrozen, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryContainer other = (QueryContainer)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.fields, other.fields) && this.trackHits == other.trackHits && this.includeFrozen == other.includeFrozen && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.humanReadable(true).prettyPrint();
                SourceGenerator.sourceBuilder(this, null).toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EqlIllegalArgumentException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }
}

