/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.time.ZoneId;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.ql.session.Configuration;

public class EqlConfiguration
extends Configuration {
    private final String[] indices;
    private final TimeValue requestTimeout;
    private final String clientId;
    private final IndicesOptions indicesOptions;
    private final TaskId taskId;
    private final EqlSearchTask task;
    private final int fetchSize;
    @Nullable
    private final QueryBuilder filter;

    public EqlConfiguration(String[] indices, ZoneId zi, String username, String clusterName, QueryBuilder filter, TimeValue requestTimeout, IndicesOptions indicesOptions, int fetchSize, String clientId, TaskId taskId, EqlSearchTask task) {
        super(zi, username, clusterName);
        this.indices = indices;
        this.filter = filter;
        this.requestTimeout = requestTimeout;
        this.clientId = clientId;
        this.indicesOptions = indicesOptions;
        this.taskId = taskId;
        this.task = task;
        this.fetchSize = fetchSize;
    }

    public String[] indices() {
        return this.indices;
    }

    public String indexAsWildcard() {
        return Strings.arrayToCommaDelimitedString((Object[])this.indices);
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public String clientId() {
        return this.clientId;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public TaskId getTaskId() {
        return this.taskId;
    }
}

