/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.ActivateAutoFollowPatternAction;

public class TransportActivateAutoFollowPatternAction
extends TransportMasterNodeAction<ActivateAutoFollowPatternAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportActivateAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/activate", transportService, clusterService, threadPool, actionFilters, ActivateAutoFollowPatternAction.Request::new, resolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(ActivateAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(final ActivateAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("activate-auto-follow-pattern-" + request.getName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                return TransportActivateAutoFollowPatternAction.innerActivate(request, currentState);
            }
        });
    }

    static ClusterState innerActivate(ActivateAutoFollowPatternAction.Request request, ClusterState currentState) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)currentState.metadata().custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{request.getName()});
        }
        Map patterns = autoFollowMetadata.getPatterns();
        AutoFollowMetadata.AutoFollowPattern previousAutoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)patterns.get(request.getName());
        if (previousAutoFollowPattern == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{request.getName()});
        }
        if (previousAutoFollowPattern.isActive() == request.isActive()) {
            return currentState;
        }
        HashMap<String, AutoFollowMetadata.AutoFollowPattern> newPatterns = new HashMap<String, AutoFollowMetadata.AutoFollowPattern>(patterns);
        newPatterns.put(request.getName(), new AutoFollowMetadata.AutoFollowPattern(previousAutoFollowPattern.getRemoteCluster(), previousAutoFollowPattern.getLeaderIndexPatterns(), previousAutoFollowPattern.getFollowIndexPattern(), previousAutoFollowPattern.getSettings(), request.isActive(), previousAutoFollowPattern.getMaxReadRequestOperationCount(), previousAutoFollowPattern.getMaxWriteRequestOperationCount(), previousAutoFollowPattern.getMaxOutstandingReadRequests(), previousAutoFollowPattern.getMaxOutstandingWriteRequests(), previousAutoFollowPattern.getMaxReadRequestSize(), previousAutoFollowPattern.getMaxWriteRequestSize(), previousAutoFollowPattern.getMaxWriteBufferCount(), previousAutoFollowPattern.getMaxWriteBufferSize(), previousAutoFollowPattern.getMaxRetryDelay(), previousAutoFollowPattern.getReadPollTimeout()));
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ccr_auto_follow", (Metadata.Custom)new AutoFollowMetadata(newPatterns, autoFollowMetadata.getFollowedLeaderIndexUUIDs(), autoFollowMetadata.getHeaders())).build()).build();
    }
}

