define(["exports","./events.js"],function(_exports,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_events=babelHelpers.interopRequireDefault(_events);function isLocalId(str){return str&&str.startsWith("local:")}function replaceAll(originalString,strReplace,strWith){var reg=new RegExp(strReplace,"ig");return originalString.replace(reg,strWith)}function paramsToString(params){var values=[];for(var key in params){var value=params[key];null!=value&&""!==value&&values.push("".concat(encodeURIComponent(key),"=").concat(encodeURIComponent(value)))}return values.join("&")}function getFetchPromise(request,signal){var headers=request.headers||{};"json"===request.dataType&&(headers.accept="application/json");var abortController,boundAbort,fetchRequest={headers:headers,method:request.type,credentials:"same-origin"};request.timeout&&(boundAbort=(abortController=new AbortController).abort.bind(abortController),signal&&signal.addEventListener("abort",boundAbort),setTimeout(boundAbort,request.timeout),signal=abortController.signal),signal&&(fetchRequest.signal=signal);var contentType=request.contentType;return request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=paramsToString(request.data),contentType=contentType||"application/x-www-form-urlencoded; charset=UTF-8")),contentType&&(headers["Content-Type"]=contentType),fetch(request.url,fetchRequest)}function setSavedEndpointInfo(instance,info){instance._endPointInfo=info}function _onNetworkChanged(instance,resetAddress){var serverInfo,newAddress;resetAddress&&(instance.connected=!1,serverInfo=instance.serverInfo(),(newAddress=function(instance,_ref){var LocalAddress=_ref.LocalAddress,ManualAddress=_ref.ManualAddress,RemoteAddress=_ref.RemoteAddress;if(LocalAddress&&allowAddress(instance,LocalAddress))return LocalAddress;if(ManualAddress&&allowAddress(instance,ManualAddress))return ManualAddress;if(RemoteAddress&&allowAddress(instance,RemoteAddress))return RemoteAddress;return null}(instance,serverInfo))&&(instance._serverAddress=newAddress)),setSavedEndpointInfo(instance,null)}function allowAddress(_ref2,address){return!(_ref2.rejectInsecureAddresses&&!address.startsWith("https:"))}function setTimeoutPromise(timeout){return new Promise(function(resolve,reject){setTimeout(resolve,timeout)})}function tryReconnectInternal(instance,signal){var addresses=[],addressesStrings=[],serverInfo=instance.serverInfo();if(serverInfo.LocalAddress&&!addressesStrings.includes(serverInfo.LocalAddress.toLowerCase())&&allowAddress(instance,serverInfo.LocalAddress)&&(addresses.push({url:serverInfo.LocalAddress,timeout:0}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddress&&!addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())&&allowAddress(instance,serverInfo.ManualAddress)&&(addresses.push({url:serverInfo.ManualAddress,timeout:100}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.RemoteAddress&&!addressesStrings.includes(serverInfo.RemoteAddress.toLowerCase())&&allowAddress(instance,serverInfo.RemoteAddress)&&(addresses.push({url:serverInfo.RemoteAddress,timeout:200}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),console.log("tryReconnect: ".concat(addressesStrings.join("|"))),!addressesStrings.length)return Promise.reject();for(var promises=[],i=0,length=addresses.length;i<length;i++)promises.push(function(instance,url,delay,signal){return console.log("tryReconnectToUrl: ".concat(url)),setTimeoutPromise(delay).then(function(){return getFetchPromise({url:instance.getUrl("system/info/public",null,url),type:"GET",dataType:"json",timeout:15e3},signal).then(function(){return url})})}(instance,addresses[i].url,addresses[i].timeout,signal));return Promise.any(promises).then(function(url){return instance.serverAddress(url),Promise.resolve(url)})}function getUserCacheKey(userId,serverId){return"user-".concat(userId,"-").concat(serverId)}function getCachedUser(instance,userId){var serverId=instance.serverId();if(!serverId)return null;var json=instance.appStorage.getItem(getUserCacheKey(userId,serverId));if(json){var user=JSON.parse(json);return user&&(user.Type="User"),user}return null}function saveUserInCache(_ref3,user){var appStorage=_ref3.appStorage;user.Type="User",user.DateLastFetched=Date.now(),appStorage.setItem(getUserCacheKey(user.Id,user.ServerId),JSON.stringify(user))}function removeCachedUser(_ref4,userId,serverId){_ref4.appStorage.removeItem(getUserCacheKey(userId,serverId))}var messageIdsReceived={};function onMessageReceivedInternal(instance,msg){var messageId=msg.MessageId;if(messageId){if(messageIdsReceived[messageId])return;messageIdsReceived[messageId]=!0}var user,msgType=msg.MessageType;"UserUpdated"===msgType||"UserConfigurationUpdated"===msgType||"UserPolicyUpdated"===msgType?(user=msg.Data).Id===instance.getCurrentUserId()&&(saveUserInCache(instance,user),instance._userViewsPromise=null):"LibraryChanged"===msgType&&(instance._userViewsPromise=null),_events.default.trigger(instance,"message",[msg])}function detectBitrateWithEndpointInfo(instance,_ref5){if(_ref5.IsInNetwork)return 14e7;if(instance.getMaxBandwidth){var maxRate=instance.getMaxBandwidth();if(maxRate)return maxRate}return 3e6}function getRemoteImagePrefix(instance,options){var urlPrefix="Items/".concat(options.itemId);return delete options.itemId,urlPrefix}function mapVirtualFolder(item){item.Type="VirtualFolder",item.Id=item.ItemId,item.IsFolder=!0}function setUsersProperties(response){return response.forEach(setUserProperties),Promise.resolve(response)}function setUserProperties(user){user.Type="User"}function setLogsProperties(instance,items){for(var serverId=instance.serverId(),i=0,length=items.length;i<length;i++){var log=items[i];log.ServerId=serverId,log.Type="Log",log.CanDownload=!0}return items}function normalizeImageOptions(_ref6,options){var ratio=_ref6._devicePixelRatio||1;ratio&&(options.width&&(options.width=Math.round(options.width*ratio)),options.height&&(options.height=Math.round(options.height*ratio)),options.maxWidth&&(options.maxWidth=Math.round(options.maxWidth*ratio)),options.maxHeight&&(options.maxHeight=Math.round(options.maxHeight*ratio))),options.quality||("Backdrop"===options.type?options.quality=70:options.quality=90)}function mapPrefix(i){return{Name:i}}var startingPlaySession=Date.now();function onUserDataUpdated(userData){var instance=this.instance,itemId=this.itemId,userId=this.userId;return userData.ItemId=itemId,_events.default.trigger(instance,"message",[{MessageType:"UserDataChanged",Data:{UserId:userId,UserDataList:[userData],IsLocalEvent:!0}}]),userData}function onItemUpdated(result){var instance=this.instance,itemId=this.itemId;return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:[],ItemsUpdated:[itemId],IsLocalEvent:!0}}]),result}function onItemsDeleted(result){for(var instance=this.instance,items=this.items,foldersRemovedFrom=[],itemsRemoved=[],i=0,length=items.length;i<length;i++){var item=items[i];item.ParentId&&foldersRemovedFrom.push(item.ParentId),itemsRemoved.push(item.Id)}return _events.default.trigger(instance,"message",[{MessageType:"LibraryChanged",Data:{ItemsAdded:[],ItemsRemoved:itemsRemoved,ItemsUpdated:[],FoldersRemovedFrom:foldersRemovedFrom,IsLocalEvent:!0}}]),result}function getCachedWakeOnLanInfo(instance){var serverId=instance.serverId(),json=instance.appStorage.getItem("server-".concat(serverId,"-wakeonlaninfo"));return json?JSON.parse(json):[]}function refreshWakeOnLanInfoIfNeeded(instance){instance._wakeOnLan.isSupported()&&instance.accessToken()&&!1!==instance.enableAutomaticBitrateDetection&&(console.log("refreshWakeOnLanInfoIfNeeded"),setTimeout(function(){var instance=this;console.log("refreshWakeOnLanInfo"),instance.getWakeOnLanInfo().then(function(info){var serverId=instance.serverId();return instance.appStorage.setItem("server-".concat(serverId,"-wakeonlaninfo"),JSON.stringify(info)),info},function(err){return[]})}.bind(instance),1e4))}function limitItemsFromQuery(items,query){return query.StartIndex&&(items=items.slice(query.StartIndex)),null!=query.Limit&&query.Limit<items.length&&(items.length=query.Limit),items}var ApiClient=function(){function ApiClient(appStorage,wakeOnLan,serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio){if(babelHelpers.classCallCheck(this,ApiClient),!serverAddress)throw new Error("Must supply a serverAddress");if(!appName)throw new Error("Must supply a appName");if(!appVersion)throw new Error("Must supply a appVersion");if(!deviceName)throw new Error("Must supply a deviceName");if(!deviceId)throw new Error("Must supply a deviceId");console.log("ApiClient serverAddress: ".concat(serverAddress)),console.log("ApiClient appName: ".concat(appName)),console.log("ApiClient appVersion: ".concat(appVersion)),console.log("ApiClient deviceName: ".concat(deviceName)),console.log("ApiClient deviceId: ".concat(deviceId)),this.appStorage=appStorage,this._wakeOnLan=wakeOnLan,this._serverInfo={},this._serverAddress=serverAddress,this._deviceId=deviceId,this._deviceName=deviceName,this._appName=appName,this._appVersion=appVersion,this._devicePixelRatio=devicePixelRatio}return babelHelpers.createClass(ApiClient,[{key:"appName",value:function(){return this._appName}},{key:"setAuthorizationInfoIntoRequest",value:function(request,includeAccessToken){var queryParams,url,auth,headers=request.headers,currentServerInfo=this.serverInfo(),appName=this._appName,accessToken=currentServerInfo.AccessToken,values=[],queryStringAuth=this._queryStringAuth,authValues=queryStringAuth?{}:headers;appName&&(authValues?authValues["X-Emby-Client"]=appName:values.push('Client="'.concat(appName,'"'))),this._deviceName&&(authValues?authValues["X-Emby-Device-Name"]=queryStringAuth?this._deviceName:encodeURIComponent(this._deviceName):values.push('Device="'.concat(encodeURIComponent(this._deviceName),'"'))),this._deviceId&&(authValues?authValues["X-Emby-Device-Id"]=this._deviceId:values.push('DeviceId="'.concat(this._deviceId,'"'))),this._appVersion&&(authValues?authValues["X-Emby-Client-Version"]=this._appVersion:values.push('Version="'.concat(this._appVersion,'"'))),accessToken&&!1!==includeAccessToken&&(authValues?authValues["X-Emby-Token"]=accessToken:values.push('Token="'.concat(accessToken,'"'))),authValues?!queryStringAuth||(queryParams=paramsToString(authValues))&&(url=request.url,url+=url.includes("?")?"&":"?",url+=queryParams,request.url=url):values.length&&(auth="MediaBrowser ".concat(values.join(", ")),headers["X-Emby-Authorization"]=auth)}},{key:"appVersion",value:function(){return this._appVersion}},{key:"deviceName",value:function(){return this._deviceName}},{key:"deviceId",value:function(){return this._deviceId}},{key:"serverAddress",value:function(val){if(null!=val){if(!val.toLowerCase().startsWith("http"))throw new Error("Invalid url: ".concat(val));this._serverAddress=val,_onNetworkChanged(this)}return this._serverAddress}},{key:"onNetworkChanged",value:function(){_onNetworkChanged(this,!0)}},{key:"getUrl",value:function(name,params,serverAddress){if(!name)throw new Error("Url name cannot be empty");var url=serverAddress||this._serverAddress;if(!url)throw new Error("serverAddress is yet not set");var lowered=url.toLowerCase();return lowered.includes("/emby")||lowered.includes("/mediabrowser")||(url+="/emby"),"/"!==name.charAt(0)&&(url+="/"),url+=name,(params=params&&paramsToString(params))&&(url+="?".concat(params)),url}},{key:"fetchWithFailover",value:function(request,enableReconnection,signal){console.log("apiclient.fetchWithFailover ".concat(request.url)),request.timeout=3e4;var instance=this;return getFetchPromise(request,signal).then(function(response){return instance.connected=!0,response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")?response.text():response:Promise.reject(response)},function(error){if(error?"AbortError"===error.name?console.log("AbortError: ".concat(request.url)):console.log("Request failed to ".concat(request.url," ").concat(error.status||""," ").concat(error.toString())):console.log("Request timed out to ".concat(request.url)),error&&error.status||!enableReconnection)throw console.log("Reporting request failure"),error;console.log("Attempting reconnection");var previousServerAddress=instance.serverAddress();return function tryReconnect(instance,signal,argument_2){var retryCount=2<arguments.length&&void 0!==argument_2?argument_2:0,promise=tryReconnectInternal(instance,signal);return 2<=retryCount?promise:promise.catch(function(err){return console.log("error in tryReconnectInternal: ".concat(err||"")),setTimeoutPromise(500).then(function(){return tryReconnect(instance,signal,retryCount+1)})})}(instance,signal,null).then(function(newServerAddress){return console.log("Reconnect succeeded to ".concat(newServerAddress)),instance.connected=!0,instance.enableWebSocketAutoConnect&&instance.ensureWebSocket(),request.url=request.url.replace(previousServerAddress,newServerAddress),console.log("Retrying request with new url: ".concat(request.url)),instance.fetchWithFailover(request,!1,signal)})})}},{key:"fetch",value:function(request,includeAccessToken,signal){if(!request)throw new Error("Request cannot be null");return request.headers=request.headers||{},this.setAuthorizationInfoIntoRequest(request,includeAccessToken),!1===this.enableAutomaticNetworking||"GET"!==request.type?getFetchPromise(request,signal).then(function(response){return response.status<400?"json"===request.dataType||"application/json"===request.headers.accept?response.json():"text"===request.dataType||(response.headers.get("Content-Type")||"").toLowerCase().startsWith("text/")?response.text():response:Promise.reject(response)}):this.fetchWithFailover(request,!0,signal)}},{key:"setAuthenticationInfo",value:function(accessKey,userId){this._serverInfo.AccessToken=accessKey,this._serverInfo.UserId!==userId&&(this._userViewsPromise=null),this._serverInfo.UserId=userId,refreshWakeOnLanInfoIfNeeded(this)}},{key:"serverInfo",value:function(info){var currentUserId;return info&&(currentUserId=this.getCurrentUserId(),this._serverInfo=info,currentUserId!==this.getCurrentUserId()&&(this._userViewsPromise=null)),this._serverInfo}},{key:"getCurrentUserName",value:function(){var userId=this.getCurrentUserId();if(!userId)return null;var user=getCachedUser(this,userId);return null==user?null:user.Name}},{key:"getCurrentUserId",value:function(){return this._serverInfo.UserId}},{key:"accessToken",value:function(){return this._serverInfo.AccessToken}},{key:"serverId",value:function(){return this.serverInfo().Id}},{key:"serverName",value:function(){return this.serverInfo().Name}},{key:"ajax",value:function(request,includeAccessToken){if(!request)throw new Error("Request cannot be null");return this.fetch(request,includeAccessToken)}},{key:"getCurrentUser",value:function(options){var userId=this.getCurrentUserId();return userId?(options=options||{},this.getUser(userId,options.enableCache,options.signal)):Promise.reject()}},{key:"isLoggedIn",value:function(){var info=this.serverInfo();return!!(info&&info.UserId&&info.AccessToken)}},{key:"logout",value:function(){var _this=this;this.closeWebSocket();function done(){return _this.setAuthenticationInfo(null,null),Promise.resolve()}if(this.accessToken()){var url=this.getUrl("Sessions/Logout");return this.ajax({type:"POST",url:url,timeout:1e4}).then(done,done)}return done()}},{key:"authenticateUserByName",value:function(name,password){if(!name)return Promise.reject();var url=this.getUrl("Users/authenticatebyname"),instance=this,postData={Username:name,Pw:password||""};return instance.ajax({type:"POST",url:url,data:JSON.stringify(postData),dataType:"json",contentType:"application/json"}).then(function(result){instance._userViewsPromise=null,saveUserInCache(instance,result.User);function afterOnAuthenticated(){return refreshWakeOnLanInfoIfNeeded(instance),result}return instance.onAuthenticated?instance.onAuthenticated(instance,result).then(afterOnAuthenticated):(afterOnAuthenticated(),result)})}},{key:"ensureWebSocket",value:function(){if(this.connected&&!this.isWebSocketOpenOrConnecting()&&this.isWebSocketSupported())try{this.openWebSocket()}catch(err){console.log("Error opening web socket: ".concat(err))}}},{key:"openWebSocket",value:function(){var accessToken=this.accessToken();if(!accessToken)throw new Error("Cannot open web socket without access token.");var url=replaceAll(url=this.getUrl("socket"),"emby/socket","embywebsocket");url=replaceAll(url,"https:","wss:"),url=replaceAll(url,"http:","ws:"),url+="?api_key=".concat(accessToken),url+="&deviceId=".concat(this.deviceId()),console.log("opening web socket with url: ".concat(url));var apiClient,socket,webSocket=new WebSocket(url);webSocket.onmessage=function(msg){onMessageReceivedInternal(this,msg=JSON.parse(msg.data))}.bind(this),webSocket.onopen=function(){console.log("web socket connection opened"),_events.default.trigger(this,"websocketopen");var list=this.messageListeners;if(list)for(var i=0,length=(list=list.slice(0)).length;i<length;i++)this.startMessageListener(list[i],"0,2000")}.bind(this),webSocket.onerror=function(){_events.default.trigger(this,"websocketerror")}.bind(this),apiClient=this,(socket=webSocket).onclose=function(){console.log("web socket closed"),apiClient._webSocket===socket&&(console.log("nulling out web socket"),apiClient._webSocket=null),setTimeout(function(){_events.default.trigger(apiClient,"websocketclose")},0)},this._webSocket=webSocket}},{key:"closeWebSocket",value:function(){var socket=this._webSocket;socket&&socket.readyState===WebSocket.OPEN&&socket.close()}},{key:"sendWebSocketMessage",value:function(name,data){console.log("Sending web socket message: ".concat(name));var msg={MessageType:name};data&&(msg.Data=data),msg=JSON.stringify(msg),this._webSocket.send(msg)}},{key:"startMessageListener",value:function(name,options){this.sendMessage("".concat(name,"Start"),options);var list=this.messageListeners;list||(this.messageListeners=list=[]),list.includes(name)||list.push(name)}},{key:"stopMessageListener",value:function(name){this.sendMessage("".concat(name,"Stop"));var list=this.messageListeners;list&&list.includes(name)&&(this.messageListeners=list=list.filter(function(n){return n!==name}))}},{key:"sendMessage",value:function(name,data){this.isWebSocketOpen()&&this.sendWebSocketMessage(name,data)}},{key:"isMessageChannelOpen",value:function(){return this.isWebSocketOpen()}},{key:"isWebSocketOpen",value:function(){var socket=this._webSocket;return!!socket&&socket.readyState===WebSocket.OPEN}},{key:"isWebSocketOpenOrConnecting",value:function(){var socket=this._webSocket;return!!socket&&(socket.readyState===WebSocket.OPEN||socket.readyState===WebSocket.CONNECTING)}},{key:"get",value:function(url){return this.ajax({type:"GET",url:url})}},{key:"getJSON",value:function(url,signal){return this.fetch({url:url,type:"GET",dataType:"json",headers:{accept:"application/json"}},null,signal)}},{key:"getText",value:function(url,signal){return this.fetch({url:url,type:"GET",dataType:"text"},null,signal)}},{key:"updateServerInfo",value:function(server,serverUrl){if(null==server)throw new Error("server cannot be null");if(this.serverInfo(server),!serverUrl)throw new Error("serverUrl cannot be null. serverInfo: ".concat(JSON.stringify(server)));console.log("Setting server address to ".concat(serverUrl)),this.serverAddress(serverUrl)}},{key:"isWebSocketSupported",value:function(){try{return null!=WebSocket}catch(err){return!1}}},{key:"clearAuthenticationInfo",value:function(){this.setAuthenticationInfo(null,null)}},{key:"encodeName",value:function(name){var val=paramsToString({name:name=(name=(name=name.split("/").join("-")).split("&").join("-")).split("?").join("-")});return val.substring(val.indexOf("=")+1).replace("'","%27")}},{key:"getProductNews",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{},url=this.getUrl("News/Product",options);return this.getJSON(url)}},{key:"detectBitrate",value:function(){var instance=this;return this.getEndpointInfo().then(function(info){return detectBitrateWithEndpointInfo(instance,info)},function(info){return detectBitrateWithEndpointInfo(instance,{})})}},{key:"getItem",value:function(userId,itemId,options){if(!itemId)throw new Error("null itemId");var url=userId?this.getUrl("Users/".concat(userId,"/Items/").concat(itemId),options):this.getUrl("Items/".concat(itemId),options);return this.getJSON(url)}},{key:"getRootFolder",value:function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/".concat(userId,"/Items/Root"));return this.getJSON(url)}},{key:"getNotificationSummary",value:function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Notifications/".concat(userId,"/Summary"));return this.getJSON(url)}},{key:"getNotifications",value:function(userId,options){if(!userId)throw new Error("null userId");var url=this.getUrl("Notifications/".concat(userId),options||{});return this.getJSON(url)}},{key:"markNotificationsRead",value:function(userId,idList,isRead){if(!userId)throw new Error("null userId");if(!idList)throw new Error("null idList");var suffix=isRead?"Read":"Unread",params={UserId:userId,Ids:idList.join(",")},url=this.getUrl("Notifications/".concat(userId,"/").concat(suffix),params);return this.ajax({type:"POST",url:url})}},{key:"getRemoteImageProviders",value:function(options){if(!options)throw new Error("null options");var urlPrefix=getRemoteImagePrefix(0,options),url=this.getUrl("".concat(urlPrefix,"/RemoteImages/Providers"),options);return this.getJSON(url)}},{key:"getAvailableRemoteImages",value:function(options){if(!options)throw new Error("null options");var urlPrefix=getRemoteImagePrefix(0,options),url=this.getUrl("".concat(urlPrefix,"/RemoteImages"),options);return this.getJSON(url)}},{key:"downloadRemoteImage",value:function(options){if(!options)throw new Error("null options");var itemId=options.itemId,urlPrefix=getRemoteImagePrefix(0,options),url=this.getUrl("".concat(urlPrefix,"/RemoteImages/Download"),options);return this.ajax({type:"POST",url:url}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"getRecordingFolders",value:function(userId){var url=this.getUrl("LiveTv/Recordings/Folders",{userId:userId});return this.getJSON(url)}},{key:"getLiveTvInfo",value:function(options){var url=this.getUrl("LiveTv/Info",options||{});return this.getJSON(url)}},{key:"getLiveTvGuideInfo",value:function(options){var url=this.getUrl("LiveTv/GuideInfo",options||{});return this.getJSON(url)}},{key:"getLiveTvChannel",value:function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Channels/".concat(id),options);return this.getJSON(url)}},{key:"getLiveTvChannelsForManagement",value:function(query){var url=this.getUrl("LiveTv/Manage/Channels",query);return this.getJSON(url)}},{key:"setChannelDisabled",value:function(item,disabled){var id=item.Id,url=this.getUrl("LiveTv/Manage/Channels/".concat(id,"/Disabled"),{ManagementId:item.ManagementId,Disabled:disabled});return this.ajax({type:"POST",url:url,contentType:"application/json",dataType:"json"}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Channel:result,Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))}},{key:"setChannelSortIndex",value:function(item,newIndex){var id=item.Id,url=this.getUrl("LiveTv/Manage/Channels/".concat(id,"/SortIndex"),{ManagementId:item.ManagementId,NewIndex:newIndex});return this.ajax({type:"POST",url:url}).then(function(result){var instance=this.instance,id=this.id;return _events.default.trigger(instance,"message",[{MessageType:"ChannelManagementInfoUpdated",Data:{Id:id,IsLocalEvent:!0}}]),result}.bind({instance:this,id:id}))}},{key:"getLiveTvChannels",value:function(options){var url=this.getUrl("LiveTv/Channels",options||{});return this.getJSON(url)}},{key:"getLiveTvPrograms",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{};return options.channelIds&&1800<options.channelIds.length?this.ajax({type:"POST",url:this.getUrl("LiveTv/Programs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}):this.getJSON(this.getUrl("LiveTv/Programs",options))}},{key:"getEpg",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{};if(options.AddCurrentProgram=!1,options.EnableUserData=!1,options.EnableImageTypes="Primary",options.UserId=this.getCurrentUserId(),this.isMinServerVersion("4.4.3"))return this.getJSON(this.getUrl("LiveTv/EPG",options)).then(function(result){return result.Items.forEach(function(result){result.Type="EpgChannel",result.ServerId=this.serverId()}.bind(this)),result}.bind(this));var serverId=this.serverId(),instance=this,maxStartDate=options.MaxStartDate;delete options.MaxStartDate;var minEndDate=options.MinEndDate;return delete options.MinEndDate,this.getLiveTvChannels(options).then(function(result){for(var channelIds=[],programMap={},i=0,length=result.Items.length;i<length;i++){var channel=result.Items[i];channelIds.push(channel.Id);var programs=programMap[channel.Id]=[];result.Items[i]={Type:"EpgChannel",ServerId:serverId,Channel:channel,Programs:programs}}var programQuery={UserId:instance.getCurrentUserId(),MaxStartDate:maxStartDate,MinEndDate:minEndDate,channelIds:channelIds.join(","),ImageTypeLimit:1,EnableImages:!1,SortBy:"StartDate",EnableTotalRecordCount:!1,EnableUserData:!1,Fields:options.ProgramFields};return instance.getLiveTvPrograms(programQuery).then(function(_ref7){for(var Items=_ref7.Items,j=0,programResultLength=Items.length;j<programResultLength;j++){var program=Items[j];programMap[program.ChannelId].push(program)}return result})})}},{key:"getLiveTvRecommendedPrograms",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{};return this.getJSON(this.getUrl("LiveTv/Programs/Recommended",options))}},{key:"getLiveTvRecordings",value:function(options,signal){var url=this.getUrl("LiveTv/Recordings",options||{});return this.getJSON(url,signal)}},{key:"getLiveTvRecordingSeries",value:function(options){var url=this.getUrl("LiveTv/Recordings/Series",options||{});return this.getJSON(url)}},{key:"getLiveTvRecording",value:function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Recordings/".concat(id),options);return this.getJSON(url)}},{key:"getLiveTvProgram",value:function(id,userId){if(!id)throw new Error("null id");var options={};userId&&(options.userId=userId);var url=this.getUrl("LiveTv/Programs/".concat(id),options);return this.getJSON(url)}},{key:"deleteLiveTvRecording",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Recordings/".concat(id));return this.ajax({type:"DELETE",url:url})}},{key:"cancelLiveTvTimer",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Timers/".concat(id));return this.ajax({type:"DELETE",url:url})}},{key:"getLiveTvTimers",value:function(options){var url=this.getUrl("LiveTv/Timers",options||{});return this.getJSON(url)}},{key:"getLiveTvTimer",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Timers/".concat(id));return this.getJSON(url)}},{key:"getNewLiveTvTimerDefaults",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{},url=this.getUrl("LiveTv/Timers/Defaults",options);return this.getJSON(url)}},{key:"createLiveTvTimer",value:function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/Timers");return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})}},{key:"updateLiveTvTimer",value:function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/Timers/".concat(item.Id));return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})}},{key:"resetLiveTvTuner",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/Tuners/".concat(id,"/Reset"));return this.ajax({type:"POST",url:url})}},{key:"getLiveTvSeriesTimers",value:function(query,signal){var instance=this;return this.getJSON(this.getUrl("LiveTv/SeriesTimers",query),signal).then(function(result){return!instance.isMinServerVersion("4.6.0.37")&&query&&(result.Items=limitItemsFromQuery(result.Items,query)),result})}},{key:"getLiveTvSeriesTimer",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/SeriesTimers/".concat(id));return this.getJSON(url)}},{key:"cancelLiveTvSeriesTimer",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("LiveTv/SeriesTimers/".concat(id));return this.ajax({type:"DELETE",url:url})}},{key:"createLiveTvSeriesTimer",value:function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/SeriesTimers");return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})}},{key:"updateLiveTvSeriesTimer",value:function(item){if(!item)throw new Error("null item");var url=this.getUrl("LiveTv/SeriesTimers/".concat(item.Id));return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"})}},{key:"getRegistrationInfo",value:function(feature){var url=this.getUrl("Registrations/".concat(feature));return this.getJSON(url)}},{key:"getSystemInfo",value:function(){var url=this.getUrl("System/Info"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})}},{key:"getSyncStatus",value:function(itemId){var url=this.getUrl("Sync/".concat(itemId,"/Status"));return this.ajax({url:url,type:"POST",dataType:"json",contentType:"application/json",data:JSON.stringify({TargetId:this.deviceId()})})}},{key:"getPublicSystemInfo",value:function(){var url=this.getUrl("System/Info/Public"),instance=this;return this.getJSON(url).then(function(info){return instance.setSystemInfo(info),Promise.resolve(info)})}},{key:"getInstantMixFromItem",value:function(itemId,options){var url=this.getUrl("Items/".concat(itemId,"/InstantMix"),options);return this.getJSON(url)}},{key:"getEpisodes",value:function(itemId,options){var url=this.getUrl("Shows/".concat(itemId,"/Episodes"),options);return this.getJSON(url)}},{key:"getDisplayPreferences",value:function(id,userId,app){var url=this.getUrl("DisplayPreferences/".concat(id),{userId:userId,client:app});return this.getJSON(url)}},{key:"updateDisplayPreferences",value:function(id,obj,userId,app){var url=this.getUrl("DisplayPreferences/".concat(id),{userId:userId,client:app});return this.ajax({type:"POST",url:url,data:JSON.stringify(obj),contentType:"application/json"})}},{key:"getSeasons",value:function(itemId,options){var url=this.getUrl("Shows/".concat(itemId,"/Seasons"),options);return this.getJSON(url)}},{key:"getSimilarItems",value:function(itemId,options){var url=this.getUrl("Items/".concat(itemId,"/Similar"),options);return this.getJSON(url)}},{key:"getCultures",value:function(){var url=this.getUrl("Localization/cultures");return this.getJSON(url)}},{key:"getCountries",value:function(){var url=this.getUrl("Localization/countries");return this.getJSON(url)}},{key:"getPlaybackInfo",value:function(itemId,options,deviceProfile){var postData={DeviceProfile:deviceProfile};return this.ajax({url:this.getUrl("Items/".concat(itemId,"/PlaybackInfo"),options),type:"POST",data:JSON.stringify(postData),contentType:"application/json",dataType:"json"})}},{key:"getLiveStreamMediaInfo",value:function(liveStreamId){var postData={LiveStreamId:liveStreamId};return this.ajax({url:this.getUrl("LiveStreams/MediaInfo"),type:"POST",data:JSON.stringify(postData),contentType:"application/json",dataType:"json"})}},{key:"getIntros",value:function(itemId){return this.getJSON(this.getUrl("Users/".concat(this.getCurrentUserId(),"/Items/").concat(itemId,"/Intros")))}},{key:"getDirectoryContents",value:function(path,options){if(!path)throw new Error("null path");if("string"!=typeof path)throw new Error("invalid path");(options=options||{}).path=path;var url=this.getUrl("Environment/DirectoryContents",options);return this.getJSON(url)}},{key:"getNetworkShares",value:function(path){if(!path)throw new Error("null path");var options={};options.path=path;var url=this.getUrl("Environment/NetworkShares",options);return this.getJSON(url)}},{key:"getParentPath",value:function(path){if(!path)throw new Error("null path");var options={};options.path=path;var url=this.getUrl("Environment/ParentPath",options);return this.ajax({type:"GET",url:url,dataType:"text"})}},{key:"getDrives",value:function(){var url=this.getUrl("Environment/Drives");return this.getJSON(url)}},{key:"getNetworkDevices",value:function(){var url=this.getUrl("Environment/NetworkDevices");return this.getJSON(url)}},{key:"getActivityLog",value:function(options){var url=this.getUrl("System/ActivityLog/Entries",options||{}),serverId=this.serverId();return this.getJSON(url).then(function(result){for(var items=result.Items,i=0,length=items.length;i<length;i++){var item=items[i];item.Type="ActivityLogEntry",item.ServerId=serverId}return result})}},{key:"cancelPackageInstallation",value:function(installationId){if(!installationId)throw new Error("null installationId");var url=this.getUrl("Packages/Installing/".concat(installationId));return this.ajax({type:"DELETE",url:url})}},{key:"refreshItem",value:function(itemId,options){if(!itemId)throw new Error("null itemId");var url=this.getUrl("Items/".concat(itemId,"/Refresh"),options||{});return this.ajax({type:"POST",url:url})}},{key:"installPlugin",value:function(name,guid,updateClass,version){if(!name)throw new Error("null name");if(!updateClass)throw new Error("null updateClass");var options={updateClass:updateClass,AssemblyGuid:guid};version&&(options.version=version);var url=this.getUrl("Packages/Installed/".concat(name),options);return this.ajax({type:"POST",url:url})}},{key:"restartServer",value:function(){var url=this.getUrl("System/Restart");return this.ajax({type:"POST",url:url})}},{key:"shutdownServer",value:function(){var url=this.getUrl("System/Shutdown");return this.ajax({type:"POST",url:url})}},{key:"getPackageInfo",value:function(name,guid){if(!name)throw new Error("null name");var options={AssemblyGuid:guid},url=this.getUrl("Packages/".concat(name),options);return this.getJSON(url)}},{key:"getAvailableApplicationUpdate",value:function(){var url=this.getUrl("Packages/Updates",{PackageType:"System"});return this.getJSON(url)}},{key:"getAvailablePluginUpdates",value:function(){var url=this.getUrl("Packages/Updates",{PackageType:"UserInstalled"});return this.getJSON(url)}},{key:"_getVirtualFoldersLegacy",value:function(query,signal){var serverId=this.serverId();return this.getJSON(this.getUrl("Library/VirtualFolders",query),signal).then(function(items){var result={Items:items,TotalRecordCount:items.length};query&&(result.Items=limitItemsFromQuery(result.Items,query));for(var i=0,length=result.Items.length;i<length;i++){var item=result.Items[i];mapVirtualFolder(item),item.ServerId=serverId}return result})}},{key:"getVirtualFolders",value:function(query,signal){if(this.isMinServerVersion("4.6.0.37")){var serverId=this.serverId();return this.getJSON(this.getUrl("Library/VirtualFolders/Query",query),signal).then(function(result){for(var i=0,length=result.Items.length;i<length;i++){var item=result.Items[i];mapVirtualFolder(item),item.ServerId=serverId}return result})}return this._getVirtualFoldersLegacy(query,signal)}},{key:"getPhysicalPaths",value:function(){var url=this.getUrl("Library/PhysicalPaths");return this.getJSON(url)}},{key:"getServerConfiguration",value:function(){var url=this.getUrl("System/Configuration");return this.getJSON(url)}},{key:"getDevices",value:function(query){var instance=this;return this.getJSON(this.getUrl("Devices",query)).then(function(result){return query&&!instance.isMinServerVersion("4.6.0.37")&&(result.Items=limitItemsFromQuery(result.Items,query)),result})}},{key:"getDevicesOptions",value:function(){var url=this.getUrl("System/Configuration/devices");return this.getJSON(url)}},{key:"getContentUploadHistory",value:function(){var url=this.getUrl("Devices/CameraUploads",{DeviceId:this.deviceId()});return this.getJSON(url)}},{key:"getNamedConfiguration",value:function(name){var url=this.getUrl("System/Configuration/".concat(name));return this.getJSON(url)}},{key:"getHardwareAccelerations",value:function(){var url=this.getUrl("Encoding/HardwareAccelerations");return this.getJSON(url)}},{key:"getVideoCodecInformation",value:function(){var url=this.getUrl("Encoding/CodecInformation/Video");return this.getJSON(url)}},{key:"getScheduledTasks",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{},url=this.getUrl("ScheduledTasks",options);return this.getJSON(url)}},{key:"startScheduledTask",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/Running/".concat(id));return this.ajax({type:"POST",url:url})}},{key:"getScheduledTask",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/".concat(id));return this.getJSON(url)}},{key:"getNextUpEpisodes",value:function(options){var url=this.getUrl("Shows/NextUp",options);return this.getJSON(url)}},{key:"stopScheduledTask",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("ScheduledTasks/Running/".concat(id));return this.ajax({type:"DELETE",url:url})}},{key:"getPluginConfiguration",value:function(id){if(!id)throw new Error("null Id");var url=this.getUrl("Plugins/".concat(id,"/Configuration"));return this.getJSON(url)}},{key:"getAvailablePlugins",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{};options.PackageType="UserInstalled";var url=this.getUrl("Packages",options);return this.getJSON(url)}},{key:"uninstallPlugin",value:function(id){if(!id)throw new Error("null Id");var url=this.getUrl("Plugins/".concat(id));return this.ajax({type:"DELETE",url:url})}},{key:"removeVirtualFolder",value:function(virtualFolder,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url=this.getUrl("Library/VirtualFolders",{refreshLibrary:!!refreshLibrary,id:virtualFolder.Id,name:virtualFolder.Name}),instance=this;return this.ajax({type:"DELETE",url:url}).then(function(){instance._userViewsPromise=null})}},{key:"addVirtualFolder",value:function(name,type,refreshLibrary,libraryOptions){if(!name)throw new Error("null name");var options={};type&&(options.collectionType=type),options.refreshLibrary=!!refreshLibrary,options.name=name;var url=this.getUrl("Library/VirtualFolders",options),instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({LibraryOptions:libraryOptions}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null})}},{key:"updateVirtualFolderOptions",value:function(id,libraryOptions){if(!id)throw new Error("null name");var url=this.getUrl("Library/VirtualFolders/LibraryOptions"),instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({Id:id,LibraryOptions:libraryOptions}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:id})).then(function(){instance._userViewsPromise=null})}},{key:"renameVirtualFolder",value:function(virtualFolder,newName,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");var url=this.getUrl("Library/VirtualFolders/Name",{refreshLibrary:!!refreshLibrary,newName:newName,name:virtualFolder.Name,Id:virtualFolder.Id}),instance=this;return this.ajax({type:"POST",url:url}).then(function(){instance._userViewsPromise=null})}},{key:"addMediaPath",value:function(virtualFolder,mediaPath,networkSharePath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");if(!mediaPath)throw new Error("null mediaPath");var url,pathInfo={Path:mediaPath};networkSharePath&&(pathInfo.NetworkPath=networkSharePath),url=this.getUrl("Library/VirtualFolders/Paths",{refreshLibrary:!!refreshLibrary});var instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null})}},{key:"updateMediaPath",value:function(virtualFolder,pathInfo){if(!virtualFolder)throw new Error("null virtualFolder");if(!pathInfo)throw new Error("null pathInfo");var url=this.getUrl("Library/VirtualFolders/Paths/Update"),instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({Name:virtualFolder.Name,PathInfo:pathInfo,Id:virtualFolder.Id}),contentType:"application/json"}).then(function(){instance._userViewsPromise=null})}},{key:"removeMediaPath",value:function(virtualFolder,mediaPath,refreshLibrary){if(!virtualFolder)throw new Error("null virtualFolder");if(!mediaPath)throw new Error("null mediaPath");var instance=this,url=this.getUrl("Library/VirtualFolders/Paths",{refreshLibrary:!!refreshLibrary,path:mediaPath,name:virtualFolder.Name,Id:virtualFolder.Id});return this.ajax({type:"DELETE",url:url}).then(function(){instance._userViewsPromise=null})}},{key:"deleteUser",value:function(id){if(!id)throw new Error("null id");var url=this.getUrl("Users/".concat(id)),serverId=this.serverId(),instance=this;return this.ajax({type:"DELETE",url:url}).then(function(){removeCachedUser(instance,id,serverId),instance._userViewsPromise=null})}},{key:"deleteUserImage",value:function(userId,imageType,imageIndex){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");var url=this.getUrl("Users/".concat(userId,"/Images/").concat(imageType));null!=imageIndex&&(url+="/".concat(imageIndex));var serverId=this.serverId(),instance=this;return this.ajax({type:"DELETE",url:url}).then(function(){removeCachedUser(instance,userId,serverId)})}},{key:"deleteItemImage",value:function(itemId,imageType,imageIndex){if(!imageType)throw new Error("null imageType");var url=this.getUrl("Items/".concat(itemId,"/Images"));return url+="/".concat(imageType),null!=imageIndex&&(url+="/".concat(imageIndex)),this.ajax({type:"DELETE",url:url}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"deleteItem",value:function(item){if(!item)throw new Error("null itemId");var url=this.getUrl("Items/".concat(item.Id));return this.ajax({type:"DELETE",url:url}).then(onItemsDeleted.bind({instance:this,items:[item]}))}},{key:"deleteItems",value:function(items){if(!items)throw new Error("null itemId");for(var promises=[],i=0,length=items.length;i<length;i++){var item=items[i];promises.push(this.ajax({type:"DELETE",url:this.getUrl("Items/".concat(item.Id))}))}return Promise.all(promises).then(onItemsDeleted.bind({instance:this,items:items}))}},{key:"stopActiveEncodings",value:function(playSessionId){var options={deviceId:this.deviceId()};playSessionId&&(options.PlaySessionId=playSessionId);var url=this.getUrl("Videos/ActiveEncodings",options);return this.ajax({type:"DELETE",url:url})}},{key:"reportCapabilities",value:function(options){var url=this.getUrl("Sessions/Capabilities/Full");return this.ajax({type:"POST",url:url,data:JSON.stringify(options),contentType:"application/json"})}},{key:"updateItemImageFromUrl",value:function(itemId,imageType,imageIndex,imageUrl){if(!imageType)throw new Error("null imageType");return imageIndex=imageIndex||0,this.ajax({type:"POST",url:this.getUrl("Items/".concat(itemId,"/Images/").concat(imageType,"/").concat(imageIndex,"/Url"),{}),data:JSON.stringify({Url:imageUrl}),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"updateItemImageIndex",value:function(itemId,imageType,imageIndex,newIndex){if(!imageType)throw new Error("null imageType");var options={newIndex:newIndex};imageIndex=imageIndex||0;var url=this.getUrl("Items/".concat(itemId,"/Images/").concat(imageType,"/").concat(imageIndex,"/Index"),options);return this.ajax({type:"POST",url:url}).then(onItemUpdated.bind({instance:this,itemId:itemId}))}},{key:"getItemImageInfos",value:function(itemId){var url=this.getUrl("Items/".concat(itemId,"/Images"));return this.getJSON(url)}},{key:"getCriticReviews",value:function(itemId,options){if(!itemId)throw new Error("null itemId");var url=this.getUrl("Items/".concat(itemId,"/CriticReviews"),options);return this.getJSON(url)}},{key:"getItemDownloadUrl",value:function(itemId,mediaSourceId){if(!itemId)throw new Error("itemId cannot be empty");var url="Items/".concat(itemId,"/Download");return this.getUrl(url,{api_key:this.accessToken(),mediaSourceId:mediaSourceId})}},{key:"getSessions",value:function(options){var url=this.getUrl("Sessions",options);return this.getJSON(url)}},{key:"uploadUserImage",value:function(userId,imageType,file){if(!userId)throw new Error("null userId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var instance=this,serverId=this.serverId();return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref8){var data=_ref8.target.result.split(",")[1],url=instance.getUrl("Users/".concat(userId,"/Images/").concat(imageType));instance.ajax({type:"POST",url:url,data:data,contentType:"image/".concat(file.name.substring(file.name.lastIndexOf(".")+1))}).then(function(){removeCachedUser(instance,userId,serverId),resolve()},reject)},reader.readAsDataURL(file)})}},{key:"uploadItemImage",value:function(itemId,imageType,file){if(!itemId)throw new Error("null itemId");if(!imageType)throw new Error("null imageType");if(!file)throw new Error("File must be an image.");if("image/png"!==file.type&&"image/jpeg"!==file.type&&"image/jpeg"!==file.type)throw new Error("File must be an image.");var url=this.getUrl("Items/".concat(itemId,"/Images"));url+="/".concat(imageType);var instance=this;return new Promise(function(resolve,reject){var reader=new FileReader;reader.onerror=function(){reject()},reader.onabort=function(){reject()},reader.onload=function(_ref9){var data=_ref9.target.result.split(",")[1];instance.ajax({type:"POST",url:url,data:data,contentType:"image/".concat(file.name.substring(file.name.lastIndexOf(".")+1))}).then(function(result){onItemUpdated.call({instance:instance,itemId:itemId}),resolve(result)},reject)},reader.readAsDataURL(file)})}},{key:"getInstalledPlugins",value:function(){var url=this.getUrl("Plugins",{});return this.getJSON(url)}},{key:"getCurrentUserCached",value:function(){return getCachedUser(this,this.getCurrentUserId())}},{key:"getUser",value:function(id,enableCache,signal){if(!id)throw new Error("Must supply a userId");var cachedUser;if(!1!==enableCache&&(cachedUser=getCachedUser(this,id))&&Date.now()-(cachedUser.DateLastFetched||0)<=6e4)return Promise.resolve(cachedUser);var instance=this,url=this.getUrl("Users/".concat(id)),serverPromise=this.getJSON(url,signal).then(function(user){return saveUserInCache(instance,user),user},function(response){if((!signal||!signal.aborted)&&(!response||!response.status)&&instance.accessToken()){var user=getCachedUser(instance,id);if(user)return Promise.resolve(user)}throw response});return!1!==enableCache&&cachedUser?Promise.resolve(cachedUser):serverPromise}},{key:"getStudio",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Studios/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getGenre",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Genres/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getMusicGenre",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("MusicGenres/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getGameGenre",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("GameGenres/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getArtist",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Artists/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getPerson",value:function(name,userId){if(!name)throw new Error("null name");var options={};userId&&(options.userId=userId);var url=this.getUrl("Persons/".concat(this.encodeName(name)),options);return this.getJSON(url)}},{key:"getPublicUsers",value:function(){var url=this.getUrl("users/public");return this.ajax({type:"GET",url:url,dataType:"json"},!1).then(setUsersProperties)}},{key:"_getUsersQueryResultLegacy",value:function(query,signal){return this.getJSON(this.getUrl("users",query),signal).then(function(items){var result={Items:items,TotalRecordCount:items.length};return query&&(result.Items=limitItemsFromQuery(result.Items,query)),setUsersProperties(result.Items),result})}},{key:"getUsersQueryResult",value:function(query,signal){if(this.isMinServerVersion("4.6.0.37")){return this.getJSON(this.getUrl("Users/Query",query),signal).then(function(result){return setUsersProperties(result.Items),result})}return this._getUsersQueryResultLegacy(query,signal)}},{key:"getUsers",value:function(query,signal){return this.getUsersQueryResult(query,signal).then(function(result){return result.Items})}},{key:"getUserPrefixes",value:function(query,signal){return this.isMinServerVersion("4.6.0.37")?this.getJSON(this.getUrl("Users/Prefixes",query),signal):Promise.resolve([])}},{key:"getApiKeys",value:function(query,signal){var instance=this;return this.getJSON(this.getUrl("Auth/Keys",query),signal).then(function(result){return!instance.isMinServerVersion("4.6.0.37")&&query&&(result.Items=limitItemsFromQuery(result.Items,query)),function(instance,response){for(var serverId=instance.serverId(),i=0,length=response.Items.length;i<length;i++){var log=response.Items[i];log.ServerId=serverId,log.Type="ApiKey",log.CanDelete=!0}}(instance,result),result})}},{key:"_getLogsLegacy",value:function(query,signal){var instance=this;return this.getJSON(this.getUrl("System/Logs",query),signal).then(function(items){var result={Items:items,TotalRecordCount:items.length};return query&&(result.Items=limitItemsFromQuery(result.Items,query)),setLogsProperties(instance,result.Items),result})}},{key:"getLogs",value:function(query,signal){if(this.isMinServerVersion("4.6.0.37")){var instance=this;return this.getJSON(this.getUrl("System/Logs/Query",query),signal).then(function(result){return setLogsProperties(instance,result.Items),result})}return this._getLogsLegacy(query,signal)}},{key:"getLogDownloadUrl",value:function(_ref10){var Name=_ref10.Name,url=this.getUrl("System/Logs/".concat(Name));return url+="?api_key=".concat(this.accessToken())}},{key:"getLogLines",value:function(options,signal){var name=options.name;options.name=null;var url=this.getUrl("System/Logs/".concat(name,"/Lines"),options||{});return this.getJSON(url,signal)}},{key:"getParentalRatings",value:function(){var url=this.getUrl("Localization/ParentalRatings");return this.getJSON(url)}},{key:"getImageUrl",value:function(itemId,options){if(!itemId)throw new Error("itemId cannot be empty");options=options||{};var url="Items/".concat(itemId,"/Images/").concat(options.type);return null!=options.index&&(url+="/".concat(options.index)),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(url,options)}},{key:"getLogoImageUrl",value:function(item,options,preferredLogoImageTypes){for(var i=0,length=preferredLogoImageTypes.length;i<length;i++){var logoType=preferredLogoImageTypes[i];if(item.ImageTags&&item.ImageTags[logoType])return options.type=logoType,options.tag=item.ImageTags[logoType],this.getImageUrl(item.Id,options)}return item.ParentLogoImageTag?(options.tag=item.ParentLogoImageTag,options.type="Logo",this.getImageUrl(item.ParentLogoItemId,options)):("TvChannel"===item.Type||"ChannelManagementInfo"===item.Type)&&item.ImageTags&&item.ImageTags.Primary?(options.tag=item.ImageTags.Primary,options.type="Primary",this.getImageUrl(item.Id,options)):null}},{key:"getUserImageUrl",value:function(userId,options){if(!userId)throw new Error("null userId");options=options||{};var url="Users/".concat(userId,"/Images/").concat(options.type);return null!=options.index&&(url+="/".concat(options.index)),normalizeImageOptions(this,options),delete options.type,delete options.index,this.getUrl(url,options)}},{key:"getThumbImageUrl",value:function(item,options){if(!item)throw new Error("null item");return(options=options||{}).imageType="thumb",item.ImageTags&&item.ImageTags.Thumb?(options.tag=item.ImageTags.Thumb,this.getImageUrl(item.Id,options)):item.ParentThumbItemId?(options.tag=item.ImageTags.ParentThumbImageTag,this.getImageUrl(item.ParentThumbItemId,options)):null}},{key:"updateUserPassword",value:function(userId,currentPassword,newPassword){if(!userId)return Promise.reject();var url=this.getUrl("Users/".concat(userId,"/Password")),serverId=this.serverId(),instance=this;return this.ajax({type:"POST",url:url,data:JSON.stringify({CurrentPw:currentPassword||"",NewPw:newPassword}),contentType:"application/json"}).then(function(){return removeCachedUser(instance,userId,serverId),Promise.resolve()})}},{key:"updateEasyPassword",value:function(userId,newPassword){var instance=this;if(userId){var url=this.getUrl("Users/".concat(userId,"/EasyPassword")),serverId=this.serverId();return this.ajax({type:"POST",url:url,data:{NewPw:newPassword}}).then(function(){return removeCachedUser(instance,userId,serverId),Promise.resolve()})}Promise.reject()}},{key:"resetUserPassword",value:function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/".concat(userId,"/Password")),serverId=this.serverId(),postData={resetPassword:!0},instance=this;return this.ajax({type:"POST",url:url,data:postData}).then(function(){return removeCachedUser(instance,userId,serverId),Promise.resolve()})}},{key:"resetEasyPassword",value:function(userId){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/".concat(userId,"/EasyPassword")),serverId=this.serverId(),postData={resetPassword:!0},instance=this;return this.ajax({type:"POST",url:url,data:postData}).then(function(){return removeCachedUser(instance,userId,serverId),Promise.resolve()})}},{key:"updateServerConfiguration",value:function(configuration){if(!configuration)throw new Error("null configuration");var url=this.getUrl("System/Configuration");return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})}},{key:"updateNamedConfiguration",value:function(name,configuration){if(!configuration)throw new Error("null configuration");var url=this.getUrl("System/Configuration/".concat(name));return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})}},{key:"updateItem",value:function(item){if(!item)throw new Error("null item");var url=this.getUrl("Items/".concat(item.Id));return this.ajax({type:"POST",url:url,data:JSON.stringify(item),contentType:"application/json"}).then(onItemUpdated.bind({instance:this,itemId:item.Id}))}},{key:"updatePluginSecurityInfo",value:function(info){var url=this.getUrl("Plugins/SecurityInfo");return this.ajax({type:"POST",url:url,data:JSON.stringify(info),contentType:"application/json"})}},{key:"createUser",value:function(name){var url=this.getUrl("Users/New");return this.ajax({type:"POST",url:url,data:{Name:name},dataType:"json"})}},{key:"updateUser",value:function(user){if(!user)throw new Error("null user");var url=this.getUrl("Users/".concat(user.Id));return this.ajax({type:"POST",url:url,data:JSON.stringify(user),contentType:"application/json"})}},{key:"updateUserPolicy",value:function(userId,policy){if(!userId)throw new Error("null userId");if(!policy)throw new Error("null policy");var url=this.getUrl("Users/".concat(userId,"/Policy")),instance=this;return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(instance,userId,instance.serverId()),this.ajax({type:"POST",url:url,data:JSON.stringify(policy),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(instance,userId,instance.serverId()),Promise.resolve()})}},{key:"updateUserConfiguration",value:function(userId,configuration){if(!userId)throw new Error("null userId");if(!configuration)throw new Error("null configuration");var url=this.getUrl("Users/".concat(userId,"/Configuration")),instance=this;return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(instance,userId,instance.serverId()),this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"}).then(function(){return instance.getCurrentUserId()===userId&&(instance._userViewsPromise=null),removeCachedUser(instance,userId,instance.serverId()),Promise.resolve()})}},{key:"updateScheduledTaskTriggers",value:function(id,triggers){if(!id)throw new Error("null id");if(!triggers)throw new Error("null triggers");var url=this.getUrl("ScheduledTasks/".concat(id,"/Triggers"));return this.ajax({type:"POST",url:url,data:JSON.stringify(triggers),contentType:"application/json"})}},{key:"updatePluginConfiguration",value:function(id,configuration){if(!id)throw new Error("null Id");if(!configuration)throw new Error("null configuration");var url=this.getUrl("Plugins/".concat(id,"/Configuration"));return this.ajax({type:"POST",url:url,data:JSON.stringify(configuration),contentType:"application/json"})}},{key:"getAncestorItems",value:function(itemId,userId){if(!itemId)throw new Error("null itemId");var options={};userId&&(options.userId=userId);var url=this.getUrl("Items/".concat(itemId,"/Ancestors"),options);return this.getJSON(url)}},{key:"getItems",value:function(userId,options,signal){if(!this.supportsGlobalSearch()){if("Person"===options.IncludeItemTypes)return options.IncludeItemTypes=null,this.getPeople(userId,options,signal);if("Tag"===options.IncludeItemTypes)return options.IncludeItemTypes=null,this.getTags(userId,options,signal);if("MusicArtist"===options.IncludeItemTypes)return options.IncludeItemTypes=null,this.getArtists(userId,options,signal)}var url="string"===(typeof userId).toString().toLowerCase()?this.getUrl("Users/".concat(userId,"/Items"),options):this.getUrl("Items",options);return this.getJSON(url,signal)}},{key:"getLiveTvChannelTags",value:function(options,signal){if(!this.isMinServerVersion("4.6.0.23"))return Promise.resolve({Items:[]});(options=options||{}).UserId=this.getCurrentUserId();var url=this.getUrl("LiveTv/ChannelTags",options);return this.getJSON(url,signal)}},{key:"getLiveTvChannelTagPrefixes",value:function(options,signal){if(!this.isMinServerVersion("4.6.0.23"))return Promise.resolve({Items:[]});(options=options||{}).UserId=this.getCurrentUserId();var url=this.getUrl("LiveTv/ChannelTags/Prefixes",options);return this.getJSON(url,signal)}},{key:"getResumableItems",value:function(userId,options){return this.getJSON(this.getUrl("Users/".concat(userId,"/Items/Resume"),options))}},{key:"getMovieRecommendations",value:function(options){return this.getJSON(this.getUrl("Movies/Recommendations",options))}},{key:"getUpcomingEpisodes",value:function(options){return this.getJSON(this.getUrl("Shows/Upcoming",options))}},{key:"getUserViews",value:function(options,userId,signal){var currentUserId=this.getCurrentUserId(),enableCache=!((userId=userId||currentUserId)!==currentUserId||options&&options.IncludeHidden);if(enableCache&&this._userViewsPromise)return this._userViewsPromise;var url=this.getUrl("Users/".concat(userId,"/Views"),options),self=this,promise=this.getJSON(url,signal).catch(function(){self._userViewsPromise=null});return enableCache&&(this._userViewsPromise=promise),promise}},{key:"getArtists",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Artists",options);return this.getJSON(url)}},{key:"getAlbumArtists",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Artists/AlbumArtists",options);return this.getJSON(url)}},{key:"getGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Genres",options);return this.getJSON(url)}},{key:"getMusicGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("MusicGenres",options);return this.getJSON(url)}},{key:"getGameGenres",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("GameGenres",options);return this.getJSON(url)}},{key:"getPeople",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Persons",options);return this.getJSON(url)}},{key:"getThumbnails",value:function(itemId,options){if(isLocalId(itemId))return Promise.resolve({Thumbnails:[]});var url=this.getUrl("Items/".concat(itemId,"/ThumbnailSet"),options);return this.getJSON(url)}},{key:"getDeleteInfo",value:function(itemId,options){var url=this.getUrl("Items/".concat(itemId,"/DeleteInfo"),options);return this.getJSON(url)}},{key:"getStudios",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Studios",options);return this.getJSON(url)}},{key:"getOfficialRatings",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("OfficialRatings",options);return this.getJSON(url)}},{key:"getYears",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Years",options);return this.getJSON(url)}},{key:"getTags",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Tags",options);return this.getJSON(url).then(function(result){for(var serverId=this.serverId(),items=result.Items||result,i=0,length=items.length;i<length;i++){var item=items[i];item.ServerId=serverId,item.Type="Tag"}return result}.bind(this))}},{key:"getItemTypes",value:function(userId,options){if(!this.isMinServerVersion("4.5.3"))return Promise.resolve({Items:(list=[],(collectionType=options.CollectionType)&&"movies"!==collectionType||list.push("Movie"),collectionType&&"tvshows"!==collectionType||(list.push("Series"),list.push("Episode")),collectionType||list.push("LiveTvProgram"),collectionType&&"livetv"!==collectionType||list.push("TvChannel"),"livetv"!==collectionType&&list.push("Video"),collectionType&&"musicvideos"!==collectionType||list.push("MusicVideo"),list.push("Trailer"),list.push("Person"),list.push("Tag"),collectionType&&"music"!==collectionType||(list.push("MusicArtist"),list.push("MusicAlbum")),collectionType&&"music"!==collectionType&&"audiobooks"!==collectionType||list.push("Audio"),collectionType&&"homevideos"!==collectionType||(list.push("Photo"),list.push("PhotoAlbum")),collectionType&&"books"!==collectionType||list.push("Book"),collectionType&&"games"!==collectionType||list.push("Game"),list.push("Playlist"),list.push("BoxSet"),list)});var list,collectionType;if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("ItemTypes",options);return this.getJSON(url)}},{key:"getContainers",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Containers",options);return this.getJSON(url)}},{key:"getAudioCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("AudioCodecs",options);return this.getJSON(url)}},{key:"getStreamLanguages",value:function(userId,options){if(!this.isMinServerVersion("4.5.0.15"))return Promise.resolve({Items:[]});if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("StreamLanguages",options);return this.getJSON(url)}},{key:"getVideoCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("VideoCodecs",options);return this.getJSON(url)}},{key:"getSubtitleCodecs",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("SubtitleCodecs",options);return this.getJSON(url)}},{key:"getDefaultPrefixes",value:function(){return Promise.resolve(["#","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"].map(mapPrefix))}},{key:"getPrefixes",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Items/Prefixes",options);return this.getJSON(url)}},{key:"getArtistPrefixes",value:function(userId,options){if(!userId)throw new Error("null userId");(options=options||{}).userId=userId;var url=this.getUrl("Artists/Prefixes",options);return this.getJSON(url)}},{key:"getLocalTrailers",value:function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/LocalTrailers"));return this.getJSON(url)}},{key:"getGameSystems",value:function(){var options={},userId=this.getCurrentUserId();userId&&(options.userId=userId);var url=this.getUrl("Games/SystemSummaries",options);return this.getJSON(url)}},{key:"getAdditionalVideoParts",value:function(userId,itemId){if(!itemId)throw new Error("null itemId");var options={};userId&&(options.userId=userId);var url=this.getUrl("Videos/".concat(itemId,"/AdditionalParts"),options);return this.getJSON(url)}},{key:"getThemeMedia",value:function(itemId,options){var url=this.getUrl("Items/".concat(itemId,"/ThemeMedia"),options);return this.getJSON(url)}},{key:"getAudioStreamUrl",value:function(_ref11,_ref12,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var Id=_ref11.Id,Container=_ref12.Container,Protocol=_ref12.Protocol,AudioCodec=_ref12.AudioCodec,url="Audio/".concat(Id,"/universal");return startingPlaySession++,this.getUrl(url,{UserId:this.getCurrentUserId(),DeviceId:this.deviceId(),MaxStreamingBitrate:maxBitrate,Container:directPlayContainers,TranscodingContainer:Container||null,TranscodingProtocol:Protocol||null,AudioCodec:AudioCodec,MaxAudioSampleRate:maxAudioSampleRate,MaxAudioBitDepth:maxAudioBitDepth,api_key:this.accessToken(),PlaySessionId:startingPlaySession,StartTimeTicks:startPosition||0,EnableRedirection:!0,EnableRemoteMedia:enableRemoteMedia})}},{key:"getAudioStreamUrls",value:function(items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){for(var streamUrls=[],i=0,length=items.length;i<length;i++){var item=items[i],streamUrl=void 0;"Audio"===item.MediaType&&(streamUrl=this.getAudioStreamUrl(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)),streamUrls.push(streamUrl||""),0===i&&(startPosition=0)}return Promise.resolve(streamUrls)}},{key:"getSpecialFeatures",value:function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/SpecialFeatures"));return this.getJSON(url)}},{key:"getDateParamValue",value:function(date){function formatDigit(i){return i<10?"0".concat(i):i}var d=date;return"".concat(d.getFullYear()).concat(formatDigit(d.getMonth()+1)).concat(formatDigit(d.getDate())).concat(formatDigit(d.getHours())).concat(formatDigit(d.getMinutes())).concat(formatDigit(d.getSeconds()))}},{key:"markPlayed",value:function(userId,itemId,date){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var options={};date&&(options.DatePlayed=this.getDateParamValue(date));var url=this.getUrl("Users/".concat(userId,"/PlayedItems/").concat(itemId),options);return this.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"markUnplayed",value:function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/PlayedItems/").concat(itemId));return this.ajax({type:"DELETE",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"updateFavoriteStatus",value:function(userId,itemId,isFavorite){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/FavoriteItems/").concat(itemId)),method=isFavorite?"POST":"DELETE";return this.ajax({type:method,url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"updateUserItemRating",value:function(userId,itemId,likes){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/Rating"),{likes:likes});return this.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"updateHideFromResume",value:function(itemId,hide){if(!itemId)throw new Error("null itemId");var userId=this.getCurrentUserId(),url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/HideFromResume"),{Hide:!1!==hide});return this.ajax({type:"POST",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"getItemCounts",value:function(userId){var options={};userId&&(options.userId=userId);var url=this.getUrl("Items/Counts",options);return this.getJSON(url)}},{key:"clearUserItemRating",value:function(userId,itemId){if(!userId)throw new Error("null userId");if(!itemId)throw new Error("null itemId");var url=this.getUrl("Users/".concat(userId,"/Items/").concat(itemId,"/Rating"));return this.ajax({type:"DELETE",url:url,dataType:"json"}).then(onUserDataUpdated.bind({instance:this,userId:userId,itemId:itemId}))}},{key:"reportPlaybackStart",value:function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing"),promise=this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url});return options.ItemId&&!isLocalId(options.ItemId)&&this.ensureWebSocket(),promise}},{key:"reportPlaybackProgress",value:function(options){if(!options)throw new Error("null options");var newPositionTicks=options.PositionTicks;if("timeupdate"===(options.EventName||"timeupdate")){var now=Date.now(),msSinceLastReport=now-(this.lastPlaybackProgressReport||0);if(msSinceLastReport<=1e4){if(!newPositionTicks)return Promise.resolve();var expectedReportTicks=1e4*msSinceLastReport+(this.lastPlaybackProgressReportTicks||0);if(Math.abs((newPositionTicks||0)-expectedReportTicks)<5e7)return Promise.resolve()}this.lastPlaybackProgressReport=now}else this.lastPlaybackProgressReport=0;this.lastPlaybackProgressReportTicks=newPositionTicks;var url=this.getUrl("Sessions/Playing/Progress");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})}},{key:"reportOfflineActions",value:function(actions){if(!actions)throw new Error("null actions");var url=this.getUrl("Sync/OfflineActions");return this.ajax({type:"POST",data:JSON.stringify(actions),contentType:"application/json",url:url})}},{key:"syncData",value:function(data){if(!data)throw new Error("null data");var url=this.getUrl("Sync/Data");return this.ajax({type:"POST",data:JSON.stringify(data),contentType:"application/json",url:url,dataType:"json"})}},{key:"getReadySyncItems",value:function(deviceId){if(!deviceId)throw new Error("null deviceId");var url=this.getUrl("Sync/Items/Ready",{TargetId:deviceId});return this.getJSON(url)}},{key:"reportSyncJobItemTransferred",value:function(syncJobItemId){if(!syncJobItemId)throw new Error("null syncJobItemId");var url=this.getUrl("Sync/JobItems/".concat(syncJobItemId,"/Transferred"));return this.ajax({type:"POST",url:url})}},{key:"cancelSyncItems",value:function(itemIds,targetId){if(!itemIds)throw new Error("null itemIds");var url=this.getUrl("Sync/".concat(targetId||this.deviceId(),"/Items"),{ItemIds:itemIds.join(",")});return this.ajax({type:"DELETE",url:url})}},{key:"clearUserTrackSelections",value:function(userId,type){if(!userId)throw new Error("null userId");var url=this.getUrl("Users/".concat(userId,"/TrackSelections/").concat(type)),serverId=this.serverId(),instance=this;return this.ajax({type:"DELETE",url:url}).then(function(){removeCachedUser(instance,userId,serverId)})}},{key:"reportPlaybackStopped",value:function(options){if(!options)throw new Error("null options");this.lastPlaybackProgressReport=0,this.lastPlaybackProgressReportTicks=null;var url=this.getUrl("Sessions/Playing/Stopped");return this.ajax({type:"POST",data:JSON.stringify(options),contentType:"application/json",url:url})}},{key:"sendPlayCommand",value:function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(!options)throw new Error("null options");var url=this.getUrl("Sessions/".concat(sessionId,"/Playing"),options);return this.ajax({type:"POST",url:url})}},{key:"sendCommand",value:function(sessionId,command){if(!sessionId)throw new Error("null sessionId");if(!command)throw new Error("null command");var ajaxOptions={type:"POST",url:this.getUrl("Sessions/".concat(sessionId,"/Command"))};return ajaxOptions.data=JSON.stringify(command),ajaxOptions.contentType="application/json",this.ajax(ajaxOptions)}},{key:"sendMessageCommand",value:function(sessionId,options){if(!sessionId)throw new Error("null sessionId");if(!options)throw new Error("null options");var ajaxOptions={type:"POST",url:this.getUrl("Sessions/".concat(sessionId,"/Message"))};return ajaxOptions.data=JSON.stringify(options),ajaxOptions.contentType="application/json",this.ajax(ajaxOptions)}},{key:"sendPlayStateCommand",value:function(sessionId,command,options){if(!sessionId)throw new Error("null sessionId");if(!command)throw new Error("null command");var url=this.getUrl("Sessions/".concat(sessionId,"/Playing/").concat(command),options||{});return this.ajax({type:"POST",url:url})}},{key:"getSavedEndpointInfo",value:function(){return this._endPointInfo}},{key:"getEndpointInfo",value:function(){var savedValue=this._endPointInfo;if(savedValue)return Promise.resolve(savedValue);var instance=this;return this.getJSON(this.getUrl("System/Endpoint")).then(function(endPointInfo){return setSavedEndpointInfo(instance,endPointInfo),endPointInfo})}},{key:"getWakeOnLanInfo",value:function(){return this.getJSON(this.getUrl("System/WakeOnLanInfo"))}},{key:"getLatestItems",value:function(argument_0){var options=0<arguments.length&&void 0!==argument_0?argument_0:{};return this.getJSON(this.getUrl("Users/".concat(this.getCurrentUserId(),"/Items/Latest"),options))}},{key:"getPlayQueue",value:function(options){return this.isMinServerVersion("4.6")?this.getJSON(this.getUrl("Sessions/PlayQueue",options)):Promise.resolve({Items:[],TotalRecordCount:0})}},{key:"supportsWakeOnLan",value:function(){return!!this._wakeOnLan.isSupported()&&0<getCachedWakeOnLanInfo(this).length}},{key:"wakeOnLan",value:function(){var infos=getCachedWakeOnLanInfo(this);return function sendNextWakeOnLan(wakeOnLan,infos,index){if(index>=infos.length)return Promise.resolve();var info=infos[index];function goNext(){return sendNextWakeOnLan(wakeOnLan,infos,index+1)}return console.log("sending wakeonlan to ".concat(info.MacAddress)),wakeOnLan.send(info).then(goNext,goNext)}(this._wakeOnLan,infos,0)}},{key:"setSystemInfo",value:function(_ref13){var Version=_ref13.Version;this._serverVersion=Version,this._queryStringAuth=!0}},{key:"serverVersion",value:function(){return this._serverVersion}},{key:"isMinServerVersion",value:function(version){var serverVersion=this.serverVersion();return!!serverVersion&&0<=function(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}(serverVersion,version)}},{key:"handleMessageReceived",value:function(msg){onMessageReceivedInternal(this,msg)}},{key:"supportsGlobalSearch",value:function(){return this.isMinServerVersion("4.5.3")}},{key:"getSearchResults",value:function(query){if(!query.SearchTerm||query.SearchTerm.length<2)return Promise.resolve({Items:[],TotalRecordCount:0,ItemTypes:[]});var promises=[];return query.IncludeItemTypes||this.supportsGlobalSearch()?promises.push(this.getItems(this.getCurrentUserId(),query)):promises.push(Promise.resolve({Items:[],TotalRecordCount:0})),query.StartIndex||query.IncludeItemTypes||!1===query.IncludeSearchTypes||promises.push(this.getItemTypes(this.getCurrentUserId(),query)),Promise.all(promises).then(function(responses){return 1<responses.length&&(responses[0].ItemTypes=responses[1].Items),responses[0]})}},{key:"getToneMapOptions",value:function(){if(!this.isMinServerVersion("4.6.0.25"))return Promise.resolve({OptionsVisibility:{}});var url=this.getUrl("Encoding/ToneMapOptions");return this.getJSON(url)}},{key:"removeItemsFromPlaylist",value:function(playlistId,items){for(var playlistItemIds=[],i=0,length=items.length;i<length;i++)playlistItemIds.push(items[i].PlaylistItemId);return this.ajax({url:this.getUrl("Playlists/"+playlistId+"/Items",{EntryIds:playlistItemIds.join(",")}),type:"DELETE"}).then(function(result){var instance=this.instance,playlistItemIds=this.playlistItemIds,playlistId=this.playlistId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromPlaylist",Data:{PlaylistId:playlistId,PlaylistItemIds:playlistItemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,playlistItemIds:playlistItemIds,playlistId:playlistId}))}},{key:"removeItemsFromCollection",value:function(collectionId,items){for(var itemIds=[],i=0,length=items.length;i<length;i++)itemIds.push(items[i].Id);return this.ajax({url:this.getUrl("Collections/"+collectionId+"/Items",{Ids:itemIds.join(",")}),type:"DELETE"}).then(function(result){var instance=this.instance,itemIds=this.itemIds,collectionId=this.collectionId;return _events.default.trigger(instance,"message",[{MessageType:"ItemsRemovedFromCollection",Data:{CollectionId:collectionId,ItemIds:itemIds,IsLocalEvent:!0}}]),result}.bind({instance:this,itemIds:itemIds,collectionId:collectionId}))}}]),ApiClient}();ApiClient.prototype.getScaledImageUrl=function(itemId,options){return this.getImageUrl(itemId,options)},_exports.default=ApiClient});