define(["exports","./apiclient.js"],function(_exports,_apiclient){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_apiclient=babelHelpers.interopRequireDefault(_apiclient);var localPrefix="local:";function isLocalId(str){return str&&str.startsWith(localPrefix)}function isLocalViewId(str){return str&&str.startsWith("localview:")}function stripLocalPrefix(str){var res=stripStart(str,localPrefix);return res=stripStart(res,"localview:")}function stripStart(str,find){return str&&find&&str.startsWith(find)?str.substr(find.length):str}function createEmptyList(){return{Items:[],TotalRecordCount:0}}function convertGuidToLocal(guid){return guid?isLocalId(guid)?guid:"local:"+guid:null}function syncNow(){require(["localsync"],function(localSync){localSync.sync()})}function getLocalUrl(_ref){var MediaSources=_ref.MediaSources;if(MediaSources&&MediaSources.length){var mediaSource=MediaSources[0];return mediaSource.StreamUrl||mediaSource.Path}return""}function adjustGuidProperties(downloadedItem){downloadedItem.Id=convertGuidToLocal(downloadedItem.Id),downloadedItem.SeriesId=convertGuidToLocal(downloadedItem.SeriesId),downloadedItem.SeasonId=convertGuidToLocal(downloadedItem.SeasonId),downloadedItem.AlbumId=convertGuidToLocal(downloadedItem.AlbumId),downloadedItem.ParentId=convertGuidToLocal(downloadedItem.ParentId),downloadedItem.ParentThumbItemId=convertGuidToLocal(downloadedItem.ParentThumbItemId),downloadedItem.ParentPrimaryImageItemId=convertGuidToLocal(downloadedItem.ParentPrimaryImageItemId),downloadedItem.PrimaryImageItemId=convertGuidToLocal(downloadedItem.PrimaryImageItemId),downloadedItem.ParentLogoItemId=convertGuidToLocal(downloadedItem.ParentLogoItemId),downloadedItem.ParentBackdropItemId=convertGuidToLocal(downloadedItem.ParentBackdropItemId),downloadedItem.ParentBackdropImageTags=null}function getLocalView(instance,serverId,userId){return instance.getLocalFolders(serverId,userId).then(function(views){var localView=null;return 0<views.length&&(localView={Name:instance.downloadsTitleText||"Downloads",ServerId:serverId,Id:"localview",Type:"localview",IsFolder:!0}),Promise.resolve(localView)})}var ApiClientEx=function(_ApiClient){babelHelpers.inherits(ApiClientEx,_ApiClient);var _super=_createSuper(ApiClientEx);function ApiClientEx(appStorage,wakeOnLan,serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio,localassetmanager,itemrepository,useractionrepository){var _this;return babelHelpers.classCallCheck(this,ApiClientEx),(_this=_super.call(this,appStorage,wakeOnLan,serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio)).localassetmanager=localassetmanager,_this.itemrepository=itemrepository,_this.useractionrepository=useractionrepository,_this}return babelHelpers.createClass(ApiClientEx,[{key:"getPlaybackInfo",value:function(itemId,options,deviceProfile){var promises=[];return isLocalId(itemId)||options&&isLocalId(options.MediaSourceId)?promises.push(Promise.resolve({MediaSources:[]})):promises.push(babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getPlaybackInfo",this).call(this,itemId,options,deviceProfile)),options&&options.MediaSourceId&&!isLocalId(options.MediaSourceId)?promises.push(Promise.resolve({MediaSources:[]})):promises.push(this.itemrepository.getLibraryItem(this.serverId(),stripLocalPrefix(itemId)).then(function(item){return!item||item.SyncStatus&&"synced"!==item.SyncStatus?{MediaSources:[]}:{MediaSources:item.Item.MediaSources.map(function(m){return null!=options.AudioStreamIndex&&(m.DefaultAudioStreamIndex=parseInt(options.AudioStreamIndex)),null!=options.SubtitleStreamIndex&&(m.DefaultSubtitleStreamIndex=parseInt(options.SubtitleStreamIndex)),m.SupportsDirectPlay=!0,m.SupportsDirectStream=!1,m.SupportsTranscoding=!1,m.IsLocal=!0,m.Name="Downloaded version",m.Id=localPrefix+m.Id,m})}})),Promise.all(promises).then(function(results){for(var result=results[0],localResult=results[1],i=0,length=localResult.MediaSources.length;i<length;i++)result.MediaSources.unshift(localResult.MediaSources[i]);return result})}},{key:"getAudioStreamUrl",value:function(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){if(isLocalId(item.Id)&&item.MediaSources&&item.MediaSources.length){var mediaSource=item.MediaSources[0];return mediaSource.StreamUrl||mediaSource.Path}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getAudioStreamUrl",this).call(this,item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)}},{key:"getAudioStreamUrls",value:function(items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var _this2=this;if(!items.length)return Promise.resolve([]);if(isLocalId(items[0].Id))return Promise.resolve(items.map(getLocalUrl));var self=this,ids=items.map(function(_ref2){return _ref2.Id});return this.itemrepository.getLibraryItemPathsByIds(items[0].ServerId,ids).then(function(localItems){var localItemMap={},localUrls=localItems.map(function(libraryItem){return(localItemMap[libraryItem.ItemId]=libraryItem).LocalPath});if(localUrls.length===items.length)return localUrls;if(localItems.length){for(var streamUrls=[],i=0;i<items.length;i++){var item=items[i],streamUrl=void 0;streamUrl=localItemMap[item.Id]?localItemMap[item.Id].LocalPath:babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getAudioStreamUrl",_this2).call(self,item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia),streamUrls.push(streamUrl||"")}return streamUrls}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getAudioStreamUrls",_this2).call(self,items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)})}},{key:"getItems",value:function(userId,options){var serverInfo=this.serverInfo();if(serverInfo&&"localview"===options.ParentId)return this.getLocalFolders(serverInfo.Id,userId).then(function(items){var result={Items:items,TotalRecordCount:items.length};return Promise.resolve(result)});if(serverInfo&&options&&(isLocalId(options.ParentId)||isLocalId(options.SeriesId)||isLocalId(options.SeasonId)||isLocalViewId(options.ParentId)||isLocalId(options.AlbumIds)))return this.itemrepository.getLibraryItems(serverInfo.Id,options).then(function(result){return result.Items.forEach(function(item){adjustGuidProperties(item)}),Promise.resolve(result)});if(options&&options.ExcludeItemIds&&options.ExcludeItemIds.length){for(var exItems=options.ExcludeItemIds.split(","),i=0;i<exItems.length;i++)if(isLocalId(exItems[i]))return Promise.resolve(createEmptyList())}else if(options&&options.Ids&&options.Ids.length){var ids=options.Ids.split(","),hasLocal=!1;for(i=0;i<ids.length;i++)if(isLocalId(ids[i])){hasLocal=!0;break}if(hasLocal){var localIds=ids.map(stripLocalPrefix);return this.itemrepository.getLibraryItemsByIds(serverInfo.Id,localIds).then(function(items){items.forEach(function(_ref3){adjustGuidProperties(_ref3.Item)});var libraryItems=items.map(function(_ref4){return _ref4.Item}),result={Items:libraryItems,TotalRecordCount:libraryItems.length};return Promise.resolve(result)})}}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getItems",this).call(this,userId,options)}},{key:"getUserViews",value:function(options,userId,signal){var instance=this;options=options||{};var basePromise=babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getUserViews",this).apply(instance,arguments);return options.enableLocalView?basePromise.then(function(result){var serverInfo=instance.serverInfo();return serverInfo?getLocalView(instance,serverInfo.Id,userId).then(function(localView){return localView&&(result.Items.push(localView),result.TotalRecordCount++),Promise.resolve(result)}):Promise.resolve(result)}):basePromise}},{key:"getItem",value:function(userId,itemId,options){if(!itemId)throw new Error("null itemId");var serverInfo;return"localview"===(itemId=itemId&&itemId.toString())&&(serverInfo=this.serverInfo())?getLocalView(this,serverInfo.Id,userId):isLocalViewId(itemId)&&(serverInfo=this.serverInfo())?this.getLocalFolders(serverInfo.Id,userId).then(function(items){var views=items.filter(function(_ref5){return _ref5.Id===itemId});return 0<views.length?Promise.resolve(views[0]):Promise.reject()}):isLocalId(itemId)?(serverInfo=this.serverInfo())?this.itemrepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(itemId)).then(function(item){return item?(adjustGuidProperties(item.Item),Promise.resolve(item.Item)):Promise.reject()}):Promise.reject():babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getItem",this).call(this,userId,itemId,options)}},{key:"getLocalFolders",value:function(userId){var itemrepository,serverId,serverInfo=this.serverInfo();return userId=userId||serverInfo.UserId,itemrepository=this.itemrepository,serverId=serverInfo.Id,itemrepository.getLibarytemTypes(serverId).then(function(types){var list=[];return types.includes("Audio")&&list.push({Name:"Music",ServerId:serverId,Id:"localview:MusicView",Type:"MusicView",CollectionType:"music",IsFolder:!0}),types.includes("Photo")&&list.push({Name:"Photos",ServerId:serverId,Id:"localview:PhotosView",Type:"PhotosView",CollectionType:"photos",IsFolder:!0}),types.includes("Episode")&&list.push({Name:"TV",ServerId:serverId,Id:"localview:TVView",Type:"TVView",CollectionType:"tvshows",IsFolder:!0}),types.includes("Movie")&&list.push({Name:"Movies",ServerId:serverId,Id:"localview:MoviesView",Type:"MoviesView",CollectionType:"movies",IsFolder:!0}),types.includes("Video")&&list.push({Name:"Videos",ServerId:serverId,Id:"localview:VideosView",Type:"VideosView",IsFolder:!0}),types.includes("MusicVideo")&&list.push({Name:"Music Videos",ServerId:serverId,Id:"localview:MusicVideosView",Type:"MusicVideosView",CollectionType:"musicvideos",IsFolder:!0}),types.includes("Trailer")&&list.push({Name:"Trailers",ServerId:serverId,Id:"localview:TrailersView",Type:"TrailersView",IsFolder:!0}),list}).catch(function(){return[]})}},{key:"getNextUpEpisodes",value:function(options){return options.SeriesId&&isLocalId(options.SeriesId)?Promise.resolve(createEmptyList()):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getNextUpEpisodes",this).call(this,options)}},{key:"getSyncStatus",value:function(itemId){return isLocalId(itemId)?Promise.resolve({}):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getSyncStatus",this).call(this,itemId)}},{key:"getSeasons",value:function(itemId,options){return isLocalId(itemId)?(options.SeriesId=itemId,options.IncludeItemTypes="Season",options.Recursive?options.SortBy="ParentIndexNumber,IndexNumber":options.SortBy="IndexNumber",this.getItems(this.getCurrentUserId(),options)):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getSeasons",this).call(this,itemId,options)}},{key:"getEpisodes",value:function(itemId,options){return isLocalId(options.SeasonId)||isLocalId(options.seasonId)||isLocalId(itemId)?(options.SeriesId=itemId,options.IncludeItemTypes="Episode",options.SortBy="ParentIndexNumber,IndexNumber,SortName",this.getItems(this.getCurrentUserId(),options)):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getEpisodes",this).call(this,itemId,options)}},{key:"getLatestOfflineItems",value:function(options){options.SortBy="DateCreated",options.SortOrder="Descending",options.EnableTotalRecordCount=!1;var serverInfo=this.serverInfo();return serverInfo?this.itemrepository.getLibraryItems(serverInfo.Id,options).then(function(_ref6){var items=_ref6.Items;return items.forEach(function(item){adjustGuidProperties(item)}),Promise.resolve(items)}):Promise.resolve([])}},{key:"getThemeMedia",value:function(itemId,options){return isLocalViewId(itemId)||isLocalId(itemId)||"localview"===itemId?Promise.resolve({ThemeVideosResult:{Items:[],TotalRecordCount:0},ThemeSongsResult:{Items:[],TotalRecordCount:0}}):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getThemeMedia",this).call(this,itemId,options)}},{key:"getSpecialFeatures",value:function(userId,itemId){return isLocalId(itemId)?Promise.resolve([]):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getSpecialFeatures",this).call(this,userId,itemId)}},{key:"getSimilarItems",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve(createEmptyList()):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getSimilarItems",this).call(this,itemId,options)}},{key:"updateFavoriteStatus",value:function(userId,itemId,isFavorite){return isLocalId(itemId)?Promise.resolve():babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"updateFavoriteStatus",this).call(this,userId,itemId,isFavorite)}},{key:"getImageUrl",value:function(itemId,options){if(isLocalId(itemId)||options&&options.itemid&&isLocalId(options.itemid)){var serverInfo=this.serverInfo(),id=stripLocalPrefix(itemId);return this.localassetmanager.getImageUrl(serverInfo.Id,id,options)}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getImageUrl",this).call(this,itemId,options)}},{key:"reportPlaybackStart",value:function(options){if(!options)throw new Error("null options");return isLocalId(options.ItemId)?Promise.resolve():babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"reportPlaybackStart",this).call(this,options)}},{key:"reportPlaybackProgress",value:function(options){if(!options)throw new Error("null options");if(isLocalId(options.ItemId)){var serverInfo=this.serverInfo();if(serverInfo){var instance=this;return this.itemrepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(options.ItemId)).then(function(item){var libraryItem=item.Item;return"Video"===libraryItem.MediaType||"AudioBook"===libraryItem.Type||libraryItem.SupportsResume?(libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.PlaybackPositionTicks=options.PositionTicks,libraryItem.UserData.PlayedPercentage=Math.min(libraryItem.RunTimeTicks?(options.PositionTicks||0)/libraryItem.RunTimeTicks*100:0,100),libraryItem.UserData.PlaybackPositionTicks&&libraryItem.RunTimeTicks&&libraryItem.UserData.PlaybackPositionTicks>=.9*libraryItem.RunTimeTicks&&(libraryItem.UserData.Played=!0,libraryItem.UserData.PlaybackPositionTicks=0,libraryItem.UserData.PlayedPercentage=0),instance.itemrepository.updateLibraryItem(item.ServerId,item.Id,item)):Promise.resolve()})}return Promise.resolve()}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"reportPlaybackProgress",this).call(this,options)}},{key:"reportPlaybackStopped",value:function(options){if(!options)throw new Error("null options");if(isLocalId(options.ItemId)){var serverInfo=this.serverInfo();if(serverInfo){var instance=this;return this.itemrepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(options.ItemId)).then(function(item){var promise,libraryItem=item.Item;return"Video"!==libraryItem.MediaType&&"AudioBook"!==libraryItem.Type&&!libraryItem.SupportsResume||(libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.PlaybackPositionTicks=options.PositionTicks,libraryItem.UserData.PlayedPercentage=Math.min(libraryItem.RunTimeTicks?(options.PositionTicks||0)/libraryItem.RunTimeTicks*100:0,100),libraryItem.UserData.PlaybackPositionTicks&&libraryItem.RunTimeTicks&&libraryItem.UserData.PlaybackPositionTicks>=.9*libraryItem.RunTimeTicks&&(libraryItem.UserData.Played=!0,libraryItem.UserData.PlaybackPositionTicks=0,libraryItem.UserData.PlayedPercentage=0),promise=instance.itemrepository.updateLibraryItem(item.ServerId,item.Id,item)),(promise||Promise.resolve()).then(function(){var d,action={Date:Date.now(),ItemId:stripLocalPrefix(options.ItemId),PositionTicks:options.PositionTicks,ServerId:serverInfo.Id,Type:0,UserId:this.getCurrentUserId(),Id:(d=Date.now(),window.performance&&"function"==typeof window.performance.now&&(d+=performance.now()),"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=(d+16*Math.random())%16|0;return d=Math.floor(d/16),("x"===c?r:3&r|8).toString(16)}))};return this.useractionrepository.addUserAction(action.Id,action)})})}return Promise.resolve()}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"reportPlaybackStopped",this).call(this,options)}},{key:"getIntros",value:function(itemId){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getIntros",this).call(this,itemId)}},{key:"getInstantMixFromItem",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Items:[],TotalRecordCount:0}):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getInstantMixFromItem",this).call(this,itemId,options)}},{key:"getItemDownloadUrl",value:function(itemId){if(isLocalId(itemId)){var serverInfo=this.serverInfo();return serverInfo?this.itemrepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(itemId)).then(function(_ref7){var LocalPath=_ref7.LocalPath;return Promise.resolve(LocalPath)}):Promise.reject()}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getItemDownloadUrl",this).call(this,itemId)}},{key:"deleteItem",value:function(itemId){if(isLocalId(itemId)){var instance=this;return this.itemrepository.getLibraryItem(this.serverId(),stripLocalPrefix(itemId)).then(function(item){return item?instance.localassetmanager.removeLocalItem(item).then(syncNow):Promise.resolve()})}return babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"deleteItem",this).call(this,itemId)}},{key:"getDeleteInfo",value:function(itemId,options){return isLocalId(itemId)?Promise.resolve({Paths:[]}):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getDeleteInfo",this).apply(this,arguments)}},{key:"getPrefixes",value:function(userId,options){return isLocalId(options.ParentId)||isLocalId(options.GenreIds)||isLocalId(options.ArtistIds)||isLocalId(options.StudioIds)?babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getDeefaultPrefixes",this).call(this):babelHelpers.get(babelHelpers.getPrototypeOf(ApiClientEx.prototype),"getPrefixes",this).call(this,userId,options)}}]),ApiClientEx}(_apiclient.default);_exports.default=ApiClientEx});