define(["connectionManager","dom","globalize","./spotlight","imageLoader","focusManager","cardBuilder","appRouter","emby-itemscontainer"],function(connectionManager,dom,globalize,spotlight,imageLoader,focusManager,cardBuilder,appRouter){"use strict";function loadRecommendations(element,apiClient){return apiClient.getMovieRecommendations({categoryLimit:4,ItemLimit:8,UserId:apiClient.getCurrentUserId(),ImageTypeLimit:1,Fields:"PrimaryImageAspectRatio,ProductionYear,CommunityRating"}).then(function(recommendations){var itemsContainer,recommendation,values=recommendations.map(getRecommendationHtml),recs=element.querySelector(".recommendations");if(recs){recs.innerHTML='<div class="horizontalSectionsContainer">'+values.join("")+"</div>";for(var itemsContainers=recs.querySelectorAll(".itemsContainer"),i=0,length=recommendations.length;i<length;i++)itemsContainer=itemsContainers[i],recommendation=recommendations[i],cardBuilder.buildCards(recommendation.Items,{shape:"portrait",rows:2,scalable:!1,multiSelect:!1,itemsContainer:itemsContainer})}})}function getRecommendationHtml(recommendation){var title="";switch(recommendation.RecommendationType){case"SimilarToRecentlyPlayed":title=globalize.translate("BecauseYouWatchedValue",recommendation.BaselineItemName);break;case"SimilarToLikedItem":title=globalize.translate("BecauseYouLikeValue",recommendation.BaselineItemName);break;case"HasDirectorFromRecentlyPlayed":case"HasLikedDirector":title=globalize.translate("DirectedByValue",recommendation.BaselineItemName);break;case"HasActorFromRecentlyPlayed":case"HasLikedActor":title=globalize.translate("StarringValue",recommendation.BaselineItemName)}var html="";return html+='<div class="horizontalSection">',html+='<div class="sectionTitle">'+title+"</div>",html+='<div is="emby-itemscontainer" class="itemsContainer">',html+="</div>",html+="</div>"}function backdropImageUrl(item,options){return(options=options||{}).type=options.type||"Backdrop",options.maxWidth||options.width||options.maxHeight||options.height||(options.quality=100),item.BackdropImageTags&&item.BackdropImageTags.length?(options.tag=item.BackdropImageTags[0],connectionManager.getApiClient(item.ServerId).getImageUrl(item.Id,options)):null}return function(element,apiClient,parentId){var self=this;this.parentId=parentId,this.apiClient=apiClient,this.latestItemsContainer=element.querySelector(".latestSection .itemsContainer"),this.latestItemsContainer.fetchData=function(){var options={IncludeItemTypes:"Movie",Limit:12,ParentId:this.parentId,EnableImageTypes:"Primary,Backdrop,Thumb,Logo",Fields:"PrimaryImageAspectRatio,ProductionYear,CommunityRating",ImageTypeLimit:1,EnableTotalRecordCount:!1};return this.apiClient.getLatestItems(options)}.bind(this),this.latestItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{shape:"portrait",rows:2,scalable:!1,multiSelect:!1},virtualScrollLayout:"vertical-grid"}}.bind(this),this.latestItemsContainer.parentContainer=this.latestItemsContainer.closest(".horizontalSection"),this.resumeItemsContainer=element.querySelector(".resumeSection .itemsContainer"),this.resumeItemsContainer.fetchData=function(){var options={IncludeItemTypes:"Movie",Limit:6,ParentId:this.parentId,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Thumb,Logo",EnableTotalRecordCount:!1},apiClient=this.apiClient;return apiClient.getResumableItems(apiClient.getCurrentUserId(),options)}.bind(this),this.resumeItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{shape:"backdrop",rows:3,preferThumb:!0,scalable:!1,multiSelect:!1},virtualScrollLayout:"vertical-grid"}}.bind(this),this.resumeItemsContainer.parentContainer=this.resumeItemsContainer.closest(".horizontalSection"),this.categoryItemsContainer=element.querySelector(".categoryItemsContainer"),this.categoryItemsContainer.fetchData=function(){var apiClient=this.apiClient,parentId=this.parentId;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"IsFavoriteOrLiked,Random",SortOrder:"Descending",IncludeItemTypes:"BoxSet",Limit:1,Recursive:!0,ParentId:parentId,EnableImageTypes:"Backdrop",ImageTypes:"Backdrop",Fields:"PrimaryImageAspectRatio,ProductionYear,CommunityRating",ImageTypeLimit:1}).then(function(collectionResult){var collectionItems=collectionResult.Items;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"IsFavoriteOrLiked,Random",SortOrder:"Descending",IncludeItemTypes:"Movie",Limit:2,Recursive:!0,ParentId:parentId,EnableImageTypes:"Backdrop",ImageTypes:"Backdrop",Fields:"PrimaryImageAspectRatio,ProductionYear,CommunityRating",ImageTypeLimit:1}).then(function(movieResult){var movieItems=movieResult.Items,imgOptions={maxWidth:600},items=[];return items.push({Name:globalize.translate("Movies"),Id:"movies_movies",ServerId:apiClient.serverId(),ParentId:parentId,Icon:cardBuilder.getDefaultIcon({CollectionType:"movies"}),IsCategory:!0,ImageUrl:1<movieItems.length?backdropImageUrl(movieItems[1],imgOptions):null}),items.push({Name:globalize.translate("Favorites"),Id:"movies_favorites",ServerId:apiClient.serverId(),ParentId:parentId,Icon:"favorite",IsCategory:!0,ImageUrl:movieItems.length?backdropImageUrl(movieItems[0],imgOptions):null}),items.push({Name:globalize.translate("Collections"),Id:"movies_collections",ServerId:apiClient.serverId(),ParentId:parentId,Icon:cardBuilder.getDefaultIcon({CollectionType:"boxsets"}),IsCategory:!0,ImageUrl:collectionItems.length?backdropImageUrl(collectionItems[0],imgOptions):null}),Promise.resolve({Items:items,TotalRecordCount:items.length})})})}.bind(this),this.categoryItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{shape:"backdrop",multiSelect:!1,contextMenu:!1,overlayText:!0,fields:["Name"],action:"custom"},virtualScrollLayout:"vertical-grid"}}.bind(this),this.categoryItemsContainer.addEventListener("action-null",function(e){var item=e.detail.item,url="/videos?serverId="+connectionManager.getApiClient(item).serverId()+"&parentId="+item.ParentId,idParts=item.Id.split("_");1<idParts.length&&(url+="&tab="+idParts[1]),appRouter.show(url)}.bind(this)),this.spotlight=new spotlight(element.querySelector(".spotlightItemsContainer"),function(query){var apiClient=this.apiClient;return apiClient.getItems(apiClient.getCurrentUserId(),Object.assign({SortBy:"Random",IncludeItemTypes:"Movie",Recursive:!0,ParentId:this.parentId,EnableImageTypes:"Backdrop,Logo",ImageTypes:"Backdrop",Fields:"Taglines,ProductionYear,CommunityRating",ImageTypeLimit:1},query))}.bind(this),function(query){var apiClient=this.apiClient;return{Id:this.parentId,ServerId:apiClient.serverId(),CollectionType:"movies",Name:globalize.translate("Movies"),IsFolder:!0}}.bind(this)),self.resume=function(options){var promises=[this.spotlight.resume(options),this.categoryItemsContainer.resume(options),this.resumeItemsContainer.resume(options),this.latestItemsContainer.resume(options)];return options.refresh&&promises.push(loadRecommendations(element,apiClient)),Promise.all(promises)},self.pause=function(){self.spotlight.pause(),self.latestItemsContainer.pause(),self.resumeItemsContainer.pause(),self.categoryItemsContainer.pause()},self.destroy=function(){self.spotlight&&(self.spotlight.destroy(),self.spotlight=null),self.latestItemsContainer=null,self.resumeItemsContainer=null,self.categoryItemsContainer=null,self.apiClient=null}}});