define(["events","multiSelect","itemHelper","backdrop","searchFields","globalize","browser","dom","appHeader","inputManager","listView","layoutManager","userSettings","focusManager","cardBuilder","loading","connectionManager","playbackManager","alphaPicker","baseView","emby-itemscontainer","emby-scroller","emby-tabs"],function(events,MultiSelect,itemHelper,backdrop,SearchFields,globalize,browser,dom,appHeader,inputManager,listView,layoutManager,userSettings,focusManager,cardBuilder,loading,connectionManager,playbackManager,alphaPicker,BaseView){"use strict";function updateSortText(instance){var btnSortText=instance.btnSortText;if(btnSortText){for(var options=instance.getSortMenuOptions(),values=instance.getSortValues(options),sortBy=values.sortBy,i=0,length=options.length;i<length;i++)if(sortBy===options[i].value){btnSortText.innerHTML=globalize.translate("SortByValue",options[i].name);break}var btnSortIcon=instance.btnSortIcon;btnSortIcon&&(btnSortIcon.innerHTML="Descending"===values.sortOrder?"&#xE5DB;":"&#xE5D8;")}}function getApiClient(instance){var serverId=instance.params.serverId;return serverId?connectionManager.getApiClient(serverId):connectionManager.currentApiClient()}function showViewSettingsMenu(){var instance=this;require(["viewSettings"],function(ViewSettings){(new ViewSettings).show({settingsKey:instance.getSettingsKey(),settings:instance.getViewSettings(),visibleSettings:instance.getVisibleViewSettings()}).then(function(){refreshAfterSettingsChange(instance)})})}function showFilterMenu(){var instance=this,params=instance.params,query={};params.genreId&&(query.GenreIds=params.genreId);var item=instance.currentItem;item&&("Studio"===item.Type?query.StudioIds=item.Id:"Tag"===item.Type?query.TagIds=item.Id:"Genre"===item.Type||"GameGenre"===item.Type||"MusicGenre"===item.Type?query.GenreIds=item.Id:"Person"===item.Type&&(query.PersonIds=item.Id)),params.artistId&&(query.ArtistIds=params.artistId),params.albumArtistId&&(query.AlbumArtistIds=params.albumArtistId),require(["filterMenu"],function(FilterMenu){(new FilterMenu).show(Object.assign(query,{settingsKey:instance.getSettingsKey(),settings:instance.getFilters(),visibleSettings:instance.getVisibleFilters(),onChange:instance.itemsContainer.refreshItems.bind(instance.itemsContainer),parentId:instance.params.parentId,itemTypes:instance.getItemTypes(),serverId:instance.params.serverId,filterMenuOptions:instance.getFilterMenuOptions()})).then(function(){refreshAfterSettingsChange(instance)})})}function compareByName(a,b){var aName=a.menuSortKey||a.name,bName=b.menuSortKey||b.name;return aName<bName?-1:bName<aName?1:0}function getDefaultSortOrder(sortMenuOptions,sortBy){if(sortBy){var option=function(sortMenuOptions,sortBy){for(var i=0,length=sortMenuOptions.length;i<length;i++){var option=sortMenuOptions[i];if(option.value===sortBy)return option}return null}(sortMenuOptions,sortBy);if(option&&option.value===sortBy&&option.defaultSortOrder)return option.defaultSortOrder;if((sortBy=sortBy.toLowerCase()).startsWith("sortname")||sortBy.startsWith("runtime")||sortBy.startsWith("album")||sortBy.startsWith("isfolder")||sortBy.startsWith("channelnumber"))return"Ascending"}return"Descending"}function showSortMenu(e){var instance=this;require(["actionsheet"],function(actionsheet){var options=instance.getSortMenuOptions();!function(instance,options){for(var currentValues=instance.getSortValues(options),i=0,length=options.length;i<length;i++){var opt=options[i];if(opt.selected=opt.value===currentValues.sortBy,opt.selected){var icon="Descending"===currentValues.sortOrder?"&#xE5DB;":"&#xE5D8;";opt.asideIcon=icon;break}}}(instance,options),options.sort(compareByName),actionsheet.show({items:options,positionTo:e.target.closest("button"),title:globalize.translate("LabelSortBy"),positionY:"bottom",hideTitleWhenNotFullscreen:!0,offsetTop:2}).then(function(value){var currentValues=instance.getSortValues(options),sortOrder=currentValues.sortOrder,sortOrder=currentValues.sortBy===value?"Ascending"===sortOrder?"Descending":"Ascending":getDefaultSortOrder(options,value),settingsKey=instance.getSettingsKey();userSettings.setFilter(instance.getSortBySettingsKey(),value),userSettings.setFilter(settingsKey+"-sortorder",sortOrder),updateSortText(instance),refreshAfterSettingsChange(instance)})})}function refreshAfterSettingsChange(instance){instance.itemsContainer.refreshItems()}function hideOrShowAll(elems,hide){for(var i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function bindAll(elems,eventName,fn){for(var i=0,length=elems.length;i<length;i++)elems[i].addEventListener(eventName,fn)}function trySelectValue(instance,scroller,view,value,focus){value&&"#"!==value?instance.getItems({Limit:0}).then(function(totalResult){instance.getItems({Limit:0,NameStartsWithOrGreater:value}).then(function(result){instance.itemsContainer.scrollToIndex(Math.max(totalResult.TotalRecordCount-result.TotalRecordCount,0),{},focus)})}):instance.itemsContainer.scrollToIndex(0,{},focus)}function initAlphaPicker(instance){var alphaPickerElement=instance.alphaPickerElement;layoutManager.tv?(alphaPickerElement.classList.add("alphaPicker-fixed-left"),alphaPickerElement.classList.add("focuscontainer-left"),alphaPickerElement.classList.remove("alphaPicker-fixed-right")):(alphaPickerElement.classList.add("alphaPicker-fixed-right"),alphaPickerElement.classList.add("focuscontainer-right"),alphaPickerElement.classList.remove("alphaPicker-fixed-left")),instance.alphaPicker=new alphaPicker({element:alphaPickerElement,itemsContainer:instance.itemsContainer,prefixes:[],setValueOnFocus:!0}),instance.alphaPicker.on("alphavaluechanged",function(e){var value=e.detail.value;this.scroller,trySelectValue(this,0,this.itemsContainer,value)}.bind(instance))}function ItemsView(view,params){BaseView.apply(this,arguments),this.onInputCommandFn=function(e){switch(e.detail.command){case"refresh":this.itemsContainer.refreshItems();break;case"search":if(!this.searchFields)return;this.searchFields.focus();break;default:return}e.preventDefault(),e.stopPropagation()}.bind(this);var onInputCommandFn=this.onInputCommandFn;onInputCommandFn&&inputManager.on(view,onInputCommandFn);var self=this;self.params=params,null==this.supportsViewSettings&&(this.supportsViewSettings="downloads"!==params.parentId&&"search"!==params.type),null==this.enableTotalRecordCountDisplay&&(this.enableTotalRecordCountDisplay="search"!==params.type),this.itemsContainer=view.querySelector(".itemsContainer"),this.itemsContainer.setListClasses=!0,params.parentId?this.itemsContainer.setAttribute("data-parentid",params.parentId):"nextup"===params.type?(this.itemsContainer.setAttribute("data-monitor","videoplayback"),this.itemsContainer.setAttribute("data-commands","removefromnextup")):"favoritemovies"===params.type?this.itemsContainer.setAttribute("data-monitor","markfavorite"):"Program"!==params.type&&"OnNow"!==params.type||this.itemsContainer.setAttribute("data-refreshinterval","300000"),"search"===params.type&&(view.querySelector(".searchContainer").classList.remove("hide"),this.searchFields=new SearchFields({element:view.querySelector(".searchFields"),serverId:getApiClient(this).serverId(),value:params.query}),events.on(this.searchFields,"search",function(e,value){var activeSearchTab=this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active");activeSearchTab&&activeSearchTab.classList.remove("emby-searchable-tab-button"),this.itemsContainer.refreshItems(),this.searchFields.getSearchTerm()}.bind(this)));for(var btnViewSettings=view.querySelectorAll(".btnViewSettings"),supportsViewSettings=!1!==this.supportsViewSettings,i=0,length=btnViewSettings.length;i<length;i++)btnViewSettings[i].addEventListener("click",showViewSettingsMenu.bind(this)),supportsViewSettings&&btnViewSettings[i].classList.remove("hide");var filterButtons=view.querySelectorAll(".btnFilter");this.filterButtons=filterButtons;var hasVisibleFilters=this.getVisibleFilters().length;for(i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];btnFilter.addEventListener("click",showFilterMenu.bind(this)),hasVisibleFilters?btnFilter.classList.remove("hide"):btnFilter.classList.add("hide")}var sortButtons=view.querySelectorAll(".btnSort");this.sortButtons=sortButtons;var supportsSorting=this.getSortMenuOptions().length;for(i=0,length=sortButtons.length;i<length;i++){var sortButton=sortButtons[i];sortButton.addEventListener("click",showSortMenu.bind(this)),supportsSorting&&sortButton.classList.remove("hide")}this.btnSortText=view.querySelector(".btnSortText"),this.btnSortIcon=view.querySelector(".btnSortIcon"),supportsSorting||supportsViewSettings||hasVisibleFilters||!1!==this.enableTotalRecordCountDisplay||view.querySelector(".itemsViewSettingsContainer").classList.add("hide"),null==this.enableAlphaNumericShortcuts&&(this.enableAlphaNumericShortcuts="search"!==params.type&&this.enableVirtualData()),this.alphaPickerElement=view.querySelector(".alphaPicker"),self.itemsContainer.afterRefresh=self.afterItemsRefreshed.bind(self),self.itemsContainer.fetchData=self.getItems.bind(self),self.itemsContainer.virtualChunkSize=self.virtualChunkSize(),self.itemsContainer.getListOptions=self.getListOptions.bind(self),bindAll(view.querySelectorAll(".btnPlay"),"click",function(){if(MultiSelect.canPlay())return void MultiSelect.play();var currentItem=self.currentItem,params=self.params;if(currentItem&&!self.getQueryInfo(!0).hasFilters&&!params.type){if("SortName"===self.getSortValues().sortBy)return playbackManager.play({items:[currentItem],parentId:params.parentId})}self.getItems({Limit:300}).then(function(result){playbackManager.play({items:result.Items})})}),bindAll(view.querySelectorAll(".btnQueue"),"click",function(){self.currentItem,self.params;self.getItems({Limit:300}).then(function(result){playbackManager.queue({items:result.Items})})}),bindAll(view.querySelectorAll(".btnShuffle"),"click",function(){var currentItem=self.currentItem,params=self.params;if(currentItem&&!self.getQueryInfo(!0).hasFilters)return void playbackManager.shuffle(currentItem,null,{parentId:params.parentId});self.getItems({SortBy:"Random",Limit:300}).then(function(result){playbackManager.play({items:result.Items})})})}function isNotName(n){return"Name"!==n}function adjustListOptionsForGroupingProgramsBySeries(instance,items,options){"search"!==instance.params.type&&items.length&&items[0].AsSeries&&(options.progress=!1,options.showAirTime=!1,options.showAirDateTime=!1,options.showParentTitle=!1,options.fields=options.fields.filter(isNotName),options.fields.push("ParentNameOrName"))}function getTopLevelDownloadFolders(apiClient){return apiClient.getLocalFolders()}return Object.assign(ItemsView.prototype,BaseView.prototype),ItemsView.prototype.onResume=function(options){BaseView.prototype.onResume.apply(this,arguments);var searchFields=this.searchFields;searchFields&&searchFields.resume();var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&alphaNumericShortcuts.resume();var refresh=options.refresh;refresh&&loading.show(),this.setTitle();var instance=this,params=this.params;(function(instance){var params=instance.params;if("Recordings"===params.type)return Promise.resolve(null);if("Program"===params.type)return Promise.resolve(null);if("nextup"===params.type)return Promise.resolve(null);if("search"===params.type)return Promise.resolve(null);if("OnNow"===params.type)return Promise.resolve(null);if(!params.serverId)return Promise.resolve(null);var apiClient=getApiClient(instance),itemId=params.genreId||params.gameGenreId||params.musicGenreId||params.studioId||params.tagId||params.personId||params.parentId;return itemId&&"downloads"!==itemId?apiClient.getItem(apiClient.getCurrentUserId(),itemId):Promise.resolve(null)})(this).then(function(item){item?backdrop.setBackdrops([item]):backdrop.clear(),instance.currentItem=item,instance.setTitle(),updateSortText(instance),instance.itemsContainer.resume({refresh:refresh}).then(function(){loading.hide(),refresh&&focusManager.autoFocus(instance.itemsContainer)}),instance.alphaPicker||(instance.enableAlphaPicker||item&&"PhotoAlbum"!==item.Type)&&initAlphaPicker(instance);var itemType=item?item.Type:null,collectionType=item?item.CollectionType:null,view=instance.view;!1!==instance.supportsPlayback?("downloads"!==params.parentId&&"search"!==params.type&&"playlists"!==collectionType&&"boxsets"!==collectionType&&("MusicGenre"===itemType||"Program"!==params.type&&"OnNow"!==params.type&&"Game"!==params.type&&"Channel"!==itemType&&"GameSystem"!==itemType&&"GameGenre"!==itemType)?hideOrShowAll(view.querySelectorAll(".btnPlay"),!1):hideOrShowAll(view.querySelectorAll(".btnPlay"),!0),"downloads"!==params.parentId&&"search"!==params.type&&"playlists"!==collectionType&&"boxsets"!==collectionType&&("MusicGenre"===itemType||"Program"!==params.type&&"OnNow"!==params.type&&"nextup"!==params.type&&"Game"!==params.type&&"Channel"!==itemType&&"GameSystem"!==itemType&&"GameGenre"!==itemType)?hideOrShowAll(view.querySelectorAll(".btnShuffle"),!1):hideOrShowAll(view.querySelectorAll(".btnShuffle"),!0),"downloads"!==params.parentId&&"search"!==params.type&&"playlists"!==collectionType&&"boxsets"!==collectionType&&item&&playbackManager.canQueue(item)?hideOrShowAll(view.querySelectorAll(".btnQueue"),!1):hideOrShowAll(view.querySelectorAll(".btnQueue"),!0)):(hideOrShowAll(view.querySelectorAll(".btnPlay"),!0),hideOrShowAll(view.querySelectorAll(".btnShuffle"),!0),hideOrShowAll(view.querySelectorAll(".btnQueue"),!0))})},ItemsView.prototype.initAlphaNumericShortcuts=function(){var instance;this.enableAlphaNumericShortcuts&&(this.alphaNumericShortcuts||(instance=this,require(["alphaNumericShortcuts"],function(AlphaNumericShortcuts){instance.alphaNumericShortcuts=new AlphaNumericShortcuts({itemsContainer:instance.itemsContainer}),instance.alphaNumericShortcuts.onAlphaNumericValueEntered=function(value){trySelectValue(this,this.scroller,this.view,value,!0)}.bind(instance)})))},ItemsView.prototype.destroyAlphaNumericShortcuts=function(){var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&(alphaNumericShortcuts.destroy(),this.alphaNumericShortcuts=null)},ItemsView.prototype.onPause=function(){BaseView.prototype.onPause.apply(this,arguments);this.view;var searchFields=this.searchFields;searchFields&&searchFields.pause();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.pause();var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&alphaNumericShortcuts.pause()},ItemsView.prototype.destroy=function(){var view=this.view;this.destroyAlphaNumericShortcuts();var onInputCommandFn=this.onInputCommandFn;onInputCommandFn&&view&&inputManager.off(view,onInputCommandFn),this.onInputCommandFn=null,BaseView.prototype.destroy.apply(this,arguments),this.listController&&this.listController.destroy(),this.alphaPicker&&(this.alphaPicker.destroy(),this.alphaPicker=null),this.searchFields&&(this.searchFields.destroy(),this.searchFields=null),this.currentItem=null,this.itemsContainer=null,this.filterButtons=null,this.sortButtons=null,this.btnSortText=null,this.btnSortIcon=null,this.alphaPickerElement=null},ItemsView.prototype.getCardOptions=function(items,settings){var shape,preferThumb,preferDisc,preferLogo,defaultShape,params=this.params,showParentTitle=(this.currentItem,!1);"banner"===settings.imageType?shape="banner":"disc"===settings.imageType?(shape="square",preferDisc=!0):"logo"===settings.imageType?(shape="backdrop",preferLogo=!0):"thumb"===settings.imageType?(shape="backdrop",preferThumb=!0):"nextup"===params.type?(shape="backdrop",preferThumb="thumb"===settings.imageType):"Program"===params.type||"OnNow"===params.type||"Recordings"===params.type?(preferThumb=shape="auto",defaultShape="true"===params.IsMovie||"OnNow"===params.type?"portrait":"backdrop"):shape="auto";var showAirTime,activeSearchTab,visibleFields=settings.fields,options={shape:shape,preferThumb:preferThumb,preferDisc:preferDisc,preferLogo:preferLogo,overlayPlayButton:!1,defaultShape:defaultShape,action:"Audio"===params.type?"playallfromhere":null,typeIndicator:!0};return"Person"===params.type?showParentTitle=!1:"Audio"===params.type?(showParentTitle=visibleFields.includes("Name"),options.sideFooter=!0):"MusicAlbum"===params.type||"Episode"===params.type||"Game"===params.type||params.gameGenreId?showParentTitle=visibleFields.includes("Name"):"MusicArtist"===params.type?options.round=!0:"Program"===params.type?(showParentTitle=visibleFields.includes("Name")&&"true"!==params.IsMovie,showAirTime=visibleFields.includes("Name")&&"Recordings"!==params.type,options=Object.assign(options,{inheritThumb:"Recordings"===params.type,context:"livetv",showAirTime:showAirTime,showAirDateTime:showAirTime,overlayPlayButton:!1})):"OnNow"===params.type?(showParentTitle=!1,options=Object.assign(options,{programsAsSeries:!0,action:"programlink",showCurrentProgramImage:!0}),visibleFields.includes("Name")&&((visibleFields=visibleFields.filter(isNotName)).unshift("CurrentProgramParentName"),visibleFields.unshift("CurrentProgramName"),visibleFields.push("CurrentProgramTime"))):showParentTitle=visibleFields.includes("Name"),showParentTitle&&(options.showParentTitle=!0),"search"!==params.type||(activeSearchTab=this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active"))&&"MusicArtist"===activeSearchTab.getAttribute("data-searchtype")&&(options.round=!0),options.fields=visibleFields,options.overlayText=0===visibleFields.length||"None"===visibleFields[0],options.multiSelect="Program"!==params.type&&"OnNow"!==params.type,adjustListOptionsForGroupingProgramsBySeries(this,items,options),options},ItemsView.prototype.getListViewOptions=function(items,settings){var options={fields:[]},params=this.params;return"OnNow"===params.type&&(options.programsAsSeries=!0,options.action="programlink",options.showCurrentProgramImage=!0,options.fields=["CurrentProgramName","CurrentProgramParentName","CurrentProgramTime"]),options.multiSelect="Program"!==params.type&&"OnNow"!==params.type,adjustListOptionsForGroupingProgramsBySeries(this,items,options),options},ItemsView.prototype.getListOptions=function(items){var settings=this.getViewSettings(items);return"list"===settings.imageType?{renderer:listView,options:this.getListViewOptions(items,settings),virtualScrollLayout:"vertical"}:{renderer:cardBuilder,options:this.getCardOptions(items,settings),virtualScrollLayout:"vertical-grid"}},ItemsView.prototype.getItems=function(initialQuery){var params=this.params;this.currentItem;if("downloads"===params.parentId)return Promise.all(connectionManager.getApiClients().map(getTopLevelDownloadFolders)).then(function(responses){for(var list=[],i=0,length=responses.length;i<length;i++)list=list.concat(responses[i]);return list});var apiClient=getApiClient(this),queryInfo=this.getQueryInfo(!0);if(this.setFilterStatus(queryInfo.hasFilters),initialQuery&&(queryInfo.query=Object.assign(queryInfo.query,initialQuery)),"Recordings"===params.type)return queryInfo.query.UserId=apiClient.getCurrentUserId(),apiClient.getLiveTvRecordings(queryInfo.query);if("nextup"===params.type)return queryInfo.query.UserId=apiClient.getCurrentUserId(),queryInfo.query.EnableTotalRecordCount=!1,queryInfo.query.LegacyNextUp=!0,apiClient.getNextUpEpisodes(queryInfo.query);if("OnNow"===params.type)return queryInfo.query.UserId=apiClient.getCurrentUserId(),apiClient.getLiveTvChannels(queryInfo.query);var method=this.getApiClientQueryMethodName();return"getActivityLog"===method?(queryInfo.query.HasUserId=!1,apiClient.getActivityLog(queryInfo.query)):"getUserActivityLog"===method?(queryInfo.query.HasUserId=!0,apiClient.getActivityLog(queryInfo.query)):"getLogs"===method||"getLogLines"===method||"getApiKeys"===method||"getLiveTvChannelsForManagement"===method?apiClient[method](queryInfo.query):"search"!==params.type?apiClient[method](apiClient.getCurrentUserId(),queryInfo.query):(this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active")&&(queryInfo.query.IncludeSearchTypes=!1),apiClient.getSearchResults(queryInfo.query).then(function(result){return result.ItemTypes&&this.refreshSearchTabs(result.ItemTypes),result}.bind(this)))},ItemsView.prototype.getApiClientQueryMethodName=function(){var params=this.params;return"MusicArtist"===params.type?"getArtists":"Person"===params.type?"getPeople":"getItems"},ItemsView.prototype.refreshPrefixes=function(){var instance=this;this.getPrefixes().then(function(prefixes){instance.alphaPicker.setPrefixes(prefixes)})},ItemsView.prototype.getPrefixes=function(){var queryInfo=this.getQueryInfo(!1);if("downloads"===this.params.parentId||"search"===this.params.type)return Promise.resolve([]);var apiClient=getApiClient(this),query=queryInfo.query;query.SortBy=null,query.SortOrder=null,query.StartIndex=null,query.Limit=null,query.Fields=null,query.EnableImageTypes=null,query.ImageTypeLimit=null,query.NameStartsWithOrGreater=null;var method=this.getPrefixesApiClientMethodName();return query.IncludeItemTypes="getArtistPrefixes"!==method&&this.getPrefixQueryIncludeItemTypes().join(",")||null,("getUserPrefixes"===method?apiClient[method](query):apiClient[method](apiClient.getCurrentUserId(),query)).then(function(result){return result.map(function(i){return i.Name})})},ItemsView.prototype.getPrefixesApiClientMethodName=function(){return"MusicArtist"===this.params.type?"getArtistPrefixes":"getPrefixes"},ItemsView.prototype.getPrefixQueryIncludeItemTypes=function(){return this.getQueryIncludeItemTypes()},ItemsView.prototype.getQueryIncludeItemTypes=function(){var params=this.params;return"MusicArtist"===params.type||"Person"===params.type||"search"===params.type||"OnNow"===params.type?[]:this.getItemTypes()},ItemsView.prototype.getBaseQuery=function(item){var params=this.params,parentId=params.parentId,sortMenuOptions=this.getSortMenuOptions(),sortValues=this.getSortValues(sortMenuOptions),fields="BasicSyncInfo,CanDelete",settings=this.getViewSettings();"primary"!==settings.imageType&&"list"!==settings.imageType||(fields+=",PrimaryImageAspectRatio","OnNow"===params.type&&(fields+=",ProgramPrimaryImageAspectRatio"));var visibleFields=settings.fields;visibleFields.includes("ProductionYear")&&(fields+=",ProductionYear",fields+=",Status,EndDate"),visibleFields.includes("CommunityRating")&&(fields+=",CommunityRating"),visibleFields.includes("OfficialRating")&&(fields+=",OfficialRating"),visibleFields.includes("CriticRating")&&(fields+=",CriticRating");var imageTypes="Primary,Backdrop,Thumb";"banner"===settings.imageType?imageTypes+=",Banner":"disc"===settings.imageType?imageTypes+=",Disc":"logo"===settings.imageType&&(imageTypes+=",Logo");var query={SortBy:sortValues.sortBy,SortOrder:sortValues.sortOrder,IncludeItemTypes:this.getQueryIncludeItemTypes().join(",")||null,Fields:fields,ImageTypeLimit:1,EnableImageTypes:imageTypes,StartIndex:0,ParentId:parentId};return"OnNow"===params.type&&(query.EnableUserData=!1),item&&("MusicGenre"===item.Type?query.IncludeItemTypes="MusicAlbum,MusicVideo":"GameGenre"===item.Type?query.IncludeItemTypes="Game":"Genre"===item.Type?query.IncludeItemTypes="Movie,Series,Video":"Person"===item.Type?query.IncludeItemTypes=params.type||null:"Studio"===item.Type?query.IncludeItemTypes="Movie,Series,Video,Game":"movies"===item.CollectionType?query.IncludeItemTypes="Movie":"tvshows"===item.CollectionType&&(query.IncludeItemTypes="Series")),"Program"===params.type&&(query.HasAired=!1),"true"===params.IsFavorite&&(query.IsFavorite=!0),"true"===params.IsMovie?query.IsMovie=!0:"false"===params.IsMovie&&(query.IsMovie=!1),"true"===params.IsSeries?query.IsSeries=!0:"false"===params.IsSeries&&(query.IsSeries=!1),"true"===params.IsNews?query.IsNews=!0:"false"===params.IsNews&&(query.IsNews=!1),"true"===params.IsSports?query.IsSports=!0:"false"===params.IsSports&&(query.IsSports=!1),"true"===params.IsKids?query.IsKids=!0:"false"===params.IsKids&&(query.IsKids=!1),"OnNow"===params.type||"true"===params.IsAiring?query.IsAiring=!0:"false"===params.IsAiring&&(query.IsAiring=!1),params.genreId&&(query.GenreIds=params.genreId),item&&("Studio"===item.Type?(query.StudioIds=item.Id,query.Recursive=!0):"Tag"===item.Type?(query.TagIds=item.Id,query.Recursive=!0):"Genre"===item.Type||"GameGenre"===item.Type||"MusicGenre"===item.Type?(query.GenreIds=item.Id,query.Recursive=!0):"Person"===item.Type&&(query.PersonIds=item.Id,query.Recursive=!0)),params.artistId&&(query.ArtistIds=params.artistId),params.albumArtistId&&(query.AlbumArtistIds=params.albumArtistId),params.type&&(query.Recursive=!0),query},ItemsView.prototype.getQueryInfo=function(enableFilters){var hasFilters,filters,query=this.getBaseQuery(this.currentItem),queryFilters=[];!1!==enableFilters&&((filters=this.getFilters()).SeriesStatus&&(query.SeriesStatus=filters.SeriesStatus,hasFilters=!0),filters.IsPlayed&&(queryFilters.push("IsPlayed"),hasFilters=!0),filters.IsUnplayed&&(queryFilters.push("IsUnplayed"),hasFilters=!0),filters.IsFavorite&&(queryFilters.push("IsFavorite"),hasFilters=!0),filters.IsResumable&&(queryFilters.push("IsResumable"),hasFilters=!0),filters.Containers&&(hasFilters=!0,query.Containers=filters.Containers),filters.AudioCodecs&&(hasFilters=!0,query.AudioCodecs=filters.AudioCodecs),filters.AudioLanguages&&(hasFilters=!0,query.AudioLanguages=filters.AudioLanguages),filters.VideoCodecs&&(hasFilters=!0,query.VideoCodecs=filters.VideoCodecs),filters.SubtitleCodecs&&(hasFilters=!0,query.SubtitleCodecs=filters.SubtitleCodecs),filters.SubtitleLanguages&&(hasFilters=!0,query.SubtitleLanguages=filters.SubtitleLanguages),filters.GenreIds&&(hasFilters=!0,query.GenreIds=filters.GenreIds),filters.OfficialRatings&&(hasFilters=!0,query.OfficialRatings=filters.OfficialRatings),filters.StudioIds&&(hasFilters=!0,query.StudioIds=filters.StudioIds),filters.TagIds&&(hasFilters=!0,query.TagIds=filters.TagIds),filters.Years&&(hasFilters=!0,query.Years=filters.Years),filters.Is4K&&(hasFilters=query.Is4K=!0),filters.IsHD&&(hasFilters=query.IsHD=!0),filters.IsSD&&(hasFilters=!(query.IsHD=!1)),filters.Is3D&&(hasFilters=query.Is3D=!0),null!=filters.HasSubtitles&&(query.HasSubtitles=filters.HasSubtitles,hasFilters=!0),null!=filters.ChannelMappingStatus&&(query.ChannelMappingStatus=filters.ChannelMappingStatus,hasFilters=!0),null!=filters.HasTrailer&&(query.HasTrailer=filters.HasTrailer,hasFilters=!0),null!=filters.HasSpecialFeature&&(query.HasSpecialFeature=filters.HasSpecialFeature,hasFilters=!0),null!=filters.HasThemeSong&&(query.HasThemeSong=filters.HasThemeSong,hasFilters=!0),null!=filters.HasThemeVideo&&(query.HasThemeVideo=filters.HasThemeVideo,hasFilters=!0),null!=filters.HasOverview&&(query.HasOverview=filters.HasOverview,hasFilters=!0),null!=filters.HasImdbId&&(query.HasImdbId=filters.HasImdbId,hasFilters=!0),null!=filters.HasTvdbId&&(query.HasTvdbId=filters.HasTvdbId,hasFilters=!0),null!=filters.HasTmdbId&&(query.HasTmdbId=filters.HasTmdbId,hasFilters=!0),null!=filters.IsLocked&&(query.IsLocked=filters.IsLocked,hasFilters=!0)),query.Filters=queryFilters.length?queryFilters.join(","):null;var activeSearchTab,searchItemType,settings=this.getViewSettings();return settings.groupItemsIntoCollections?query.GroupItemsIntoCollections=!0:settings.groupItemsIntoTags&&(query.GroupItemsInto="Tags"),"search"===this.params.type&&(query.SearchTerm=this.lastSearchTerm=this.searchFields.getSearchTerm(),(activeSearchTab=this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active"))&&(searchItemType=activeSearchTab.getAttribute("data-searchtype"),query.IncludeItemTypes="all"!==searchItemType?searchItemType:null)),("Program"!==query.IncludeItemTypes||query.IsAiring||query.IsSports)&&(query.IncludeItemTypes||"search"!==this.params.type)||(query.GroupProgramsBySeries=!0),{query:query,hasFilters:hasFilters}},ItemsView.prototype.getFilters=function(){var basekey=this.getSettingsKey();return{IsPlayed:"true"===userSettings.getFilter(basekey+"-filter-IsPlayed"),IsUnplayed:"true"===userSettings.getFilter(basekey+"-filter-IsUnplayed"),IsFavorite:"true"===userSettings.getFilter(basekey+"-filter-IsFavorite"),IsResumable:"true"===userSettings.getFilter(basekey+"-filter-IsResumable"),Is4K:"true"===userSettings.getFilter(basekey+"-filter-Is4K"),IsHD:"true"===userSettings.getFilter(basekey+"-filter-IsHD"),IsSD:"true"===userSettings.getFilter(basekey+"-filter-IsSD"),Is3D:"true"===userSettings.getFilter(basekey+"-filter-Is3D"),SeriesStatus:userSettings.getFilter(basekey+"-filter-SeriesStatus"),HasSubtitles:userSettings.getFilter(basekey+"-filter-HasSubtitles"),ChannelMappingStatus:userSettings.getFilter(basekey+"-filter-ChannelMappingStatus"),HasTrailer:userSettings.getFilter(basekey+"-filter-HasTrailer"),HasSpecialFeature:userSettings.getFilter(basekey+"-filter-HasSpecialFeature"),HasThemeSong:userSettings.getFilter(basekey+"-filter-HasThemeSong"),HasThemeVideo:userSettings.getFilter(basekey+"-filter-HasThemeVideo"),HasOverview:userSettings.getFilter(basekey+"-filter-HasOverview"),HasImdbId:userSettings.getFilter(basekey+"-filter-HasImdbId"),HasTvdbId:userSettings.getFilter(basekey+"-filter-HasTvdbId"),HasTmdbId:userSettings.getFilter(basekey+"-filter-HasTmdbId"),IsLocked:userSettings.getFilter(basekey+"-filter-IsLocked"),GenreIds:userSettings.getFilter(basekey+"-filter-GenreIds"),StudioIds:userSettings.getFilter(basekey+"-filter-StudioIds"),TagIds:userSettings.getFilter(basekey+"-filter-TagIds"),OfficialRatings:userSettings.getFilter(basekey+"-filter-OfficialRatings"),Containers:userSettings.getFilter(basekey+"-filter-Containers"),AudioCodecs:userSettings.getFilter(basekey+"-filter-AudioCodecs"),AudioLanguages:userSettings.getFilter(basekey+"-filter-AudioLanguages"),SubtitleLanguages:userSettings.getFilter(basekey+"-filter-SubtitleLanguages"),VideoCodecs:userSettings.getFilter(basekey+"-filter-VideoCodecs"),SubtitleCodecs:userSettings.getFilter(basekey+"-filter-SubtitleCodecs"),Years:userSettings.getFilter(basekey+"-filter-Years")}},ItemsView.prototype.refreshSearchTabs=function(tabs){var html;tabs.length&&tabs.unshift({Name:globalize.translate("HeaderTopResults"),Id:"all"}),1<tabs.length&&(html='<div is="emby-tabs" class="searchTabsContainer padded-bottom focuscontainer-x"><div class="emby-tabs-slider scrollX hiddenScrollX scrollSliderX padded-top-focusscale padded-bottom-focusscale padded-left padded-left-page padded-right searchTabsScroller">',html+=tabs.map(function(tab,index){var pluralName="all"===tab.Id?tab.Name:itemHelper.getPluralItemTypeName(tab.Name);return'<button type="button" is="emby-button" class="emby-searchable-tab-button emby-search-tab-button emby-tab-button emby-button" data-searchtype="'+(tab.Id||tab.Name)+'" data-index="'+index+'">'+pluralName+"</button>"}).join(""),html+="</div></div>");var elem=this.view.querySelector(".searchTabs");(elem.innerHTML=html)?(elem.classList.remove("hide"),elem.querySelector(".searchTabsContainer").addEventListener("tabchange",function(){this.itemsContainer.refreshItems()}.bind(this))):elem.classList.add("hide")},ItemsView.prototype.afterItemsRefreshed=function(result){var instance,numItems,alphaPicker,values,alphaPickerAllowed,items=result.Items||result,totalRecordCount=result.TotalRecordCount||items.length;numItems=totalRecordCount,values=(instance=this).getSortValues(),(alphaPickerAllowed="SortName"===values.sortBy&&"Ascending"===values.sortOrder)?instance.initAlphaNumericShortcuts():instance.destroyAlphaNumericShortcuts(),!instance.alphaPicker||(alphaPicker=instance.alphaPickerElement)&&(alphaPickerAllowed&&30<numItems?(alphaPicker.classList.remove("hide"),instance.refreshPrefixes()):alphaPicker.classList.add("hide")),function(instance,view,totalRecordCount){var elem=view.querySelector(".listTotalRecordCount");elem&&(!1!==instance.enableTotalRecordCountDisplay?elem.innerHTML=instance.getItemCountText(totalRecordCount):elem.classList.add("hide"))}(this,this.view,totalRecordCount),totalRecordCount||this.setEmptyListState()},ItemsView.prototype.getEmptyListMessage=function(){if("search"===this.params.type){if(this.searchFields){var searchTerm=this.lastSearchTerm;if(!searchTerm)return Promise.resolve("");if(searchTerm.length<2)return Promise.resolve(globalize.translate("TwoSearchCharsRequired"))}return Promise.resolve(globalize.translate("NoItemsMatchingFound"))}if(this.getQueryInfo(!0).hasFilters){var html="<div>"+globalize.translate("NoItemsMatchingFound")+"</div>";return html+='<button style="margin-top:2em;" type="button" is="emby-button" class="raised btnClearFilters">',html+='<i class="md-icon button-icon button-icon-left">&#xe0b8;</i>',html+="<span>"+globalize.translate("HeaderClearFilters")+"</span>",html+="</button>",Promise.resolve(html)}return Promise.resolve(globalize.translate("NoItemsFound"))},ItemsView.prototype.clearFilters=function(){var basekey=this.getSettingsKey();userSettings.remove(basekey+"-filter-IsPlayed"),userSettings.remove(basekey+"-filter-IsUnplayed"),userSettings.remove(basekey+"-filter-IsFavorite"),userSettings.remove(basekey+"-filter-IsResumable"),userSettings.remove(basekey+"-filter-Is4K"),userSettings.remove(basekey+"-filter-IsHD"),userSettings.remove(basekey+"-filter-IsSD"),userSettings.remove(basekey+"-filter-Is3D"),userSettings.remove(basekey+"-filter-SeriesStatus"),userSettings.remove(basekey+"-filter-HasSubtitles"),userSettings.remove(basekey+"-filter-ChannelMappingStatus"),userSettings.remove(basekey+"-filter-HasTrailer"),userSettings.remove(basekey+"-filter-HasSpecialFeature"),userSettings.remove(basekey+"-filter-HasThemeSong"),userSettings.remove(basekey+"-filter-HasThemeVideo"),userSettings.remove(basekey+"-filter-HasOverview"),userSettings.remove(basekey+"-filter-HasImdbId"),userSettings.remove(basekey+"-filter-HasTvdbId"),userSettings.remove(basekey+"-filter-HasTmdbId"),userSettings.remove(basekey+"-filter-IsLocked"),userSettings.remove(basekey+"-filter-GenreIds"),userSettings.remove(basekey+"-filter-StudioIds"),userSettings.remove(basekey+"-filter-TagIds"),userSettings.remove(basekey+"-filter-OfficialRatings"),userSettings.remove(basekey+"-filter-Containers"),userSettings.remove(basekey+"-filter-AudioCodecs"),userSettings.remove(basekey+"-filter-AudioLanguages"),userSettings.remove(basekey+"-filter-SubtitleLanguages"),userSettings.remove(basekey+"-filter-VideoCodecs"),userSettings.remove(basekey+"-filter-SubtitleCodecs"),userSettings.remove(basekey+"-filter-Years"),this.itemsContainer.refreshItems()},ItemsView.prototype.setEmptyListState=function(){this.getEmptyListMessage().then(function(html){html='<div class="flex padded-top align-items-center justify-content-center flex-grow flex-direction-column">'+html,html+="</div>",this.itemsContainer.innerHTML=html;var btnClearFilters=this.itemsContainer.querySelector(".btnClearFilters");btnClearFilters&&dom.addEventListener(btnClearFilters,"click",this.clearFilters.bind(this),{})}.bind(this))},ItemsView.prototype.setTitle=function(){var params,item,title=(params=this.params,item=this.currentItem,"search"===params.type?globalize.translate("Search"):"downloads"===params.parentId?globalize.translate("Downloads"):"Recordings"===params.type?globalize.translate("Recordings"):"OnNow"===params.type?globalize.translate("HeaderOnNow"):"Program"===params.type?"true"===params.IsMovie?globalize.translate("Movies"):"true"===params.IsSports?globalize.translate("Sports"):"true"===params.IsKids?globalize.translate("HeaderForKids"):"true"===params.IsAiring?globalize.translate("HeaderOnNow"):"true"===params.IsSeries?globalize.translate("Shows"):"true"===params.IsNews?globalize.translate("News"):globalize.translate("Program"):"nextup"===params.type?globalize.translate("HeaderNextUp"):"favoritemovies"===params.type?globalize.translate("FavoriteMovies"):item||("Movie"===params.type?globalize.translate("Movies"):"Series"===params.type?globalize.translate("Shows"):"Season"===params.type?globalize.translate("Seasons"):"Episode"===params.type?globalize.translate("Episodes"):"MusicArtist"===params.type?globalize.translate("Artists"):"MusicAlbum"===params.type?globalize.translate("Albums"):"Audio"===params.type?globalize.translate("Songs"):"Game"===params.type?globalize.translate("Games"):"Video"===params.type?globalize.translate("Videos"):void 0));appHeader.setTitle(title||"")},ItemsView.prototype.getSortBySettingsKey=function(sortMenuOptions){return"OnNow"===this.params.type?userSettings.getLiveTvChannelSortSettingsKey():this.getSettingsKey()+"-sortby"},ItemsView.prototype.getSortByValue=function(){if("OnNow"!==this.params.type)return userSettings.getFilter(this.getSortBySettingsKey());var query={};return userSettings.addLiveTvChannelSortingToQuery(query,globalize),query.SortBy},ItemsView.prototype.getSortValues=function(sortMenuOptions){var basekey=this.getSettingsKey(),sortBy=this.getSortByValue(),sortOrder=sortBy?"Descending"===userSettings.getFilter(basekey+"-sortorder")?"Descending":"Ascending":(sortBy=this.getDefaultSortBy(),getDefaultSortOrder(sortMenuOptions=sortMenuOptions||this.getSortMenuOptions(),sortBy));return{sortBy:sortBy,sortOrder:sortOrder}},ItemsView.prototype.getDefaultSortBy=function(){var params=this.params;if("Program"===params.type)return"StartDate";if("OnNow"===params.type){var query={};return userSettings.addLiveTvChannelSortingToQuery(query,globalize),query.SortBy}if(!(params.type||params.genreId||params.tagId||params.studioId)){var item=this.currentItem;if(item&&"Folder"===item.Type)return this.getFileSortOption(params).value}return this.getNameSortOption(params).value},ItemsView.prototype.getSortMenuOptions=function(){var sortBy=[],params=this.params;if("OnNow"===params.type)return userSettings.getLiveTvChannelSortOrders(globalize);if("downloads"===params.parentId)return sortBy;if("nextup"===params.type)return sortBy;if("search"===params.type)return sortBy;"Program"===params.type&&sortBy.push({name:globalize.translate("AirDate"),value:"StartDate",defaultSortOrder:"Ascending"});var option=this.getNameSortOption(params);return option&&sortBy.push(option),(option=this.getCommunityRatingSortOption())&&sortBy.push(option),(option=this.getCriticRatingSortOption())&&sortBy.push(option),"Program"!==params.type&&"OnNow"!==params.type&&sortBy.push({name:globalize.translate("DateAdded"),value:"DateCreated,SortName",defaultSortOrder:"Descending"}),(option=this.getDatePlayedSortOption())&&sortBy.push(option),params.type||(option=this.getFileSortOption(params))&&sortBy.push(option),sortBy.push({name:globalize.translate("ParentalRating"),value:"OfficialRating,SortName",defaultSortOrder:"Descending"}),(option=this.getPlayCountSortOption())&&sortBy.push(option),sortBy.push({name:globalize.translate("ReleaseDate"),value:"ProductionYear,PremiereDate,SortName",defaultSortOrder:"Descending"}),sortBy.push({name:globalize.translate("Runtime"),value:"Runtime,SortName",defaultSortOrder:"Descending"}),sortBy},ItemsView.prototype.getFileSortOption=function(params){var apiClient=getApiClient(this);return apiClient&&apiClient.isMinServerVersion("4.6.0.9")?{name:globalize.translate("FileName"),value:"IsFolder,Filename"}:{name:globalize.translate("Folders"),value:"IsFolder,"+this.getNameSortOption(params).value,defaultSortOrder:"Ascending"}},ItemsView.prototype.getNameSortOption=function(params){return"Episode"===params.type?{name:globalize.translate("Title"),value:"SeriesName,SortName"}:{name:globalize.translate("Title"),value:"SortName",defaultSortOrder:"Ascending"}},ItemsView.prototype.getPlayCountSortOption=function(){var params=this.params;return"Program"===params.type||"downloads"===params.parentId?null:{name:globalize.translate("PlayCount"),value:"PlayCount,SortName",defaultSortOrder:"Descending"}},ItemsView.prototype.getDatePlayedSortOption=function(){var params=this.params;return"Program"===params.type||"downloads"===params.parentId?null:{name:globalize.translate("DatePlayed"),value:"DatePlayed,SortName",defaultSortOrder:"Descending"}},ItemsView.prototype.getCriticRatingSortOption=function(){var params=this.params;return"Program"===params.type||"downloads"===params.parentId?null:{name:globalize.translate("CriticRating"),value:"CriticRating,SortName",defaultSortOrder:"Descending"}},ItemsView.prototype.getCommunityRatingSortOption=function(){return{name:globalize.translate("CommunityRating"),value:"CommunityRating,SortName",defaultSortOrder:"Descending"}},ItemsView.prototype.getVisibleFilters=function(){var filters=[],params=this.params;return"downloads"===params.parentId||"nextup"===params.type||"OnNow"===params.type||"search"===params.type||("Program"===params.type?(filters.push("Genres"),filters.push("OfficialRatings")):"Recordings"===params.type?(filters.push("IsUnplayed"),filters.push("IsPlayed"),params.IsFavorite||filters.push("IsFavorite"),params.genreId||filters.push("Genres"),params.studioId||filters.push("Studios"),params.tagId||filters.push("Tags"),filters.push("OfficialRatings"),filters.push("Containers"),filters.push("Years"),filters.push("AudioCodecs"),filters.push("VideoCodecs"),filters.push("SubtitleCodecs"),filters.push("IsResumable"),filters.push("HasSubtitles"),filters.push("HasTrailer"),filters.push("HasSpecialFeature"),filters.push("HasThemeSong"),filters.push("HasThemeVideo"),filters.push("HasOverview"),filters.push("IsLocked")):(filters.push("IsUnplayed"),filters.push("IsPlayed"),params.IsFavorite||filters.push("IsFavorite"),params.genreId||filters.push("Genres"),params.studioId||filters.push("Studios"),params.tagId||filters.push("Tags"),filters.push("OfficialRatings"),filters.push("Containers"),filters.push("Years"),filters.push("AudioCodecs"),filters.push("VideoCodecs"),filters.push("SubtitleCodecs"),filters.push("IsResumable"),filters.push("HasSubtitles"),filters.push("HasTrailer"),filters.push("HasSpecialFeature"),filters.push("HasThemeSong"),filters.push("HasThemeVideo"),filters.push("HasOverview"),filters.push("IsLocked"),filters.push("HasImdbId"))),filters},ItemsView.prototype.setFilterStatus=function(hasFilters){var filterButtons=this.filterButtons;if(filterButtons.length)for(var i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];hasFilters?btnFilter.classList.add("filter-active"):btnFilter.classList.remove("filter-active")}},ItemsView.prototype.enableVirtualData=function(){return this.itemsContainer.hasAttribute("data-virtualscrolllayout")},ItemsView.prototype.virtualChunkSize=function(){return null},ItemsView.prototype.getFilterMenuOptions=function(){var params=this.params;return{IsAiring:params.IsAiring,IsMovie:params.IsMovie,IsSports:params.IsSports,IsKids:params.IsKids,IsNews:params.IsNews,IsSeries:params.IsSeries,Recursive:this.getQueryInfo(!1).Recursive}},ItemsView.prototype.getVisibleViewSettings=function(){var params=this.params;if("downloads"===params.parentId)return{};if("search"===params.type)return{};var item=this.currentItem,fields=["Name"],settings=[];return"Person"!==params.type&&"MusicArtist"!==params.type&&"nextup"!==params.type&&"Program"!==params.type&&"OnNow"!==params.type&&(item&&(item.CollectionType||"CollectionFolder"===item.Type||"UserView"===item.Type||"Channel"===item.Type)||(fields.push("ProductionYear"),fields.push("CommunityRating"),fields.push("CriticRating"),fields.push("OfficialRating"))),"Program"===params.type&&params.IsMovie&&fields.push("ProductionYear"),item&&("PhotoAlbum"===item.Type||"ChannelFolderItem"===item.Type)||settings.push("imageType"),{settings:settings,fields:fields}},ItemsView.prototype.detectDefaultViewType=function(items){var viewType=this._defaultViewType;return viewType||((items=items||this.itemsContainer.items||[]).length&&(viewType=function(items){for(var hasIndexNumber,matches=0,i=0,length=items.length;i<length;i++){var item=items[i];if(item){if(item.IsFolder||"Audio"!==item.MediaType)return;matches++,item.IndexNumber&&(hasIndexNumber=!0)}}return hasIndexNumber&&0<matches}(items)?this._defaultViewType="list":this._defaultViewType="primary"),viewType)},ItemsView.prototype.getViewSettingDefaults=function(currentItem,listItems,allowedVisibleFields){var activeSearchTab,searchItemType,defaults={imageType:"primary",fields:[]};return currentItem&&"PhotoAlbum"===currentItem.Type||defaults.fields.push("Name"),"search"===this.params.type?!(activeSearchTab=this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active"))||"all"===(searchItemType=activeSearchTab.getAttribute("data-searchtype"))?(defaults.fields.push("Type"),defaults.fields.push("ProductionYear")):"Movie"!==searchItemType&&"Series"!==searchItemType&&"Trailer"!==searchItemType||defaults.fields.push("ProductionYear"):defaults.imageType=this.detectDefaultViewType(listItems)||defaults.imageType,allowedVisibleFields.includes("ProductionYear")&&defaults.fields.includes("Name")&&defaults.fields.push("ProductionYear"),defaults},ItemsView.prototype.getViewSettings=function(items){items=items||this.itemsContainer.getItems();var basekey=this.getSettingsKey(),visibleFields=this.getVisibleViewSettings().fields||[],item=this.currentItem,defaults=this.getViewSettingDefaults(item,items,visibleFields),userConfiguredFields=(userConfiguredFields=userSettings.get(basekey+"-fields"))?userConfiguredFields.split(","):defaults.fields,params=this.params,imageType=userSettings.get(basekey+"-imageType");return imageType||"nextup"===params.type&&(imageType="thumb"),{fields:userConfiguredFields,groupItemsIntoTags:"true"===userSettings.get(basekey+"-groupItemsIntoTags"),groupItemsIntoCollections:"true"===userSettings.get(basekey+"-groupItemsIntoCollections"),imageType:imageType||defaults.imageType}},ItemsView.prototype.getItemTypes=function(){var params=this.params;return"nextup"===params.type?["Episode"]:"Recordings"===params.type?["Episode","Video","Movie"]:params.type?params.type.split(","):[]},ItemsView.prototype.getItemCountText=function(numItems){return 1===numItems?globalize.translate("ValueOneItem"):globalize.translate("ItemCount",numItems)},ItemsView.prototype.getSettingsKey=function(){var values=[];values.push("items");var params=this.params;return params.type?values.push(params.type):params.parentId&&values.push(params.parentId),params.IsAiring&&values.push("IsAiring"),params.IsMovie&&values.push("IsMovie"),params.IsKids&&values.push("IsKids"),params.IsSports&&values.push("IsSports"),params.IsNews&&values.push("IsNews"),params.IsSeries&&values.push("IsSeries"),params.IsFavorite&&values.push("IsFavorite"),params.genreId&&values.push("Genre"),params.gameGenreId&&values.push("GameGenre"),params.musicGenreId&&values.push("MusicGenre"),params.studioId&&values.push("Studio"),params.tagId&&values.push("Tag"),params.personId&&values.push("Person"),params.parentId&&values.push("Folder"),values.join("-")},ItemsView});