define(["baseTab","layoutManager","connectionManager","tvguide","events","datetime","imageLoader","backdrop","mediaInfo","css!./guide"],function(BaseTab,layoutManager,connectionManager,tvguide,events,datetime,imageLoader,backdrop,mediaInfo){"use strict";var focusTimeout,currentItemId,serverId,guideItemDetailsElement,guideImageElement;function getTime(date){return datetime.getDisplayTime(date).toLowerCase()}function setSelectedInfo(item){var html="";html+='<div class="guideSelectedItemPrimaryInfo">',html+="<h2>"+item.Name+"</h2>",item.SeriesTimerId?html+='<i class="seriesTimerIcon md-icon">fiber_smart_record</i>':item.TimerId&&(html+='<i class="timerIcon md-icon">fiber_manual_record</i>'),html+="</div>";var secondaryMediaInfoHtml=mediaInfo.getPrimaryMediaInfoHtml(item);secondaryMediaInfoHtml&&(html+='<div class="dim guideSelectedItemMediaInfo">',html+=secondaryMediaInfoHtml,html+="</div>");var overview=item.ShortOverview||item.Overview;overview&&(html+='<div class="guideOverview dim" style="margin-top:.15em;">',html+=overview,html+="</div>");var date="";if(item.StartDate)try{date+=getTime(datetime.parseISO8601Date(item.StartDate))}catch(e){console.log("Error parsing date: "+item.PremiereDate)}if(item.EndDate)try{date+=" - "+getTime(datetime.parseISO8601Date(item.EndDate))}catch(e){console.log("Error parsing date: "+item.EndDate)}date&&(html+='<div class="dim" style="margin-top:.15em;">',html+=date,html+="</div>"),guideItemDetailsElement.innerHTML=html;var imgUrl=function(item,options){return(options=options||{}).type=options.type||"Primary","string"==typeof item?connectionManager.getApiClient(item.ServerId).getImageUrl(item,options):item.ImageTags&&item.ImageTags[options.type]?(options.tag=item.ImageTags[options.type],connectionManager.getApiClient(item.ServerId).getImageUrl(item.Id,options)):"Primary"===options.type&&item.AlbumId&&item.AlbumPrimaryImageTag?(options.tag=item.AlbumPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getImageUrl(item.AlbumId,options)):null}(item);imgUrl?imageLoader.lazyImage(guideImageElement,imgUrl):guideImageElement.style.backgroundImage=""}function onFocusTimeout(){var apiClient=connectionManager.getApiClient(serverId);apiClient.getItem(apiClient.getCurrentUserId(),currentItemId).then(function(item){setSelectedInfo(item)})}function onGuideFocus(e,detail){focusTimeout&&clearTimeout(focusTimeout),currentItemId=detail.item.Id,focusTimeout=setTimeout(onFocusTimeout,500)}function GuideTab(view,params){BaseTab.apply(this,arguments),this.apiClient=connectionManager.getApiClient(params.serverId),this.view=view,this.params=params,serverId=params.serverId,guideItemDetailsElement=view.querySelector(".guideItemDetails"),guideImageElement=view.querySelector(".guideImage")}return Object.assign(GuideTab.prototype,BaseTab.prototype),GuideTab.prototype.onResume=function(options){BaseTab.prototype.onResume.apply(this,arguments),backdrop.clear();var guideInstance=this.guideInstance;return guideInstance||(guideInstance=this.guideInstance=new tvguide({element:this.view.querySelector(".guideContainer"),serverId:this.params.serverId}),layoutManager.tv&&(events.on(this.guideInstance,"focus",onGuideFocus),this.view.querySelector(".guideSelectedInfo").classList.remove("hide")),(options=options||{}).refresh=!0),guideInstance.resume(options)},GuideTab.prototype.onPause=function(){BaseTab.prototype.onPause.apply(this,arguments);var guideInstance=this.guideInstance;guideInstance&&guideInstance.pause()},GuideTab.prototype.destroy=function(){BaseTab.prototype.destroy.apply(this,arguments);var guideInstance=this.guideInstance;guideInstance&&(events.off(guideInstance,"focus",onGuideFocus),guideInstance.destroy()),guideImageElement=guideItemDetailsElement=serverId=null,this.view=null,this.params=null,this.guideInstance=null,this.apiClient=null},GuideTab});