define(["baseView","mainTabsManager","cardBuilder","globalize","appRouter","scripts/taskbutton","dom","layoutManager","loading","listViewStyle","flexStyles","emby-itemscontainer","material-icons","emby-linkbutton","emby-button"],function(BaseView,mainTabsManager,cardBuilder,globalize,appRouter,taskButton,dom,layoutManager,loading){"use strict";function getListingProviders(){var apiClient=this.apiClient;return apiClient.getJSON(ApiClient.getUrl("LiveTv/ListingProviders")).catch(function(){return apiClient.getNamedConfiguration("livetv").then(function(config){return config.ListingProviders})}).then(function(results){return function(providers,apiClient){for(var i=0,length=providers.length;i<length;i++){var provider=providers[i];provider.Name||(provider.Name=provider.Type),provider.Url||(provider.Url=provider.Path||provider.ListingsId),provider.SetupUrl||(provider.SetupUrl="xmltv"===provider.Type?"livetvsetup/xmltv.html":"livetvsetup/schedulesdirect.html"),provider.ProviderType=provider.Type,provider.Type="LiveTVGuideSource",provider.ServerId=apiClient.serverId()}}(results,apiClient),results})}function getTunerDevices(){var apiClient=this.apiClient;return apiClient.getJSON(ApiClient.getUrl("LiveTv/TunerHosts")).catch(function(){return apiClient.getNamedConfiguration("livetv").then(function(config){return config.TunerHosts})}).then(function(results){return function(devices,apiClient){for(var i=0,length=devices.length;i<length;i++){var tuner=devices[i];tuner.Type="LiveTVTunerDevice",tuner.Name=tuner.FriendlyName,tuner.ServerId=apiClient.serverId()}}(results,apiClient),results})}function getTabs(){var list=[{href:"livetvsetup/livetvstatus.html",name:globalize.translate("Setup")}];return ApiClient.isMinServerVersion("4.6.0.44")&&list.push({href:"livetvsetup/channels",name:globalize.translate("Channels")}),list.push({href:"livetvsetup/livetvsettings.html",name:globalize.translate("Advanced")}),list}function LiveTVSetupView(view,params){BaseView.apply(this,arguments),view.querySelector(".btnAddDevice").addEventListener("click",function(){appRouter.show("livetvsetup/livetvtuner.html")}),view.querySelector(".btnAddProvider").addEventListener("click",function(){appRouter.show("livetvsetup/guideprovider.html")}),view.querySelector(".premiereInfo").innerHTML=globalize.translate("DvrSubscriptionRequired",'<a is="emby-linkbutton" href="https://emby.media/premiere" target="_blank" class="button-link">',"</a>"),this.apiClient=ApiClient,this.tunersItemsContainer=view.querySelector(".devicesList"),this.tunersItemsContainer.fetchData=getTunerDevices.bind(this),this.tunersItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{fields:["Name","Url"],multiSelect:!1,overlayText:!1,draggable:!1,action:"edit",shape:"backdrop",defaultBackground:!0},virtualScrollLayout:"vertical-grid"}}.bind(this),this.providersItemsContainer=view.querySelector(".providerList"),this.providersItemsContainer.fetchData=getListingProviders.bind(this),this.providersItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{fields:["Name","Url"],multiSelect:!1,overlayText:!1,draggable:!1,action:"edit",shape:"backdrop",defaultBackground:!0},virtualScrollLayout:"vertical-grid"}}.bind(this)}return Object.assign(LiveTVSetupView.prototype,BaseView.prototype),LiveTVSetupView.prototype.onResume=function(options){return BaseView.prototype.onResume.apply(this,arguments),mainTabsManager.setTabs(this,0,getTabs),taskButton({mode:"on",progressElem:this.view.querySelector(".refreshGuideProgress"),taskKey:"RefreshGuide",button:this.view.querySelector(".btnRefresh")}),Promise.all([this.tunersItemsContainer.resume(options),this.providersItemsContainer.resume(options)])},LiveTVSetupView.prototype.onPause=function(){BaseView.prototype.onPause.apply(this,arguments),this.tunersItemsContainer.pause(),this.providersItemsContainer.pause(),taskButton({mode:"off",progressElem:this.view.querySelector(".refreshGuideProgress"),taskKey:"RefreshGuide",button:this.view.querySelector(".btnRefresh")})},LiveTVSetupView});