define(["dialogHelper","dom","cardBuilder","loading","layoutManager","playbackManager","connectionManager","userSettings","globalize","focusManager","emby-input","paper-icon-button-light","emby-select","material-icons","formDialogStyle","emby-button","emby-scroller","emby-itemscontainer"],function(dialogHelper,dom,cardBuilder,loading,layoutManager,playbackManager,connectionManager,userSettings,globalize,focusManager){"use strict";function AddToList(){}function initAlphaNumericShortcuts(instance){require(["alphaNumericShortcuts"],function(AlphaNumericShortcuts){instance.alphaNumericShortcuts=new AlphaNumericShortcuts({itemsContainer:instance.itemsContainer}),instance.alphaNumericShortcuts.onAlphaNumericValueEntered=function(value){!function(instance,value,focus){value&&"#"!==value?instance.getItems({Limit:0}).then(function(totalResult){instance.getItems({Limit:0,NameStartsWithOrGreater:value}).then(function(result){instance.itemsContainer.scrollToIndex(Math.max(totalResult.TotalRecordCount-result.TotalRecordCount,0),{},focus)})}):instance.itemsContainer.scrollToIndex(0,{},focus)}(this,(this.scroller,this.view,value),!0)}.bind(instance)})}function onItemsContainerUpgraded(){this.itemsContainer.resume({refresh:!0}).then(function(){var lastListId,dlg=this.dlg,type=this.options.type;if("Playlist"===type?lastListId=userSettings.get("playlisteditor-lastplaylistid"):"Collection"===type&&(lastListId=userSettings.get("collectioneditor-lastcollectionid")),lastListId){var index=this.itemsContainer.indexOfItemId(lastListId);if(-1!==index)return void this.itemsContainer.scrollToIndex(index,{},!0)}focusManager.autoFocus(dlg)}.bind(this))}function mapItem(i){return i.Id||i}function notifyAddedToList(listName,listType,numItems){var secondaryText=1===numItems?globalize.translate("OneItemAddedTo",listName):globalize.translate("ItemsAddedTo",numItems,listName);sendToast({text:"Playlist"===listType?globalize.translate("HeaderAddedToPlaylist"):globalize.translate("HeaderAddedToCollection"),secondaryText:secondaryText,icon:"playlist_add"})}function sendToast(options){require(["toast"],function(toast){toast(options)})}function onAddedToList(type,id){"Playlist"===type?userSettings.set("playlisteditor-lastplaylistid",id):"Collection"===type&&userSettings.set("collectioneditor-lastcollectionid",id)}return AddToList.prototype.getItems=function(query){var options=this.options,apiClient=connectionManager.getApiClient(options.serverId);return apiClient.getItems(apiClient.getCurrentUserId(),Object.assign({Recursive:!0,IncludeItemTypes:"Collection"===options.type?"Boxset":options.type,SortBy:"SortName",Fields:"PrimaryImageAspectRatio"},query))},AddToList.prototype.getCardOptions=function(items){return{shape:"auto",overlayText:!1,centerText:!0,fields:["Name"],overlayPlayButton:!1,multiSelect:!1,hoverMenu:!1,action:"custom",textLinks:!1,lazy:2,draggable:!1,contextMenu:!1}},AddToList.prototype.getListOptions=function(items){return{renderer:cardBuilder,options:this.getCardOptions(items),virtualScrollLayout:"vertical-grid"}},AddToList.prototype.show=function(options){var dialogOptions={removeOnClose:!0,scrollY:!1,autoFocus:!1};layoutManager.tv?dialogOptions.size="fullscreen":dialogOptions.size="fullscreen-border";var dlg=dialogHelper.createDialog(dialogOptions);dlg.classList.add("formDialog");var html="";html+='<div class="formDialogHeader formDialogHeader-clear">',html+='<button is="paper-icon-button-light" class="btnCancel autoSize" tabindex="-1"><i class="md-icon">&#xE5C4;</i></button>',html+='<h2 class="formDialogHeaderTitle">',html+="Collection"===options.type?globalize.translate("HeaderAddToCollection"):globalize.translate("HeaderAddToPlaylist"),html+="</h2>",html+="</div>",html+=function(options){var html="";return html+='<div class="formDialogContent flex flex-direction-column" style="overflow:hidden;">',html+='<div is="emby-scroller" data-horizontal="false" data-centerfocus="card" class="flex flex-grow virtualScrollerScrollContainer">',html+='<div class="scrollSlider padded-left padded-right padded-top flex-grow">',html+='<div class="padded-bottom flex align-items-center justify-content-center">',!1!==options.enableAddToPlayQueue&&"Playlist"===options.type&&playbackManager.isPlaying()&&(html+='<button is="emby-button" type="button" class="raised btnQueue flex-shrink-zero"><i class="button-icon button-icon-left md-icon">playlist_add</i>'+globalize.translate("HeaderAddToPlayQueue")+"</button>"),html+='<button is="emby-button" type="button" class="raised btnNew flex-shrink-zero"><i class="button-icon button-icon-left md-icon">add</i>'+("Collection"===options.type?globalize.translate("HeaderNewCollection"):globalize.translate("HeaderNewPlaylist"))+"</button>",html+="</div>",html+='<div is="emby-itemscontainer" data-virtualscrolllayout="vertical-grid" class="itemsContainer vertical-wrap padded-bottom-page">',html+="</div>",html+="</div>",html+="</div>",html+="</div>"}(options),dlg.innerHTML=html,this.dlg=dlg,this.options=options,dlg.querySelector(".btnCancel").addEventListener("click",function(){this.result=null,this.closeDialog()}.bind(this)),dlg.querySelector(".btnNew").addEventListener("click",function(){this.result="new",this.closeDialog()}.bind(this));var btnQueue=dlg.querySelector(".btnQueue");btnQueue&&btnQueue.addEventListener("click",function(){this.result="queue",this.closeDialog()}.bind(this));var itemsContainer=dlg.querySelector(".itemsContainer");itemsContainer.addEventListener("action-null",function(e){var item=e.detail.item;"Playlist"!==item.Type&&"BoxSet"!==item.Type||this.addToList(item)}.bind(this)),itemsContainer.fetchData=this.getItems.bind(this),itemsContainer.getListOptions=this.getListOptions.bind(this),this.itemsContainer=itemsContainer,dlg.addEventListener("opened",function(){var itemsContainer=this.itemsContainer;itemsContainer.resume?onItemsContainerUpgraded.call(this):dom.addEventListener(itemsContainer,"upgraded",onItemsContainerUpgraded.bind(this),{once:!0}),initAlphaNumericShortcuts(this)}.bind(this));var dlgClosedFn=function(){var result=this.result,options=this.options;return result?"new"===result?this.newList():("queue"===result&&(playbackManager.queue({serverId:options.serverId,ids:this.getItemIds()}),sendToast({text:globalize.translate("HeaderAddedToPlayQueue"),icon:"playlist_add"})),this.cleanup(),Promise.resolve()):(this.cleanup(),Promise.reject())}.bind(this);return dialogHelper.open(dlg).then(dlgClosedFn,dlgClosedFn)},AddToList.prototype.getItemIds=function(){return this.options.items.map(mapItem)},AddToList.prototype.addToList=function(list){var apiClient=connectionManager.getApiClient(list.ServerId);loading.show();var apiName="BoxSet"===list.Type?"Collections":"Playlists",itemIds=this.getItemIds(),url=apiClient.getUrl(apiName+"/"+list.Id+"/Items",{Ids:itemIds,userId:apiClient.getCurrentUserId()}),instance=this;return apiClient.ajax({type:"POST",url:url}).then(function(){loading.hide(),instance.result="1",instance.closeDialog();var type="BoxSet"===list.Type?"Collection":"Playlist";onAddedToList(type,list.Id),notifyAddedToList(list.Name,type,itemIds.length)})},AddToList.prototype.newList=function(){var instance=this,title="Collection"===instance.options.type?globalize.translate("HeaderNewCollection"):globalize.translate("HeaderNewPlaylist");return require(["prompt"]).then(function(responses){var dlgClosedFn=function(result){return result?this.createList(result):(this.cleanup(),Promise.reject())}.bind(instance);return responses[0]({title:title,label:globalize.translate("LabelName"),confirmText:globalize.translate("Create")}).then(dlgClosedFn,dlgClosedFn)})},AddToList.prototype.createList=function(name){loading.show();var options=this.options,apiClient=connectionManager.getApiClient(options.serverId),endpoint="Collection"===options.type?"Collections":"Playlists";this.listName=name;var url=apiClient.getUrl(endpoint,{Name:name,Ids:this.getItemIds(),UserId:apiClient.getCurrentUserId()});return apiClient.ajax({type:"POST",url:url,dataType:"json"}).then(function(result){loading.hide();var newListName=result.Name||this.listName,options=this.options;return onAddedToList(options.type,result.Id),notifyAddedToList(newListName,options.type,options.items.length),this.cleanup(),Promise.resolve()}.bind(this))},AddToList.prototype.closeDialog=function(){var dlg=this.dlg;dlg&&dialogHelper.close(dlg)},AddToList.prototype.cleanup=function(){this.listName=null,this.options=null,this.dlg=null,this.itemsContainer=null},AddToList});