define(["viewManager","dom","inputManager","backdrop","browser","layoutManager","globalize","datetime","playbackManager","connectionManager","require","mainTabsManager","serverNotifications","appRouter","apphost","events","navdrawer","navDrawerContent","userSettings","paper-icon-button-light","material-icons","css!./appheader","emby-select","scrollStyles"],function(viewManager,dom,inputManager,backdrop,browser,layoutManager,globalize,datetime,playbackManager,connectionManager,require,mainTabsManager,serverNotifications,appRouter,appHost,events,navDrawerInstance,navDrawerContent,userSettings){"use strict";var headerHomeButton,headerMenuButton,headerBackButton,headerCastButton,headerHelpButton,headerSettingsButton,headerUserButton,selectedPlayerText,headerLeft,headerRight,currentServerId,isUserAdmin,headerMiddle,boundLayoutModeChangeFn,skinHeaderElement=document.querySelector(".skinHeader"),skinBodyElement=document.querySelector(".skinBody"),mainDrawerElement=document.querySelector(".mainDrawer"),backdropContainer=document.querySelector(".backdropContainer"),hasPhysicalBackButton=appHost.supports("physicalbackbutton"),userSignedIn=!1;function updateClock(){var clock=this.clockElement;clock&&(clock.innerHTML=datetime.getDisplayTime(new Date).toLowerCase())}function onLocalUserSignedOut(e){userSignedIn=!1,document.querySelector(".headerSearchButton").classList.add("hide"),updateUserInHeader(null),setRemoteControlVisibility()}function ensureHeaderSettingsButton(){headerUserButton=headerUserButton||document.querySelector(".headerUserButton"),headerSettingsButton=headerSettingsButton||document.querySelector(".headerSettingsButton")}function updateUserInHeader(user){var userImageUrl;ensureHeaderSettingsButton(),user&&user.PrimaryImageTag&&(userImageUrl=function(user,apiClient,options){return(options=options||{}).type="Primary",user.PrimaryImageTag?(options.tag=user.PrimaryImageTag,apiClient.getUserImageUrl(user.Id,options)):null}(user,connectionManager.getApiClient(user.ServerId),{height:Math.round(38*Math.max(window.devicePixelRatio||1,2))})),headerUserButton.innerHTML=userImageUrl?'<img class="headerUserButtonImage paper-icon-button-img" src="'+userImageUrl+'" />':'<i class="md-icon">&#xE7FD;</i>',isUserAdmin=user?(headerUserButton.classList.remove("hide"),layoutManager.tv?headerSettingsButton.classList.add("hide"):headerSettingsButton.classList.remove("hide"),user.Policy.IsAdministrator):(headerUserButton.classList.add("hide"),headerSettingsButton.classList.add("hide"),!1)}function onUserUpdated(e,apiClient,data){apiClient.getCurrentUserId()===data.Id&&apiClient.serverId()===currentServerId&&updateUserInHeader(data)}function resetPremiereButton(){appHost.supports("premiereinheader")&&connectionManager.currentApiClient()&&connectionManager.currentApiClient().serverId()&&require(["registrationServices","emby-button"],function(registrationServices){registrationServices.validateFeature("themes",{viewOnly:!0,showDialog:!1}).then(removePremiereButton,function(e){!function(registrationServices){var html='<button is="emby-button" class="raised button-submit btnHeaderPremiere headerButton" style="margin-right:1em;padding-top:.5em;padding-bottom:.5em;">'+globalize.translate("HeaderBecomeProjectSupporter")+"</button>";if(document.querySelector(".btnHeaderPremiere"))return;document.querySelector(".headerRight").insertAdjacentHTML("afterbegin",html),document.querySelector(".btnHeaderPremiere").addEventListener("click",function(){registrationServices.validateFeature("themes",{viewOnly:!0}).then(resetPremiereButton)})}(registrationServices)})})}function removePremiereButton(){var btn=document.querySelector(".btnHeaderPremiere");btn&&btn.parentNode.removeChild(btn)}function onLocalUserSignedIn(e,serverId,userId){currentServerId=serverId,userSignedIn=!0,document.querySelector(".headerSearchButton").classList.remove("hide"),connectionManager.getApiClient(serverId).getUser(userId).then(updateUserInHeader),resetPremiereButton(),setRemoteControlVisibility()}function onHeaderMenuButtonClick(){navDrawerInstance.open()}function onHomeClick(){appRouter.goHome()}function onBackClick(){appRouter.back()}function onSearchClick(){inputManager.trigger("search",{sourceElement:viewManager.currentView()})}function onNowPlayingClick(){appRouter.showNowPlaying()}function onUserButtonClick(){appRouter.showUserMenu()}function onSettingsButtonClick(){var manageServerRouteUrl=appRouter.getRouteUrl("manageserver");isUserAdmin&&appRouter.getRouteInfo(manageServerRouteUrl)?appRouter.show(manageServerRouteUrl):appRouter.showUserMenu()}function onCastButtonClick(){var btn=this;require(["playerSelectionMenu"],function(playerSelectionMenu){playerSelectionMenu.show(btn)})}function onLayoutModeChange(){ensureHeaderSettingsButton(),layoutManager.tv||headerUserButton.classList.contains("hide")?headerSettingsButton.classList.add("hide"):headerSettingsButton.classList.remove("hide"),headerMiddle=headerMiddle||document.querySelector(".headerMiddle"),this.destroyClock(),this.loadClock()}function updateCastIcon(){var info,btnCast=headerCastButton;btnCast&&((info=playbackManager.getPlayerInfo())&&!info.isLocalPlayer?(btnCast.querySelector("i").innerHTML="&#xE308;",btnCast.classList.add("active"),selectedPlayerText.innerHTML=info.deviceName||info.name):(btnCast.querySelector("i").innerHTML="&#xE307;",btnCast.classList.remove("active"),selectedPlayerText.innerHTML=""))}function onPlaybackStart(e,player,state){layoutManager.tv&&state.NowPlayingItem&&"Audio"===state.NowPlayingItem.MediaType?(document.querySelector(".headerAudioPlayerButton").classList.remove("hide"),state.IsFirstItem&&state.IsFullscreen&&onNowPlayingClick()):document.querySelector(".headerAudioPlayerButton").classList.add("hide")}function onPlaybackStop(e,stopInfo){"Audio"!==stopInfo.nextMediaType&&document.querySelector(".headerAudioPlayerButton").classList.add("hide")}function setRemoteControlVisibility(){appHost.supports("remotecontrol")&&!layoutManager.tv&&userSignedIn?(headerCastButton.classList.remove("hide"),selectedPlayerText.classList.remove("hide")):(headerCastButton.classList.add("hide"),selectedPlayerText.classList.add("hide"))}function allowDrawer(detail){if(!1!==detail.drawer){if(detail.hideDrawerWithOtherUserIdParam){var params=detail.params;if(params&&params.userId&&params.serverId){var apiClient=connectionManager.getApiClient(params.serverId);if(apiClient&&apiClient.getCurrentUserId()!==params.userId)return}}return 1}}function updateWindowScroll(detail,view){var scrollingElement=document.scrollingElement||document.documentElement;enableWindowScroll(detail,view)?(scrollingElement.classList.remove("noScrollY"),scrollingElement.classList.add("overflowYScroll"),skinBodyElement.classList.add("skinBody-withWindowScroll")):(scrollingElement.classList.add("noScrollY"),scrollingElement.classList.remove("overflowYScroll"),skinBodyElement.classList.remove("skinBody-withWindowScroll"))}function onNavDrawerStateChange(e,drawerState){2===drawerState?(headerHomeButton.classList.add("headerHomeButton-withdockeddrawer"),headerMenuButton.classList.add("headerMenuButton-withfulldrawer"),skinBodyElement.classList.remove("skinBody-withPartialDrawer"),mainDrawerElement.classList.remove("mainDrawer-open-partial"),skinBodyElement.classList.add("skinBody-withFullDrawer"),skinHeaderElement.classList.add("skinHeader-withfulldrawer"),backdropContainer.classList.add("backdropContainer-withfulldrawer")):(1===drawerState?(headerHomeButton.classList.remove("headerHomeButton-withdockeddrawer"),headerMenuButton.classList.remove("headerMenuButton-withfulldrawer"),skinBodyElement.classList.remove("skinBody-withFullDrawer","skinBody-withPartialDrawer"),skinHeaderElement.classList.remove("skinHeader-withfulldrawer"),mainDrawerElement.classList.remove("mainDrawer-open-partial")):(skinBodyElement.classList.remove("skinBody-withFullDrawer","skinBody-withPartialDrawer"),skinHeaderElement.classList.remove("skinHeader-withfulldrawer"),mainDrawerElement.classList.remove("mainDrawer-open-partial"),headerHomeButton.classList.remove("headerHomeButton-withdockeddrawer"),headerMenuButton.classList.remove("headerMenuButton-withfulldrawer")),backdropContainer.classList.remove("backdropContainer-withfulldrawer","backdropContainer-withpartialdrawer"))}function onViewShow(e){var detail=e.detail;detail.clearBackdrop&&backdrop.clear(),function(detail){!layoutManager.tv&&allowDrawer(detail)&&"docked"===(detail.settingsTheme?"docked":userSettings.drawerStyle())?(detail.drawerInline=!0,navDrawerInstance.open(!0)):navDrawerInstance.close()}(detail),function(detail){var backButtonConfig=detail.backButton;!1===backButtonConfig||!appRouter.canGoBack()||hasPhysicalBackButton&&!0!==backButtonConfig&&!layoutManager.tv?headerBackButton.classList.add("hide"):headerBackButton.classList.remove("hide")}(detail),function(detail){userSignedIn&&!1!==detail.homeButton?headerHomeButton.classList.remove("hide"):headerHomeButton.classList.add("hide")}(detail),function(detail){!layoutManager.tv&&userSignedIn&&allowDrawer(detail)?headerMenuButton.classList.remove("hide"):headerMenuButton.classList.add("hide")}(detail),function(detail){var helpUrl=detail.helpUrl;helpUrl?(headerHelpButton.href=helpUrl,headerHelpButton.classList.remove("hide")):headerHelpButton.classList.add("hide")}(detail),function(detail){!layoutManager.tv&&detail.adjustHeaderForEmbeddedScroll?skinHeaderElement.classList.add("adjustHeaderForEmbeddedScroll"):skinHeaderElement.classList.remove("adjustHeaderForEmbeddedScroll")}(detail),function(detail){!1===detail.secondaryHeaderFeatures?headerRight.classList.add("hide"):headerRight.classList.remove("hide")}(detail,e.target),function(header,detail){var title;detail.defaultTitle?header.setDefaultTitle():(title=detail.title)&&header.setTitle(globalize.translate(title))}(this,detail,e.target),navDrawerContent.onViewShow(e),!detail.isRestored&&enableWindowScroll(detail)&&window.scrollTo(0,0)}function enableWindowScroll(detail,view){var elem,windowScroll=detail.windowScroll;return 2!==windowScroll||layoutManager.tv||!browser.iOS1?!0===windowScroll:(view&&((elem=view.querySelector(".padded-top-page"))&&elem.classList.remove("padded-top-page"),view.classList.add("page-withiOSScrollHack")),1)}function onViewBeforeShow(e){var detail=e.detail,view=e.target;detail.headerTabs?(headerLeft.classList.add("headerPartFixedWidth"),headerRight.classList.add("headerPartFixedWidth")):(mainTabsManager.setTabs(null),headerLeft.classList.remove("headerPartFixedWidth"),headerRight.classList.remove("headerPartFixedWidth"));var skinHeader=skinHeaderElement;!1!==detail.headerBackground&&skinHeader.classList.add("skinHeader-withBackground"),detail.adjustHeaderForEmbeddedScroll&&!0!==detail.windowScroll||(skinHeader.style.transform="none"),updateWindowScroll(detail,view),!1===detail.headerBackground&&skinHeader.classList.remove("skinHeader-withBackground"),this.setTransparent(detail.transparentHeader)}function onCancelled(){return Promise.resolve()}function showLibrarySelection(button,selectedId,serverId){connectionManager.getApiClient(serverId).getUserViews().then(function(result){require(["actionsheet"]).then(function(responses){return responses[0].show({items:function(views,selectedId){for(var items=[],i=0,length=views.length;i<length;i++){var view=views[i];items.push({name:view.Name,id:view.Id,selected:view.Id===selectedId})}return items}(result.Items,selectedId),positionTo:button,type:"select",positionX:"right",positionY:"bottom"}).then(function(id){appRouter.showItem(id,serverId)},onCancelled)})})}function onPageTitleClick(e){var btnHeaderSelectLibrary=e.target.closest(".btnHeaderSelectLibrary");btnHeaderSelectLibrary&&showLibrarySelection(btnHeaderSelectLibrary,btnHeaderSelectLibrary.getAttribute("data-id"),btnHeaderSelectLibrary.getAttribute("data-serverid"))}function onHeaderRendered(instance){skinHeaderElement.classList.remove("hide"),function(instance){var parent=instance.element;headerBackButton=parent.querySelector(".headerBackButton"),headerHomeButton=parent.querySelector(".headerHomeButton"),headerMenuButton=parent.querySelector(".headerMenuButton"),headerCastButton=parent.querySelector(".headerCastButton"),headerHelpButton=parent.querySelector(".headerHelpButton"),selectedPlayerText=parent.querySelector(".headerSelectedPlayer"),headerLeft=parent.querySelector(".headerLeft"),headerRight=parent.querySelector(".headerRight"),headerBackButton.addEventListener("click",onBackClick),headerHomeButton.addEventListener("click",onHomeClick),parent.querySelector(".headerSearchButton").addEventListener("click",onSearchClick),parent.querySelector(".headerAudioPlayerButton").addEventListener("click",onNowPlayingClick),headerCastButton.addEventListener("click",onCastButtonClick),parent.querySelector(".headerUserButton").addEventListener("click",onUserButtonClick),parent.querySelector(".headerSettingsButton").addEventListener("click",onSettingsButtonClick),headerMenuButton.addEventListener("click",onHeaderMenuButtonClick),boundLayoutModeChangeFn=onLayoutModeChange.bind(instance),events.on(layoutManager,"modechange",boundLayoutModeChangeFn),events.on(playbackManager,"playerchange",updateCastIcon),events.on(playbackManager,"playbackstart",onPlaybackStart),events.on(playbackManager,"playbackstop",onPlaybackStop),events.on(connectionManager,"localusersignedin",onLocalUserSignedIn),events.on(connectionManager,"localusersignedout",onLocalUserSignedOut),events.on(serverNotifications,"UserUpdated",onUserUpdated),document.addEventListener("viewbeforeshow",onViewBeforeShow.bind(instance)),document.addEventListener("viewshow",onViewShow.bind(instance)),(instance.pageTitleElement=parent.querySelector(".pageTitle")).addEventListener("click",onPageTitleClick),resetPremiereButton(),events.on(connectionManager,"resetregistrationinfo",resetPremiereButton)}(instance),setRemoteControlVisibility(),onLayoutModeChange.call(instance),events.on(navDrawerInstance,"drawer-state-change",onNavDrawerStateChange)}function AppHeader(){}return AppHeader.prototype.init=function(){return(instance=this).element=skinHeaderElement,require(["text!./appheader.template.html"]).then(function(responses){instance.element.innerHTML=globalize.translateHtml(responses[0]),onHeaderRendered(instance)});var instance},AppHeader.prototype.loadClock=function(){var elem;layoutManager.tv?((elem=document.querySelector(".headerClock")).classList.remove("hide"),this.clockElement=elem,this.clockInterval=setInterval(updateClock.bind(this),5e4),updateClock.call(this)):this.destroyClock()},AppHeader.prototype.setDefaultTitle=function(){var pageTitleElement=this.pageTitleElement;pageTitleElement&&(pageTitleElement.classList.add("pageTitleWithLogo","pageTitleWithDefaultLogo"),pageTitleElement.style.backgroundImage=null,pageTitleElement.innerHTML=""),document.title="Emby"},AppHeader.prototype.setTitle=function(title){var html,pageTitleElement;null!=title?("-"===title&&(title=""),html=function(title){if(!title)return"";if("string"==typeof title)return title;var serverId,itemId,item=title;return title=item.Name||"",layoutManager.tv||(item.IsFolder?(serverId=item.ServerId,itemId=item.Id):window.location.href.toString().toLowerCase().includes("livetv")&&window.location.href.toString().toLowerCase().includes("livetvsetup")&&(serverId=connectionManager.currentApiClient().serverId(),itemId="livetv"),serverId&&itemId&&(title='<div class="pageTitleTextHide">'+title+'</div><button data-serverid="'+serverId+'" data-id="'+itemId+'" is="emby-button" type="button" class="button-link button-inherit-color btnHeaderSelectLibrary"><span>'+title+'</span><i class="md-icon button-icon">arrow_drop_down</i></button>')),title}(title),(pageTitleElement=this.pageTitleElement)&&(pageTitleElement.classList.remove("pageTitleWithLogo","pageTitleWithDefaultLogo"),pageTitleElement.style.backgroundImage=null,pageTitleElement.innerHTML=html||""),document.title=title?"string"==typeof title?title:title.Name||"Emby":"Emby"):this.setDefaultTitle()},AppHeader.prototype.setTransparent=function(transparent){transparent?skinHeaderElement.classList.add("semiTransparent"):skinHeaderElement.classList.remove("semiTransparent")},AppHeader.prototype.destroyClock=function(){var interval=this.clockInterval;interval&&clearInterval(interval);var elem=this.clockElement;elem&&elem.classList.add("hide"),this.clockElement=null,this.clockInterval=null},AppHeader.prototype.destroy=function(){var parent;this.destroyClock(),(parent=this.element)&&(parent.querySelector(".headerBackButton").removeEventListener("click",onBackClick),parent.querySelector(".headerHomeButton").removeEventListener("click",onHomeClick),parent.querySelector(".headerSearchButton").removeEventListener("click",onSearchClick),parent.querySelector(".headerAudioPlayerButton").removeEventListener("click",onNowPlayingClick),parent.querySelector(".headerCastButton").removeEventListener("click",onCastButtonClick),parent.querySelector(".headerUserButton").removeEventListener("click",onUserButtonClick),parent.querySelector(".headerSettingsButton").removeEventListener("click",onSettingsButtonClick),parent.querySelector(".headerMenuButton").removeEventListener("click",onHeaderMenuButtonClick)),events.off(layoutManager,"modechange",boundLayoutModeChangeFn),events.off(playbackManager,"playerchange",updateCastIcon),events.off(playbackManager,"playbackstart",onPlaybackStart),events.off(playbackManager,"playbackstop",onPlaybackStop),events.off(connectionManager,"localusersignedin",onLocalUserSignedIn),events.off(connectionManager,"localusersignedout",onLocalUserSignedOut),events.off(serverNotifications,"UserUpdated",onUserUpdated),events.off(connectionManager,"resetregistrationinfo",resetPremiereButton),document.removeEventListener("viewbeforeshow",onViewBeforeShow),document.removeEventListener("viewshow",onViewShow),this.element=null},new AppHeader});