define(["browser","connectionManager","playbackManager","dom","Modernizr","css!./style"],function(browser,connectionManager,playbackManager,dom,Modernizr){"use strict";function enableAnimation(){return Modernizr.cssanimations&&dom.supportsEventListenerOnce()}function enableRotation(){return!!enableAnimation()}function Backdrop(){}var backdropContainer,hasExternalBackdrop,currentLoadingBackdrop,backgroundContainer,hasInternalBackdrop;function getBackdropContainer(){return(backdropContainer=backdropContainer||document.querySelector(".backdropContainer"))||((backdropContainer=document.createElement("div")).classList.add("backdropContainer"),document.body.insertBefore(backdropContainer,document.body.firstChild)),backdropContainer}function clearBackdrop(clearAll){clearRotation(),currentLoadingBackdrop&&(currentLoadingBackdrop.destroy(),currentLoadingBackdrop=null),getBackdropContainer().innerHTML="",clearAll&&(hasExternalBackdrop=!1),internalBackdrop(!1)}function getBackgroundContainer(){return backgroundContainer=backgroundContainer||document.querySelector(".backgroundContainer")}function setBackgroundContainerBackgroundEnabled(){hasInternalBackdrop||hasExternalBackdrop?getBackgroundContainer().classList.add("withBackdrop"):getBackgroundContainer().classList.remove("withBackdrop")}function internalBackdrop(enabled){hasInternalBackdrop=enabled,setBackgroundContainerBackgroundEnabled()}function setBackdropImage(url,animate){currentLoadingBackdrop&&(currentLoadingBackdrop.destroy(),currentLoadingBackdrop=null);var elem=getBackdropContainer(),existingBackdropImage=elem.querySelector(".displayingBackdropImage");if(existingBackdropImage){if(existingBackdropImage.getAttribute("data-url")===url)return;existingBackdropImage.classList.remove("displayingBackdropImage")}var instance=new Backdrop;instance.load(url,animate,elem,existingBackdropImage),currentLoadingBackdrop=instance}Backdrop.prototype.load=function(url,animate,parent,existingBackdropImage){var img=new Image,self=this;this.previousBackdropImage=existingBackdropImage,img.onload=function(){var backdropImage,onAnimationComplete;self.isDestroyed?self.removePreviousBackdropImage():((backdropImage=document.createElement("div")).classList.add("backdropImage","displayingBackdropImage"),backdropImage.style.backgroundImage="url('"+url+"')",backdropImage.setAttribute("data-url",url),backdropImage.setAttribute("loading","lazy"),self.elem=backdropImage,internalBackdrop(!0),animate&&enableAnimation()&&backdropImage.classList.add("backdropImageFadeIn"),parent.appendChild(backdropImage),enableAnimation()?(onAnimationComplete=function(){dom.removeEventListener(backdropImage,dom.whichAnimationEvent(),onAnimationComplete,{once:!0}),dom.removeEventListener(backdropImage,dom.whichAnimationCancelEvent(),onAnimationComplete,{once:!0}),self.removePreviousBackdropImage()},dom.addEventListener(backdropImage,dom.whichAnimationEvent(),onAnimationComplete,{once:!0}),dom.addEventListener(backdropImage,dom.whichAnimationCancelEvent(),onAnimationComplete,{once:!0})):self.removePreviousBackdropImage())},img.src=url,this.url=url},Backdrop.prototype.removePreviousBackdropImage=function(){var existingBackdropImage=this.previousBackdropImage;existingBackdropImage&&existingBackdropImage.parentNode&&existingBackdropImage.parentNode.removeChild(existingBackdropImage)},Backdrop.prototype.cancelAnimation=function(){var elem=this.elem;elem&&(elem.classList.remove("backdropImageFadeIn"),this.elem=null)},Backdrop.prototype.destroy=function(){this.isDestroyed=!0,this.cancelAnimation(),this.removePreviousBackdropImage()};var rotationInterval,standardWidths=[480,720,1280,1440,1920];function getBackdropMaxWidth(){var width=dom.getWindowSize().innerWidth;if(standardWidths.includes(width))return width;width=100*Math.floor(width/100);return Math.min(width,1920)}function getImageUrls(items,imageOptions){for(var list=[],i=0,length=items.length;i<length;i++)for(var itemImages=function(item,imageOptions){imageOptions=imageOptions||{};var apiClient=connectionManager.getApiClient(item);return item.BackdropImageTags&&0<item.BackdropImageTags.length?item.BackdropImageTags.map(function(imgTag,index){return apiClient.getImageUrl(item.BackdropItemId||item.Id,Object.assign(imageOptions,{type:"Backdrop",tag:imgTag,maxWidth:getBackdropMaxWidth(),index:index}))}):item.ParentBackdropItemId&&item.ParentBackdropImageTags&&item.ParentBackdropImageTags.length?item.ParentBackdropImageTags.map(function(imgTag,index){return apiClient.getImageUrl(item.ParentBackdropItemId,Object.assign(imageOptions,{type:"Backdrop",tag:imgTag,maxWidth:getBackdropMaxWidth(),index:index}))}):[]}(items[i],imageOptions),j=0,numImages=itemImages.length;j<numImages;j++)list.push(itemImages[j]);return list}var animationEnabledByCaller,currentRotatingImages=[],currentRotationIndex=-1;function onRotationInterval(){var newIndex;playbackManager.isPlayingLocally(["Video","Game","Book"])||((newIndex=currentRotationIndex+1)>=currentRotatingImages.length&&(newIndex=0),setBackdropImage(currentRotatingImages[currentRotationIndex=newIndex],animationEnabledByCaller),animationEnabledByCaller=!0)}function clearRotation(){rotationInterval&&clearInterval(rotationInterval),rotationInterval=null,currentRotatingImages=[],currentRotationIndex=-1}return{getImageUrls:getImageUrls,setBackdrops:function(items,imageOptions,enableImageRotation,enableAnimation){var images=getImageUrls(items,imageOptions);images.length?function(images,enableImageRotation,enableAnimation){if(function(a,b){if(a===b)return 1;if(null!=a&&null!=b&&a.length===b.length){for(var i=0;i<a.length;++i)if(a[i]!==b[i])return;return 1}}(images,currentRotatingImages))return;clearRotation(),animationEnabledByCaller=!(currentRotationIndex=-1)!==enableAnimation,1<(currentRotatingImages=images).length&&!1!==enableImageRotation&&enableRotation()&&(rotationInterval=setInterval(onRotationInterval,24e3));onRotationInterval()}(images,enableImageRotation,enableAnimation):clearBackdrop()},setBackdrop:function(url,imageOptions){url&&"string"!=typeof url&&(url=getImageUrls([url],imageOptions)[0]),url?(clearRotation(),setBackdropImage(url,!0)):clearBackdrop()},clear:clearBackdrop,externalBackdrop:function(enabled){hasExternalBackdrop=enabled,setBackgroundContainerBackgroundEnabled()},hasBackdrop:function(){return null!=currentLoadingBackdrop},getCurrentUrl:function(){return currentLoadingBackdrop?currentLoadingBackdrop.url:null}}});