define(["connectionManager","confirm","dialog","appRouter","globalize"],function(connectionManager,confirm,dialog,appRouter,globalize){"use strict";function onItemDeleted(options,serverId,parentId){"back"===options.navigate?appRouter.back():options.navigate&&(parentId?appRouter.showItem(parentId,serverId):appRouter.goHome())}function deleteItemInternal(item,apiClient,options){var itemId=item.Id;return apiClient.getDeleteInfo(itemId).then(function(deleteInfo){var msg;return deleteInfo.Paths.length?(msg=globalize.translate("ConfirmDeleteItem"),msg+="\n\n"+globalize.translate("FollowingFilesWillBeDeleted")+"\n"+deleteInfo.Paths.join("\n"),msg+="\n\n"+globalize.translate("AreYouSureToContinue")):msg=globalize.translate("DeleteItemConfirmation",item.Name),confirm({title:globalize.translate("HeaderDeleteItem"),text:msg,confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){var parentId=item.SeasonId||item.SeriesId||item.ParentId,serverId=item.ServerId;return apiClient.deleteItem(item).then(function(){return onItemDeleted(options,serverId,parentId)},function(err){function result(){return Promise.reject(err)}var options;return options=globalize.translate("ErrorDeletingItem"),new Promise(function(resolve,reject){require(["alert"],function(alert){alert(options).then(resolve,resolve)})}).then(result,result)})})})}return{deleteItem:function(options){var item=options.item,apiClient=connectionManager.getApiClient(item);return"Device"===item.Type?function(item,apiClient,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("DeleteDeviceConfirmation"),title:globalize.translate("HeaderDeleteDevice"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.ajax({type:"DELETE",url:apiClient.getUrl("Devices",{Id:item.Id})}).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"Server"===item.Type?function(item,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("DeleteServerConfirmation",item.Name),title:globalize.translate("HeaderDeleteServer"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return connectionManager.deleteServer(item.Id).then(function(){return onItemDeleted(options)})})})}(item,options):"User"===item.Type?function(item,apiClient,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("DeleteUserConfirmation",item.Name),title:globalize.translate("HeaderDeleteUser"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteUser(item.Id).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"LiveTVTunerDevice"===item.Type?function(item,apiClient,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({title:globalize.translate("HeaderDeleteDevice"),text:globalize.translate("MessageConfirmDeleteTunerDevice"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.ajax({type:"DELETE",url:apiClient.getUrl("LiveTv/TunerHosts",{Id:item.Id})}).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"LiveTVGuideSource"===item.Type?function(item,apiClient,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({title:globalize.translate("HeaderDeleteProvider"),text:globalize.translate("MessageConfirmDeleteGuideProvider"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.ajax({type:"DELETE",url:apiClient.getUrl("LiveTv/ListingProviders",{Id:item.Id})}).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"ItemImage"===item.Type?function(item,apiClient){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("ConfirmDeleteImage"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteItemImage(item.Id,item.ImageType,item.ImageIndex)})})}(item,apiClient):"MediaStream"===item.Type&&"Subtitle"===item.StreamType?function(item,apiClient,options){var msg=globalize.translate("MessageAreYouSureDeleteSubtitles");return require(["confirm"],function(confirm){confirm({title:globalize.translate("ConfirmDeletion"),text:msg,confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){var url="Videos/"+item.ItemId+"/Subtitles/"+item.Index;return apiClient.ajax({type:"DELETE",url:apiClient.getUrl(url)}).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"Plugin"===item.Type?function(item,apiClient,options){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("UninstallPluginConfirmation"),title:globalize.translate("HeaderUninstallPlugin"),confirmText:globalize.translate("Uninstall"),primary:"cancel"}).then(function(){return apiClient.uninstallPlugin(item.Id).then(function(){return onItemDeleted(options)})})})}(item,apiClient,options):"ApiKey"===item.Type?function(item){return require(["confirm"]).then(function(responses){return(0,responses[0])({text:globalize.translate("MessageConfirmRevokeApiKey"),title:globalize.translate("HeaderConfirmRevokeApiKey"),confirmText:globalize.translate("Delete"),primary:"cancel"}).then(function(){var apiClient=connectionManager.getApiClient(item);return apiClient.ajax({type:"DELETE",url:apiClient.getUrl("Auth/Keys/"+item.AccessToken)})})})}(item):("VirtualFolder"===item.Type?function(virtualFolder,apiClient,options){var msg=globalize.translate("MessageAreYouSureYouWishToRemoveMediaFolder");return virtualFolder.Locations.length&&(msg+="<br/><br/>"+globalize.translate("MessageTheFollowingLocationWillBeRemovedFromLibrary")+"<br/><br/>",msg+=virtualFolder.Locations.join("<br/>")),require(["confirm"]).then(function(responses){return(0,responses[0])(msg,globalize.translate("HeaderRemoveMediaFolder")).then(function(){var refreshAfterChange="true"===options.positionTo.closest(".page").getAttribute("data-refreshlibrary");return apiClient.removeVirtualFolder(virtualFolder,refreshAfterChange)})})}:"Series"===item.Type&&apiClient.isMinServerVersion("4.5.0.3")?function(item,apiClient,options){return apiClient.getEpisodes(item.Id,{Limit:1,SortBy:"DatePlayed",SortOrder:"Descending",IsPlayed:!0,UserId:apiClient.getCurrentUserId(),ExcludeLocationTypes:"Virtual"}).then(function(result){return result.Items.length?dialog({title:globalize.translate("HeaderDeleteSeries"),text:"",buttons:[{name:globalize.translate("Cancel"),id:"cancel",type:"submit"},{name:globalize.translate("HeaderDeleteLastPlayedEpisode"),id:"deletelastplayed",type:"cancel"},{name:globalize.translate("HeaderDeleteSeries"),id:"deleteseries",type:"cancel"}]}).then(function(id){return"deleteseries"===id?deleteItemInternal(item,apiClient,options):"deletelastplayed"===id?deleteItemInternal(result.Items[0],apiClient,options):Promise.reject()}):deleteItemInternal(item,apiClient,options)})}:deleteItemInternal)(item,apiClient,options)}}});