define(["globalize","itemHelper","itemShortcuts","inputManager","connectionManager","playbackManager","imageLoader","layoutManager","browser","dom","loading","focusManager","serverNotifications","events","cardBuilder","virtual-scroller"],function(globalize,itemHelper,itemShortcuts,inputManager,connectionManager,playbackManager,imageLoader,layoutManager,browser,dom,loading,focusManager,serverNotifications,events,cardBuilder){"use strict";var MultiSelect,nativeContextMenuEventSupported,touchTarget;function onClick(e){var multiSelect=this.multiSelect;multiSelect&&!1===multiSelect.onContainerClick.call(this,e)||itemShortcuts.onClick.call(this,e)}function onChange(e){itemShortcuts.onClick.call(this,e)}function onContextMenu(e){var detail;this._touchEventsBound&&((detail=e.detail)&&detail.customEvent||(this._touchEventsBound=null,nativeContextMenuEventSupported=!0,dom.removeEventListener(this,"touchstart",onTouchStart,{passive:!0}),dom.removeEventListener(this,"touchend",onTouchEnd,{}),dom.removeEventListener(this,"touchcancel",onTouchEnd,{}),dom.removeEventListener(this,"touchmove",onTouchMove,{passive:!0})));var target=e.target,card=itemShortcuts.getItemElementFromChildNode(target,!0);if(card&&(!this.classList.contains("multi-select-active")&&inputManager.trigger("menu",{sourceElement:card})))return e.preventDefault(),!1}function onChannelManagementInfoUpdated(e,apiClient,data){var id,index,item=data.Channel;item?(id=data.Id,-1!==(index=this.indexOfItemId(id))&&this.onItemUpdated(index,item)):getEventsToMonitor(this).includes("ChannelManagementInfoUpdated")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onUserDataChanged(e,apiClient,userData,data){var listItemOptions,index,item,eventsToMonitor,listOptions=this.currentListOptions;!listOptions||(listItemOptions=listOptions.options)&&listItemOptions.enableUserData&&(-1===(index=this.indexOfItemId(userData.ItemId))||(item=this.getItem(index))&&(item.UserData=userData,this.onItemUpdated(index,item)),((eventsToMonitor=getEventsToMonitor(this)).includes("markfavorite")||eventsToMonitor.includes("markplayed"))&&this.notifyRefreshNeeded(data.IsLocalEvent))}function getEventsToMonitor(itemsContainer){var monitor=itemsContainer.getAttribute("data-monitor");return monitor?monitor.split(","):[]}function onTimerCreated(e,apiClient,data){var index,item,programId=data.ProgramId,newTimerId=data.Id;newTimerId&&(-1===(index=this.indexOfItemId(programId))||(item=this.getItem(index))&&(item.TimerId=newTimerId,this.onItemUpdated(index,item))),getEventsToMonitor(this).includes("Timers")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onTimerCancelled(e,apiClient,data){data.Id;var index,item,programId=data.ProgramId;programId&&(-1===(index=this.indexOfItemId(programId))||(item=this.getItem(index))&&(item.TimerId=null,this.onItemUpdated(index,item))),getEventsToMonitor(this).includes("Timers")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onSeriesTimerCreated(e,apiClient,data){getEventsToMonitor(this).includes("SeriesTimers")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onSeriesTimerCancelled(e,apiClient,data){data.Id;getEventsToMonitor(this).includes("SeriesTimers")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onItemsRemovedFromCollection(e,apiClient,data){data.CollectionId===this.monitorCollectionId&&getEventsToMonitor(this).includes("CollectionItems")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onItemsRemovedFromPlaylist(e,apiClient,data){data.PlaylistId===this.monitorPlaylistId&&getEventsToMonitor(this).includes("PlaylistItems")&&this.notifyRefreshNeeded(data.IsLocalEvent)}function onRecordingStarted(e,apiClient,data){getEventsToMonitor(this).includes("RecordingStarted")&&this.notifyRefreshNeeded(!0)}function onRecordingEnded(e,apiClient,data){getEventsToMonitor(this).includes("RecordingEnded")&&this.notifyRefreshNeeded(!0)}function onLibraryChanged(e,apiClient,data){var eventsToMonitor=getEventsToMonitor(this);if(!eventsToMonitor.includes("SeriesTimers")&&!eventsToMonitor.includes("Timers")){var array2,i,length,itemsAdded=data.ItemsAdded||[],itemsRemoved=data.ItemsRemoved||[],itemsUpdated=data.ItemsUpdated||[],monitorItems=this.monitorItems;if(monitorItems&&(array2=monitorItems,itemsUpdated.some(function(r){return array2.includes(r)})))this.notifyRefreshNeeded(data.IsLocalEvent);else{if(this.refreshOnItemUpdated)for(i=0,length=itemsUpdated.length;i<length;i++){var updateditemId=itemsUpdated[i];if(-1!==this.indexOfItemId(updateditemId))return void this.notifyRefreshNeeded(data.IsLocalEvent)}if(itemsAdded.length||itemsRemoved.length){for(i=0,length=itemsRemoved.length;i<length;i++){var removedItemId=itemsRemoved[i];if(-1!==this.indexOfItemId(removedItemId))return void this.notifyRefreshNeeded(data.IsLocalEvent)}var parentId=this.getAttribute("data-parentid");if(parentId){var foldersAddedTo=data.FoldersAddedTo||[],foldersRemovedFrom=data.FoldersRemovedFrom||[],collectionFolders=data.CollectionFolders||[];if(!foldersAddedTo.includes(parentId)&&!foldersRemovedFrom.includes(parentId)&&!collectionFolders.includes(parentId))return}this.notifyRefreshNeeded(data.IsLocalEvent)}}}}function onPlaybackStopped(e,stopInfo){var state=stopInfo.state,eventsToMonitor=getEventsToMonitor(this);if(state.NowPlayingItem&&"Video"===state.NowPlayingItem.MediaType){if(eventsToMonitor.includes("videoplayback"))return void this.notifyRefreshNeeded(!0)}else if(state.NowPlayingItem&&"Audio"===state.NowPlayingItem.MediaType&&eventsToMonitor.includes("audioplayback"))return void this.notifyRefreshNeeded(!0)}function addNotificationEvent(instance,name,handler,owner){var localHandler=handler.bind(instance);owner=owner||serverNotifications,events.on(owner,name,localHandler),instance["event_"+name]=localHandler}function removeNotificationEvent(instance,name,owner){var handler=instance["event_"+name];handler&&(owner=owner||serverNotifications,events.off(owner,name,handler),instance["event_"+name]=null)}function onInit(){this.hasInit||(this.hasInit=!0,this.classList.add("itemsContainer"))}function getTouches(e){return e.changedTouches||e.targetTouches||e.touches}function clearTouchStartTimeout(elem){elem.touchStartTimeout&&(clearTimeout(elem.touchStartTimeout),elem.touchStartTimeout=null,elem.touchStartTimeoutTime=null)}function clearTouchTarget(container){touchTarget&&(touchTarget=null,dom.removeEventListener(container,"touchmove",onTouchMove,{passive:!0}))}function onTouchStart(e){var element,card,touch=getTouches(e)[0];clearTouchTarget(this),this.touchStartX=0,this.touchStartY=0,touch&&(this.touchStartX=touch.clientX,this.touchStartY=touch.clientY,!(element=touch.target)||(card=element.closest(".card,.listItem"))&&(clearTouchStartTimeout(this),dom.addEventListener(this,"touchmove",onTouchMove,{passive:!0}),touchTarget=card,this.touchStartTimeout=setTimeout(onTouchStartTimerFired,550),this.touchStartTimeoutTime=Date.now()))}function onTouchMove(e){var touch,touchEndX,touchEndY,deltaX,deltaY;touchTarget&&(deltaY=(touch=getTouches(e)[0])?(touchEndX=touch.clientX||0,touchEndY=touch.clientY||0,deltaX=Math.abs(touchEndX-(this.touchStartX||0)),Math.abs(touchEndY-(this.touchStartY||0))):deltaX=100,(5<=deltaX||5<=deltaY)&&(clearTouchStartTimeout(this),clearTouchTarget(this)))}function onTouchEnd(e){var time;!getTouches(e)[0]||(time=this.touchStartTimeoutTime)&&500<=(time=Date.now()-time)&&e.preventDefault(),clearTouchStartTimeout(this),clearTouchTarget(this)}function onTouchStartTimerFired(){var card=touchTarget;card&&(focusManager.focus(card),card.dispatchEvent(new CustomEvent("contextmenu",{bubbles:!0,cancelable:!0,detail:{customEvent:!0}})))}function onDroppedOntoFullTarget(itemsContainer,draggedElement,dropTarget,item){var apiClient,droppedTargetItem=itemShortcuts.getItemFromChildNode(dropTarget),droppedItemType=droppedTargetItem.Type,droppedItemId=droppedTargetItem.Id,droppedItemServerId=droppedTargetItem.ServerId;droppedItemId&&droppedItemServerId&&(apiClient=connectionManager.getApiClient(droppedTargetItem),"Playlist"!==droppedItemType&&"BoxSet"!==droppedItemType||function(apiClient,list,ids){loading.show();var apiName="BoxSet"===list.Type?"Collections":"Playlists",url=apiClient.getUrl(apiName+"/"+list.Id+"/Items",{Ids:ids,userId:apiClient.getCurrentUserId()});apiClient.ajax({type:"POST",url:url}).then(function(){loading.hide()})}(apiClient,{Id:droppedItemId,ServerId:droppedItemServerId,Type:droppedItemType},[item.Id]))}function onReorderedTo(itemsContainer,item,draggedElement,currentIndex,dropTarget,directionUp){var newIndex;if(draggedElement.classList.contains("virtualScrollItem")?(newIndex=itemsContainer.indexOfElement(dropTarget),directionUp||newIndex++,currentIndex<newIndex&&newIndex--):(itemsContainer.insertBefore(draggedElement,directionUp?dropTarget:dropTarget.nextSibling),newIndex=Array.prototype.indexOf.call(itemsContainer.children,draggedElement)),newIndex!==currentIndex){if("ItemImage"===item.Type)return function(item,newIndex){var apiClient=connectionManager.getApiClient(item);function onDone(){loading.hide()}return loading.show(),apiClient.updateItemImageIndex(item.Id,item.ImageType,item.ImageIndex,newIndex).then(onDone,function(){return loading.hide(),require(["alert"]).then(function(responses){return(0,responses[0])(globalize.translate("DefaultErrorMessage")).then(onDone,onDone)})})}(item,newIndex);if("ChannelManagementInfo"===item.Type)return function(item,newIndex){var apiClient=connectionManager.getApiClient(item);function onDone(){loading.hide()}return loading.show(),apiClient.setChannelSortIndex(item,newIndex).then(onDone,function(){return loading.hide(),require(["alert"]).then(function(responses){return(0,responses[0])(globalize.translate("DefaultErrorMessage")).then(onDone,onDone)})})}(item,newIndex);var playlistId=item.PlaylistId;if(playlistId)return function(item,itemsContainer,newIndex,playlistId){var apiClient=connectionManager.getApiClient(item),playlistItemId=item.PlaylistItemId;loading.show(),apiClient.ajax({url:apiClient.getUrl("Playlists/"+playlistId+"/Items/"+playlistItemId+"/Move/"+newIndex),type:"POST"}).then(function(){loading.hide()},function(){loading.hide(),itemsContainer.refreshItems()})}(item,itemsContainer,newIndex,playlistId),0;draggedElement.dispatchEvent(new CustomEvent("itemdrop",{detail:{newIndex:newIndex,playlistItemId:item.PlaylistItemId},bubbles:!0,cancelable:!1}))}}function abortRequests(instance){var currentAbortController=instance.currentAbortController;currentAbortController&&(currentAbortController.abort(),instance.currentAbortController=null)}function onGetItemsFailed(){}function clearRefreshInterval(itemsContainer,isPausing){itemsContainer.refreshInterval&&(clearInterval(itemsContainer.refreshInterval),itemsContainer.refreshInterval=null,isPausing||(itemsContainer.refreshIntervalEndTime=null))}function resetRefreshInterval(itemsContainer,intervalMs){clearRefreshInterval(itemsContainer),(intervalMs=intervalMs||parseInt(itemsContainer.getAttribute("data-refreshinterval")||"0"))&&(itemsContainer.refreshInterval=setInterval(itemsContainer.notifyRefreshNeeded.bind(itemsContainer),intervalMs),itemsContainer.refreshIntervalEndTime=Date.now()+intervalMs)}function updateVirtualElement(child,item,index){for(var chkItemSelect,listOptions=this.currentListOptions,listItemOptions=listOptions.options,renderer=listOptions.renderer,allItemParts=this.itemParts,itemParts=allItemParts[index]||(allItemParts[index]=renderer.getItemParts(item,index,listItemOptions)),attributes=itemParts.attributes,i=0,length=attributes.length;i<length;i++){var att=attributes[i];child.setAttribute(att.name,att.value)}child.innerHTML=itemParts.html,MultiSelect&&MultiSelect.isSelected(item)&&((chkItemSelect=child.querySelector(".chkItemSelect"))&&(chkItemSelect.checked=!0,child.querySelector(".cardBox,.chkListItemSelectContainer").classList.add("item-multiselected")));var onUpdateElement=this.onUpdateElement;this.onUpdateElement&&onUpdateElement(child,item,index)}function getVirtualChunkSize(elem,listOptions){var size=elem.virtualChunkSize;if(size)return size;!listOptions&&elem.getListOptions&&(listOptions=elem.getListOptions([]));var layout=listOptions?listOptions.virtualScrollLayout:elem.getAttribute("data-virtualscrolllayout");if(layout){if(layout.includes("horizontal"))return 12;var renderer=listOptions?listOptions.renderer:null;return renderer&&renderer!==cardBuilder?30:50}return null}function onDataFetched(result){var items=result.Items||result;null!=result.TotalRecordCount&&this.maxTotalRecordCount&&(result.TotalRecordCount=Math.min(result.TotalRecordCount,this.maxTotalRecordCount));var sectionSeeAllButton,parentContainer=this.parentContainer;parentContainer&&(items.length?((sectionSeeAllButton=parentContainer.querySelector(".sectionSeeAllButton"))&&(8<=items.length||"true"===this.getAttribute("data-alwaysshowseeall")?sectionSeeAllButton.classList.remove("hide"):sectionSeeAllButton.classList.add("hide")),parentContainer.classList.remove("hide")):parentContainer.classList.add("hide"));var focusId,hasActiveElement,scrollPosition,focusIndexElement,focusedItem,scroller,focusIndex,activeElement=document.activeElement;this.contains(activeElement)&&(hasActiveElement=!0,focusIndexElement=itemShortcuts.getItemElementFromChildNode(activeElement,!0),null==(focusIndex=focusIndexElement?this.indexOfElement(focusIndexElement):null)||(focusedItem=this.getItem(focusIndex))&&(focusId=focusedItem.Id),focusId=focusId||activeElement.getAttribute("data-id"),layoutManager.tv||(scroller=this.virtualScroller?this.closest(".emby-scroller"):null)&&(scrollPosition=scroller.getScrollPosition()));var instance,delay=0,listOptions=this.getListOptions?this.getListOptions(items):null;this.setListClasses&&(instance=this,listOptions.renderer===cardBuilder?(instance.classList.add("vertical-wrap"),instance.classList.remove("vertical-list")):(instance.classList.remove("vertical-wrap"),instance.classList.add("vertical-list")));var listItemOptions=listOptions?listOptions.options:null,itemParts=[];itemParts.length=result.TotalRecordCount||items.length,this.itemParts=itemParts,this._addOnChangeListener&&!this._onChangeListenerBound&&(this._onChangeListenerBound=!0,this.addEventListener("change",onChange));var virtualScroller,scrollResizeObserver,minItemsForVirtualRendering=this.onUpdateElement?0:8;return(items.length>=minItemsForVirtualRendering||items.length<(result.TotalRecordCount||0))&&this.hasAttribute("data-virtualscrolllayout")?(this.classList.add("virtualItemsContainer"),listOptions&&(listOptions.virtualScrollLayout.includes("horizontal")&&(listOptions.options.horizontal=!0),listOptions.options.isVirtualList=!0,listOptions.options.lazy=2,listOptions.renderer.setListOptions(items,listOptions.options)),(virtualScroller=this.virtualScroller)&&listOptions.enableScrollReuse&&virtualScroller.templateInnerHTML===listOptions.options.templateInnerHTML||(this.currentListOptions=listOptions,scrollResizeObserver=this.scrollResizeObserver?' data-scrollresizeobserver="true"':"",this.innerHTML='<div is="virtual-scroller" class="flex-grow virtualScroller" layout="'+listOptions.virtualScrollLayout+'" '+scrollResizeObserver+"></div>",(virtualScroller=this.querySelector(".virtualScroller")).virtualChunkSize=getVirtualChunkSize(this,listOptions),virtualScroller.templateInnerHTML=listItemOptions.templateInnerHTML,virtualScroller.templateHTML="<"+listItemOptions.tagName+' class="virtualScrollItem '+listItemOptions.className+'" '+listItemOptions.fixedAttributes+">"+listItemOptions.templateInnerHTML+"</"+listItemOptions.tagName+">",virtualScroller.getItems=this.fetchData.bind(this),this.virtualScroller=virtualScroller,function(instance,renderer){renderer===cardBuilder||instance.virtualScroller&&instance.virtualScroller.classList.add("virtual-scroller-overflowvisible")}(this,listOptions.renderer),virtualScroller.updateElement=updateVirtualElement.bind(this),virtualScroller.onRecycleElement=this.onRecycleElement,virtualScroller.onElementCreated=function(elem){addDragEventsToDropTarget(elem)}.bind(this)),this.items=null,delay=virtualScroller.setItemSource?(virtualScroller.setItemSource(items,result.TotalRecordCount),50):(dom.addEventListener(virtualScroller,"upgraded",function(e){var items=this.Items||this;e.currentTarget.setItemSource(items,this.TotalRecordCount)}.bind(result),{once:!0}),100)):(this.classList.remove("virtualItemsContainer"),(this.currentListOptions=listOptions)?(listOptions.options.horizontal=null,listOptions.options.isVirtualList=null,this.innerHTML=listOptions.renderer.getItemsHtml(items,listOptions.options)):this.innerHTML=this.getItemsHtml(items),this.virtualScroller=null,this.items=items,imageLoader.lazyChildren(this),function(itemsContainer){for(var items=itemsContainer.querySelectorAll(".drop-target,*[draggable]"),i=0,length=items.length;i<length;i++){addDragEventsToDropTarget(items[i])}}(this)),this.enableContextMenu(listItemOptions&&listItemOptions.contextMenu),this.enableMultiSelect(listItemOptions&&listItemOptions.multiSelect),(delay?function(delay){return new Promise(function(resolve,reject){setTimeout(resolve,delay)})}(delay):Promise.resolve()).then(function(){hasActiveElement&&(null!=scrollPosition?this.closest(".emby-scroller").scrollToPosition({position:scrollPosition,behavior:"instant"}):function(itemsContainer,focusId,focusIndex){if(focusId){var newIndex=itemsContainer.indexOfItemId(focusId);if(-1!==newIndex)return itemsContainer.scrollToIndex(newIndex,{},!0)}if(null!=focusIndex)return itemsContainer.scrollToIndex(parseInt(focusIndex),{},!0);{var view;layoutManager.tv&&(focusManager.autoFocus(itemsContainer)||(view=itemsContainer.closest(".focuscontainer,.view"))&&focusManager.autoFocus(view))}}(this,focusId,focusIndex)),resetRefreshInterval(this),this.afterRefresh&&this.afterRefresh(result)}.bind(this))}function onItemDragStart(e){var draggableElement=e.target;draggableElement.classList.add("dragging"),e.dataTransfer.effectAllowed="copy";var itemsContainer=draggableElement.closest(".itemsContainer");window.CurrentDragInfo={element:draggableElement,elementIndex:itemsContainer.indexOfElement(draggableElement),item:itemShortcuts.getItemFromChildNode(draggableElement)},draggableElement.classList.contains("ordered-drop-target-y")&&document.documentElement.classList.add("drag-reorder-y-active","drag-active")}function onItemDragEnd(e){e.target.classList.remove("dragging"),e.preventDefault(),window.CurrentDragInfo=null,document.documentElement.classList.remove("drag-reorder-y-active","drag-active")}function supportsAddingToCollection(item){var user=connectionManager.getApiClient(item).getCurrentUserCached();return user&&itemHelper.supportsAddingToCollection(item,user)}function onItemDragEnter(e){if(!this.classList.contains("full-drop-target"))return onItemDragOver.call(this,e);var listType,data=window.CurrentDragInfo,item=data?data.item:null;!item||("Playlist"===(listType=itemShortcuts.getItemFromChildNode(this).Type)&&itemHelper.supportsAddingToPlaylist(item)||"BoxSet"===listType&&supportsAddingToCollection(item))&&(e.preventDefault(),this.classList.add("dragging-over"),this.dragCounter=(this.dragCounter||0)+1)}function onItemDragOver(e){var elem,classList,rect,data=window.CurrentDragInfo,draggingElement=data?data.element:null;if(this.classList.contains("full-drop-target")){var listType,item=data?data.item:null;!item||("Playlist"===(listType=itemShortcuts.getItemFromChildNode(this).Type)&&itemHelper.supportsAddingToPlaylist(item)||"BoxSet"===listType&&supportsAddingToCollection(item))&&(e.preventDefault(),e.dataTransfer.dropEffect="copy")}else if(this.classList.contains("ordered-drop-target-x")&&draggingElement.classList.contains("ordered-drop-target-x")){if(e.preventDefault(),e.dataTransfer.dropEffect="copy",!(elem=(elem=e.target).closest(".drop-target")))return;classList=elem.classList;var maxXForLeft=(rect=elem.getBoundingClientRect()).x+rect.width/2;e.clientX<=maxXForLeft?(classList.remove("dragging-over-right"),classList.add("dragging-over","dragging-over-left")):(classList.remove("dragging-over-left"),classList.add("dragging-over","dragging-over-right"))}else if(this.classList.contains("ordered-drop-target-y")&&draggingElement.classList.contains("ordered-drop-target-y")){if(e.preventDefault(),e.dataTransfer.dropEffect="copy",!(elem=(elem=e.target).closest(".drop-target")))return;classList=elem.classList;var maxYForTop=(rect=elem.getBoundingClientRect()).y+rect.height/2;e.clientY<=maxYForTop?(classList.remove("dragging-over-bottom"),classList.add("dragging-over","dragging-over-top")):(classList.remove("dragging-over-top"),classList.add("dragging-over","dragging-over-bottom"))}}function onItemDragLeave(e){var listType,data=window.CurrentDragInfo,item=data?data.item:null;item&&(this.classList.contains("full-drop-target")?("Playlist"===(listType=itemShortcuts.getItemFromChildNode(this).Type)&&itemHelper.supportsAddingToPlaylist(item)||"BoxSet"===listType&&supportsAddingToCollection(item))&&(e.preventDefault(),this.dragCounter--,(this.dragCounter<=0||browser.firefox)&&(this.classList.remove("dragging-over"),this.dragCounter=0)):this.classList.contains("ordered-drop-target-x")?(e.preventDefault(),this.classList.remove("dragging-over","dragging-over-left","dragging-over-right")):this.classList.contains("ordered-drop-target-y")&&(e.preventDefault(),this.classList.remove("dragging-over","dragging-over-top","dragging-over-bottom")))}function onItemDrop(e){e.preventDefault();var dragInfo=window.CurrentDragInfo,draggedElement=dragInfo.element,draggedElementIndex=dragInfo.elementIndex,item=dragInfo.item;this.classList.remove("dragging-over","dragging-over-top","dragging-over-bottom","dragging-over-left","dragging-over-right"),this.classList.contains("full-drop-target")?onDroppedOntoFullTarget(this.closest(".itemsContainer"),0,this,item):this.classList.contains("ordered-drop-target-x")?function(e,itemsContainer,item,draggedElement,draggedElementIndex,dropTarget){var directionLeft,rect=dropTarget.getBoundingClientRect(),maxXForLeft=rect.x+rect.width/2;e.clientX<=maxXForLeft&&(directionLeft=!0),onReorderedTo(itemsContainer,item,draggedElement,draggedElementIndex,dropTarget,directionLeft)}(e,this.closest(".itemsContainer"),item,draggedElement,draggedElementIndex,this):this.classList.contains("ordered-drop-target-y")&&function(e,itemsContainer,item,draggedElement,draggedElementIndex,dropTarget){var directionUp,rect=dropTarget.getBoundingClientRect(),maxYForTop=rect.y+rect.height/2;e.clientY<=maxYForTop&&(directionUp=!0),onReorderedTo(itemsContainer,item,draggedElement,draggedElementIndex,dropTarget,directionUp)}(e,this.closest(".itemsContainer"),item,draggedElement,draggedElementIndex,this),this.dragCounter=0}function addDragEventsToDropTarget(elem){elem.addEventListener("dragstart",onItemDragStart),elem.addEventListener("dragend",onItemDragEnd),elem.addEventListener("dragenter",onItemDragEnter),elem.addEventListener("dragover",onItemDragOver),elem.addEventListener("dragleave",onItemDragLeave),elem.addEventListener("drop",onItemDrop)}var EmbyItemsContainer=function(_HTMLDivElement){babelHelpers.inherits(EmbyItemsContainer,_HTMLDivElement);var _super=_createSuper(EmbyItemsContainer);function EmbyItemsContainer(){var _this;babelHelpers.classCallCheck(this,EmbyItemsContainer);var self=_this=_super.call(this);return onInit.call(self),babelHelpers.possibleConstructorReturn(_this,self)}return babelHelpers.createClass(EmbyItemsContainer,[{key:"connectedCallback",value:function(){onInit.call(this),this.addEventListener("click",onClick),layoutManager.tv&&this.classList.add("itemsContainer-tv"),itemShortcuts.on(this,{click:!1}),addNotificationEvent(this,"UserDataChanged",onUserDataChanged),addNotificationEvent(this,"TimerCreated",onTimerCreated),addNotificationEvent(this,"SeriesTimerCreated",onSeriesTimerCreated),addNotificationEvent(this,"TimerCancelled",onTimerCancelled),addNotificationEvent(this,"SeriesTimerCancelled",onSeriesTimerCancelled),addNotificationEvent(this,"LibraryChanged",onLibraryChanged),addNotificationEvent(this,"ItemsRemovedFromCollection",onItemsRemovedFromCollection),addNotificationEvent(this,"ItemsRemovedFromPlaylist",onItemsRemovedFromPlaylist),addNotificationEvent(this,"RecordingStarted",onRecordingStarted),addNotificationEvent(this,"RecordingEnded",onRecordingEnded),addNotificationEvent(this,"ChannelManagementInfoUpdated",onChannelManagementInfoUpdated),addNotificationEvent(this,"playbackstop",onPlaybackStopped,playbackManager),!layoutManager.tv&&"ontouchstart"in document&&require(["dragDropTouch"]),this.hasAttribute("data-contextmenu")&&this.enableContextMenu(!0),this.hasAttribute("data-multiselect")&&this.enableMultiSelect(!0),this.dispatchEvent(new CustomEvent("upgraded",{cancelable:!1}))}},{key:"disconnectedCallback",value:function(){clearRefreshInterval(this),abortRequests(this),this.enableMultiSelect(!1),this.removeEventListener("click",onClick),this.removeEventListener("change",onChange),this.removeEventListener("contextmenu",onContextMenu,!0),itemShortcuts.off(this,{click:!1}),removeNotificationEvent(this,"UserDataChanged"),removeNotificationEvent(this,"TimerCreated"),removeNotificationEvent(this,"SeriesTimerCreated"),removeNotificationEvent(this,"TimerCancelled"),removeNotificationEvent(this,"SeriesTimerCancelled"),removeNotificationEvent(this,"LibraryChanged"),removeNotificationEvent(this,"ItemsRemovedFromCollection"),removeNotificationEvent(this,"ItemsRemovedFromPlaylist"),removeNotificationEvent(this,"RecordingStarted"),removeNotificationEvent(this,"RecordingEnded"),removeNotificationEvent(this,"ChannelManagementInfoUpdated"),removeNotificationEvent(this,"playbackstop",playbackManager),this.fetchData=null,this.getItemsHtml=null,this.parentContainer=null,this.virtualScroller=null,this.currentListOptions=null,this.itemParts=null,this.items=null,this._touchEventsBound=null,this._contextMenuEventsBound=!0}},{key:"pause",value:function(){clearRefreshInterval(this,!0),this.paused=!0;var virtualScroller=this.virtualScroller;virtualScroller&&virtualScroller.pause()}},{key:"resume",value:function(options){this.paused=!1;var remainingMs,refreshIntervalEndTime=this.refreshIntervalEndTime;refreshIntervalEndTime&&(0<(remainingMs=refreshIntervalEndTime-Date.now())&&!this.needsRefresh?resetRefreshInterval(this,remainingMs):(this.needsRefresh=!0,this.refreshIntervalEndTime=null));var virtualScroller=this.virtualScroller;return virtualScroller&&virtualScroller.resume(),this.needsRefresh||options&&options.refresh?this.refreshItems():Promise.resolve()}},{key:"getItemFromElement",value:function(element){var virtualScroller=this.virtualScroller;if(virtualScroller)return virtualScroller.getItemFromElement(element);var index=this.indexOfElement(element);if(0<=index){var elem=this.getItem(index);if(elem)return elem}return null}},{key:"getItem",value:function(index){var scroller=this.virtualScroller;if(scroller)return scroller.getItem(index);var items=this.items;return items?items[index]:null}},{key:"refreshItems",value:function(){if(!this.fetchData)return Promise.resolve();if(this.paused)return this.needsRefresh=!0,Promise.resolve();this.needsRefresh=!1,abortRequests(this);var abortController=new AbortController;this.currentAbortController=abortController;var query={},limit=getVirtualChunkSize(this);return limit&&(query.Limit=limit),this.fetchData(query,abortController.signal).then(onDataFetched.bind(this),onGetItemsFailed)}},{key:"notifyRefreshNeeded",value:function(isInForeground){var timeout;this.paused?this.needsRefresh=!0:((timeout=this.refreshTimeout)&&clearTimeout(timeout),!0===isInForeground?this.refreshItems():this.refreshTimeout=setTimeout(this.refreshItems.bind(this),1e4))}},{key:"showMultiSelect",value:function(childElement,selected){var card=itemShortcuts.getItemElementFromChildNode(childElement,!0);this.multiSelect.showSelections(card,selected)}},{key:"enableMultiSelect",value:function(enabled){var self,current=this.multiSelect;enabled?current||(self=this,require(["multiSelect"],function(multiSelect){MultiSelect=multiSelect,self.multiSelect=new MultiSelect({container:self})})):current&&(this.multiSelect=null)}},{key:"enableContextMenu",value:function(enabled){var element;enabled&&((element=this)._contextMenuEventsBound||(element._contextMenuEventsBound=!0,element.addEventListener("contextmenu",onContextMenu,!0),layoutManager.tv||nativeContextMenuEventSupported||(browser.iOS||browser.osx)&&(element._touchEventsBound=!0,dom.addEventListener(element,"touchstart",onTouchStart,{passive:!0}),dom.addEventListener(element,"touchend",onTouchEnd,{}),dom.addEventListener(element,"touchcancel",onTouchEnd,{}))))}},{key:"getElement",value:function(index){var items=this.querySelectorAll(".card,.listItem,.epgRow");if(items.length)return items[index]}},{key:"scrollToIndex",value:function(index,scrollOptions,focus){var virtualScroller=this.virtualScroller;if(virtualScroller)return virtualScroller.scrollToIndex(index,scrollOptions,focus);var item,scroller,items=this.querySelectorAll(".card,.listItem,.epgRow");!items.length||(item=items[index]||items[items.length-1])&&(focus?focusManager.focus(item):(scroller=this.closest("[is=emby-scroller]"))&&scroller.toStart(item,scrollOptions))}},{key:"pageUp",value:function(activeElement){var currentIndex,newIndex;this.getItems()&&(activeElement=itemShortcuts.getItemElementFromChildNode(activeElement,!0)||activeElement,newIndex=-1===(currentIndex=this.indexOfElement(activeElement))?0:Math.max(0,currentIndex-12),this.scrollToIndex(newIndex,{},!0))}},{key:"pageDown",value:function(activeElement){var currentIndex,newIndex,items=this.getItems();items&&(activeElement=itemShortcuts.getItemElementFromChildNode(activeElement,!0)||activeElement,newIndex=-1===(currentIndex=this.indexOfElement(activeElement))?0:Math.min(items.length-1,currentIndex+12),this.scrollToIndex(newIndex,{},!0))}},{key:"indexOfElement",value:function(element){var virtualScroller=this.virtualScroller;return virtualScroller?virtualScroller.indexOfElement(element):parseInt(element.getAttribute("data-index")||"-1")}},{key:"indexOfItemId",value:function(id){var virtualScroller=this.virtualScroller;if(virtualScroller)return virtualScroller.indexOfItemId(id);var elem=this.querySelector('[data-id="'+id+'"]');return elem?this.indexOfElement(elem):-1}},{key:"focusLast",value:function(){var items=this.getItems();items&&this.scrollToIndex(items.length-1,{},!0)}},{key:"getItems",value:function(){var virtualScroller=this.virtualScroller;return virtualScroller?virtualScroller._itemSource:this.items}},{key:"onItemUpdated",value:function(index,item){var itemParts=this.itemParts;if(itemParts){itemParts[index]=null;var any,child,virtualScroller=this.virtualScroller;if(virtualScroller)return virtualScroller.onItemUpdated(index,item);this.items&&(any=!1,(child=this.children[index])&&(updateVirtualElement.call(this,child,item,index),any=!0),any&&imageLoader.lazyChildren(this))}}}]),EmbyItemsContainer}(babelHelpers.wrapNativeSuper(HTMLDivElement));return customElements.define("emby-itemscontainer",EmbyItemsContainer,{extends:"div"}),EmbyItemsContainer});