define(["layoutManager","browser","actionsheet","globalize","css!./emby-select"],function(layoutManager,browser,actionsheet,globalize){"use strict";function enableNativeMenu(elem){return!layoutManager.tv&&!elem.hasAttribute("multiple")&&"custom"!==elem.getAttribute("data-menu")}function showActionSheet(select){var labelElem=getLabel(select),title=labelElem?labelElem.textContent||labelElem.innerText:null,options={items:select.options,positionTo:select,title:title,hideTitleWhenNotFullscreen:!0};layoutManager.tv||(options.positionY="top",options.positionX="left",options.transformOrigin="center top",options.preventOverflow=!1,options.minWidthToElement=!0),options.multiple=select.hasAttribute("multiple"),actionsheet.show(options).then(function(value){select.setValues(value)})}function getLabel(select){for(var elem=select.previousSibling;elem&&"LABEL"!==elem.tagName;)elem=elem.previousSibling;return elem}function onFocus(e){var label=getLabel(this);label&&label.classList.add("selectLabelFocused")}function onBlur(e){var label=getLabel(this);label&&label.classList.remove("selectLabelFocused")}function onMouseDown(e){e.button||enableNativeMenu(this)||(e.preventDefault(),showActionSheet(this))}function onKeyDown(e){switch(e.keyCode){case 13:return void(enableNativeMenu(this)||(e.preventDefault(),showActionSheet(this)));case 37:case 38:case 39:case 40:return void(layoutManager.tv&&e.preventDefault())}}var inputId=0;function onInit(){this.hasInit||(this.hasInit=!0,this.id||(this.id="embyselect"+inputId,inputId++),this.classList.add("emby-select-withcolor"),layoutManager.tv&&(this.classList.add("emby-select-focusscale"),this.classList.add("emby-select-tv"),this.classList.contains("emby-select-inline")&&this.classList.add("emby-select-tv-inline")),this.addEventListener("mousedown",onMouseDown),this.addEventListener("keydown",onKeyDown),this.addEventListener("focus",onFocus),this.addEventListener("blur",onBlur))}function onItemsMutation(mutationsList){for(var i=0,length=mutationsList.length;i<length;i++){var target=mutationsList[i].target;target&&target.onItemsChanged&&target.onItemsChanged()}}var EmbySelect=function(_HTMLSelectElement){babelHelpers.inherits(EmbySelect,_HTMLSelectElement);var _super=_createSuper(EmbySelect);function EmbySelect(){var _this;babelHelpers.classCallCheck(this,EmbySelect);var self=_this=_super.call(this);return onInit.call(self),babelHelpers.possibleConstructorReturn(_this,self)}return babelHelpers.createClass(EmbySelect,[{key:"getValues",value:function(){for(var values=[],options=this.options,i=0,length=options.length;i<length;i++){var option=options[i];option.selected&&values.push(option.value)}return values}},{key:"setValues",value:function(values){if(this.hasAttribute("multiple")){for(var names=[],options=this.options,i=0,length=options.length;i<length;i++){var option=options[i];values.includes(option.value)?(option.selected=!0,names.push(option.textContent||option.innerText)):option.selected=!1}var label=this.nameLabel;label&&(label.innerHTML=names.length?names.join(" / "):globalize.translate("Any"))}else this.value=Array.isArray(values)?values[0]||"":values||"";var select,evt;select=this,(evt=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),select.dispatchEvent(evt)}},{key:"onItemsChanged",value:function(){if(this.hasAttribute("multiple")){for(var names=[],options=this.options,i=0,length=options.length;i<length;i++){var option=options[i];option.selected&&names.push(option.textContent||option.innerText)}var label=this.nameLabel;label&&(label.innerHTML=names.length?names.join(" / "):globalize.translate("Any"))}}},{key:"connectedCallback",value:function(){var multiple,labelText,label,insertLabel,arrowContainerClass;onInit.call(this),this.classList.contains("emby-select")||((multiple=this.hasAttribute("multiple"))&&(this.size=1,this.classList.add("hiddenScrollY")),this.classList.add("emby-select"),labelText=this.getAttribute("label")||"",(label=this.closest("label"))?(label.insertAdjacentHTML("afterbegin",'<div class="selectLabelText">'+labelText+"</div>"),label.classList.add("selectLabel")):((label=this.ownerDocument.createElement("label")).classList.add("selectLabel","selectLabelText"),label.innerHTML=labelText,label.htmlFor=this.id,insertLabel=!0),arrowContainerClass="selectArrowContainer",this.classList.contains("emby-select-inline")&&(label.classList.add("selectLabel-inline"),arrowContainerClass+=" selectArrowContainer-inline"),insertLabel&&this.parentNode.insertBefore(label,this),multiple&&(this.parentNode.insertAdjacentHTML("beforeend",'<div class="emby-select-selectedNameContainer"><div style="visibility:hidden;">0</div><div class="emby-select-selectedName"></div></div>'),this.nameLabel=this.parentNode.querySelector(".emby-select-selectedName")),this.classList.contains("emby-select-withcolor")&&this.parentNode.insertAdjacentHTML("beforeend",'<div class="'+arrowContainerClass+'"><div style="visibility:hidden;">0</div><i class="selectArrow md-icon">&#xE313;</i></div>'),multiple&&self.MutationObserver&&(this.observer=new MutationObserver(onItemsMutation),this.observer.observe(this,{characterData:!1,childList:!0,attributes:!1})))}},{key:"disconnectedCallback",value:function(){var observer=this.observer;observer&&(observer.disconnect(),this.observer=null)}},{key:"setLabel",value:function(text){this.parentNode.querySelector("label").innerHTML=text}}]),EmbySelect}(babelHelpers.wrapNativeSuper(HTMLSelectElement));customElements.define("emby-select",EmbySelect,{extends:"select"})});