define(["exports","../utils/logger.js","./amf-parser.js","./demux-errors.js","../core/media-info.js","../utils/exception.js","./exp-golomb.js"],function(_exports,_logger,_amfParser,_demuxErrors,_mediaInfo,_exception,_expGolomb){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_logger=babelHelpers.interopRequireDefault(_logger),_amfParser=babelHelpers.interopRequireDefault(_amfParser),_demuxErrors=babelHelpers.interopRequireDefault(_demuxErrors),_mediaInfo=babelHelpers.interopRequireDefault(_mediaInfo),_expGolomb=babelHelpers.interopRequireDefault(_expGolomb);var FLVDemuxer=function(){function FLVDemuxer(probeData,config){babelHelpers.classCallCheck(this,FLVDemuxer),this.TAG="FLVDemuxer",this._config=config,this._onError=null,this._onMediaInfo=null,this._onMetaDataArrived=null,this._onScriptDataArrived=null,this._onTrackMetadata=null,this._onDataAvailable=null,this._dataOffset=probeData.dataOffset,this._firstParse=!0,this._dispatch=!1,this._hasAudio=probeData.hasAudioTrack,this._hasVideo=probeData.hasVideoTrack,this._audioInitialMetadataDispatched=!1,this._videoInitialMetadataDispatched=!1,this._mediaInfo=new _mediaInfo.default,this._mediaInfo.hasAudio=this._hasAudio,this._mediaInfo.hasVideo=this._hasVideo,this._metadata=null,this._audioMetadata=null,this._videoMetadata=null,this._naluLengthSize=4,this._timestampBase=0,this._timescale=1e3,this._duration=0,this._referenceFrameRate={fixed:!0,fps:23.976,fps_num:23976,fps_den:1e3},this._flvSoundRateTable=[5500,11025,22050,44100,48e3],this._mpegSamplingRates=[96e3,88200,64e3,48e3,44100,32e3,24e3,22050,16e3,12e3,11025,8e3,7350],this._mpegAudioV10SampleRateTable=[44100,48e3,32e3,0],this._mpegAudioV20SampleRateTable=[22050,24e3,16e3,0],this._mpegAudioV25SampleRateTable=[11025,12e3,8e3,0],this._mpegAudioL1BitRateTable=[0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,-1],this._mpegAudioL2BitRateTable=[0,32,48,56,64,80,96,112,128,160,192,224,256,320,384,-1],this._mpegAudioL3BitRateTable=[0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,-1],this._videoTrack={type:"video",id:1,sequenceNumber:0,samples:[],length:0},this._audioTrack={type:"audio",id:2,sequenceNumber:0,samples:[],length:0},this._littleEndian=!1}return babelHelpers.createClass(FLVDemuxer,[{key:"destroy",value:function(){this._mediaInfo=null,this._metadata=null,this._audioMetadata=null,this._videoMetadata=null,this._videoTrack=null,this._audioTrack=null,this._onError=null,this._onMediaInfo=null,this._onMetaDataArrived=null,this._onScriptDataArrived=null,this._onTrackMetadata=null,this._onDataAvailable=null}},{key:"bindDataSource",value:function(loader){return loader.onDataArrival=this.parseChunks.bind(this),this}},{key:"resetMediaInfo",value:function(){this._mediaInfo=new _mediaInfo.default}},{key:"_isInitialMetadataDispatched",value:function(){return this._hasAudio&&this._hasVideo?this._audioInitialMetadataDispatched&&this._videoInitialMetadataDispatched:this._hasAudio&&!this._hasVideo?this._audioInitialMetadataDispatched:!(this._hasAudio||!this._hasVideo)&&this._videoInitialMetadataDispatched}},{key:"parseChunks",value:function(chunk,byteStart){if(!(this._onError&&this._onMediaInfo&&this._onTrackMetadata&&this._onDataAvailable))throw new _exception.IllegalStateException("Flv: onError & onMediaInfo & onTrackMetadata & onDataAvailable callback must be specified");var offset=0,le=this._littleEndian;if(0===byteStart){if(!(13<chunk.byteLength))return 0;offset=FLVDemuxer.probe(chunk).dataOffset}for(this._firstParse&&(this._firstParse=!1,byteStart+offset!==this._dataOffset&&_logger.default.w(this.TAG,"First time parsing but chunk byteStart invalid!"),0!==new DataView(chunk,offset).getUint32(0,le)&&_logger.default.w(this.TAG,"PrevTagSize0 !== 0 !!!"),offset+=4);offset<chunk.byteLength;){this._dispatch=!0;var _v=new DataView(chunk,offset);if(offset+11+4>chunk.byteLength)break;var tagType=_v.getUint8(0),dataSize=16777215&_v.getUint32(0,le);if(offset+11+dataSize+4>chunk.byteLength)break;if(8===tagType||9===tagType||18===tagType){var ts2=_v.getUint8(4),ts1=_v.getUint8(5),timestamp=_v.getUint8(6)|ts1<<8|ts2<<16|_v.getUint8(7)<<24;0!=(16777215&_v.getUint32(7,le))&&_logger.default.w(this.TAG,"Meet tag which has StreamID != 0!");var dataOffset=offset+11;switch(tagType){case 8:this._parseAudioData(chunk,dataOffset,dataSize,timestamp);break;case 9:this._parseVideoData(chunk,dataOffset,dataSize,timestamp,byteStart+offset);break;case 18:this._parseScriptData(chunk,dataOffset,dataSize)}var prevTagSize=_v.getUint32(11+dataSize,le);prevTagSize!==11+dataSize&&_logger.default.w(this.TAG,"Invalid PrevTagSize ".concat(prevTagSize)),offset+=11+dataSize+4}else _logger.default.w(this.TAG,"Unsupported tag type ".concat(tagType,", skipped")),offset+=11+dataSize+4}return this._isInitialMetadataDispatched()&&this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack),offset}},{key:"_parseScriptData",value:function(arrayBuffer,dataOffset,dataSize){var scriptData=_amfParser.default.parseScriptData(arrayBuffer,dataOffset,dataSize);if(scriptData.hasOwnProperty("onMetaData")){if(null==scriptData.onMetaData||"object"!=typeof scriptData.onMetaData)return void _logger.default.w(this.TAG,"Invalid onMetaData structure!");this._metadata&&_logger.default.w(this.TAG,"Found another onMetaData tag!"),this._metadata=scriptData;var duration,fps_num,fps,keyframes,onMetaData=this._metadata.onMetaData;this._onMetaDataArrived&&this._onMetaDataArrived(Object.assign({},onMetaData)),"boolean"==typeof onMetaData.hasAudio&&(this._hasAudio=onMetaData.hasAudio,this._mediaInfo.hasAudio=this._hasAudio),"boolean"==typeof onMetaData.hasVideo&&(this._hasVideo=onMetaData.hasVideo,this._mediaInfo.hasVideo=this._hasVideo),"number"==typeof onMetaData.audiodatarate&&(this._mediaInfo.audioDataRate=onMetaData.audiodatarate),"number"==typeof onMetaData.videodatarate&&(this._mediaInfo.videoDataRate=onMetaData.videodatarate),"number"==typeof onMetaData.width&&(this._mediaInfo.width=onMetaData.width),"number"==typeof onMetaData.height&&(this._mediaInfo.height=onMetaData.height),"number"==typeof onMetaData.duration?(duration=Math.floor(onMetaData.duration*this._timescale),this._duration=duration,this._mediaInfo.duration=duration):this._mediaInfo.duration=0,"number"!=typeof onMetaData.framerate||0<(fps_num=Math.floor(1e3*onMetaData.framerate))&&(fps=fps_num/1e3,this._referenceFrameRate.fixed=!0,this._referenceFrameRate.fps=fps,this._referenceFrameRate.fps_num=fps_num,this._referenceFrameRate.fps_den=1e3,this._mediaInfo.fps=fps),"object"==typeof onMetaData.keyframes?(this._mediaInfo.hasKeyframesIndex=!0,keyframes=onMetaData.keyframes,this._mediaInfo.keyframesIndex=this._parseKeyframesIndex(keyframes),onMetaData.keyframes=null):this._mediaInfo.hasKeyframesIndex=!1,this._dispatch=!1,this._mediaInfo.metadata=onMetaData,_logger.default.v(this.TAG,"Parsed onMetaData"),this._mediaInfo.isComplete()&&this._onMediaInfo(this._mediaInfo)}0<Object.keys(scriptData).length&&this._onScriptDataArrived&&this._onScriptDataArrived(Object.assign({},scriptData))}},{key:"_parseKeyframesIndex",value:function(keyframes){for(var times=[],filepositions=[],i=1;i<keyframes.times.length;i++){var time=this._timestampBase+Math.floor(1e3*keyframes.times[i]);times.push(time),filepositions.push(keyframes.filepositions[i])}return{times:times,filepositions:filepositions}}},{key:"_parseAudioData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp){if(dataSize<=1)_logger.default.w(this.TAG,"Flv: Invalid audio packet, missing SoundData payload!");else{this._littleEndian;var soundSpec=new DataView(arrayBuffer,dataOffset,dataSize).getUint8(0),soundFormat=soundSpec>>>4;if(2==soundFormat||10==soundFormat){var soundRate=0,soundRateIndex=(12&soundSpec)>>>2;if(0<=soundRateIndex&&soundRateIndex<=4){soundRate=this._flvSoundRateTable[soundRateIndex];var soundType=1&soundSpec,meta=this._audioMetadata,track=this._audioTrack;if(meta||(!1===this._hasAudio&&(this._hasAudio=!0,this._mediaInfo.hasAudio=!0),(meta=this._audioMetadata={}).type="audio",meta.id=track.id,meta.timescale=this._timescale,meta.duration=this._duration,meta.audioSampleRate=soundRate,meta.channelCount=0==soundType?1:2),10==soundFormat){var misc,mi,dts,aacSample,aacData=this._parseAACAudioData(arrayBuffer,dataOffset+1,dataSize-1);if(null==aacData)return;0===aacData.packetType?(meta.config&&_logger.default.w(this.TAG,"Found another AudioSpecificConfig!"),misc=aacData.data,meta.audioSampleRate=misc.samplingRate,meta.channelCount=misc.channelCount,meta.codec=misc.codec,meta.originalCodec=misc.originalCodec,meta.config=misc.config,meta.refSampleDuration=1024/meta.audioSampleRate*meta.timescale,_logger.default.v(this.TAG,"Parsed AudioSpecificConfig"),this._isInitialMetadataDispatched()?this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack):this._audioInitialMetadataDispatched=!0,this._dispatch=!1,this._onTrackMetadata("audio",meta),(mi=this._mediaInfo).audioCodec=meta.originalCodec,mi.audioSampleRate=meta.audioSampleRate,mi.audioChannelCount=meta.channelCount,mi.hasVideo?null!=mi.videoCodec&&(mi.mimeType='video/x-flv; codecs="'+mi.videoCodec+","+mi.audioCodec+'"'):mi.mimeType='video/x-flv; codecs="'+mi.audioCodec+'"',mi.isComplete()&&this._onMediaInfo(mi)):1===aacData.packetType?(dts=this._timestampBase+tagTimestamp,aacSample={unit:aacData.data,length:aacData.data.byteLength,dts:dts,pts:dts},track.samples.push(aacSample),track.length+=aacData.data.length):_logger.default.e(this.TAG,"Flv: Unsupported AAC data type ".concat(aacData.packetType))}else if(2==soundFormat){if(!meta.codec){var _misc=this._parseMP3AudioData(arrayBuffer,dataOffset+1,dataSize-1,!0);if(null==_misc)return;meta.audioSampleRate=_misc.samplingRate,meta.channelCount=_misc.channelCount,meta.codec=_misc.codec,meta.originalCodec=_misc.originalCodec,meta.refSampleDuration=1152/meta.audioSampleRate*meta.timescale,_logger.default.v(this.TAG,"Parsed MPEG Audio Frame Header"),this._audioInitialMetadataDispatched=!0,this._onTrackMetadata("audio",meta);var _mi=this._mediaInfo;_mi.audioCodec=meta.codec,_mi.audioSampleRate=meta.audioSampleRate,_mi.audioChannelCount=meta.channelCount,_mi.audioDataRate=_misc.bitRate,_mi.hasVideo?null!=_mi.videoCodec&&(_mi.mimeType='video/x-flv; codecs="'+_mi.videoCodec+","+_mi.audioCodec+'"'):_mi.mimeType='video/x-flv; codecs="'+_mi.audioCodec+'"',_mi.isComplete()&&this._onMediaInfo(_mi)}var data=this._parseMP3AudioData(arrayBuffer,dataOffset+1,dataSize-1,!1);if(null==data)return;var _dts=this._timestampBase+tagTimestamp,mp3Sample={unit:data,length:data.byteLength,dts:_dts,pts:_dts};track.samples.push(mp3Sample),track.length+=data.length}}else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid audio sample rate idx: "+soundRateIndex)}else this._onError(_demuxErrors.default.CODEC_UNSUPPORTED,"Flv: Unsupported audio codec idx: "+soundFormat)}}},{key:"_parseAACAudioData",value:function(arrayBuffer,dataOffset,dataSize){if(!(dataSize<=1)){var result={},array=new Uint8Array(arrayBuffer,dataOffset,dataSize);return result.packetType=array[0],0===array[0]?result.data=this._parseAACAudioSpecificConfig(arrayBuffer,dataOffset+1,dataSize-1):result.data=array.subarray(1),result}_logger.default.w(this.TAG,"Flv: Invalid AAC packet, missing AACPacketType or/and Data!")}},{key:"_parseAACAudioSpecificConfig",value:function(arrayBuffer,dataOffset,dataSize){var originalAudioObjectType,array=new Uint8Array(arrayBuffer,dataOffset,dataSize),config=null,audioObjectType=0,samplingIndex=0,extensionSamplingIndex=null,audioObjectType=originalAudioObjectType=array[0]>>>3;if((samplingIndex=(7&array[0])<<1|array[1]>>>7)<0||samplingIndex>=this._mpegSamplingRates.length)this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: AAC invalid sampling frequency index!");else{var samplingFrequence=this._mpegSamplingRates[samplingIndex],channelConfig=(120&array[1])>>>3;if(!(channelConfig<0||8<=channelConfig)){5===audioObjectType&&(extensionSamplingIndex=(7&array[1])<<1|array[2]>>>7,array[2]);var userAgent=self.navigator.userAgent.toLowerCase();return-1!==userAgent.indexOf("firefox")?extensionSamplingIndex=6<=samplingIndex?(audioObjectType=5,config=new Array(4),samplingIndex-3):(audioObjectType=2,config=new Array(2),samplingIndex):-1!==userAgent.indexOf("android")?(audioObjectType=2,config=new Array(2),extensionSamplingIndex=samplingIndex):(audioObjectType=5,extensionSamplingIndex=samplingIndex,config=new Array(4),6<=samplingIndex?extensionSamplingIndex=samplingIndex-3:1==channelConfig&&(audioObjectType=2,config=new Array(2),extensionSamplingIndex=samplingIndex)),config[0]=audioObjectType<<3,config[0]|=(15&samplingIndex)>>>1,config[1]=(15&samplingIndex)<<7,config[1]|=(15&channelConfig)<<3,5===audioObjectType&&(config[1]|=(15&extensionSamplingIndex)>>>1,config[2]=(1&extensionSamplingIndex)<<7,config[2]|=8,config[3]=0),{config:config,samplingRate:samplingFrequence,channelCount:channelConfig,codec:"mp4a.40."+audioObjectType,originalCodec:"mp4a.40."+originalAudioObjectType}}this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: AAC invalid channel configuration")}}},{key:"_parseMP3AudioData",value:function(arrayBuffer,dataOffset,dataSize,requestHeader){if(!(dataSize<4)){this._littleEndian;var array=new Uint8Array(arrayBuffer,dataOffset,dataSize),result=null;if(requestHeader){if(255!==array[0])return;var ver=array[1]>>>3&3,layer=(6&array[1])>>1,bitrate_index=(240&array[2])>>>4,sampling_freq_index=(12&array[2])>>>2,channel_count=3!=(array[3]>>>6&3)?2:1,sample_rate=0,bit_rate=0;switch(ver){case 0:sample_rate=this._mpegAudioV25SampleRateTable[sampling_freq_index];break;case 2:sample_rate=this._mpegAudioV20SampleRateTable[sampling_freq_index];break;case 3:sample_rate=this._mpegAudioV10SampleRateTable[sampling_freq_index]}switch(layer){case 1:bitrate_index<this._mpegAudioL3BitRateTable.length&&(bit_rate=this._mpegAudioL3BitRateTable[bitrate_index]);break;case 2:bitrate_index<this._mpegAudioL2BitRateTable.length&&(bit_rate=this._mpegAudioL2BitRateTable[bitrate_index]);break;case 3:bitrate_index<this._mpegAudioL1BitRateTable.length&&(bit_rate=this._mpegAudioL1BitRateTable[bitrate_index])}result={bitRate:bit_rate,samplingRate:sample_rate,channelCount:channel_count,codec:"mp3",originalCodec:"mp3"}}else result=array;return result}_logger.default.w(this.TAG,"Flv: Invalid MP3 packet, header missing!")}},{key:"_parseVideoData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition){var spec,frameType,codecId;dataSize<=1?_logger.default.w(this.TAG,"Flv: Invalid video packet, missing VideoData payload!"):(frameType=(240&(spec=new Uint8Array(arrayBuffer,dataOffset,dataSize)[0]))>>>4,7==(codecId=15&spec)?this._parseAVCVideoPacket(arrayBuffer,dataOffset+1,dataSize-1,tagTimestamp,tagPosition,frameType):this._onError(_demuxErrors.default.CODEC_UNSUPPORTED,"Flv: Unsupported codec in video frame: ".concat(codecId)))}},{key:"_parseAVCVideoPacket",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition,frameType){if(dataSize<4)_logger.default.w(this.TAG,"Flv: Invalid AVC packet, missing AVCPacketType or/and CompositionTime");else{var le=this._littleEndian,v=new DataView(arrayBuffer,dataOffset,dataSize),packetType=v.getUint8(0),cts=(16777215&v.getUint32(0,le))<<8>>8;if(0===packetType)this._parseAVCDecoderConfigurationRecord(arrayBuffer,dataOffset+4,dataSize-4);else if(1===packetType)this._parseAVCVideoData(arrayBuffer,dataOffset+4,dataSize-4,tagTimestamp,tagPosition,frameType,cts);else if(2!==packetType)return void this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid video packet type ".concat(packetType))}}},{key:"_parseAVCDecoderConfigurationRecord",value:function(arrayBuffer,dataOffset,dataSize){if(dataSize<7)_logger.default.w(this.TAG,"Flv: Invalid AVCDecoderConfigurationRecord, lack of data!");else{var meta=this._videoMetadata,track=this._videoTrack,le=this._littleEndian,v=new DataView(arrayBuffer,dataOffset,dataSize);meta?void 0!==meta.avcc&&_logger.default.w(this.TAG,"Found another AVCDecoderConfigurationRecord!"):(!1===this._hasVideo&&(this._hasVideo=!0,this._mediaInfo.hasVideo=!0),(meta=this._videoMetadata={}).type="video",meta.id=track.id,meta.timescale=this._timescale,meta.duration=this._duration);var version=v.getUint8(0),avcProfile=v.getUint8(1);v.getUint8(2),v.getUint8(3);if(1===version&&0!==avcProfile)if(this._naluLengthSize=1+(3&v.getUint8(4)),3===this._naluLengthSize||4===this._naluLengthSize){var spsCount=31&v.getUint8(5);if(0!=spsCount){1<spsCount&&_logger.default.w(this.TAG,"Flv: Strange AVCDecoderConfigurationRecord: SPS Count = ".concat(spsCount));for(var offset=6,i=0;i<spsCount;i++){var len=v.getUint16(offset,le);if(offset+=2,0!==len){var sps=new Uint8Array(arrayBuffer,dataOffset+offset,len);if(offset+=len,0===i){var parsedSps=function(uint8array){for(var src=uint8array,src_length=src.byteLength,dst=new Uint8Array(src_length),dst_idx=0,i=0;i<src_length;i++)2<=i&&3===src[i]&&0===src[i-1]&&0===src[i-2]||(dst[dst_idx]=src[i],dst_idx++);return new Uint8Array(dst.buffer,0,dst_idx)}(sps),expConfig=new _expGolomb.default(parsedSps).readSPS();meta.sps=[parsedSps],meta.pps=sps,meta.pixelRatio=expConfig.pixelRatio,meta.width=expConfig.width,meta.height=expConfig.height,meta.codecWidth=expConfig.width,meta.codecHeight=expConfig.height,meta.presentWidth=expConfig.width,meta.presentHeight=expConfig.height;for(var codecArray=sps.subarray(1,4),codecString="avc1.",j=0;j<3;j++){var h=codecArray[j].toString(16);h.length<2&&(h="0"+h),codecString+=h}meta.codec=codecString;var mi=this._mediaInfo;mi.width=meta.codecWidth,mi.height=meta.codecHeight,mi.videoCodec=codecString,mi.hasAudio?null!=mi.audioCodec&&(mi.mimeType='video/x-flv; codecs="'+mi.videoCodec+","+mi.audioCodec+'"'):mi.mimeType='video/x-flv; codecs="'+mi.videoCodec+'"',mi.isComplete()&&this._onMediaInfo(mi)}}}var ppsCount=v.getUint8(offset);if(0!==ppsCount){1<ppsCount&&_logger.default.w(this.TAG,"Flv: Strange AVCDecoderConfigurationRecord: PPS Count = ".concat(ppsCount)),offset++;for(var _i=0;_i<ppsCount;_i++){var _len=v.getUint16(offset,le);offset+=2,0!==_len&&(offset+=_len)}meta.avcc=new Uint8Array(dataSize),meta.avcc.set(new Uint8Array(arrayBuffer,dataOffset,dataSize),0),_logger.default.v(this.TAG,"Parsed AVCDecoderConfigurationRecord"),this._isInitialMetadataDispatched()?this._dispatch&&(this._audioTrack.length||this._videoTrack.length)&&this._onDataAvailable(this._audioTrack,this._videoTrack):this._videoInitialMetadataDispatched=!0,this._dispatch=!1,this._onTrackMetadata("video",meta)}else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord: No PPS")}else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord: No SPS")}else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Strange NaluLengthSizeMinusOne: ".concat(this._naluLengthSize-1));else this._onError(_demuxErrors.default.FORMAT_ERROR,"Flv: Invalid AVCDecoderConfigurationRecord")}}},{key:"_parseAVCVideoData",value:function(arrayBuffer,dataOffset,dataSize,tagTimestamp,tagPosition,frameType,cts){for(var track,avcSample,le=this._littleEndian,v=new DataView(arrayBuffer,dataOffset,dataSize),units=[],length=0,offset=0,lengthSize=this._naluLengthSize,dts=this._timestampBase+tagTimestamp,keyframe=1===frameType;offset<dataSize;){if(dataSize<=offset+4){_logger.default.w(this.TAG,"Malformed Nalu near timestamp ".concat(dts,", offset = ").concat(offset,", dataSize = ").concat(dataSize));break}var naluSize=v.getUint32(offset,le);if(3===lengthSize&&(naluSize>>>=8),dataSize-lengthSize<naluSize)return void _logger.default.w(this.TAG,"Malformed Nalus near timestamp ".concat(dts,", NaluSize > DataSize!"));var unitType=31&v.getUint8(offset+lengthSize);5==unitType&&(keyframe=!0);var data=new Uint8Array(arrayBuffer,dataOffset+offset,lengthSize+naluSize),unit={type:unitType,data:data};units.push(unit),length+=data.byteLength,offset+=lengthSize+naluSize}units.length&&(track=this._videoTrack,avcSample={units:units,length:length,isKeyframe:keyframe,dts:dts,cts:cts,pts:dts+cts},keyframe&&(avcSample.fileposition=tagPosition),track.samples.push(avcSample),track.length+=length)}},{key:"onTrackMetadata",get:function(){return this._onTrackMetadata},set:function(callback){this._onTrackMetadata=callback}},{key:"onMediaInfo",get:function(){return this._onMediaInfo},set:function(callback){this._onMediaInfo=callback}},{key:"onMetaDataArrived",get:function(){return this._onMetaDataArrived},set:function(callback){this._onMetaDataArrived=callback}},{key:"onScriptDataArrived",get:function(){return this._onScriptDataArrived},set:function(callback){this._onScriptDataArrived=callback}},{key:"onError",get:function(){return this._onError},set:function(callback){this._onError=callback}},{key:"onDataAvailable",get:function(){return this._onDataAvailable},set:function(callback){this._onDataAvailable=callback}},{key:"timestampBase",get:function(){return this._timestampBase},set:function(base){this._timestampBase=base}}],[{key:"probe",value:function(buffer){var data=new Uint8Array(buffer),mismatch={match:!1};if(70!==data[0]||76!==data[1]||86!==data[2]||1!==data[3])return mismatch;var array,index,hasAudio=(4&data[4])>>>2!=0,hasVideo=0!=(1&data[4]),offset=(array=data)[index=5]<<24|array[index+1]<<16|array[index+2]<<8|array[index+3];return offset<9?mismatch:{match:!0,consumed:offset,dataOffset:offset,hasAudioTrack:hasAudio,hasVideoTrack:hasVideo}}}]),FLVDemuxer}();_exports.default=FLVDemuxer});