define(["exports","../utils/logger.js","../../browser.js","./loader.js","../utils/exception.js"],function(_exports,_logger,_browser,_loader,_exception){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_logger=babelHelpers.interopRequireDefault(_logger),_browser=babelHelpers.interopRequireDefault(_browser);var FetchStreamLoader=function(_BaseLoader){babelHelpers.inherits(FetchStreamLoader,_BaseLoader);var _super=_createSuper(FetchStreamLoader);function FetchStreamLoader(seekHandler,config){var _this;return babelHelpers.classCallCheck(this,FetchStreamLoader),(_this=_super.call(this,"fetch-stream-loader")).TAG="FetchStreamLoader",_this._seekHandler=seekHandler,_this._config=config,_this._needStash=!0,_this._requestAbort=!1,_this._contentLength=null,_this._receivedLength=0,_this}return babelHelpers.createClass(FetchStreamLoader,null,[{key:"isSupported",value:function(){try{return self.fetch&&self.ReadableStream}catch(e){return!1}}}]),babelHelpers.createClass(FetchStreamLoader,[{key:"destroy",value:function(){this.isWorking()&&this.abort(),babelHelpers.get(babelHelpers.getPrototypeOf(FetchStreamLoader.prototype),"destroy",this).call(this)}},{key:"open",value:function(dataSource,range){var _this2=this;this._dataSource=dataSource,this._range=range;var sourceURL=dataSource.url;this._config.reuseRedirectedURL&&dataSource.redirectedURL&&(sourceURL=dataSource.redirectedURL);var seekConfig=this._seekHandler.getConfig(sourceURL,range),headers=new self.Headers;if("object"==typeof seekConfig.headers){var configHeaders=seekConfig.headers;for(var key in configHeaders)configHeaders.hasOwnProperty(key)&&headers.append(key,configHeaders[key])}var params={method:"GET",headers:headers,mode:"cors",cache:"default",referrerPolicy:"no-referrer-when-downgrade"};if("object"==typeof this._config.headers)for(var _key in this._config.headers)headers.append(_key,this._config.headers[_key]);!1===dataSource.cors&&(params.mode="same-origin"),dataSource.withCredentials&&(params.credentials="include"),dataSource.referrerPolicy&&(params.referrerPolicy=dataSource.referrerPolicy),self.AbortController&&(this._abortController=new self.AbortController,params.signal=this._abortController.signal),this._status=_loader.LoaderStatus.kConnecting,self.fetch(seekConfig.url,params).then(function(res){if(_this2._requestAbort)return _this2._requestAbort=!1,_this2._status=_loader.LoaderStatus.kIdle,void res.body.cancel();if(res.ok&&200<=res.status&&res.status<=299){var redirectedURL;res.url!==seekConfig.url&&_this2._onURLRedirect&&(redirectedURL=_this2._seekHandler.removeURLParameters(res.url),_this2._onURLRedirect(redirectedURL));var lengthHeader=res.headers.get("Content-Length");return null!=lengthHeader&&(_this2._contentLength=parseInt(lengthHeader),0!==_this2._contentLength&&_this2._onContentLengthKnown&&_this2._onContentLengthKnown(_this2._contentLength)),_this2._pump.call(_this2,res.body.getReader())}if(_this2._status=_loader.LoaderStatus.kError,!_this2._onError)throw new _exception.RuntimeException("FetchStreamLoader: Http code invalid, "+res.status+" "+res.statusText);_this2._onError(_loader.LoaderErrors.HTTP_STATUS_CODE_INVALID,{code:res.status,msg:res.statusText})}).catch(function(e){if(!_this2._abortController||!_this2._abortController.signal.aborted){if(_this2._status=_loader.LoaderStatus.kError,!_this2._onError)throw e;_this2._onError(_loader.LoaderErrors.EXCEPTION,{code:-1,msg:e.message})}})}},{key:"abort",value:function(){this._requestAbort=!0,this._abortController&&this._abortController.abort()}},{key:"_pump",value:function(reader){var _this3=this;return reader.read().then(function(result){if(result.done)if(null!==_this3._contentLength&&_this3._receivedLength<_this3._contentLength){_this3._status=_loader.LoaderStatus.kError;var type=_loader.LoaderErrors.EARLY_EOF,info={code:-1,msg:"Fetch stream meet Early-EOF"};if(!_this3._onError)throw new _exception.RuntimeException(info.msg);_this3._onError(type,info)}else _this3._status=_loader.LoaderStatus.kComplete,_this3._onComplete&&_this3._onComplete(_this3._range.from,_this3._range.from+_this3._receivedLength-1);else{if(!0===_this3._requestAbort)return _this3._requestAbort=!1,_this3._status=_loader.LoaderStatus.kComplete,reader.cancel();_this3._status=_loader.LoaderStatus.kBuffering;var chunk=result.value.buffer,byteStart=_this3._range.from+_this3._receivedLength;_this3._receivedLength+=chunk.byteLength,_this3._onDataArrival&&_this3._onDataArrival(chunk,byteStart,_this3._receivedLength),_this3._pump(reader)}}).catch(function(e){if(11!==e.code||!_browser.default.edge){_this3._status=_loader.LoaderStatus.kError;var type=0,info=null,info=19!==e.code&&"network error"!==e.message||!(null===_this3._contentLength||null!==_this3._contentLength&&_this3._receivedLength<_this3._contentLength)?(type=_loader.LoaderErrors.EXCEPTION,{code:e.code,msg:e.message}):(type=_loader.LoaderErrors.EARLY_EOF,{code:e.code,msg:"Fetch stream meet Early-EOF"});if(!_this3._onError)throw new _exception.RuntimeException(info.msg);_this3._onError(type,info)}})}}]),FetchStreamLoader}(_loader.BaseLoader);_exports.default=FetchStreamLoader});