define(["exports","../utils/logger.js","./mp4-generator.js","./aac-silent.js","../../browser.js","../core/media-segment-info.js","../utils/exception.js"],function(_exports,_logger,_mp4Generator,_aacSilent,_browser,_mediaSegmentInfo,_exception){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_logger=babelHelpers.interopRequireDefault(_logger),_mp4Generator=babelHelpers.interopRequireDefault(_mp4Generator),_aacSilent=babelHelpers.interopRequireDefault(_aacSilent),_browser=babelHelpers.interopRequireDefault(_browser);var MP4Remuxer=function(){function MP4Remuxer(config){var result;babelHelpers.classCallCheck(this,MP4Remuxer),this.TAG="MP4Remuxer",this._config=config,this._isLive=!0===config.isLive,this._dtsBase=-1,this._dtsBaseInited=!1,this._audioDtsBase=1/0,this._videoDtsBase=1/0,this._audioNextDts=void 0,this._videoNextDts=void 0,this._audioStashedLastSample=null,this._videoStashedLastSample=null,this._audioMeta=null,this._videoMeta=null,this._audioSegmentInfoList=new _mediaSegmentInfo.MediaSegmentInfoList("audio"),this._videoSegmentInfoList=new _mediaSegmentInfo.MediaSegmentInfoList("video"),this._onInitSegment=null,this._onMediaSegment=null,this._forceFirstIDR=_browser.default.chrome&&((result=navigator.userAgent.match(/Chrome\/(\d+)/i))?parseInt(result[1]):0)<=50,this._fillSilentAfterSeek=_browser.default.edge,this._mp3UseMpegAudio=!_browser.default.firefox,this._fillAudioTimestampGap=this._config.fixAudioTimestampGap}return babelHelpers.createClass(MP4Remuxer,[{key:"destroy",value:function(){this._dtsBase=-1,this._dtsBaseInited=!1,this._audioMeta=null,this._videoMeta=null,this._audioSegmentInfoList.clear(),this._audioSegmentInfoList=null,this._videoSegmentInfoList.clear(),this._videoSegmentInfoList=null,this._onInitSegment=null,this._onMediaSegment=null}},{key:"bindDataSource",value:function(producer){return producer.onDataAvailable=this.remux.bind(this),producer.onTrackMetadata=this._onTrackMetadataReceived.bind(this),this}},{key:"insertDiscontinuity",value:function(){this._audioNextDts=this._videoNextDts=void 0}},{key:"seek",value:function(){this._audioStashedLastSample=null,this._videoStashedLastSample=null,this._videoSegmentInfoList.clear(),this._audioSegmentInfoList.clear()}},{key:"remux",value:function(audioTrack,videoTrack){if(!this._onMediaSegment)throw new _exception.IllegalStateException("MP4Remuxer: onMediaSegment callback must be specificed!");this._dtsBaseInited||this._calculateDtsBase(audioTrack,videoTrack),this._remuxVideo(videoTrack),this._remuxAudio(audioTrack)}},{key:"_onTrackMetadataReceived",value:function(type,metadata){var metabox=null,container="mp4",codec=metadata.codec;if("audio"===type)metabox="mp3"===(this._audioMeta=metadata).codec&&this._mp3UseMpegAudio?(container="mpeg",codec="",new Uint8Array):_mp4Generator.default.initSegment([metadata]);else{if("video"!==type)return;this._videoMeta=metadata,metabox=_mp4Generator.default.initSegment([metadata])}if(!this._onInitSegment)throw new _exception.IllegalStateException("MP4Remuxer: onInitSegment callback must be specified!");this._onInitSegment(type,{type:type,data:metabox.buffer,codec:codec,container:"".concat(type,"/").concat(container),mediaDuration:metadata.duration})}},{key:"_calculateDtsBase",value:function(audioTrack,videoTrack){this._dtsBaseInited||(audioTrack.samples&&audioTrack.samples.length&&(this._audioDtsBase=audioTrack.samples[0].dts),videoTrack.samples&&videoTrack.samples.length&&(this._videoDtsBase=videoTrack.samples[0].dts),this._dtsBase=Math.min(this._audioDtsBase,this._videoDtsBase),this._dtsBaseInited=!0)}},{key:"flushStashedSamples",value:function(){var videoSample=this._videoStashedLastSample,audioSample=this._audioStashedLastSample,videoTrack={type:"video",id:1,sequenceNumber:0,samples:[],length:0};null!=videoSample&&(videoTrack.samples.push(videoSample),videoTrack.length=videoSample.length);var audioTrack={type:"audio",id:2,sequenceNumber:0,samples:[],length:0};null!=audioSample&&(audioTrack.samples.push(audioSample),audioTrack.length=audioSample.length),this._videoStashedLastSample=null,this._audioStashedLastSample=null,this._remuxVideo(videoTrack,!0),this._remuxAudio(audioTrack,!0)}},{key:"_remuxAudio",value:function(audioTrack,force){if(null!=this._audioMeta){var track=audioTrack,samples=track.samples,firstDts=-1,refSampleDuration=this._audioMeta.refSampleDuration,mpegRawTrack="mp3"===this._audioMeta.codec&&this._mp3UseMpegAudio,firstSegmentAfterSeek=this._dtsBaseInited&&void 0===this._audioNextDts,insertPrefixSilentFrame=!1;if(samples&&0!==samples.length&&(1!==samples.length||force)){var sample,offset=0,mdatbox=null,mdatBytes=0,mdatBytes=mpegRawTrack?(offset=0,track.length):(offset=8)+track.length,lastSample=null;1<samples.length&&(mdatBytes-=(lastSample=samples.pop()).length),null!=this._audioStashedLastSample&&(sample=this._audioStashedLastSample,this._audioStashedLastSample=null,samples.unshift(sample),mdatBytes+=sample.length),null!=lastSample&&(this._audioStashedLastSample=lastSample);var _lastSample,distance,dtsCorrection,firstSampleDts,videoSegment,silentUnit,dts,silentFrameDuration,firstSampleOriginalDts=samples[0].dts-this._dtsBase;this._audioNextDts?dtsCorrection=firstSampleOriginalDts-this._audioNextDts:this._audioSegmentInfoList.isEmpty()?(dtsCorrection=0,this._fillSilentAfterSeek&&!this._videoSegmentInfoList.isEmpty()&&"mp3"!==this._audioMeta.originalCodec&&(insertPrefixSilentFrame=!0)):dtsCorrection=null!=(_lastSample=this._audioSegmentInfoList.getLastSampleBefore(firstSampleOriginalDts))?((distance=firstSampleOriginalDts-(_lastSample.originalDts+_lastSample.duration))<=3&&(distance=0),firstSampleOriginalDts-(_lastSample.dts+_lastSample.duration+distance)):0,insertPrefixSilentFrame&&(firstSampleDts=firstSampleOriginalDts-dtsCorrection,null!=(videoSegment=this._videoSegmentInfoList.getLastSegmentBefore(firstSampleOriginalDts))&&videoSegment.beginDts<firstSampleDts?(silentUnit=_aacSilent.default.getSilentFrame(this._audioMeta.originalCodec,this._audioMeta.channelCount))&&(dts=videoSegment.beginDts,silentFrameDuration=firstSampleDts-videoSegment.beginDts,_logger.default.v(this.TAG,"InsertPrefixSilentAudio: dts: ".concat(dts,", duration: ").concat(silentFrameDuration)),samples.unshift({unit:silentUnit,dts:dts,pts:dts}),mdatBytes+=silentUnit.byteLength):insertPrefixSilentFrame=!1);for(var mp4Samples=[],i=0;i<samples.length;i++){var _sample=samples[i],unit=_sample.unit,originalDts=_sample.dts-this._dtsBase,_dts=originalDts-dtsCorrection;-1===firstDts&&(firstDts=_dts);var sampleDuration=0,needFillSilentFrames=!1,silentFrames=null;if(1.5*refSampleDuration<(sampleDuration=i!==samples.length-1?samples[i+1].dts-this._dtsBase-dtsCorrection-_dts:null!=lastSample?lastSample.dts-this._dtsBase-dtsCorrection-_dts:1<=mp4Samples.length?mp4Samples[mp4Samples.length-1].duration:Math.floor(refSampleDuration))&&"mp3"!==this._audioMeta.codec&&this._fillAudioTimestampGap&&!_browser.default.safari){needFillSilentFrames=!0;var delta=Math.abs(sampleDuration-refSampleDuration),frameCount=Math.ceil(delta/refSampleDuration),currentDts=_dts+refSampleDuration;_logger.default.w(this.TAG,"Large audio timestamp gap detected, may cause AV sync to drift. Silent frames will be generated to avoid unsync.\n"+"dts: ".concat(_dts+sampleDuration," ms, expected: ").concat(_dts+Math.round(refSampleDuration)," ms, ")+"delta: ".concat(Math.round(delta)," ms, generate: ").concat(frameCount," frames"));var _silentUnit=_aacSilent.default.getSilentFrame(this._audioMeta.originalCodec,this._audioMeta.channelCount);null==_silentUnit&&(_logger.default.w(this.TAG,"Unable to generate silent frame for "+"".concat(this._audioMeta.originalCodec," with ").concat(this._audioMeta.channelCount," channels, repeat last frame")),_silentUnit=unit),silentFrames=[];for(var j=0;j<frameCount;j++){var previousFrame,intDts=Math.round(currentDts);0<silentFrames.length&&((previousFrame=silentFrames[silentFrames.length-1]).duration=intDts-previousFrame.dts);var frame={dts:intDts,pts:intDts,cts:0,unit:_silentUnit,size:_silentUnit.byteLength,duration:0,originalDts:originalDts,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0}};silentFrames.push(frame),mdatBytes+=frame.size,currentDts+=refSampleDuration}var lastFrame=silentFrames[silentFrames.length-1];lastFrame.duration=_dts+sampleDuration-lastFrame.dts,sampleDuration=Math.round(refSampleDuration)}mp4Samples.push({dts:_dts,pts:_dts,cts:0,unit:_sample.unit,size:_sample.unit.byteLength,duration:sampleDuration,originalDts:originalDts,flags:{isLeading:0,dependsOn:1,isDependedOn:0,hasRedundancy:0}}),needFillSilentFrames&&mp4Samples.push.apply(mp4Samples,silentFrames)}mpegRawTrack?mdatbox=new Uint8Array(mdatBytes):((mdatbox=new Uint8Array(mdatBytes))[0]=mdatBytes>>>24&255,mdatbox[1]=mdatBytes>>>16&255,mdatbox[2]=mdatBytes>>>8&255,mdatbox[3]=255&mdatBytes,mdatbox.set(_mp4Generator.default.types.mdat,4));for(var _i=0;_i<mp4Samples.length;_i++){var _unit=mp4Samples[_i].unit;mdatbox.set(_unit,offset),offset+=_unit.byteLength}var latest=mp4Samples[mp4Samples.length-1],lastDts=latest.dts+latest.duration;this._audioNextDts=lastDts;var info=new _mediaSegmentInfo.MediaSegmentInfo;info.beginDts=firstDts,info.endDts=lastDts,info.beginPts=firstDts,info.endPts=lastDts,info.originalBeginDts=mp4Samples[0].originalDts,info.originalEndDts=latest.originalDts+latest.duration,info.firstSample=new _mediaSegmentInfo.SampleInfo(mp4Samples[0].dts,mp4Samples[0].pts,mp4Samples[0].duration,mp4Samples[0].originalDts,!1),info.lastSample=new _mediaSegmentInfo.SampleInfo(latest.dts,latest.pts,latest.duration,latest.originalDts,!1),this._isLive||this._audioSegmentInfoList.append(info),track.samples=mp4Samples,track.sequenceNumber++;var moofbox=null,moofbox=mpegRawTrack?new Uint8Array:_mp4Generator.default.moof(track.sequenceNumber,firstDts,track);track.samples=[],track.length=0;var segment={type:"audio",data:this._mergeBoxes(moofbox,mdatbox).buffer,sampleCount:mp4Samples.length,info:info};mpegRawTrack&&firstSegmentAfterSeek&&(segment.timestampOffset=firstDts),this._onMediaSegment("audio",segment)}}}},{key:"_remuxVideo",value:function(videoTrack,force){if(null!=this._videoMeta){var track=videoTrack,samples=track.samples,firstDts=-1,firstPts=-1;if(samples&&0!==samples.length&&(1!==samples.length||force)){var sample,offset=8,mdatbox=null,mdatBytes=8+videoTrack.length,lastSample=null;1<samples.length&&(mdatBytes-=(lastSample=samples.pop()).length),null!=this._videoStashedLastSample&&(sample=this._videoStashedLastSample,this._videoStashedLastSample=null,samples.unshift(sample),mdatBytes+=sample.length),null!=lastSample&&(this._videoStashedLastSample=lastSample);var _lastSample2,distance,dtsCorrection,firstSampleOriginalDts=samples[0].dts-this._dtsBase;dtsCorrection=this._videoNextDts?firstSampleOriginalDts-this._videoNextDts:!this._videoSegmentInfoList.isEmpty()&&null!=(_lastSample2=this._videoSegmentInfoList.getLastSampleBefore(firstSampleOriginalDts))?((distance=firstSampleOriginalDts-(_lastSample2.originalDts+_lastSample2.duration))<=3&&(distance=0),firstSampleOriginalDts-(_lastSample2.dts+_lastSample2.duration+distance)):0;for(var info=new _mediaSegmentInfo.MediaSegmentInfo,mp4Samples=[],i=0;i<samples.length;i++){var _sample2=samples[i],originalDts=_sample2.dts-this._dtsBase,isKeyframe=_sample2.isKeyframe,dts=originalDts-dtsCorrection,cts=_sample2.cts,pts=dts+cts;-1===firstDts&&(firstDts=dts,firstPts=pts);var syncPoint,sampleDuration=0;sampleDuration=i!==samples.length-1?samples[i+1].dts-this._dtsBase-dtsCorrection-dts:null!=lastSample?lastSample.dts-this._dtsBase-dtsCorrection-dts:1<=mp4Samples.length?mp4Samples[mp4Samples.length-1].duration:Math.floor(this._videoMeta.refSampleDuration),isKeyframe&&((syncPoint=new _mediaSegmentInfo.SampleInfo(dts,pts,sampleDuration,_sample2.dts,!0)).fileposition=_sample2.fileposition,info.appendSyncPoint(syncPoint)),mp4Samples.push({dts:dts,pts:pts,cts:cts,units:_sample2.units,size:_sample2.length,isKeyframe:isKeyframe,duration:sampleDuration,originalDts:originalDts,flags:{isLeading:0,dependsOn:isKeyframe?2:1,isDependedOn:isKeyframe?1:0,hasRedundancy:0,isNonSync:isKeyframe?0:1}})}(mdatbox=new Uint8Array(mdatBytes))[0]=mdatBytes>>>24&255,mdatbox[1]=mdatBytes>>>16&255,mdatbox[2]=mdatBytes>>>8&255,mdatbox[3]=255&mdatBytes,mdatbox.set(_mp4Generator.default.types.mdat,4);for(var _i2=0;_i2<mp4Samples.length;_i2++)for(var units=mp4Samples[_i2].units;units.length;){var data=units.shift().data;mdatbox.set(data,offset),offset+=data.byteLength}var flags,latest=mp4Samples[mp4Samples.length-1],lastDts=latest.dts+latest.duration,lastPts=latest.pts+latest.duration;this._videoNextDts=lastDts,info.beginDts=firstDts,info.endDts=lastDts,info.beginPts=firstPts,info.endPts=lastPts,info.originalBeginDts=mp4Samples[0].originalDts,info.originalEndDts=latest.originalDts+latest.duration,info.firstSample=new _mediaSegmentInfo.SampleInfo(mp4Samples[0].dts,mp4Samples[0].pts,mp4Samples[0].duration,mp4Samples[0].originalDts,mp4Samples[0].isKeyframe),info.lastSample=new _mediaSegmentInfo.SampleInfo(latest.dts,latest.pts,latest.duration,latest.originalDts,latest.isKeyframe),this._isLive||this._videoSegmentInfoList.append(info),track.samples=mp4Samples,track.sequenceNumber++,this._forceFirstIDR&&((flags=mp4Samples[0].flags).dependsOn=2,flags.isNonSync=0);var moofbox=_mp4Generator.default.moof(track.sequenceNumber,firstDts,track);track.samples=[],track.length=0,this._onMediaSegment("video",{type:"video",data:this._mergeBoxes(moofbox,mdatbox).buffer,sampleCount:mp4Samples.length,info:info})}}}},{key:"_mergeBoxes",value:function(moof,mdat){var result=new Uint8Array(moof.byteLength+mdat.byteLength);return result.set(moof,0),result.set(mdat,moof.byteLength),result}},{key:"onInitSegment",get:function(){return this._onInitSegment},set:function(callback){this._onInitSegment=callback}},{key:"onMediaSegment",get:function(){return this._onMediaSegment},set:function(callback){this._onMediaSegment=callback}}]),MP4Remuxer}();_exports.default=MP4Remuxer});