define(["events","browser","htmlMediaHelper","../htmlvideoplayer/basehtmlplayer"],function(events,browser,htmlMediaHelper,BaseHtmlPlayer){"use strict";var fadeTimeout,supportedFeatures;function cancelFadeTimeout(){fadeTimeout&&(clearTimeout(fadeTimeout),fadeTimeout=null)}function HtmlAudioPlayer(){var self=this;function unBindEvents(elem){elem.removeEventListener("timeupdate",onTimeUpdate),elem.removeEventListener("ended",onEnded),elem.removeEventListener("volumechange",onVolumeChange),elem.removeEventListener("ratechange",onRateChange),elem.removeEventListener("pause",onPause),elem.removeEventListener("playing",onPlaying),elem.removeEventListener("play",onPlay)}function bindMediaManager(elem){browser.chromecast&&(cast.framework.CastReceiverContext.getInstance().getPlayerManager().setMediaElement(elem),self.bindMediaManagerEvents())}function onEnded(){htmlMediaHelper.onEndedInternal(self,this,onError)}function onTimeUpdate(){var time,currentPlayOptions;self._started&&!self._isFadingOut&&((time=this.currentTime)&&!self._timeUpdated&&(self._timeUpdated=!0),self._currentTime=time,(currentPlayOptions=self._currentPlayOptions)&&currentPlayOptions.transcodingOffsetTicks,events.trigger(self,"timeupdate"))}function onVolumeChange(){self._isFadingOut||(htmlMediaHelper.saveVolume(this.volume),events.trigger(self,"volumechange"))}function onRateChange(){events.trigger(self,"playbackratechange")}function onPlaying(e){self._started||(self._started=!0,self.seekOnPlaybackStart(e.target,self._currentPlayOptions.playerStartPositionTicks)),events.trigger(self,"playing")}function onPlay(e){events.trigger(self,"unpause")}function onPause(){events.trigger(self,"pause")}function onError(){var type,errorCode=this.error&&this.error.code||0,errorMessage=this.error&&this.error.message||"";switch(console.log("Media element error: "+errorCode.toString()+" "+errorMessage),errorCode){case 1:return;case 2:type="network";break;case 3:if(self._hlsPlayer)return void htmlMediaHelper.handleHlsJsMediaError(self);type="mediadecodeerror";break;case 4:type="medianotsupported";break;default:return}htmlMediaHelper.onErrorInternal(self,type)}BaseHtmlPlayer.call(this),browser.edgeUwp?this.name="Windows Audio Player":this.name="Web Audio Player",self.id="htmlaudioplayer",self.mediaType="audio",self.priority=1,self.play=function(options){return self._started=!1,self._timeUpdated=!1,self._currentTime=null,function(elem,options){elem.removeEventListener("error",onError),unBindEvents(elem),function(elem){elem.addEventListener("timeupdate",onTimeUpdate),elem.addEventListener("ended",onEnded),elem.addEventListener("volumechange",onVolumeChange),elem.addEventListener("ratechange",onRateChange),elem.addEventListener("pause",onPause),elem.addEventListener("playing",onPlaying),elem.addEventListener("play",onPlay)}(elem);var val=options.url;console.log("playing url: "+val);var seconds=(options.playerStartPositionTicks||0)/1e7;seconds&&(val+="#t="+seconds);htmlMediaHelper.destroyHlsPlayer(self),self._currentPlayOptions=options;var crossOrigin=htmlMediaHelper.getCrossOriginValue(options.mediaSource,options.playMethod);crossOrigin&&(elem.crossOrigin=crossOrigin);return browser.chromecast?self.setCurrentSrcChromecast(elem,options,val):self.loadIntoPlayer(elem,options,val)}(function(){var elem=self._mediaElement;if(elem)return bindMediaManager(elem),elem;(elem=document.querySelector(".mediaPlayerAudio"))||((elem=document.createElement("audio")).classList.add("mediaPlayerAudio"),elem.classList.add("hide"),document.body.appendChild(elem));return elem.volume=htmlMediaHelper.getSavedVolume(),bindMediaManager(self._mediaElement=elem),elem}(),options)},self.loadIntoPlayer=function(elem,options,val){return url=val,options.item,mediaSource=options.mediaSource,mediaType="Audio",(htmlMediaHelper.enableHlsJsPlayer(mediaSource.RunTimeTicks,mediaType)?-1!==url.indexOf(".m3u8")?Promise.resolve():fetch(url,{method:"HEAD"}).then(function(response){return"application/x-mpegurl"===(response.headers.get("Content-Type")||"").toLowerCase()?Promise.resolve():Promise.reject()}):Promise.reject()).then(function(){return self.setSrcWithHlsJs(elem,options,val,onError)},function(){return elem.autoplay=!0,htmlMediaHelper.applySrc(elem,val,options).then(function(){return self._currentSrc=val,htmlMediaHelper.playWithPromise(elem,onError)})});var url,mediaSource,mediaType},self.stop=function(destroyPlayer){cancelFadeTimeout();var elem=self._mediaElement,src=self._currentSrc;if(elem){if(!destroyPlayer||browser.tizen||browser.orsay||browser.web0s||browser.operaTv||browser.netcast)return src&&elem.pause(),htmlMediaHelper.onEndedInternal(self,elem,onError),destroyPlayer&&self.destroy(),Promise.resolve();var originalVolume=elem.volume;return function fade(instance,elem,startingVolume){instance._isFadingOut=!0;var newVolume=Math.max(0,startingVolume-.15);return console.log("fading volume to "+newVolume),(elem.volume=newVolume)<=0?(instance._isFadingOut=!1,Promise.resolve()):new Promise(function(resolve,reject){cancelFadeTimeout(),fadeTimeout=setTimeout(function(){fade(instance,elem,newVolume).then(resolve,reject)},100)})}(self,elem,elem.volume).then(function(){elem.pause(),elem.volume=originalVolume,htmlMediaHelper.onEndedInternal(self,elem,onError),destroyPlayer&&self.destroy()})}return Promise.resolve()},self.destroy=function(){browser.chromecast&&self.unBindMediaManagerEvents(),unBindEvents(self._mediaElement)}}return Object.assign(HtmlAudioPlayer.prototype,BaseHtmlPlayer.prototype),HtmlAudioPlayer.prototype.supports=function(feature){var list;return supportedFeatures||((list=[]).push("SetPlaybackRate"),supportedFeatures=list),-1!==supportedFeatures.indexOf(feature)},HtmlAudioPlayer.prototype.destroy=function(){},HtmlAudioPlayer});