define(["dialogHelper","dom","cardBuilder","loading","layoutManager","connectionManager","globalize","focusManager","emby-input","paper-icon-button-light","emby-select","material-icons","formDialogStyle","emby-button","emby-scroller","emby-itemscontainer","emby-toggle"],function(dialogHelper,dom,cardBuilder,loading,layoutManager,connectionManager,globalize,focusManager){"use strict";function ImageDownloader(){}function getDisplayUrl(url,apiClient){return apiClient.getUrl("Images/Remote",{api_key:apiClient.accessToken(),imageUrl:url})}function normalizeResult(result){var providersHtml=result.Providers.map(function(p){return'<option value="'+p+'">'+p+"</option>"}),selectImageProvider=this.dlg.querySelector("#selectImageProvider");return selectImageProvider.innerHTML='<option value="">'+globalize.translate("All")+"</option>"+providersHtml,selectImageProvider.value=this.options.imageProvider||"",result.Items=result.Images,result.Images=null,result.Items.forEach(function(image){var options=this.options,apiClient=connectionManager.getApiClient(options.item);return image.Name=image.ProviderName,image.ImageUrl=getDisplayUrl(image.ThumbnailUrl||image.Url,apiClient),image.OriginalImageUrl=getDisplayUrl(image.Url,apiClient),image}.bind(this)),result}function onItemsContainerUpgraded(){loading.show(),this.itemsContainer.resume({refresh:!0}).then(function(){var dlg=this.dlg;loading.hide(),focusManager.autoFocus(dlg)}.bind(this))}return ImageDownloader.prototype.getItems=function(query){var options=this.options,item=options.item;return connectionManager.getApiClient(item).getAvailableRemoteImages(Object.assign({Type:options.imageType||"Primary",IncludeAllLanguages:options.allLanguages,ProviderName:options.imageProvider,itemId:item.Id},query)).then(normalizeResult.bind(this))},ImageDownloader.prototype.getCardOptions=function(items){var options=this.options,imageType=options.imageType,currentItemType=options.item.Type,shape="auto";return"Backdrop"===imageType||"Thumb"===imageType?shape="backdrop":"Art"===imageType||"Logo"===imageType||"LogoLight"===imageType||"LogoLightColor"===imageType?shape="backdrop":"Banner"===imageType?shape="banner":"Disc"===imageType?shape="square":"Episode"===currentItemType?shape="backdrop":shape="MusicAlbum"===currentItemType||"MusicArtist"===currentItemType?"square":"portrait",{shape:shape,overlayText:!1,centerText:!0,fields:["Name"],coverImage:!0,overlayPlayButton:!1,multiSelect:!1,contextMenu:!1,hoverDownloadButton:!0,action:"custom",textLinks:!1,lazy:2,showDownloadableImageInfo:!0,previewImageButton:!0,draggable:!1}},ImageDownloader.prototype.getListOptions=function(items){return{renderer:cardBuilder,options:this.getCardOptions(items),virtualScrollLayout:"vertical-grid"}},ImageDownloader.prototype.show=function(options){var dialogOptions={removeOnClose:!0,scrollY:!1,autoFocus:!1};layoutManager.tv?dialogOptions.size="fullscreen":dialogOptions.size="fullscreen-border";var dlg=dialogHelper.createDialog(dialogOptions);dlg.classList.add("formDialog");var html="";html+='<div class="formDialogHeader formDialogHeader-clear">',html+='<button is="paper-icon-button-light" class="btnCancel autoSize" tabindex="-1"><i class="md-icon">&#xE5C4;</i></button>',html+='<h2 class="formDialogHeaderTitle">',html+=globalize.translate("HeaderSearchForImages"),html+="</h2>",html+="</div>",html+=function(){var html="";return html+='<div class="formDialogContent flex flex-direction-column" style="overflow:hidden;">',html+='<div is="emby-scroller" data-horizontal="false" data-centerfocus="card" class="flex flex-grow virtualScrollerScrollContainer">',html+='<div class="scrollSlider padded-left padded-right flex-grow">',html+='<div class=" padded-bottom flex align-items-center justify-content-center flex-wrap-wrap focuscontainer-x">',html+='<div class="selectContainer">',html+='<select is="emby-select" id="selectImageProvider" label="'+globalize.translate("LabelSource")+'" class="emby-select-inline">',html+='<option value="">'+globalize.translate("All")+"</option>",html+="</select>",html+="</div>",html+='<div class="selectContainer fldSelectImageType hide" style="margin-left:1em;">',html+='<select is="emby-select" id="selectBrowsableImageType" label="'+globalize.translate("LabelType")+'" class="emby-select-inline">',html+='<option value="Primary">'+globalize.translate("Primary")+"</option>",html+='<option value="Art">'+globalize.translate("Art")+"</option>",html+='<option value="Backdrop">'+globalize.translate("Backdrop")+"</option>",html+='<option value="Banner">'+globalize.translate("Banner")+"</option>",html+='<option value="Disc">'+globalize.translate("Disc")+"</option>",html+='<option value="Logo">'+globalize.translate("Logo")+"</option>",html+='<option value="Thumb">'+globalize.translate("Thumb")+"</option>",html+="</select>",html+="</div>",html+='<label class="selectContainer" style="margin: 0 0 0 1em;width:auto;">',html+='<input id="chkAllLanguages" type="checkbox" is="emby-toggle" />',html+="<span>"+globalize.translate("HeaderAllLanguages")+"</span>",html+="</label>",html+="</div>",html+='<div is="emby-itemscontainer" data-virtualscrolllayout="vertical-grid" class="itemsContainer vertical-wrap padded-bottom-page">',html+="</div>",html+="</div>",html+="</div>",html+="</div>"}(),dlg.innerHTML=html,options.imageType||dlg.querySelector(".fldSelectImageType").classList.remove("hide"),this.dlg=dlg,this.options=options;var selectImageType=dlg.querySelector("#selectBrowsableImageType");selectImageType.value=options.imageType||"Primary",dlg.querySelector(".btnCancel").addEventListener("click",function(){this.closeDialog()}.bind(this)),selectImageType.addEventListener("change",function(e){this.options.imageType=e.target.value,this.options.imageProvider=null,loading.show(),this.itemsContainer.refreshItems().then(loading.hide.bind(loading))}.bind(this)),dlg.querySelector("#selectImageProvider").addEventListener("change",function(e){this.options.imageProvider=e.target.value,loading.show(),this.itemsContainer.refreshItems().then(loading.hide.bind(loading))}.bind(this)),dlg.querySelector("#chkAllLanguages").addEventListener("change",function(e){this.options.allLanguages=e.target.checked,loading.show(),this.itemsContainer.refreshItems().then(loading.hide.bind(loading))}.bind(this));var itemsContainer=dlg.querySelector(".itemsContainer");itemsContainer.addEventListener("action-null",function(e){var options=this.options,item=e.detail.item,mediaItem=options.item,downloadOptions={itemId:mediaItem.Id};downloadOptions.Type=item.Type,downloadOptions.ImageUrl=item.Url,downloadOptions.ProviderName=item.ProviderName,loading.show();var apiClient=connectionManager.getApiClient(mediaItem),instance=this;apiClient.downloadRemoteImage(downloadOptions).then(function(){instance.result=!0,instance.closeDialog()})}.bind(this)),itemsContainer.fetchData=this.getItems.bind(this),itemsContainer.getListOptions=this.getListOptions.bind(this),this.itemsContainer=itemsContainer,dlg.addEventListener("opened",function(){var itemsContainer=this.itemsContainer;itemsContainer.resume?onItemsContainerUpgraded.call(this):dom.addEventListener(itemsContainer,"upgraded",onItemsContainerUpgraded.bind(this),{once:!0})}.bind(this));var dlgClosedFn=function(){var result=this.result;return this.options,this.cleanup(),loading.hide(),result?Promise.resolve():Promise.reject()}.bind(this);return dialogHelper.open(dlg).then(dlgClosedFn,dlgClosedFn)},ImageDownloader.prototype.closeDialog=function(){var dlg=this.dlg;dlg&&dialogHelper.close(dlg)},ImageDownloader.prototype.cleanup=function(){this.options=null,this.dlg=null,this.itemsContainer=null},ImageDownloader});