define(["dialogHelper","dom","cardBuilder","listView","loading","connectionManager","require","globalize","layoutManager","focusManager","emby-input","emby-checkbox","paper-icon-button-light","formDialogStyle","material-icons","cardStyle","emby-scroller"],function(dialogHelper,dom,cardBuilder,listView,loading,connectionManager,require,globalize,layoutManager,focusManager){"use strict";function showIdentifyOptions(instance,page,identifyResult){var identifyOptionsForm=page.querySelector(".identifyOptionsForm");page.querySelector(".popupIdentifyForm").classList.add("hide"),page.querySelector(".identificationSearchResults").classList.add("hide"),identifyOptionsForm.classList.remove("hide"),page.querySelector("#chkIdentifyReplaceImages").checked=!0;var lines=[];lines.push(identifyResult.Name),identifyResult.ProductionYear&&lines.push(identifyResult.ProductionYear),identifyResult.GameSystem&&lines.push(identifyResult.GameSystem);var resultHtml=lines.join("<br/>");identifyResult.ImageUrl&&(resultHtml='<div style="display:flex;align-items:center;"><img src="'+function(apiClient,url,provider){return apiClient.getUrl("Items/RemoteSearch/Image",{imageUrl:url,ProviderName:provider,api_key:apiClient.accessToken()})}(connectionManager.getApiClient(instance.options.item),identifyResult.ImageUrl,identifyResult.SearchProviderName)+'" style="max-height:240px;" /><div style="margin-left:1em;">'+resultHtml+"</div>"),page.querySelector(".selectedSearchResult").innerHTML=resultHtml,autoFocus.call(instance)}function autoFocus(){var dlg=this.dlg;loading.hide(),focusManager.autoFocus(dlg)}function ItemIdentifier(options){this.options=options}function onItemsContainerUpgraded(){this.itemsContainer.resume({refresh:!1}).then(autoFocus.bind(this))}return ItemIdentifier.prototype.getItems=function(query){loading.show();var dlg=this.dlg;if(!dlg)return Promise.resolve([]);for(var value,item=this.options.item,apiClient=connectionManager.getApiClient(item),lookupInfo={ProviderIds:{}},identifyField=dlg.querySelectorAll(".identifyField"),i=0,length=identifyField.length;i<length;i++)(value=identifyField[i].value)&&("number"===identifyField[i].type&&(value=parseInt(value)),lookupInfo[identifyField[i].getAttribute("data-lookup")]=value);var hasId=!1,txtLookupId=dlg.querySelectorAll(".txtLookupId");for(i=0,length=txtLookupId.length;i<length;i++)(value=txtLookupId[i].value)&&(hasId=!0,lookupInfo.ProviderIds[txtLookupId[i].getAttribute("data-providerkey")]=value);if(!hasId&&!lookupInfo.Name)return require(["toast"],function(toast){toast(globalize.translate("PleaseEnterNameOrId"))}),Promise.resolve([]);item.GameSystem&&(lookupInfo.GameSystem=item.GameSystem),lookupInfo={SearchInfo:lookupInfo},item.Id?lookupInfo.ItemId=item.Id:lookupInfo.IncludeDisabledProviders=!0;var instance=this;return apiClient.ajax({type:"POST",url:apiClient.getUrl("Items/RemoteSearch/"+item.Type),data:JSON.stringify(lookupInfo),contentType:"application/json",dataType:"json"}).then(function(results){return results.forEach(function(item){var type=this.options.item.Type;item.Type=type,item.IsFolder="Series"===type||"MusicAlbum"===type,item.PrimaryImageAspectRatio="Movie"===type||"Series"===type||"Trailer"===type||"BoxSet"===type||"Person"===type?2/3:1;item.ShortOverview=item.DisambiguationComment}.bind(instance)),results})},ItemIdentifier.prototype.getCardOptions=function(items){var type=this.options.item.Type,showParentTitle="Game"===type||"MusicAlbum"===type||"MusicVideo"===type,fields=["Name"];return"Person"!==type&&"MusicArtist"!==type&&fields.push("ProductionYear"),{shape:"auto",overlayText:!1,centerText:!0,fields:fields,showParentTitle:showParentTitle,overlayPlayButton:!1,multiSelect:!1,contextMenu:!1,hoverMenu:!1,action:"custom",textLinks:!1,lazy:2,draggable:!1}},ItemIdentifier.prototype.getListViewOptions=function(items){var type=this.options.item.Type,showParentTitle="Game"===type||"MusicAlbum"===type||"MusicVideo"===type,fields=["Name"];return"Person"!==type&&"MusicArtist"!==type&&fields.push("ProductionYear"),{enableDefaultIcon:!0,showShortOverview:!0,action:"custom",showParentTitle:showParentTitle,fields:fields,artist:"MusicAlbum"===type||"MusicVideo"===type,draggable:!1,multiSelect:!1,contextMenu:!1,hoverPlayButton:!1}},ItemIdentifier.prototype.getListOptions=function(items){return"MusicAlbum"===this.options.item.Type?{renderer:listView,options:this.getListViewOptions(items)}:{renderer:cardBuilder,options:this.getCardOptions(items)}},ItemIdentifier.prototype.show=function(){var item=this.options.item,instance=this;return require(["text!./itemidentifier.template.html"]).then(function(responses){var template=responses[0],dialogOptions={removeOnClose:!0,scrollY:!1,autoFocus:!1};layoutManager.tv?dialogOptions.size="fullscreen":dialogOptions.size="fullscreen-border";var dlg=dialogHelper.createDialog(dialogOptions);(instance.dlg=dlg).classList.add("formDialog");var html="";html+=globalize.translateDocument(template,"sharedcomponents"),dlg.innerHTML=html,item.Path?dlg.querySelector(".itemPathContainer").classList.remove("hide"):dlg.querySelector(".itemPathContainer").classList.add("hide"),dlg.querySelector(".itemPath").innerHTML=item.Path||"",dlg.querySelector(".popupIdentifyForm").addEventListener("submit",instance.onIdentifyFormSubmit.bind(instance)),dlg.querySelector(".identifyOptionsForm").addEventListener("submit",instance.onResultConfirmed.bind(instance)),dlg.querySelector(".btnCancel").addEventListener("click",function(){this.result=null,this.closeDialog()}.bind(instance)),dlg.classList.add("identifyDialog"),(item.Id?function(dlg,item){var apiClient=connectionManager.getApiClient(item);apiClient.getJSON(apiClient.getUrl("Items/"+item.Id+"/ExternalIdInfos")).then(function(idList){for(var html="",providerIds=item.ProviderIds||{},i=0,length=idList.length;i<length;i++){var idInfo=idList[i],id="txtLookup"+idInfo.Key;html+='<div class="inputContainer">';var idLabel=globalize.translate("LabelDynamicExternalId").replace("{0}",idInfo.Name);idInfo.Key;html+='<input is="emby-input" class="txtLookupId" data-providerkey="'+idInfo.Key+'" id="'+id+'" label="'+idLabel+'"/>',html+="</div>"}dlg.querySelector("#txtLookupName").value="","Person"===item.Type||"BoxSet"===item.Type?dlg.querySelector(".fldLookupYear").classList.add("hide"):dlg.querySelector(".fldLookupYear").classList.remove("hide"),dlg.querySelector("#txtLookupYear").value="",dlg.querySelector(".identifyProviderIds").innerHTML=html,dlg.querySelector(".formDialogHeaderTitle").innerHTML=globalize.translate("Identify")})}:function(dlg,item){dlg.querySelector("#txtLookupName").value=item.Name||"","Person"===item.Type||"BoxSet"===item.Type?(dlg.querySelector(".fldLookupYear").classList.add("hide"),dlg.querySelector("#txtLookupYear").value=""):(dlg.querySelector(".fldLookupYear").classList.remove("hide"),dlg.querySelector("#txtLookupYear").value=item.ProductionYear||""),dlg.querySelector(".formDialogHeaderTitle").innerHTML=globalize.translate("Search")})(dlg,item);var itemsContainer=dlg.querySelector(".itemsContainer");"MusicAlbum"===item.Type&&(itemsContainer.classList.remove("vertical-wrap"),itemsContainer.classList.add("vertical-list"),dlg.querySelector(".sectionTitle-cards").classList.remove("sectionTitle-cards")),itemsContainer.addEventListener("action-null",function(e){var item=e.detail.item;if(this.currentSearchResult=item,loading.hide(),!this.options.item.Id)return this.hasChanges=!0,void this.closeDialog();var dlg=this.dlg;dlg&&showIdentifyOptions(this,dlg,item)}.bind(instance)),itemsContainer.fetchData=instance.getItems.bind(instance),itemsContainer.getListOptions=instance.getListOptions.bind(instance),instance.itemsContainer=itemsContainer,dlg.addEventListener("opened",function(){var itemsContainer=this.itemsContainer;itemsContainer.resume?onItemsContainerUpgraded.call(this):dom.addEventListener(itemsContainer,"upgraded",onItemsContainerUpgraded.bind(this),{once:!0})}.bind(instance));var dlgClosedFn=function(){loading.hide();var hasChanges=this.hasChanges;return this.cleanup(),hasChanges?Promise.resolve(this.currentSearchResult):Promise.reject()}.bind(instance);return dialogHelper.open(dlg).then(dlgClosedFn,dlgClosedFn)})},ItemIdentifier.prototype.onIdentifyFormSubmit=function(e){e.preventDefault(),e.stopPropagation();var dlg=this.dlg;dlg&&(dlg.querySelector(".popupIdentifyForm").classList.add("hide"),dlg.querySelector(".identificationSearchResults").classList.remove("hide"),dlg.querySelector(".identifyOptionsForm").classList.add("hide"));var itemsContainer=this.itemsContainer;return itemsContainer&&itemsContainer.refreshItems().then(autoFocus.bind(this)),!1},ItemIdentifier.prototype.onResultConfirmed=function(e){e.preventDefault(),e.stopPropagation();var apiClient,instance,dlg=this.dlg;return dlg&&(loading.show(),apiClient=connectionManager.getApiClient(this.options.item),instance=this,apiClient.ajax({type:"POST",url:apiClient.getUrl("Items/RemoteSearch/Apply/"+this.options.item.Id,{ReplaceAllImages:dlg.querySelector("#chkIdentifyReplaceImages").checked}),data:JSON.stringify(instance.currentSearchResult),contentType:"application/json"}).then(function(){instance.hasChanges=!0,loading.hide(),dialogHelper.close(dlg)},function(){loading.hide()})),!1},ItemIdentifier.prototype.closeDialog=function(){var dlg=this.dlg;dlg&&dialogHelper.close(dlg)},ItemIdentifier.prototype.cleanup=function(){this.options=null,this.dlg=null,this.itemsContainer=null},{show:function(item){return new ItemIdentifier({item:item}).show()},showFindNew:function(itemName,itemYear,itemType,serverId){return new ItemIdentifier({item:{Name:itemName,ProductionYear:itemYear,Type:itemType,ServerId:serverId}}).show()}}});