define([],function(){"use strict";var indexedDB=self.indexedDB;function getObjectByKey(db,key,storeName){return new Promise(function(resolve,reject){var request=getStore(db,storeName).get(key);request.onerror=reject,request.onsuccess=function(){resolve(request.result)}})}function getObjectsBySingleIndexKey(db,indexName,key,storeName){return new Promise(function(resolve,reject){storeName=storeName||db.name;var results,request,index=db.transaction([storeName],"readonly").objectStore(storeName).index(indexName);"function"==typeof index.getAll?(request=index.getAll(key)).onsuccess=function(event){resolve(event.target.result)}:(results=[],(request=index.openCursor(key)).onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.value),cursor.continue()):resolve(results)}),request.onerror=reject})}function getStore(db,storeName,access){return storeName=storeName||db.name,access=access||"readonly",db.transaction(storeName,access).objectStore(storeName)}return{addObject:function(db,key,val,storeName){return new Promise(function(resolve,reject){var request=getStore(db,storeName,"readwrite").put(val,key);request.onerror=reject,request.onsuccess=resolve})},updateObject:function(db,key,val,storeName){return new Promise(function(resolve,reject){var request=getStore(db,storeName,"readwrite").put(val,key);request.onerror=reject,request.onsuccess=function(){resolve(request.result)}})},deleteObject:function(db,key,storeName){return new Promise(function(resolve,reject){var request=getStore(db,storeName,"readwrite").delete(key);request.onerror=reject,request.onsuccess=resolve})},clearObjects:function(db,storeName){return new Promise(function(resolve,reject){var request=getStore(db,storeName,"readwrite").clear();request.onerror=reject,request.onsuccess=resolve})},getAllObjects:function(db,storeName){return new Promise(function(resolve,reject){var results,request,objectStore=getStore(db,storeName);"function"==typeof objectStore.getAll?(request=objectStore.getAll()).onsuccess=function(event){resolve(event.target.result)}:(results=[],(request=objectStore.openCursor()).onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.value),cursor.continue()):resolve(results)}),request.onerror=reject})},getObjectByKey:getObjectByKey,getObjectsByKeys:function(db,keys,storeName){return Array.isArray(keys)&&1!==keys.length?(4<keys.length?function(db,keys,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName),set=keys.slice(0);set.sort(function(a,b){return indexedDB.cmp(a,b)});var i=0,range=IDBKeyRange.bound(set[0],set[set.length-1]),results=[],request=objectStore.openCursor(range);request.onsuccess=function(event){var cursor=event.target.result;if(cursor){for(var key=cursor.key;0<indexedDB.cmp(key,set[i]);)if(++i===set.length)return void resolve(results);key===set[i]?(results.push(cursor.value),cursor.continue()):cursor.continue(set[i])}else resolve(results)},request.onerror=reject})}:function(db,keys,storeName){var actions=keys.map(function(key){return getObjectByKey(db,key,storeName)});return Promise.all(actions).then(function(results){var flattened=results.reduce(function(acc,val){return acc.concat(val)},[]);return Promise.resolve(flattened)})})(db,keys,storeName):getObjectByKey(db,Array.isArray(keys)?keys[0]:keys,storeName)},getObjectsByIndexKeys:function(db,indexName,keys,storeName){return Array.isArray(keys)&&1!==keys.length?(4<keys.length?function(db,indexName,keys,storeName){return new Promise(function(resolve,reject){var index=getStore(db,storeName).index(indexName),set=keys.slice(0);set.sort(function(a,b){return indexedDB.cmp(a,b)});var i=0,range=IDBKeyRange.bound(set[0],set[set.length-1]),results=[],request=index.openCursor(range);request.onsuccess=function(event){var cursor=event.target.result;if(cursor){for(var key=cursor.key;0<indexedDB.cmp(key,set[i]);)if(++i===set.length)return void resolve(results);key===set[i]?(results.push(cursor.value),cursor.continue()):cursor.continue(set[i])}else resolve(results)},request.onerror=reject})}:function(db,indexName,keys,storeName){var actions=keys.map(function(key){return getObjectsBySingleIndexKey(db,indexName,key,storeName)});return Promise.all(actions).then(function(results){var flattened=results.reduce(function(acc,val){return acc.concat(val)},[]);return Promise.resolve(flattened)})})(db,indexName,keys,storeName):getObjectsBySingleIndexKey(db,indexName,Array.isArray(keys)?keys[0]:keys,storeName)},getDistinctndexKeys:function(db,indexName,storeName){return new Promise(function(resolve,reject){var index=getStore(db,storeName).index(indexName),results=[],request=index.openKeyCursor(null,"nextunique");request.onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.key),cursor.continue()):resolve(results)},request.onerror=reject})}}});