define(["idbcore"],function(idb){"use strict";var indexedDB=self.indexedDB,libraryDbVersion=3,databases={};function getLibraryDb(serverId){var dbName;return dbName="items_"+serverId,new Promise(function(resolve,reject){var request;dbName in databases?resolve(databases[dbName]):((request=indexedDB.open(dbName,libraryDbVersion)).onerror=reject,request.onblocked=reject,request.onupgradeneeded=function(event){var objectStore,db=request.result;event.oldVersion<1&&db.createObjectStore(dbName),event.oldVersion<3&&((objectStore=request.transaction.objectStore(dbName)).createIndex("Index_ItemType","Item.Type"),objectStore.createIndex("Index_SyncStatus","SyncStatus"))},request.onsuccess=function(event){var db=event.target.result;db.onversionchange=function(){db.close(),delete databases[dbName]},databases[dbName]=db,resolve(db)})})}function getLibraryItemsByIds(serverId,ids){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByKeys(db,ids).then(function(items){return items=items||[],Array.isArray(items)||(items=[items]),items.sort(function(a,b){var indexA=ids.indexOf(a.Id),indexB=ids.indexOf(b.Id);return indexedDB.cmp(indexA,indexB)}),Promise.resolve(items)})})}function getLibraryItemsByType(serverId,itemTypes,options){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_ItemType",itemTypes)})}function getAllLibraryItems(serverId){return getLibraryDb(serverId).then(function(db){return idb.getAllObjects(db)})}function getLibraryItem(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.getObjectByKey(db,key)})}function normalizeId(id){return id?(id=stripStart(id,"localview:"),id=stripStart(id,"local:")):null}function stripStart(str,find){return function(str,find){if(str&&find&&str.length>find.length&&0===str.indexOf(find))return!0;return!1}(str,find)?str.substr(find.length):str}return{getLibarytemTypes:function(serverId){return getLibraryDb(serverId).then(function(db){return idb.getDistinctndexKeys(db,"Index_ItemType")})},getLibraryItemsByIds:getLibraryItemsByIds,getLibraryItemPathsByIds:function(serverId,ids){return getLibraryItemsByIds(serverId,ids).then(function(items){var paths=items.reduce(function(result,item){var id_path,mediaSource;return item&&(id_path={ItemId:item.ItemId,LocalPath:""},item.LocalPath?id_path.LocalPath=item.LocalPath:item.Item&&item.Item.MediaSources&&item.Item.MediaSources.length&&(mediaSource=item.Item.MediaSources[0],id_path.LocalPath=mediaSource.StreamUrl||mediaSource.Path),result.push(id_path)),result},[]);return Promise.resolve(paths)}).catch(function(error){return Promise.resolve([])})},getLibraryItemsBySyncStatus:function(serverId,syncStati){return getLibraryDb(serverId).then(function(db){return idb.getObjectsByIndexKeys(db,"Index_SyncStatus",syncStati)})},getLibraryItemsByType:getLibraryItemsByType,getAllLibraryItems:getAllLibraryItems,getLibraryItem:getLibraryItem,getLibraryItems:function(serverId,options){var searchParentId=normalizeId(searchParentId=options.ParentId),seasonId=normalizeId(options.SeasonId||options.seasonId),seriesId=normalizeId(options.SeriesId||options.seriesId),albumIds=function(val){if(val)return val.split(",").map(normalizeId);return[]}(options.AlbumIds||options.albumIds),includeItemTypes=options.IncludeItemTypes?options.IncludeItemTypes.split(","):[],filters=options.Filters?options.Filters.split(","):[],mediaTypes=options.MediaTypes?options.MediaTypes.split(","):[];!function(parentId,includeItemTypes,query){switch(parentId){case"MusicView":return query.Recursive?includeItemTypes.push("Audio"):includeItemTypes.push("MusicAlbum"),!0;case"PhotosView":return query.Recursive?includeItemTypes.push("Photo"):includeItemTypes.push("PhotoAlbum"),!0;case"TVView":return query.Recursive?includeItemTypes.push("Episode"):includeItemTypes.push("Series"),!0;case"VideosView":return query.Recursive,includeItemTypes.push("Video"),!0;case"MoviesView":return query.Recursive,includeItemTypes.push("Movie"),!0;case"MusicVideosView":return query.Recursive,includeItemTypes.push("MusicVideo"),!0;case"TrailersView":return query.Recursive,includeItemTypes.push("Trailer"),!0}return!1}(searchParentId,includeItemTypes,options)||(searchParentId=null);var getPromise=Promise.resolve();return searchParentId&&(getPromise=getLibraryItem(serverId,searchParentId).then(function(item){item&&item.Item&&"MusicAlbum"===item.Item.Type&&(options.Recursive=!0,includeItemTypes.push("Audio"))})),(getPromise=includeItemTypes.length?getPromise.then(function(){var includeSet=Array.from(new Set(includeItemTypes));return includeItemTypes=[],getLibraryItemsByType(serverId,includeSet)}):getPromise.then(function(){return getAllLibraryItems(serverId)})).then(function(items){var addSubtreeIds,searchParentItem,itemsMap=new Map,subtreeIdSet=new Set;items.forEach(function(item){item.Item.LocalChildren=[],itemsMap.set(item.Item.Id,item.Item)}),itemsMap.forEach(function(item){item.ParentId&&itemsMap.has(item.ParentId)&&itemsMap.get(item.ParentId).LocalChildren.push(item)}),options.Recursive&&searchParentId&&itemsMap.has(searchParentId)&&(addSubtreeIds=function(recurseItem){subtreeIdSet.has(recurseItem.Id)||subtreeIdSet.add(recurseItem.Id),recurseItem.LocalChildren.forEach(function(childItem){addSubtreeIds(childItem)})},searchParentItem=itemsMap.get(searchParentId),addSubtreeIds(searchParentItem));var resultItems=items.filter(function(item){return(!item.SyncStatus||"synced"===item.SyncStatus)&&((!mediaTypes.length||-1!==mediaTypes.indexOf(item.Item.MediaType||""))&&((!seriesId||item.Item.SeriesId===seriesId)&&((!seasonId||item.Item.SeasonId===seasonId)&&((!albumIds.length||-1!==albumIds.indexOf(item.Item.AlbumId||""))&&((!item.Item.IsFolder||-1===filters.indexOf("IsNotFolder"))&&(!(!item.Item.IsFolder&&-1!==filters.indexOf("IsFolder"))&&((!includeItemTypes.length||-1!==includeItemTypes.indexOf(item.Item.Type||""))&&(!searchParentId||(options.Recursive?subtreeIdSet.has(item.Item.Id):item.Item.ParentId===searchParentId)))))))))}).map(function(item2){return item2.Item}),totalRecordCount=(resultItems=function(items,query){query.LocalSortBy&&0!==query.LocalSortBy.length&&(query.SortBy=query.LocalSortBy);if(!query.SortBy||0===query.SortBy.length)return items;if("Random"===query.SortBy)return function(array){var temporaryValue,randomIndex,currentIndex=array.length;for(;0!==currentIndex;)randomIndex=Math.floor(Math.random()*currentIndex),temporaryValue=array[--currentIndex],array[currentIndex]=array[randomIndex],array[randomIndex]=temporaryValue;return array}(items);var sortSpec=function(query){for(var sortFields=(query.SortBy||"").split(","),sortOrders=(query.SortOrder||"").split(","),sortSpec=[],i=0;i<sortFields.length;i++){var orderDesc=!1;i<sortOrders.length&&-1!==sortOrders[i].toLowerCase().indexOf("desc")&&(orderDesc=!0),sortSpec.push({Field:sortFields[i],OrderDescending:orderDesc})}return sortSpec}(query);return items.sort(function(a,b){for(var i=0;i<sortSpec.length;i++){var result=function(a,b,field,orderDesc){if(!a.hasOwnProperty(field)||!b.hasOwnProperty(field))return 0;var valA=a[field],valB=b[field],result=0;"string"==typeof valA||"string"==typeof valB?(valB=valB||"",result=(valA=valA||"").toLowerCase().localeCompare(valB.toLowerCase())):valB<valA?result=1:valA<valB&&(result=-1);orderDesc&&(result*=-1);return result}(a,b,sortSpec[i].Field,sortSpec[i].OrderDescending);if(0!==result)return result}return 0}),items}(resultItems,options)).length;return options.StartIndex&&(resultItems=resultItems.slice(options.StartIndex)),null!=options.Limit&&(resultItems=resultItems.slice(0,options.Limit)),Promise.resolve({Items:resultItems,TotalRecordCount:totalRecordCount})})},addLibraryItem:function(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.addObject(db,key,val)})},updateLibraryItem:function(serverId,key,val){return getLibraryDb(serverId).then(function(db){return idb.updateObject(db,key,val)})},deleteLibraryItem:function(serverId,key){return getLibraryDb(serverId).then(function(db){return idb.deleteObject(db,key)})},clearLibrary:function(serverId){return getLibraryDb(serverId).then(function(db){return idb.clearObjects(db)})}}});