define(["filerepository","transfermanager","itemrepository"],function(filerepository,transfermanager,itemrepository){"use strict";function getImageUrl(serverId,itemId,imageOptions){var pathArray=getImagePath(0,itemId,imageOptions.type,imageOptions.index);return filerepository.getImageUrl(pathArray)}function getImagePath(serverId,itemId,imageType,index){var parts=[];parts.push("images"),index=index||0,parts.push(itemId+"_"+imageType+"_"+index.toString());for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(parts[i]);return finalParts}return{getDirectoryPath:function(item){var parts=[],itemtype=item.Type.toLowerCase(),mediaType=(item.MediaType||"").toLowerCase();"episode"===itemtype||"series"===itemtype||"season"===itemtype?parts.push("TV"):"trailer"===itemtype?parts.push("Trailers"):"video"===mediaType?parts.push("Videos"):"audio"===itemtype||"musicalbum"===itemtype||"musicartist"===itemtype?parts.push("Music"):"photo"===itemtype||"photoalbum"===itemtype?parts.push("Photos"):"game"!==itemtype&&"gamesystem"!==itemtype||parts.push("Games");var albumArtist=item.AlbumArtist;albumArtist&&parts.push(albumArtist);var seriesName=item.SeriesName;seriesName&&parts.push(seriesName);var seasonName=item.SeasonName;seasonName&&parts.push(seasonName),item.Album&&parts.push(item.Album),item.GameSystem&&parts.push(item.GameSystem),("video"===mediaType&&"episode"!==itemtype||"game"===itemtype||item.IsFolder)&&parts.push(item.Name);for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(filerepository.getValidFileName(parts[i]));return finalParts},getLocalFileName:function(item,originalFileName){var filename=originalFileName||item.Name;return filerepository.getValidFileName(filename)},removeLocalItem:function(localItem){return itemrepository.getLibraryItem(localItem.ServerId,localItem.ItemId).then(function(item){function onFileDeletedSuccessOrFail(){return itemrepository.deleteLibraryItem(localItem.ServerId,localItem.ItemId)}var p=Promise.resolve();return item.LocalPath&&(p=p.then(function(){return filerepository.deleteFile(item.LocalPath)})),item&&item.Item&&item.Item.MediaSources&&item.Item.MediaSources.forEach(function(mediaSource){mediaSource.MediaStreams&&0<mediaSource.MediaStreams.length&&mediaSource.MediaStreams.forEach(function(mediaStream){mediaStream.Path&&(p=p.then(function(){return filerepository.deleteFile(mediaStream.Path)}))})}),p.then(onFileDeletedSuccessOrFail,onFileDeletedSuccessOrFail)},function(){return Promise.resolve()})},downloadFile:function(url,localItem){var imageUrl=getImageUrl(localItem.Item.ServerId,localItem.Item.Id,{type:"Primary",index:0});return transfermanager.downloadFile(url,localItem,imageUrl)},downloadSubtitles:function(url,fileName){return transfermanager.downloadSubtitles(url,fileName)},hasImage:function(serverId,itemId,imageType,index){var pathArray=getImagePath(0,itemId,imageType,index),localFilePath=filerepository.getFullMetadataPath(pathArray);return filerepository.fileExists(localFilePath).then(function(exists){return Promise.resolve(exists)},function(){return Promise.resolve(!1)})},downloadImage:function(localItem,url,serverId,itemId,imageType,index){var localPathParts=getImagePath(0,itemId,imageType,index);return transfermanager.downloadImage(url,localPathParts)},getImageUrl:getImageUrl,getSubtitleSaveFileName:function(localItem,mediaPath,language,isForced,format){var name=function(path){var fileName=path,pos=fileName.lastIndexOf(".");0<pos&&(fileName=fileName.substring(0,pos));return fileName}(mediaPath),name=filerepository.getValidFileName(name);language&&(name+="."+language.toLowerCase()),isForced&&(name+=".forced"),name=name+"."+format.toLowerCase();var mediaFolder=filerepository.getParentPath(localItem.LocalPath);return filerepository.combinePath(mediaFolder,name)},getItemFileSize:function(path){return filerepository.getItemFileSize(path)},isDownloadFileInQueue:function(path){return transfermanager.isDownloadFileInQueue(path)},getDownloadItemCount:function(){return transfermanager.getDownloadItemCount()},resyncTransfers:function(){return transfermanager.resyncTransfers()},fileExists:function(localFilePath){return filerepository.fileExists(localFilePath)},enableBackgroundCompletion:function(){return transfermanager.enableBackgroundCompletion}}});