define(["datetime","connectionManager","globalize","appRouter","itemHelper","indicators","material-icons","css!./mediainfo.css","programStyles","emby-linkbutton"],function(datetime,connectionManager,globalize,appRouter,itemHelper,indicators){"use strict";function getHumanReadableRuntime(ticks){try{var days=Math.trunc(ticks/864e9),hours=Math.trunc(ticks%864e9/36e9),mins=Math.trunc(ticks%36e9/6e8),parts=[];return days&&parts.push(days+"d"),hours&&parts.push(hours+"h"),mins&&parts.push(mins+"m"),parts.length?parts.join(" "):datetime.getDisplayRunningTime(ticks)}catch(err){return datetime.getDisplayRunningTime(ticks)}}function getProgramInfoHtml(item,options){var text,date,timerHtml,html="",miscInfo=[];if(item.StartDate&&!1!==options.programTime)try{text="",date=datetime.parseISO8601Date(item.StartDate),!1!==options.startDate&&(text+=datetime.toLocaleDateString(date,{weekday:"short",month:"short",day:"numeric"})),text+=" "+datetime.getDisplayTime(date),item.EndDate&&(date=datetime.parseISO8601Date(item.EndDate),text+=" &ndash; "+datetime.getDisplayTime(date)),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.StartDate)}return item.ChannelNumber&&miscInfo.push("CH "+item.ChannelNumber),item.ChannelName&&(options.interactive&&item.ChannelId?miscInfo.push({html:'<a is="emby-linkbutton" style="color:inherit;" class="button-link mediaInfoItem" href="'+appRouter.getRouteUrl({ServerId:item.ServerId,Type:"TvChannel",Name:item.ChannelName,Id:item.ChannelId})+'">'+item.ChannelName+"</a>"}):miscInfo.push(item.ChannelName)),!options.timerIndicator||(timerHtml=function(item){var status;if("SeriesTimer"===item.Type)return'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE062;</i>';if(item.TimerId||item.SeriesTimerId)status=item.Status||"Cancelled";else{if("Timer"!==item.Type)return"";status=item.Status}return item.SeriesTimerId?"Cancelled"!==status?'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE062;</i>':'<i class="md-icon mediaInfoItem mediaInfoIconItem">&#xE062;</i>':'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE061;</i>'}(item))&&miscInfo.push({html:timerHtml}),html+=miscInfo.map(getMediaInfoItem).join("")}function getEndsAt(item){if("Video"!==item.MediaType||!item.RunTimeTicks||item.StartDate||"Program"===item.Type)return null;var positionTicks=item.UserData&&item.UserData.PlaybackPositionTicks||0;return getEndsAtFromPosition(item.RunTimeTicks,positionTicks)}function getEndsAtFromPosition(runtimeTicks,positionTicks,includeText){var endDate=Date.now()+(runtimeTicks-(positionTicks||0))/1e4,endDate=new Date(endDate),displayTime=datetime.getDisplayTime(endDate);return!1===includeText?displayTime:globalize.translate("EndsAtValue",displayTime)}function getMediaInfoItem(m,cssClass){cssClass=cssClass?cssClass+" mediaInfoItem":"mediaInfoItem";var mediaInfoText=m;if("string"!=typeof m&&"number"!=typeof m){if(m.html)return m.html;mediaInfoText=m.text,cssClass+=" "+m.cssClass}return'<div class="'+cssClass+'">'+mediaInfoText+"</div>"}function getCriticRating(item,options){var outerClass="mediaInfoItem mediaInfoCriticRating";return options&&options.outerClass&&(outerClass+=" "+options.outerClass),60<=item.CriticRating?outerClass+=" mediaInfoCriticRatingFresh":outerClass+=" mediaInfoCriticRatingRotten",'<div class="'+outerClass+'">'+item.CriticRating+"%</div>"}function getStarIconsHtml(item,options){var outerClass,html="",rating=item.CommunityRating;return rating&&(outerClass="starRatingContainer mediaInfoItem",options&&options.outerClass&&(outerClass+=" "+options.outerClass),html+='<div class="'+outerClass+'">',html+='<i class="md-icon starIcon">&#xE838;</i>',html+=rating,html+="</div>"),html}function fillPrimaryMediaInfo(elem,item,options){var html=getPrimaryMediaInfoHtml(item,options);(elem.innerHTML=html)?elem.classList.remove("hide"):elem.classList.add("hide"),afterFill(elem,item,options)}function afterFill(elem,item,options){var endsAtElem;!1!==options.endsAt&&(endsAtElem=elem.querySelector(".endsAt"))&&function(elem,item){var interval=setInterval(function(){document.body.contains(elem)?elem.innerHTML=getEndsAt(item):clearInterval(interval)},6e4)}(endsAtElem,item)}function getPrimaryMediaInfoHtml(item,options){return null==(options=options||{}).interactive&&(options.interactive=!1),function(item,options){var text,date,html="",miscInfo=[];options=options||{};var studioHtml,studio,count,endsAt,dateCreated,showFolderRuntime="MusicAlbum"===item.Type||"MusicArtist"===item.Type||"Playlist"===item.Type||"MusicGenre"===item.Type;if(("Episode"===item.Type||"Photo"===item.MediaType)&&!1!==options.originalAirDate&&item.PremiereDate)try{date=datetime.parseISO8601Date(item.PremiereDate),text=datetime.toLocaleDateString(date),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}if("SeriesTimer"===item.Type&&(item.RecordAnyTime?miscInfo.push(globalize.translate("Anytime")):miscInfo.push(datetime.getDisplayTime(item.StartDate)),item.RecordAnyChannel?miscInfo.push(globalize.translate("AllChannels")):miscInfo.push(item.ChannelName||globalize.translate("OneChannel"))),item.StartDate&&"Program"!==item.Type&&"SeriesTimer"!==item.Type)try{date=datetime.parseISO8601Date(item.StartDate),text=datetime.toLocaleDateString(date),miscInfo.push(text),"Recording"!==item.Type&&(text=datetime.getDisplayTime(date),miscInfo.push(text))}catch(e){console.log("Error parsing date: "+item.StartDate)}if(!1!==options.year&&item.ProductionYear&&"Series"===item.Type)if("Continuing"===item.Status)miscInfo.push(globalize.translate("SeriesYearToPresent",item.ProductionYear));else if(item.ProductionYear){if(text=item.ProductionYear,item.EndDate)try{datetime.parseISO8601Date(item.EndDate).getFullYear()!==item.ProductionYear&&(text+=" &ndash; "+datetime.parseISO8601Date(item.EndDate).getFullYear())}catch(e){console.log("Error parsing date: "+item.EndDate)}miscInfo.push(text)}if("Series"===item.Type&&(studioHtml="",item.Studios&&item.Studios.length&&(studio=item.Studios[0],studioHtml&&(studioHtml+=" on "),studioHtml+='<a style="color:inherit;" class="button-link" is="emby-linkbutton" href="'+appRouter.getRouteUrl({Name:studio.Name,Type:"Studio",ServerId:item.ServerId,Id:studio.Id})+'">'+studio.Name+"</a>"),studioHtml&&miscInfo.push(studioHtml)),"Program"===item.Type)if(!1!==options.programIndicator&&(item.IsLive?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem liveTvProgram">'+globalize.translate("Live")+"</div>"}):item.IsPremiere?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem premiereTvProgram">'+globalize.translate("Premiere")+"</div>"}):item.IsNew?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem newTvProgram">'+globalize.translate("AttributeNew")+"</div>"}):item.IsRepeat&&miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem repeatTvProgram secondaryText">'+globalize.translate("Repeat")+"</div>"})),(item.IsSeries||item.EpisodeTitle)&&!1!==options.episodeTitle)(text=itemHelper.getDisplayName(item,{includeIndexNumber:options.episodeTitleIndexNumber}))&&miscInfo.push(text);else if(item.IsMovie&&item.ProductionYear&&!1!==options.originalAirDate)miscInfo.push(item.ProductionYear);else if(item.PremiereDate&&!1!==options.originalAirDate)try{date=datetime.parseISO8601Date(item.PremiereDate),text=globalize.translate("OriginalAirDateValue",datetime.toLocaleDateString(date)),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}else item.ProductionYear&&miscInfo.push(item.ProductionYear);if(!1!==options.year&&"Series"!==item.Type&&"Episode"!==item.Type&&"Person"!==item.Type&&"Photo"!==item.MediaType&&"Program"!==item.Type&&"Season"!==item.Type)if(item.ProductionYear)miscInfo.push(item.ProductionYear);else if(item.PremiereDate)try{text=datetime.parseISO8601Date(item.PremiereDate).getFullYear(),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}return item.RunTimeTicks&&"Series"!==item.Type&&"Program"!==item.Type&&!showFolderRuntime&&!1!==options.runtime&&("Audio"===item.Type?miscInfo.push(datetime.getDisplayRunningTime(item.RunTimeTicks)):miscInfo.push(getHumanReadableRuntime(item.RunTimeTicks))),item.OfficialRating&&miscInfo.push({text:item.OfficialRating}),showFolderRuntime&&((count=item.SongCount||item.ChildCount)&&(1===count?miscInfo.push(globalize.translate("OneTrack")):miscInfo.push(globalize.translate("TrackCount",count))),item.RunTimeTicks&&"Playlist"===item.Type&&miscInfo.push(getHumanReadableRuntime(item.RunTimeTicks))),"Series"===item.Type&&item.ChildCount&&(1===item.ChildCount?miscInfo.push(globalize.translate("OneSeason")):miscInfo.push(globalize.translate("NumberSeasonsValue",item.ChildCount))),item.Video3DFormat&&miscInfo.push("3D"),"Photo"===item.MediaType&&item.Width&&item.Height&&miscInfo.push(item.Width+"x"+item.Height),!1!==options.container&&"Audio"===item.Type&&item.Container&&miscInfo.push(item.Container),!1!==options.CommunityRating&&item.CommunityRating&&(html+=getStarIconsHtml(item)),item.CriticRating&&!1!==options.criticRating&&(html+=getCriticRating(item)),html+=miscInfo.map(getMediaInfoItem).join(""),item.HasSubtitles&&!1!==options.subtitles&&(html+='<div class="mediaInfoItem mediaInfoText closedCaptionMediaInfoText">CC</div>'),!1===options.endsAt||(endsAt=getEndsAt(item))&&(html+=getMediaInfoItem(endsAt,"endsAt")),options.dateAdded&&itemHelper.enableDateAddedDisplay(item)&&(dateCreated=datetime.parseISO8601Date(item.DateCreated),html+=getMediaInfoItem(globalize.translate("AddedOnValue",datetime.toLocaleDateString(dateCreated)))),html+=indicators.getMissingIndicator(item)}(item,options)}function getSecondaryMediaInfoHtml(item,options){return null==(options=options||{}).interactive&&(options.interactive=!1),"Program"===item.Type?getProgramInfoHtml(item,options):""}function getResolutionText(i){var width=i.Width,height=i.Height;if(width&&height){if(3800<=width||2e3<=height)return"4K";if(2500<=width||1400<=height)return i.IsInterlaced?"1440i":"1440P";if(1800<=width||1e3<=height)return i.IsInterlaced?"1080i":"1080P";if(1200<=width||700<=height)return i.IsInterlaced?"720i":"720P";if(700<=width||400<=height)return i.IsInterlaced?"480i":"480P"}return null}function createAttribute(label,value,className){return className=className?className+" ":className,className+=" flex",'<div class="'+(className+=" mediaStreamAttribute")+'"><span class="mediaInfoAttributeLabel">'+label+'</span><span class="mediaInfoAttributeValue">'+value+"</span></div>"}function intToString(value){try{return new Intl.NumberFormat(globalize.getCurrentLocales(),{style:"decimal"}).format(value)}catch(err){return console.log("Error in NumberFormat: "+err),value}}return{getMediaInfoHtml:getPrimaryMediaInfoHtml,fill:fillPrimaryMediaInfo,getEndsAt:getEndsAt,getEndsAtFromPosition:getEndsAtFromPosition,getPrimaryMediaInfoHtml:getPrimaryMediaInfoHtml,getSecondaryMediaInfoHtml:getSecondaryMediaInfoHtml,fillPrimaryMediaInfo:fillPrimaryMediaInfo,fillSecondaryMediaInfo:function(elem,item,options){var html=getSecondaryMediaInfoHtml(item,options);elem.innerHTML=html,afterFill(elem,item,options)},getMediaInfoStats:function(item,options){var list=[],videoStream=(((item.MediaSources||[])[0]||{}).MediaStreams||[]).filter(function(i){return"Video"===i.Type})[0]||{},audioStream=function(item){if(!item.MediaSources)return null;var mediaSource=item.MediaSources[0];return mediaSource?(mediaSource.MediaStreams||[]).filter(function(i){return"Audio"===i.Type&&(i.Index===mediaSource.DefaultAudioStreamIndex||null==mediaSource.DefaultAudioStreamIndex)})[0]:null}(item)||{};"Dvd"!==item.VideoType&&"dvd"!==item.Container||list.push({type:"mediainfo",text:"Dvd"}),"BluRay"!==item.VideoType&&"bluray"!==item.Container||list.push({type:"mediainfo",text:"BluRay"});var resolutionText=getResolutionText(videoStream);resolutionText&&list.push({type:"mediainfo",text:resolutionText}),videoStream.Codec&&list.push({type:"mediainfo",text:videoStream.Codec});var channelText,channels=audioStream.Channels;8===channels?channelText="7.1":7===channels?channelText="6.1":6===channels?channelText="5.1":2===channels&&(channelText="2.0"),channelText&&list.push({type:"mediainfo",text:channelText});var dateCreated,audioCodec=(audioStream.Codec||"").toLowerCase();return"dca"!==audioCodec&&"dts"!==audioCodec||!audioStream.Profile?audioStream.Codec&&list.push({type:"mediainfo",text:audioStream.Codec}):list.push({type:"mediainfo",text:audioStream.Profile}),item.DateCreated&&itemHelper.enableDateAddedDisplay(item)&&(dateCreated=datetime.parseISO8601Date(item.DateCreated),list.push({type:"added",text:globalize.translate("AddedOnValue",datetime.toLocaleDateString(dateCreated)+" "+datetime.getDisplayTime(dateCreated))})),list},getResolutionText:getResolutionText,pushMediaStreamLines:function(stream,options,lines,icon){var streamType=stream.StreamType,streamTypeLocalizationKey="EmbeddedImage"===streamType?"Image":streamType,displayType=globalize.translate(streamTypeLocalizationKey);icon&&(displayType='<i class="md-icon mediaStreamTypeIcon">'+icon+"</i>"+displayType),lines.push('<h3 style="margin: .6em 0 .8em;" class="flex align-items-center">'+displayType+"</h3>"),stream.DisplayTitle&&lines.push(createAttribute(globalize.translate("Title"),stream.DisplayTitle)),stream.Title&&stream.Title!==stream.DisplayTitle&&lines.push(createAttribute(globalize.translate("HeaderEmbeddedTitle"),stream.Title)),(stream.DisplayLanguage||stream.Language)&&"Video"!==streamType&&lines.push(createAttribute(globalize.translate("Language"),stream.DisplayLanguage||stream.Language)),stream.Codec&&lines.push(createAttribute(globalize.translate("Codec"),stream.Codec.toUpperCase())),stream.CodecTag&&lines.push(createAttribute(globalize.translate("HeaderCodecTag"),stream.CodecTag)),null!=stream.IsAVC&&lines.push(createAttribute("AVC",stream.IsAVC?globalize.translate("Yes"):globalize.translate("No"))),stream.Profile&&lines.push(createAttribute(globalize.translate("Profile"),stream.Profile)),stream.Level&&lines.push(createAttribute(globalize.translate("Level"),stream.Level)),(stream.Width||stream.Height)&&lines.push(createAttribute(globalize.translate("Resolution"),stream.Width+"x"+stream.Height)),stream.AspectRatio&&"mjpeg"!==stream.Codec&&lines.push(createAttribute(globalize.translate("HeaderAspectRatio"),stream.AspectRatio)),"Video"===streamType&&lines.push(createAttribute(globalize.translate("Interlaced"),stream.IsInterlaced?globalize.translate("Yes"):globalize.translate("No"))),(stream.AverageFrameRate||stream.RealFrameRate)&&lines.push(createAttribute(globalize.translate("Framerate"),intToString(stream.AverageFrameRate||stream.RealFrameRate))),stream.ChannelLayout&&lines.push(createAttribute(globalize.translate("Layout"),stream.ChannelLayout)),stream.Channels&&lines.push(createAttribute(globalize.translate("Channels"),stream.Channels+" ch")),stream.BitRate&&"mjpeg"!==stream.Codec&&lines.push(createAttribute(globalize.translate("Bitrate"),intToString(parseInt(stream.BitRate/1e3))+" kbps")),stream.SampleRate&&lines.push(createAttribute(globalize.translate("HeaderSampleRate"),intToString(stream.SampleRate)+" Hz")),stream.VideoRange&&"SDR"!==stream.VideoRange&&lines.push(createAttribute(globalize.translate("HeaderVideoRange"),stream.VideoRange)),stream.ColorPrimaries&&lines.push(createAttribute(globalize.translate("HeaderColorPrimaries"),stream.ColorPrimaries)),stream.ColorSpace&&lines.push(createAttribute(globalize.translate("HeaderColorSpace"),stream.ColorSpace)),stream.ColorTransfer&&lines.push(createAttribute(globalize.translate("HeaderColorTransfer"),stream.ColorTransfer)),stream.BitDepth&&lines.push(createAttribute(globalize.translate("HeaderBitDepth"),stream.BitDepth+" bit")),stream.PixelFormat&&lines.push(createAttribute(globalize.translate("HeaderPixelFormat"),stream.PixelFormat)),stream.RefFrames&&lines.push(createAttribute(globalize.translate("HeaderReferenceFrames"),stream.RefFrames)),"Video"!==streamType&&lines.push(createAttribute(globalize.translate("Default"),stream.IsDefault?globalize.translate("Yes"):globalize.translate("No"))),"Subtitle"===streamType&&(lines.push(createAttribute(globalize.translate("Forced"),stream.IsForced?globalize.translate("Yes"):globalize.translate("No"))),lines.push(createAttribute(globalize.translate("External"),stream.IsExternal?globalize.translate("Yes"):globalize.translate("No")))),stream.Extradata&&lines.push(createAttribute(globalize.translate("HeaderExtradata"),stream.Extradata)),stream.IsExternal&&stream.Path&&lines.push(createAttribute(globalize.translate("File"),function(stream){var parts=stream.Path.split("/").join("\\").split("\\");return parts[parts.length-1]}(stream)))},getCommunityRating:getStarIconsHtml,getCriticRating:getCriticRating}});