define(["itemHelper","itemShortcuts","apphost","loading","connectionManager","globalize","dom","playbackManager","css!./multiselect"],function(itemHelper,itemShortcuts,appHost,loading,connectionManager,globalize,dom,playbackManager){"use strict";var currentSelectionCommandsPanel,selectedItems=[],selectedItemsMap={},selectedElements=[];function getSelectedItemsMap(serverId){return selectedItemsMap[serverId=serverId||"0"]||(selectedItemsMap[serverId]={})}function hideSelections(){if(currentSelectionCommandsPanel){currentSelectionCommandsPanel.parentNode.removeChild(currentSelectionCommandsPanel),currentSelectionCommandsPanel=null,selectedItems=[],selectedItemsMap={},selectedElements=[];for(var elems=document.querySelectorAll(".multi-select-active"),i=0,length=elems.length;i<length;i++)elems[i].classList.remove("multi-select-active");for(i=0,length=(elems=document.querySelectorAll(".chkItemSelect:checked")).length;i<length;i++)elems[i].checked=!1;for(i=0,length=(elems=document.querySelectorAll(".item-multiselected")).length;i<length;i++)elems[i].classList.remove("item-multiselected")}}function alertText(options){return new Promise(function(resolve,reject){require(["alert"],function(alert){alert(options).then(resolve,resolve)})})}function separateItemsByServer(items){for(var servers=[],serversMap={},i=0,length=items.length;i<length;i++){var serverId,server,item=items[i],apiClient=connectionManager.getApiClient(item);apiClient&&((server=serversMap[serverId=apiClient.serverId()])||(server={apiClient:apiClient,items:[]},serversMap[serverId]=server,servers.push(server)),server.items.push(item))}return servers}function removeFromCollection(items,users){for(var servers=separateItemsByServer(items),promises=[],i=0,length=servers.length;i<length;i++){var server=servers[i],apiClient=server.apiClient,itemsToRemove=function(items,users){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];itemHelper.supportsAddingToCollection(item,user)&&list.push(item)}return list}(server.items,users);itemsToRemove.length&&promises.push(apiClient.removeItemsFromCollection(itemsToRemove[0].CollectionId,itemsToRemove))}return Promise.all(promises)}function removeFromPlaylist(items,users){for(var servers=separateItemsByServer(items),promises=[],i=0,length=servers.length;i<length;i++){var server=servers[i],apiClient=server.apiClient,itemsToRemove=function(items,users){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i];users[item.ServerId];itemHelper.supportsAddingToPlaylist(item)&&list.push(item)}return list}(server.items,users);itemsToRemove.length&&promises.push(apiClient.removeItemsFromPlaylist(itemsToRemove[0].PlaylistId,itemsToRemove))}return Promise.all(promises)}function deleteItems(items){var msg=globalize.translate("ConfirmDeleteItem"),title=globalize.translate("HeaderDeleteItem");return 1<items.length&&(msg=globalize.translate("ConfirmDeleteItems"),title=globalize.translate("HeaderDeleteItems")),msg+="\n\n"+globalize.translate("AreYouSureToContinue"),require(["confirm"]).then(function(responses){return responses[0](msg,title).then(function(){for(var servers=separateItemsByServer(items),promises=[],i=0,length=servers.length;i<length;i++){var server=servers[i],apiClient=server.apiClient,itemsToDelete=function(items){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i];item.CanDelete&&list.push(item)}return list}(server.items);itemsToDelete.length&&promises.push(apiClient.deleteItems(itemsToDelete))}return promises.length?Promise.all(promises).catch(function(){return alertText(globalize.translate("ErrorDeletingItem"))}):showNoItemsMessage()})})}function filterItemsToOneServer(items){if(!items.length)return items;var serverId=items[0].ServerId;if(!serverId)return[];for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i];item.ServerId===serverId&&list.push(item)}return list}function showNoItemsMessage(){return alertText(globalize.translate("NoSelectedItemsSupportOperation"))}function mapApiClientArrayToObject(responses){for(var map={},i=0,length=responses.length;i<length;i++){var user=responses[i];map[user.ServerId]=user}return map}function syncItems(items,users,isLocalSync){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];itemHelper.canSync(user,item)&&list.push(items[i])}if(!(items=filterItemsToOneServer(items=list)).length)return showNoItemsMessage();var serverId=items[0].ServerId;require(["syncDialog"],function(syncDialog){syncDialog.showMenu({items:items,isLocalSync:isLocalSync,serverId:serverId})})}function sendToast(text){return require(["toast"]).then(function(responses){return(0,responses[0])(text),Promise.resolve()})}function showMenuForSelectedItems(e){var items=selectedItems;return function(items){for(var promises=[],servers={},i=0,length=items.length;i<length;i++){var item=items[i],serverId=item.ServerId;serverId&&!servers[serverId]&&(servers[serverId]=!0,promises.push(connectionManager.getApiClient(item).getCurrentUser()))}return Promise.all(promises).then(mapApiClientArrayToObject)}(items).then(function(users){var menuItems=[];if(!function(items){for(var i=0,length=items.length;i<length;i++)if(playbackManager.canQueue(items[i]))return 1}(items)||(menuItems.push({name:globalize.translate("HeaderAddToPlayQueue"),id:"queue",icon:"&#xe03b;"}),menuItems.push({name:globalize.translate("HeaderPlayNext"),id:"queuenext",icon:"&#xe03b;"})),function(items,users){for(var i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(itemHelper.supportsAddingToCollection(item,user))return 1}}(items,users)&&menuItems.push({name:globalize.translate("HeaderAddToCollection"),id:"addtocollection",ironIcon:"add",icon:"playlist_add"}),function(items){for(var i=0,length=items.length;i<length;i++)if(itemHelper.supportsAddingToPlaylist(items[i]))return 1}(items)&&menuItems.push({name:globalize.translate("HeaderAddToPlaylist"),id:"addtoplaylist",icon:"playlist_add"}),function(items){for(var i=0,length=items.length;i<length;i++){if(items[i].CanDelete)return 1}}(items)&&menuItems.push({name:globalize.translate("Delete"),id:"delete",icon:"delete"}),function(items,users){for(var i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(item.CanDownload&&user.Policy.EnableContentDownloading)return 1}}(items,users)&&appHost.supports("filedownload")&&items.push({name:globalize.translate("ButtonDownload"),id:"download",ironIcon:"file-download"}),function(items,users){for(var i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(itemHelper.canSync(user,item))return 1}}(items,users)&&(appHost.supports("sync")&&menuItems.push({name:globalize.translate("Download"),id:"synclocal",icon:"download"}),menuItems.push({name:globalize.translate("HeaderDownloadToDots"),id:"sync",icon:"download"})),function(items,users){for(var count=0,i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(itemHelper.canManageMultiVersionGrouping(item,user)&&1<++count)return 1}}(items,users)&&menuItems.push({name:globalize.translate("HeaderGroupVersions"),id:"groupvideos",icon:"call_merge"}),function(items){for(var i=0,length=items.length;i<length;i++)if(itemHelper.canMarkPlayed(items[i]))return 1}(items)&&(menuItems.push({name:globalize.translate("HeaderMarkPlayed"),id:"markplayed",icon:"check"}),menuItems.push({name:globalize.translate("HeaderMarkUnplayed"),id:"markunplayed",icon:"remove"})),function(items,users){for(var i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(itemHelper.canRefreshMetadata(item,user))return 1}}(items,users)&&menuItems.push({name:globalize.translate("HeaderRefreshMetadata"),id:"refresh",icon:"refresh"}),function(items){for(var i=0,length=items.length;i<length;i++){if(items[i].PlaylistId)return 1}}(items)&&menuItems.push({name:globalize.translate("HeaderRemoveFromPlaylist"),id:"removefromplaylist",icon:"remove_circle"}),function(items,users){for(var i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];if(item.CollectionId&&itemHelper.supportsAddingToCollection(item,user))return 1}}(items,users)&&menuItems.push({name:globalize.translate("HeaderRemoveFromCollection"),id:"removefromcollection",icon:"remove_circle"}),!menuItems.length)return alertText(globalize.translate("NoOperationsForSelectedItems"));require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,positionTo:e.target,callback:function(id){switch(id){case"addtocollection":!function(items,users){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];itemHelper.supportsAddingToCollection(item,user)&&list.push(item)}if(!(items=filterItemsToOneServer(items=list)).length)return showNoItemsMessage();var serverId=items[0].ServerId;require(["addToList"]).then(function(responses){return(new responses[0]).show({items:items,serverId:serverId,type:"Collection"})})}(items,users),hideSelections();break;case"addtoplaylist":!function(items){for(var list=[],i=0,length=items.length;i<length;i++)itemHelper.supportsAddingToPlaylist(items[i])&&list.push(items[i]);if(!(items=filterItemsToOneServer(items=list)).length)return showNoItemsMessage();var serverId=items[0].ServerId;require(["addToList"]).then(function(responses){return(new responses[0]).show({items:items,serverId:serverId,type:"Playlist"})})}(items),hideSelections();break;case"delete":deleteItems(items),hideSelections();break;case"groupvideos":!function(items,users){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];itemHelper.canManageMultiVersionGrouping(item,user)&&list.push(items[i])}var serverId=(items=filterItemsToOneServer(items=list))[0].ServerId;if(items.length<2)return alertText(globalize.translate("PleaseSelectTwoItems"));loading.show();var apiClient=connectionManager.getApiClient(serverId);apiClient.ajax({type:"POST",url:apiClient.getUrl("Videos/MergeVersions",{Ids:items.map(mapToId).join(",")})}).then(function(){loading.hide(),function(){var i,length,elems=[],selectedElems=selectedElements;for(i=0,length=selectedElems.length;i<length;i++){var container=selectedElems[i].closest("[is=emby-itemscontainer]");container&&-1===elems.indexOf(container)&&elems.push(container)}for(i=0,length=elems.length;i<length;i++)elems[i].notifyRefreshNeeded(!0)}(),hideSelections()},function(){loading.hide(),hideSelections()})}(items,users);break;case"markplayed":!function(items){for(var any=!1,i=0,length=items.length;i<length;i++){var apiClient,item=items[i];!itemHelper.canMarkPlayed(item)||(apiClient=connectionManager.getApiClient(item))&&(apiClient.markPlayed(apiClient.getCurrentUserId(),item.Id),any=!0)}any?Promise.resolve():showNoItemsMessage()}(items),hideSelections();break;case"markunplayed":!function(items){for(var any=!1,i=0,length=items.length;i<length;i++){var apiClient,item=items[i];!itemHelper.canMarkPlayed(item)||(apiClient=connectionManager.getApiClient(item))&&(apiClient.markUnplayed(apiClient.getCurrentUserId(),item.Id),any=!0)}any?Promise.resolve():showNoItemsMessage()}(items),hideSelections();break;case"refresh":!function(items,users){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i],user=users[item.ServerId];itemHelper.canRefreshMetadata(item,user)&&list.push(items[i])}(items=filterItemsToOneServer(items=list)).length?require(["refreshDialog"]).then(function(responses){return new responses[0]({items:items}).show()}):showNoItemsMessage()}(items,users),hideSelections();break;case"sync":syncItems(items,users,!1),hideSelections();break;case"synclocal":syncItems(items,users,!0),hideSelections();break;case"removefromplaylist":removeFromPlaylist(items,users),hideSelections();break;case"removefromcollection":removeFromCollection(items,users),hideSelections();break;case"queue":playbackManager.queue({items:items}),hideSelections(),sendToast({text:globalize.translate("HeaderAddedToPlayQueue"),icon:"playlist_add"}),Promise.resolve();break;case"queuenext":playbackManager.queueNext({items:items}),hideSelections(),sendToast({text:globalize.translate("HeaderPlayingNext"),icon:"playlist_add"}),Promise.resolve()}}})})})}function mapToId(item){return item.Id}function getSelectedItemIdentifier(item){return item.PlaylistItemId||item.Id}function showSelections(chkItemSelect,selected){chkItemSelect.classList.contains("chkItemSelect")||(chkItemSelect=chkItemSelect.querySelector(".chkItemSelect")),null==selected?selected=chkItemSelect.checked:chkItemSelect.checked=selected;var itemSelectionCount,btnSelectionPanelOptions,selectionCommandsPanel,itemElement=itemShortcuts.getItemElementFromChildNode(chkItemSelect,!0),item=itemShortcuts.getItemFromChildNode(itemElement),serverId=item.ServerId,id=getSelectedItemIdentifier(item),container=chkItemSelect.closest("[is=emby-itemscontainer]");selected?(itemElement.querySelector(".cardBox,.chkListItemSelectContainer").classList.add("item-multiselected"),selectedItems.filter(function(i){return getSelectedItemIdentifier(i)===id&&i.ServerId===serverId}).length||(selectedItems.push(item),getSelectedItemsMap(serverId)[id]=!0,selectedElements.push(chkItemSelect))):(itemElement.querySelector(".cardBox,.chkListItemSelectContainer").classList.remove("item-multiselected"),selectedItems=selectedItems.filter(function(i){return getSelectedItemIdentifier(i)!==id||i.ServerId!==serverId}),getSelectedItemsMap(serverId)[id]=null,selectedElements=selectedElements.filter(function(i){return i!==chkItemSelect})),selectedItems.length?(container.classList.add("multi-select-active"),(selectionCommandsPanel=currentSelectionCommandsPanel)||((selectionCommandsPanel=document.createElement("div")).classList.add("selectionCommandsPanel"),document.body.appendChild(selectionCommandsPanel),(currentSelectionCommandsPanel=selectionCommandsPanel).innerHTML='<button is="paper-icon-button-light" class="btnCloseSelectionPanel autoSize"><i class="md-icon">close</i></button><h1 class="itemSelectionCount"></h1><button is="paper-icon-button-light" class="btnSelectionPanelOptions autoSize" style="margin-left:auto;"><i class="md-icon">&#xE5D3;</i></button>',selectionCommandsPanel.querySelector(".btnCloseSelectionPanel").addEventListener("click",hideSelections),btnSelectionPanelOptions=selectionCommandsPanel.querySelector(".btnSelectionPanelOptions"),dom.addEventListener(btnSelectionPanelOptions,"click",showMenuForSelectedItems,{passive:!0})),(itemSelectionCount=document.querySelector(".itemSelectionCount"))&&(itemSelectionCount.innerHTML=selectedItems.length)):hideSelections()}function onChange(e){var target=e.target,chkItemSelect=target.closest(".chkItemSelect");if(chkItemSelect&&itemShortcuts.getItemElementFromChildNode(target,!0))return showSelections(chkItemSelect,chkItemSelect.checked),e.preventDefault(),e.stopPropagation(),!1}function MultiSelect(options){options.container.addEventListener("change",onChange)}return document.addEventListener("viewbeforehide",hideSelections),MultiSelect.prototype.showSelections=showSelections,MultiSelect.prototype.onContainerClick=function(e){var target=e.target,chkItemSelectContainer=target.closest(".chkItemSelectContainer");if(chkItemSelectContainer)return!1;if(selectedItems.length){var itemElement=itemShortcuts.getItemElementFromChildNode(target,!0);if(itemElement&&!chkItemSelectContainer){var chkItemSelect=itemElement.querySelector(".chkItemSelect");return showSelections(chkItemSelect,!chkItemSelect.checked),e.preventDefault(),e.stopPropagation(),!1}}},MultiSelect.isSelected=function(item){var id=getSelectedItemIdentifier(item);return!!id&&getSelectedItemsMap(item.ServerId)[id]},MultiSelect.canPlay=function(){return 0<selectedItems.length},MultiSelect.play=function(){var promise=playbackManager.play({items:selectedItems.slice(0)});return hideSelections(),promise},MultiSelect});