define(["itemShortcuts","events","listView","layoutManager","connectionManager","globalize","dom","appRouter","cardBuilder","apphost","pluginManager","emby-collapse","paper-icon-button-light","emby-itemscontainer"],function(itemShortcuts,events,listView,layoutManager,connectionManager,globalize,dom,appRouter,cardBuilder,appHost,pluginManager){"use strict";var navDrawerElement,currentServerId,currentListItems,currentViewEvent,appHeader,renderAbortController,currentDrawerType=0,enableLazyLoadingDrawerContents=!1;function getNavDrawerElement(){return navDrawerElement=navDrawerElement||document.querySelector(".mainDrawer")}function addPluginPagesToMainMenu(links,pluginItems,section){for(var i=0,length=pluginItems.length;i<length;i++){var pluginItem=pluginItems[i];pluginManager.allowPluginPages(pluginItem.PluginId)&&pluginItem.EnableInMainMenu&&pluginItem.MenuSection===section&&links.push({Name:pluginItem.DisplayName,Icon:pluginItem.MenuIcon||"folder",href:pluginManager.getConfigurationPageUrl(pluginItem.Name),navMenuId:"/"+pluginManager.getConfigurationPageUrl(pluginItem.Name)})}}function getAdminMenuItems(apiClient,user,signal){return appRouter.getRouteInfo(appRouter.getRouteUrl("manageserver"))&&user.Policy.IsAdministrator?apiClient.getJSON(apiClient.getUrl("web/configurationpages")+"?pageType=PluginConfiguration&EnableInMainMenu=true",signal).then(function(items){return function(pluginItems,apiClient){var links=[{Name:globalize.translate("Server")},{Name:globalize.translate("Dashboard"),href:appRouter.getRouteUrl("manageserver"),Icon:"dashboard"},{Name:globalize.translate("Settings"),href:"/dashboard/settings",Icon:"settings"},{Name:globalize.translate("Users"),href:"/users",Icon:"people"},{Name:"Emby Premiere",href:"/embypremiere",Icon:"star"},{Name:globalize.translate("Library"),href:"/librarysetup/library.html",Icon:"folder"},{Name:globalize.translate("Network"),Icon:"wifi",href:"/network"},{Name:globalize.translate("Transcoding"),Icon:"transform",href:"/transcoding"}];return links.push({Name:globalize.translate("Conversions"),Icon:"sync",href:"/conversions?mode=convert"}),addPluginPagesToMainMenu(links,pluginItems,"server"),links.push({divider:!0,Name:globalize.translate("Devices")}),links.push({Name:globalize.translate("Devices"),href:"/devices",Icon:"devices"}),links.push({Name:globalize.translate("Downloads"),Icon:"download",href:"/serverdownloads"}),links.push({Name:globalize.translate("HeaderCameraUpload"),href:"/devices/cameraupload.html",Icon:"photo_camera"}),addPluginPagesToMainMenu(links,pluginItems,"devices"),links.push({divider:!0,Name:globalize.translate("LiveTV")+" / DVR"}),links.push({Name:globalize.translate("Setup"),href:"/livetvsetup/livetvstatus.html",Icon:"live_tv"}),apiClient.isMinServerVersion("4.6.0.44")&&links.push({Name:globalize.translate("Channels"),href:"/livetvsetup/channels",Icon:"dvr"}),links.push({Name:globalize.translate("Advanced"),href:"/livetvsetup/livetvsettings.html",Icon:"settings"}),links.push({divider:!0,Name:globalize.translate("Advanced")}),links.push({Name:globalize.translate("Logs"),href:"/logs",Icon:"folder_open"}),links.push({Name:globalize.translate("Notifications"),Icon:"notifications",href:"server/notifications/notificationsettings.html"}),links.push({Name:globalize.translate("Plugins"),Icon:"add_shopping_cart",href:"/plugins"}),links.push({Name:globalize.translate("HeaderScheduledTasks"),href:"/scheduledtasks",Icon:"schedule"}),links.push({Name:globalize.translate("HeaderApiKeys"),href:"/apikeys",Icon:"vpn_key"}),links.push({Name:globalize.translate("MetadataManager"),href:"/metadatamanager",Icon:"edit"}),addPluginPagesToMainMenu(links,pluginItems),links}(items,apiClient)},function(err){return[]}):Promise.resolve([])}function sortRoutes(a,b){var aOrder=null==a.order?1e3:a.order,bOrder=null==b.order?1e3:b.order;if(bOrder<aOrder)return 1;if(aOrder<bOrder)return-1;var aName=(aName=a.title)&&globalize.translate(aName),bName=b.title;return(bName=bName&&globalize.translate(bName))<aName?1:aName<bName?-1:0}function getUserSetingsRoutes(user,loggedInUser){return appRouter.getRoutes().filter(function(r){return function(route,user,loggedInUser){return"settings"===route.type&&("user"===route.settingsType&&appRouter.validateUserAccessToRoute(route,user,loggedInUser))}(r,user,loggedInUser)}).sort(sortRoutes)}function mapRouteToMenuItem(route,user){var path=route.path;return path&&"settings"===route.type&&"user"===route.settingsType&&(path+="?userId="+user.Id,path+="&serverId="+user.ServerId),{Name:globalize.translate(route.title),href:path,Icon:route.icon}}function getAppSettingsMenuItems(options){var i,length,items=[],user=options.user,routes=getUserSetingsRoutes(user,options.loggedInUser);if(!1!==options.home&&items.push({Name:globalize.translate("Home"),Icon:"&#xE88A;",href:appRouter.getRouteUrl("home")}),routes.length)for(items.push({Name:user.Name}),i=0,length=routes.length;i<length;i++)items.push(mapRouteToMenuItem(routes[i],user));options.selectServer&&appHost.supports("multiserver")&&items.push({Name:globalize.translate("HeaderSelectServer"),href:appRouter.getRouteUrl("selectserver"),Icon:"router"}),options.signOut&&!user.EnableAutoLogin&&user.Id===options.loggedInUser.Id&&items.push({Name:globalize.translate("HeaderSignOut"),href:"#",Icon:"&#xE879;",onclick:"logout"}),routes=appRouter.getRoutes().filter(function(r){return"settings"===r.type&&"user"!==r.settingsType}).sort(sortRoutes);var supportsExit=appHost.supports("exit")&&layoutManager.tv;if(routes.length||supportsExit)for(items.push({Name:appHost.appName()}),i=0,length=routes.length;i<length;i++)items.push(mapRouteToMenuItem(routes[i],user));return supportsExit&&items.push({Name:globalize.translate("Exit"),href:"#",Icon:"&#xE879;",onclick:"exit"}),items=items.concat(function(){var items=[];appHost.supports("sleep")&&items.push({Name:globalize.translate("Sleep"),href:"#",Icon:"&#xE426;",onclick:"sleep"});appHost.supports("shutdown")&&items.push({Name:globalize.translate("Shutdown"),href:"#",Icon:"&#xE8AC;",onclick:"shutdown"});appHost.supports("restart")&&items.push({Name:globalize.translate("Restart"),href:"#",Icon:"&#xE5D5;",onclick:"restart"});items.length&&items.unshift({Name:appHost.deviceName()});return items}()),Promise.resolve(items)}function getItemsHtml(items,options){options.isGlobalList?currentListItems=items:options.listItems=items;var icon,title,menuHtml="";!1!==options.header&&(menuHtml+='<div class="navDrawerHeader flex flex-direction-row align-items-center">',menuHtml+='<div class="navDrawerLogo pageTitleWithDefaultLogo flex-grow" href="'+appRouter.getRouteUrl("home")+'" title="'+globalize.translate("Home")+'" aria-label="'+globalize.translate("Home")+'"></div>',!1!==options.drawerOptions&&(menuHtml+='<button type="button" is="paper-icon-button-light" class="btnPinNavDrawer secondaryText'+(enableLazyLoadingDrawerContents?(icon="view_sidebar",title=globalize.translate("HeaderPinSidebar")," btnPinNavDrawer-iconpin"):(icon="menu_open",title=globalize.translate("HeaderCloseSidebar")," btnPinNavDrawer-iconclose"))+'" title="'+title+'" aria-label="'+title+'"><i class="md-icon btnPinNavDrawerIcon">'+icon+"</i></button>"),menuHtml+="</div>",menuHtml+="</div>");for(var headerClass,item,collapsible=!1!==options.collapsible&&!layoutManager.tv,sectionClose=collapsible?"</div></div>":"</div>",isSectionOpen=!1,i=0,length=items.length;i<length;i++){(item=items[i]).section&&isSectionOpen&&(isSectionOpen=!1,menuHtml+=sectionClose),"playlists"===item.section?menuHtml+=function(options){var html="",headerClass="navMenuHeader";return options.itemClass&&(headerClass+=" navMenuHeader-"+options.itemClass),html+='<div is="emby-collapse" title="'+globalize.translate("Playlists")+'" data-expanded="true" class="navDrawerCollapseSection" data-headerclass="'+headerClass+'" data-buttonclass="navDrawerCollapseButton" data-iconclass="secondaryText navDrawerCollapseIcon">',html+='<div is="emby-itemscontainer" class="navDrawerItemsContainer itemsContainer vertical-list collapseContent navDrawerCollapseContent" data-listtype="playlists">',html+="</div></div>"}(options):"collections"===item.section?menuHtml+=function(options){var html="",headerClass="navMenuHeader";return options.itemClass&&(headerClass+=" navMenuHeader-"+options.itemClass),html+='<div is="emby-collapse" title="'+globalize.translate("Collections")+'" data-expanded="false" class="navDrawerCollapseSection" data-headerclass="'+headerClass+'" data-buttonclass="navDrawerCollapseButton" data-iconclass="secondaryText navDrawerCollapseIcon">',html+='<div is="emby-itemscontainer" class="navDrawerItemsContainer itemsContainer vertical-list collapseContent navDrawerCollapseContent" data-listtype="collections">',html+="</div></div>"}(options):item.href?isSectionOpen||(menuHtml+='<div is="emby-itemscontainer" class="navDrawerItemsContainer itemsContainer vertical-list" data-listindex="'+i+'"></div>'):item.Name&&(isSectionOpen&&(isSectionOpen=!1,menuHtml+=sectionClose),headerClass="navMenuHeader",options.itemClass&&(headerClass+=" navMenuHeader-"+options.itemClass),isSectionOpen=(collapsible?(menuHtml+='<div is="emby-collapse" title="'+item.Name+'" data-expanded="true" class="navDrawerCollapseSection" data-headerclass="'+headerClass+'" data-buttonclass="navDrawerCollapseButton" data-iconclass="secondaryText navDrawerCollapseIcon">',menuHtml+='<div is="emby-itemscontainer" class="navDrawerItemsContainer itemsContainer vertical-list collapseContent navDrawerCollapseContent" data-listindex="'+(i+1)+'">'):(menuHtml+='<h3 class="'+headerClass+'">',item.imageUrl&&(menuHtml+='<img src="'+item.imageUrl+'" class="navMenuHeaderImage" />'),menuHtml+=item.Name,menuHtml+="</h3>",menuHtml+='<div is="emby-itemscontainer" class="navDrawerItemsContainer itemsContainer vertical-list" data-listindex="'+(i+1)+'">'),!0))}return isSectionOpen&&(isSectionOpen=!1,menuHtml+=sectionClose),menuHtml}function getSettingsDrawerHtml(options){return function(options){var apiClient=options.apiClient,user=options.user,signal=options.signal;return Promise.all([getAppSettingsMenuItems(options),getAdminMenuItems(apiClient,user,signal)]).then(function(responses){return responses[0].concat(responses[1])})}(options).then(function(items){return options.drawerOptions=!1,getItemsHtml(items,options)})}function getLibraryDrawerHtml(apiClient,signal){return apiClient.getCurrentUser({signal:signal}).then(function(user){return function(apiClient){return apiClient.getUserViews({},apiClient.getCurrentUserId()).then(function(result){for(var items=result.Items,list=[],i=0,length=items.length;i<length;i++){var guideView,view=items[i];list.push(view),"livetv"===view.CollectionType&&((guideView=Object.assign({},view)).Name=globalize.translate("Guide"),guideView.ImageTags={},guideView.Icon="dvr",guideView.url=appRouter.getRouteUrl("livetv",{section:"guide",serverId:apiClient.serverId()}),list.push(guideView))}return list})}(apiClient).then(function(result){var items=result,menuItems=[];menuItems.push({Name:globalize.translate("Home"),Icon:"&#xE88A;",href:appRouter.getRouteUrl("home")}),user.Policy.EnableContentDownloading&&appHost.supports("sync")&&(menuItems.push({Name:globalize.translate("Downloads")}),menuItems.push({Name:globalize.translate("Downloads"),href:appRouter.getRouteUrl("downloads"),Icon:"&#xE2C7;"}),menuItems.push({Name:globalize.translate("Manage"),href:appRouter.getRouteUrl("managedownloads"),Icon:"&#xE3C9;"})),menuItems.push({Name:globalize.translate("HeaderMyMedia")});for(var iconOptions={defaultIcon:"folder"},i=0,length=items.length;i<length;i++){var item=items[i],url=appRouter.getRouteUrl(item,{context:item.CollectionType});menuItems.push({Name:item.Name,href:url,Icon:item.Icon||cardBuilder.getDefaultIcon(item,iconOptions),ServerId:item.ServerId,Type:item.Type,CollectionType:item.CollectionType,IsFolder:item.IsFolder,ParentId:item.ParentId})}return menuItems.push({section:"playlists"}),menuItems.push({section:"collections"}),user.Policy.IsAdministrator&&appRouter.getRouteInfo(appRouter.getRouteUrl("manageserver"))&&(menuItems.push({Name:globalize.translate("Admin")}),menuItems.push({Name:globalize.translate("ManageEmbyServer"),href:appRouter.getRouteUrl("manageserver"),Icon:"&#xE8B8;"}),menuItems.push({Name:globalize.translate("MetadataManager"),href:"/metadatamanager",Icon:"&#xE2C7;"})),menuItems.push({Name:globalize.translate("Settings"),href:appRouter.getRouteUrl("settings",{serverId:apiClient.serverId()}),Icon:"&#xE8B8;"}),appHost.supports("multiserver")&&menuItems.push({Name:globalize.translate("HeaderSelectServer"),href:appRouter.getRouteUrl("selectserver"),Icon:"router"}),user.EnableAutoLogin||menuItems.push({Name:globalize.translate("HeaderSignOut"),href:"#",Icon:"&#xE879;",onclick:"logout"}),getItemsHtml(menuItems,{isGlobalList:!0})})})}function getDrawerHtml(type,signal){var apiClient=currentServerId?connectionManager.getApiClient(currentServerId):connectionManager.currentApiClient();return 1===type&&currentServerId?getLibraryDrawerHtml(apiClient,signal):2===type?function(apiClient,signal){return apiClient.getCurrentUser({signal:signal}).then(function(user){return getSettingsDrawerHtml({apiClient:apiClient,user:user,signal:signal,isGlobalList:!0})})}(apiClient,signal):Promise.resolve("")}function getListOptions(items){return{renderer:listView,options:{action:"link",image:!0,addToListButton:!1,showParentTitle:!1,fields:["Name"],enableUserDataButtons:!1,moreButton:!1,highlight:!1,mediaInfo:!1,dropTarget:!0,itemClass:("navMenuOption navDrawerListItem "+(this.navItemClass||"")).trim(),hoverPlayButton:!1,multiSelect:!1,draggable:!1,enableSideMediaInfo:!1,enableOverview:!1,iconClass:"navDrawerListItemIcon"},virtualScrollLayout:"vertical-list"}}function getNavMenuItemsResult(){var allListItems=this.listItems,itemsContainer=this.itemsContainer,items=function(index,allListItems){for(var items=allListItems.slice(index),i=0,length=items.length;i<length;i++)if(!items[i].href)return items.length=i,items;return items}(parseInt(itemsContainer.getAttribute("data-listindex")),allListItems);return Promise.resolve({Items:items,TotalRecordCount:items.length})}function getNavMenuListOptions(items){return{renderer:listView,options:{action:"custom",addToListButton:!1,showParentTitle:!1,fields:["Name"],enableUserDataButtons:!1,moreButton:!1,highlight:!1,mediaInfo:!1,dropTarget:!1,itemClass:("navMenuOption navDrawerListItem "+(this.navItemClass||"")).trim(),hoverPlayButton:!1,multiSelect:!1,draggable:!1,contextMenu:!1,enableSideMediaInfo:!1,enableOverview:!1,iconClass:"navDrawerListItemIcon"},virtualScrollLayout:"vertical-list"}}function onItemsContainerUpgrade(){return this.resume({refresh:!0})}function onItemAction(e){var href,item=e.detail.item,onclick=item.onclick;"logout"!==onclick?"exit"!==onclick?"sleep"!==onclick?"shutdown"!==onclick?"restart"!==onclick?(href=item.href)&&appRouter.show(href):appHost.restart():appHost.shutdown():appHost.sleep():appHost.exit():appRouter.logout()}function initItemsContainers(elem,options){for(var apiClient=currentServerId?connectionManager.getApiClient(currentServerId):connectionManager.currentApiClient(),itemsContainers=elem.querySelectorAll(".itemsContainer"),promises=[],i=0,length=itemsContainers.length;i<length;i++){var itemsContainer=itemsContainers[i],type=itemsContainer.getAttribute("data-listtype");if("playlists"===type)itemsContainer.fetchData=function(serverId){return function(){var apiClient=connectionManager.getApiClient(serverId);return apiClient.getItems(apiClient.getCurrentUserId(),{Recursive:!0,IncludeItemTypes:"Playlist"})}}(apiClient.serverId()),itemsContainer.getListOptions=getListOptions;else if("collections"===type)itemsContainer.fetchData=function(serverId){return function(){var apiClient=connectionManager.getApiClient(serverId);return apiClient.getItems(apiClient.getCurrentUserId(),{Recursive:!0,IncludeItemTypes:"BoxSet"})}}(apiClient.serverId()),itemsContainer.getListOptions=getListOptions;else{if(!itemsContainer.hasAttribute("data-listindex"))continue;itemsContainer.fetchData=getNavMenuItemsResult.bind({itemsContainer:itemsContainer,listItems:options?options.listItems:currentListItems}),itemsContainer.navItemClass=options?options.itemClass:null,itemsContainer.getListOptions=getNavMenuListOptions,itemsContainer.addEventListener("action-null",onItemAction)}itemsContainer.resume?promises.push(onItemsContainerUpgrade.call(itemsContainer)):promises.push(function(itemsContainer){return new Promise(function(resolve,reject){dom.addEventListener(itemsContainer,"upgraded",function(){onItemsContainerUpgrade.call(itemsContainer).then(resolve)},{once:!0})})}(itemsContainer))}return elem.itemsContainers=itemsContainers,Promise.all(promises)}function onItemContainersRefreshed(){currentViewEvent&&updateSelectedItem(currentViewEvent)}function onSetInnerHtmlCallback(html){var elem;null!=html&&(html||(currentDrawerType=0),(elem=getNavDrawerElement()).innerHTML=html,initItemsContainers(elem).then(onItemContainersRefreshed),elem.scrollTop=0)}function onRequestError(){}function updateSelectedItem(e){for(var itemsContainer,currentSelectedOption,currentNavMenuId=(currentNavMenuId=e.detail.navMenuId)||(currentNavMenuId=window.location.href.toString()).substring(currentNavMenuId.indexOf("#!")+2),navDrawerElement=getNavDrawerElement(),itemsContainers=navDrawerElement.itemsContainers||[],newSelectedOption=currentNavMenuId?navDrawerElement.querySelector('.navMenuOption[data-navmenuid="'+currentNavMenuId+'"]'):null,i=0,length=itemsContainers.length;i<length;i++)if((itemsContainer=itemsContainers[i]).hasAttribute("data-listindex")){var itemIndexFromNavMenuId=function(itemsContainer,currentNavMenuId){for(var items=itemsContainer.items||[],i=0,length=items.length;i<length;i++){var routeInfo,item=items[i],navMenuId=item.navMenuId;if(!navMenuId&&item.href&&(navMenuId=(routeInfo=appRouter.getRouteInfo(item.href))&&routeInfo.navMenuId||item.href),currentNavMenuId===navMenuId)return i}return-1}(itemsContainer,currentNavMenuId);if(-1!==itemIndexFromNavMenuId){newSelectedOption=itemsContainer.getElement(itemIndexFromNavMenuId);break}}if(!newSelectedOption&&e.detail.params&&e.detail.params.id&&e.detail.params.serverId)for(i=0,length=itemsContainers.length;i<length;i++){var indexOfItem=(itemsContainer=itemsContainers[i]).indexOfItemId(e.detail.params.id);if(-1!==indexOfItem){var itemFromNavOption=itemsContainer.getItem(indexOfItem);if(itemFromNavOption&&itemFromNavOption.ServerId===e.detail.params.serverId){newSelectedOption=itemsContainer.getElement(indexOfItem);break}}}newSelectedOption&&newSelectedOption.classList.contains("navMenuOption-selected")||((currentSelectedOption=navDrawerElement.querySelector(".navMenuOption-selected"))&&currentSelectedOption.classList.remove("navMenuOption-selected"),newSelectedOption&&(newSelectedOption.classList.add("navMenuOption-selected"),e.detail.requiresDynamicTitle&&function(newSelectedOption){var link=newSelectedOption.querySelector(".listItemBodyText")||newSelectedOption,title=(link.innerText||link.textContent).trim();appHeader?appHeader.setTitle(title):function(title){require(["appHeader"]).then(function(responses){(appHeader=responses[0]).setTitle(title)})}(title)}(newSelectedOption)))}function onViewShowInternal(e,loadContent){var type,signal,drawerType=function(e){var detail=e.detail;return currentServerId&&!1!==detail.drawer?detail.settingsTheme?2:1:0}(e);drawerType!==currentDrawerType?loadContent?(type=drawerType,signal=function(){renderAbortController&&renderAbortController.abort();var newController=new AbortController;return(renderAbortController=newController).signal}(),getDrawerHtml(currentDrawerType=type,signal).then(function(html){signal.aborted||onSetInnerHtmlCallback(html)},onRequestError)):onSetInnerHtmlCallback(""):currentDrawerType&&loadContent&&updateSelectedItem(e)}return events.on(connectionManager,"localusersignedin",function(e,serverId,userId){currentServerId=serverId,currentDrawerType=0}),events.on(connectionManager,"localusersignedout",function(){currentServerId=null}),{onViewShow:function(e){onViewShowInternal(currentViewEvent=e,!(enableLazyLoadingDrawerContents=!e.detail.drawerInline))},onBeforeOpen:function(){enableLazyLoadingDrawerContents&&onViewShowInternal(currentViewEvent,!0)},getSettingsDrawerHtml:getSettingsDrawerHtml,initItemsContainers:initItemsContainers}});