define(["loading","globalize","events","viewManager","layoutManager","skinManager","backdrop","browser","pageJs","appSettings","apphost","connectionManager","userSettings","itemHelper","pluginManager"],function(loading,globalize,events,viewManager,layoutManager,skinManager,backdrop,browser,page,appSettings,appHost,connectionManager,userSettings,itemHelper,pluginManager){"use strict";var appRouter={showLocalLogin:function(serverId,manualLogin){return show("/startup/"+(manualLogin?"manuallogin":"login")+".html?serverId="+serverId)},showSelectServer:function(){return show(getRouteUrl("selectserver"))},showWelcome:function(){return appHost.supports("multiserver")?show("/startup/welcome.html"):show("/startup/login.html?serverId="+connectionManager.currentApiClient().serverId())},showConnectLogin:function(){return show(getRouteUrl("connectlogin"))},showSettings:function(){return show(getRouteUrl("settings",{serverId:connectionManager.currentApiClient().serverId()}))},showUserMenu:function(){return appRouter.showSettings()},showSearch:function(){return show(getRouteUrl("search"))},showGuide:function(){return show(appRouter.getRouteUrl("livetv",{serverId:connectionManager.currentApiClient().serverId(),section:"guide"}))},showLiveTV:function(){return show(appRouter.getRouteUrl("livetv",{serverId:connectionManager.currentApiClient().serverId()}))},showRecordedTV:function(){return show(appRouter.getRouteUrl("recordedtv",{serverId:connectionManager.currentApiClient().serverId()}))},showFavorites:function(){return show(getHomeRoute()+"&tab=favorites")},showNowPlaying:function(){return show("/videoosd/videoosd.html")}};function showLocalLoginFromApiClient(apiClient){return console.log("appRouter - showLocalLoginFromApiClient: "+apiClient.serverId()),apiClient.getPublicUsers().then(function(users){return users.length?appRouter.showLocalLogin(apiClient.serverId()):appRouter.showLocalLogin(apiClient.serverId(),!0)})}function beginConnectionWizard(){return backdrop.clear(),loading.show(),appHost.supports("multiserver")?connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then(function(result){return handleConnectionResult(result,!1,!0)}):showLocalLoginFromApiClient(connectionManager.currentApiClient())}function onRedirectToLocalServerNotNeeded(result){switch(result.State){case"SignedIn":loading.hide(),skinManager.loadUserSkin();break;case"ServerSignIn":showLocalLoginFromApiClient(result.ApiClient)}}function redirectToLocalServer(apiClient,logoutDefault){return skinManager.loadSkin().then(function(){return require(["alert"]).then(function(responses){var alert=responses[0],serverAddress=apiClient.serverAddress(),text='<div style="text-align:left;"><div>'+globalize.translate("LocalServerRedirectMessage")+"</div>";text+="<p>",text+=globalize.translate("DomainValue",serverAddress),text+="<br/>",text+=globalize.translate("ServerNameValue",apiClient.serverName()),text+="</p>",text+="<div>"+globalize.translate("AllMediaOwnedHosted",serverAddress)+"</div>",text+="</div>",loading.hide(),alert({title:globalize.translate("HeaderConnectingToServer"),html:text,confirmHref:serverAddress}).then(function(){appRouter.showSelectServer()},function(){logoutDefault&&appRouter.showSelectServer()})})})}function hasConnectedToLocalServer(connectionResult){var apiClient=connectionResult.ApiClient;if(apiClient&&appHost.supports("redirecttolocalserver")){var serverId=apiClient.serverId();if(serverId){var settingsKey=serverId+"-haslocalconnection";return"true"===appSettings.get(settingsKey)}}}function handleConnectionResult(result,allowServerUpdateNeedAlert,useWelcomeForConnectSignIn,logoutOnCancelledRedirect){switch(console.log("appRouter.handleConnectionResult: "+(result.State||"")),result.State){case"SignedIn":!function(result,logoutDefault){var apiClient=result.ApiClient;apiClient&&appHost.supports("redirecttolocalserver")&&connectionManager.isLoggedIntoConnect()&&!hasConnectedToLocalServer(result)?apiClient.getEndpointInfo().then(function(endpointInfo){if(endpointInfo.IsInNetwork){var settingsKey=apiClient.serverId()+"-haslocalconnection";return appSettings.set(settingsKey,"true"),onRedirectToLocalServerNotNeeded(result)}return redirectToLocalServer(result.ApiClient,logoutDefault)},function(){return redirectToLocalServer(result.ApiClient,logoutDefault)}):onRedirectToLocalServerNotNeeded(result)}(result,logoutOnCancelledRedirect);break;case"ServerSignIn":showLocalLoginFromApiClient(result.ApiClient);break;case"ServerSelection":appHost.supports("multiserver")?appRouter.showSelectServer():showLocalLoginFromApiClient(connectionManager.currentApiClient());break;case"ConnectSignIn":!0===useWelcomeForConnectSignIn?appRouter.showWelcome():appRouter.showConnectLogin();break;case"ServerUpdateNeeded":!1===allowServerUpdateNeedAlert?appRouter.showSelectServer():(loading.hide(),require(["alert"],function(alert){alert(globalize.translate("ServerUpdateNeeded",'<a href="https://emby.media">https://emby.media</a>')).then(function(){show("/startup/selectserver.html")})}));break;case"Unavailable":loading.hide(),showAlert({text:globalize.translate("MessageUnableToConnectToServer"),title:globalize.translate("HeaderConnectionFailure")})}}var currentViewLoadRequest,isDummyBackToHome,firstConnectionResult,loadedTranslations={};function loadPluginTranslations(pageName){if(loadedTranslations[pageName])return Promise.resolve();loadedTranslations[pageName]=!0;var apiClient=connectionManager.currentApiClient();return apiClient.getJSON(apiClient.getUrl("web/configurationpages",{Name:pageName})).then(function(configPages){if(configPages.length)return function(apiClient,configPage){var languages=configPage.Translations;if(!languages||!languages.length)return Promise.resolve();var translations=(languages||[]).map(function(i){return{lang:i,path:apiClient.getUrl("web/strings",{PluginId:configPage.PluginId,Locale:i})}});return globalize.loadStrings({name:"plugin-"+configPage.PluginId,translations:translations})}(apiClient,configPages[0])})}function loadContentUrl(ctx,route,request,signal){var url=route.contentPath&&"function"==typeof route.contentPath?route.contentPath(ctx.querystring):route.contentPath||route.path;url.includes("://")||(url.startsWith("/")||(url="/"+url),url=baseUrl()+url),ctx.querystring&&route.enableContentQueryString&&(url+="?"+ctx.querystring);var promises=[require(["text!"+url])];return(getRouteInfo("/configurationpage")||getRouteInfo("/configurationpageext"))&&(request.isPluginPage=request.url.toLowerCase().includes("/configurationpage"),request.isPluginPage&&promises.push(loadPluginTranslations(function(name,url){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var index,regex=new RegExp("[\\?&]"+name+"=([^&#]*)","i"),search=window.location.search;search||-1!==(index=window.location.href.indexOf("?"))&&(search=window.location.href.substring(index));var results=regex.exec(url||search);return null==results?"":decodeURIComponent(results[1].replace(/\+/g," "))}("name",request.url)))),Promise.all(promises).then(function(responses){var html=responses[0][0];return function(ctx,route,html,request,signal){return request.view=globalize.translateDocument(html,route.dictionary),ctx.handled=!0,viewManager.loadView(request,signal)}(ctx,route,html,request,signal)})}function initRoute(ctx,route){function onInitComplete(controllerFactory){!function(ctx,route,controllerFactory){if(isDummyBackToHome&&"home"===route.type)return isDummyBackToHome=!1;(function(){var currentRequest=currentViewLoadRequest;currentRequest&&currentRequest.abortController.abort()})(),console.log("appRouter.sendRouteToViewManager - processing path: isBack: "+ctx.isBack);var isBackNav=ctx.isBack,currentRequest=Object.assign({},route);currentRequest.url=baseUrl()+ctx.path,currentRequest.controllerFactory=controllerFactory,currentRequest.state=ctx.state,currentRequest.isBack=isBackNav,currentRequest.abortController=new AbortController,currentRequest.route=route,currentRequest.contextPath=ctx.path;var signal=(currentViewLoadRequest=currentRequest).abortController.signal;isBackNav?viewManager.tryRestoreView(currentRequest,signal).catch(function(result){if(!signal.aborted)return loadContentUrl(ctx,route,currentRequest,signal)}):loadContentUrl(ctx,route,currentRequest,signal)}(ctx,route,controllerFactory)}route.controller?require([route.controller],onInitComplete):onInitComplete()}function onBeforeExit(e){browser.web0s&&page.restorePreviousState()}function getMaxBandwidth(){var connection=navigator.connection;if(connection){var downlink=connection.downlink;if(downlink&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink*=1e6,downlink*=.7,downlink=parseInt(downlink);if((downlink=connection.downlinkMax)&&0<downlink&&downlink<Number.POSITIVE_INFINITY)return downlink*=1e6,downlink*=.7,downlink=parseInt(downlink)}return browser.tv||browser.chromecast?null:15e5}function onApiClientCreated(e,newApiClient){newApiClient.getMaxBandwidth=getMaxBandwidth}function initApiClients(){var currentApiClient=connectionManager.currentApiClient();currentApiClient&&onApiClientCreated(0,currentApiClient),events.on(connectionManager,"apiclientcreated",onApiClientCreated)}function onAppResume(){connectionManager.onAppResume()}function handleRoute(ctx,route){var firstResult=firstConnectionResult;if(firstResult&&(firstConnectionResult=null,!route.anonymous)){if("SignedIn"!==firstResult.State)return void handleConnectionResult(firstResult,!1,!0);if(appHost.supports("redirecttolocalserver")&&!hasConnectedToLocalServer(firstResult))return void handleConnectionResult(firstResult,!1,!0,!0)}var apiClient=connectionManager.currentApiClient(),pathname=ctx.pathname.toLowerCase();console.log("appRouter - processing path: "+pathname+", isBack: "+ctx.isBack);var currentRouteInfo=getCurrentRouteInfo(),isCurrentRouteStartup=!currentRouteInfo||currentRouteInfo.route.startup,shouldExitApp=ctx.isBack&&route.isDefaultRoute&&isCurrentRouteStartup;if(!(shouldExitApp||apiClient&&apiClient.isLoggedIn()||route.anonymous))return console.log("appRouter - route does not allow anonymous access, redirecting to login"),void beginConnectionWizard();if(shouldExitApp)return appHost.supports("exit")?void appHost.exit():void 0;if(apiClient&&apiClient.isLoggedIn()){if(console.log("appRouter - user is authenticated"),ctx.isBack&&(route.isDefaultRoute||route.startup)&&!isCurrentRouteStartup)return void function(){if(appHost.supports("exit")&&!appHost.supports("exitmenu"))return appHost.exit();if(isDummyBackToHome=!0,skinManager.loadUserSkin(),!layoutManager.tv)return appHost.supports("exit")&&appHost.exit();!function(showHome){require(["backMenu"]).then(function(responses){return responses[0]({showHome:showHome})})}(!1)}();if(route.isDefaultRoute)return console.log("appRouter - loading skin home page"),void function(ctx){require(["queryString"],function(queryString){var params=queryString.parse(ctx.querystring);skinManager.loadUserSkin({start:params.start})})}(ctx);if(route.roles)return void function(apiClient,route){return route.roles?apiClient.getCurrentUser().then(function(user){return validateUserAccessToRoute(route,user)}):Promise.resolve()}(apiClient,route).then(function(){initRoute(ctx,route)},beginConnectionWizard)}console.log("appRouter - proceeding to "+pathname),initRoute(ctx,route)}function validateUserAccessToRoute(route,user,loggedInUser){var roles=(route.roles||"").split(",");return!(roles.includes("admin")&&!user.Policy.IsAdministrator)&&!!(!roles.includes("EnableUserPreferenceAccess")||user.Policy.EnableUserPreferenceAccess||loggedInUser&&loggedInUser.Policy.IsAdministrator)}function getRequestFile(){var path=self.location.pathname||"",index=path.lastIndexOf("/");return(path=-1!==index?path.substring(index):"/"+path)&&"/"!==path||(path="/index.html"),path}function endsWith(str,srch){return str.lastIndexOf(srch)===srch.length-1}appHost.supports("multiserver")&&navigator.connection&&navigator.connection.addEventListener&&navigator.connection.addEventListener("change",function(){connectionManager.onNetworkChanged()});var resolveOnNextShow,backdropContainer,backgroundContainer,baseRoute=self.location.href.split("?")[0].replace(getRequestFile(),"");function baseUrl(){return baseRoute}function show(path,options){path.startsWith("/")||path.includes("://")||(path="/"+path);var baseRoute=baseUrl();path=path.replace(baseRoute,"");var currentRouteInfo=getCurrentRouteInfo();return currentRouteInfo&&currentRouteInfo.contextPath===path&&"home"!==currentRouteInfo.route.type?(loading.hide(),Promise.resolve()):new Promise(function(resolve,reject){resolveOnNextShow=resolve,page.show(path,options)})}function getCurrentRouteInfo(){return viewManager.currentViewInfo()}function current(){var currentRouteInfo=getCurrentRouteInfo();return currentRouteInfo?currentRouteInfo.route:null}function getHomeRoute(){return layoutManager.tv&&"horizontal"===userSettings.get("tvhome")?"/home_horiz/home.html":"/home"}function getRouteInfo(url){return page.getRoute(url)}function getRouteUrl(item,options){if(item.url)return item.url;var url,context=(options=options||{})?options.context:null,id=item.Id||item.ItemId,serverId=item.ServerId||options.serverId;if("home"===item)return getHomeRoute();if("search"===item){if(!layoutManager.tv)if((serverId?connectionManager.getApiClient(serverId):connectionManager.currentApiClient()).supportsGlobalSearch())return"/list/list.html?type=search";return"/search"}if("connectlogin"===item)return"/startup/connectlogin.html";if("selectserver"===item)return"/startup/selectserver.html";if("settings"===item)return serverId?"/settings?serverId="+serverId:"/settings";if("wizard"===item)return"/wizardstart.html";if("downloads"===item)return"/list/list.html?parentId=downloads";if("downloadsettings"===item)return"/settings/download.html";if("premiere"===item)return"/embypremiere";if("managedownloads"===item)return"/settings/managedownloads.html";if("manageserver"===item)return"/dashboard";if("recordedtv"===item)return"/livetv?tab=recordings&serverId="+serverId;if("nextup"===item)return"/list/list.html?type=nextup&serverId="+serverId;if("PluginCatalog"===item)return"/plugincatalog";if("livetv"===item||"livetv"===item.CollectionType)return"programs"===options.section?"/livetv?tab=suggestions&serverId="+serverId:"guide"===options.section?"/livetv?tab=guide&serverId="+serverId:"movies"===options.section?"/list/list.html?type=Program&IsMovie=true&serverId="+serverId:"shows"===options.section?"/list/list.html?type=Program&IsSeries=true&IsMovie=false&IsNews=false&serverId="+serverId:"sports"===options.section?"/list/list.html?type=Program&IsSports=true&serverId="+serverId:"kids"===options.section?"/list/list.html?type=Program&IsKids=true&serverId="+serverId:"news"===options.section?"/list/list.html?type=Program&IsNews=true&serverId="+serverId:"onnow"===options.section?"/list/list.html?type=OnNow&serverId="+serverId:"dvrschedule"===options.section?"/livetv?tab=schedule&serverId="+serverId:"/livetv?serverId="+serverId;if("list"===item)return url="/list/list.html?serverId="+serverId+"&type="+options.itemTypes,options.isFavorite&&(url+="&IsFavorite=true"),options.artistId&&(url+="&artistId="+options.artistId),options.albumArtistId&&(url+="&albumArtistId="+options.albumArtistId),url;var itemType=item.Type||(options?options.itemType:null);if("EmbyConnect"===itemType)return getRouteUrl("connectlogin");if("Downloads"===itemType)return getRouteUrl("downloads");if("SelectServer"===itemType)return getRouteUrl("selectserver");if("ForgotPassword"===itemType)return"/startup/forgotpassword.html?serverId="+serverId;if("ManualLogin"===itemType)return url="/startup/manuallogin.html?serverId="+serverId,item.Username&&(url+="&user="+encodeURIComponent(item.Username)),url;if("SeriesTimer"===itemType)return"/item?seriesTimerId="+id+"&serverId="+serverId;if("Device"===itemType)return"/devices/device.html?id="+id;if("Log"===itemType)return"/log?name="+item.Name;if("AddServer"===itemType)return"/startup/manualserver.html";if("Plugin"===itemType)return pluginManager.allowPluginPages(item.Id)?"/"+item.ConfigPageUrl:null;if("User"===itemType)return"/users/user?userId="+id;if("LiveTVTunerDevice"===itemType)return"/livetvsetup/livetvtuner.html?id="+id;if("LiveTVGuideSource"===itemType)return function(url,name,value){return-1===url.indexOf("?")?url+"?"+name+"="+value:url+"&"+name+"="+value}(item.SetupUrl,"id",id);if("GameGenre"===itemType)return url="/list/list.html?gameGenreId="+id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("MusicGenre"===itemType)return url="/list/list.html?musicGenreId="+id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("Tag"===itemType||"Studio"===itemType||"Genre"===itemType)return url="/list/list.html?"+item.Type.toLowerCase()+"Id="+id+"&serverId="+serverId,"livetv"===context&&(url+="&type=Program"),options.parentId&&(url+="&parentId="+options.parentId),options.itemTypes&&(url+="&type="+options.itemTypes),url;if("folders"!==context&&"GameSystem"===item.Type)return url="/list/list.html?type=Game&serverId="+serverId,url+="&parentId="+id;if("folders"!==context&&!itemHelper.isLocalItem(item)){if("games"===item.CollectionType)return url="/games?serverId="+serverId+"&parentId="+id;if("musicvideos"===item.CollectionType||"homevideos"===item.CollectionType||"movies"===item.CollectionType||"CollectionFolder"===item.Type&&!item.CollectionType&&connectionManager.getApiClient(item).isMinServerVersion("4.6.0.15"))return url="/videos?serverId="+serverId+"&parentId="+id,"latest"===options.section&&"movies"===item.CollectionType&&(url+="&tab=suggestions"),url;if("tvshows"===item.CollectionType)return url="/tv?serverId="+serverId+"&parentId="+id,"latest"===options.section&&(url+="&tab=suggestions"),url;if("music"===item.CollectionType||"audiobooks"===item.CollectionType)return url="/music?serverId="+serverId+"&parentId="+id}return"PluginCatalogItem"===itemType?"plugins/install?name="+encodeURIComponent(item.Name)+"&guid="+item.Id:"Playlist"===itemType||"TvChannel"===itemType||"BoxSet"===itemType||"MusicAlbum"===itemType||"MusicGenre"===itemType||"Person"===itemType||"Recording"===itemType||"MusicArtist"===itemType?"/item?id="+id+"&serverId="+serverId:"Program"===itemType?item.AsSeries?"/item?id="+id+"&asSeries=true&serverId="+serverId:"/item?id="+id+"&serverId="+serverId:"Series"===itemType||"Season"===itemType||"Episode"===itemType?"/item?id="+id+(context?"&context="+context:"")+"&serverId="+serverId:item.IsFolder?id?"/list/list.html?parentId="+id+"&serverId="+serverId:"#":"/item?id="+id+"&serverId="+serverId}function showAlert(text){return require(["alert"]).then(function(responses){return responses[0](text)})}function showItem(item,serverId,options){if("string"==typeof item){var apiClient=serverId?connectionManager.getApiClient(serverId):connectionManager.currentApiClient();return apiClient.getItem(apiClient.getCurrentUserId(),item).then(function(item){return appRouter.showItem(item,options)})}if("Plugin"===item.Type){if(!item.ConfigPageUrl)return showAlert(globalize.translate("NoPluginConfigurationMessage"));if(!pluginManager.allowPluginPages(item.Id))return showAlert(globalize.translate("MessagePluginConfigurationRequiresLocalAccess"))}else if("Server"===item.Type)return Promise.reject();return 2===arguments.length&&(options=serverId),show(appRouter.getRouteUrl(item,options),{item:item})}function addRoute(path,newRoute){path&&newRoute?page(path,newRoute,handleRoute):function(newRoute){var baseRoute=baseUrl(),path=(path=newRoute.path).replace(baseRoute,"");console.log("Defining route: "+path),addRoute(path,newRoute)}(path)}return endsWith(baseRoute=baseRoute.split("#")[0],"/")&&!endsWith(baseRoute,"://")&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),document.addEventListener("viewshow",function(){var resolve=resolveOnNextShow;resolve&&(resolveOnNextShow=null,resolve())}),function(){var baseRoute=self.location.pathname.replace(getRequestFile(),"");baseRoute.lastIndexOf("/")===baseRoute.length-1&&(baseRoute=baseRoute.substring(0,baseRoute.length-1)),console.log("Setting page base to "+baseRoute),page.base(baseRoute)}(),appRouter.addRoute=addRoute,appRouter.back=function(){page.back()},appRouter.show=show,appRouter.start=function(options){return loading.show(),initApiClients(),events.on(appHost,"beforeexit",onBeforeExit),events.on(appHost,"resume",onAppResume),connectionManager.connect({enableAutoLogin:appSettings.enableAutoLogin()}).then(function(result){firstConnectionResult=result,loading.hide(),page({click:!1!==(options=options||{}).click,hashbang:!1!==options.hashbang})})},appRouter.baseUrl=baseUrl,appRouter.canGoBack=function(){var curr=current();return!!curr&&("home"!==curr.type&&page.canGoBack())},appRouter.current=current,appRouter.beginConnectionWizard=beginConnectionWizard,appRouter.goHome=function(){return show(getHomeRoute())},appRouter.showItem=showItem,appRouter.setTitle=function(title){require(["appHeader"],function(appHeader){appHeader.setTitle(title)})},appRouter.setTransparency=function(level){backdropContainer=backdropContainer||document.querySelector(".backdropContainer"),backgroundContainer=backgroundContainer||document.querySelector(".backgroundContainer"),"full"===level||2===level?(backdrop.clear(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):"backdrop"===level||1===level?(backdrop.externalBackdrop(!0),document.documentElement.classList.add("transparentDocument"),backgroundContainer.classList.add("backgroundContainer-transparent"),backdropContainer.classList.add("hide")):(backdrop.externalBackdrop(!1),document.documentElement.classList.remove("transparentDocument"),backgroundContainer.classList.remove("backgroundContainer-transparent"),backdropContainer.classList.remove("hide"))},appRouter.getRoutes=function(){return page.getRoutes()},appRouter.getRouteUrl=getRouteUrl,appRouter.getRouteInfo=getRouteInfo,appRouter.pushState=function(state,title,url){state.navigate=!1,page.pushState(state,title,url)},appRouter.enableNativeHistory=function(){return!browser.orsay},appRouter.showVideoOsd=function(options){var url="/videoosd/videoosd.html";return options&&options.controls&&(url+="?controls=true"),show(url)},appRouter.handleAnchorClick=page.handleAnchorClick,appRouter.TransparencyLevel={None:0,Backdrop:1,Full:2},appRouter.invokeShortcut=function(id){return id.startsWith("library-")?showItem((id=(id=id.replace("library-","")).split("_"))[0],id[1]):id.startsWith("item-")?showItem((id=(id=id.replace("item-","")).split("_"))[0],id[1]):(id=id.split("_"),show(appRouter.getRouteUrl(id[0],{serverId:id[1]})))},appRouter.logout=function(){require(["playbackManager"],function(playbackManager){loading.show(),playbackManager.stop(),connectionManager.logout().then(beginConnectionWizard)})},appRouter.handleConnectionResult=handleConnectionResult,appRouter.validateUserAccessToRoute=validateUserAccessToRoute,appRouter});