define(["appSettings","commandProcessor","inputManager","connectionManager","appRouter","globalize","loading","dom","recordingHelper"],function(appSettings,commandProcessor,inputManager,connectionManager,appRouter,globalize,loading,dom,recordingHelper){"use strict";function getItemElementFromChildNode(child,isMainElement){return isMainElement?child.closest(".card,.listItem,.epgRow"):child.closest("[data-type],.card,.listItem,.epgRow")}function getItemFromElement(element){var itemsContainer=element.closest(".itemsContainer");if(itemsContainer){var item=itemsContainer.getItemFromElement(element);if(item)return item}return function(card){var item={Type:card.getAttribute("data-type"),Id:card.getAttribute("data-id"),ServerId:card.getAttribute("data-serverid"),IsFolder:"true"===card.getAttribute("data-isfolder"),Status:card.getAttribute("data-status")||null},timerId=card.getAttribute("data-timerid");timerId&&(item.TimerId=timerId);var seriesTimerId=card.getAttribute("data-seriestimerid");return seriesTimerId&&(item.SeriesTimerId=seriesTimerId),item}(element)}function notifyRefreshNeeded(childElement,itemsContainer){(itemsContainer=itemsContainer||childElement.closest("[is=emby-itemscontainer]"))&&itemsContainer.notifyRefreshNeeded(!0)}function showContextMenu(card,options){return function(button){var itemFromElement=getItemFromElement(button=getItemElementFromChildNode(button)),type=itemFromElement.Type;if("Plugin"===type||"Device"===type||"Server"===type||"Log"===type||"ApiKey"===type||"ActivityLogEntry"===type||"MediaStream"===type||"ItemImage"===type||"LiveTVTunerDevice"===type||"LiveTVGuideSource"===type||"ChannelManagementInfo"===type)return Promise.resolve(itemFromElement);var id=itemFromElement.Id;if(!id)return Promise.resolve(itemFromElement);var apiClient=connectionManager.getApiClient(itemFromElement);return"VirtualFolder"===type?function(apiClient,id){return apiClient.getVirtualFolders().then(function(result){return result.Items.filter(function(u){return u.ItemId===id})[0]})}(apiClient,id):"User"===type?apiClient.getUser(id):"Timer"===type?apiClient.getLiveTvTimer(id):"SeriesTimer"===type?apiClient.getLiveTvSeriesTimer(id):apiClient.getItem(apiClient.getCurrentUserId(),id).then(function(fullItem){return fullItem.PlaylistItemId=itemFromElement.PlaylistItemId,fullItem.CollectionId=itemFromElement.CollectionId,fullItem.PlaylistId=itemFromElement.PlaylistId,fullItem})}(card).then(function(item){return require(["itemContextMenu"]).then(function(responses){return function(item){var serverId=item.ServerId;if(!serverId)return Promise.resolve(null);var apiClient=connectionManager.getApiClient(serverId);return apiClient.getCurrentUserId()?apiClient.getCurrentUser():Promise.resolve(null)}(item).then(function(user){var itemsContainer=options.itemsContainer||card.closest(".itemsContainer");options.positionTo&&!options.itemElement&&(options.itemElement=card);var contextMenuExcludes=(itemsContainer.getAttribute("data-excludecontextcommands")||"").split(",");return responses[0].show(Object.assign({item:item,play:!0,queue:!0,playAllFromHere:!item.IsFolder,queueAllFromHere:!item.IsFolder,user:user,multiSelect:!!card.querySelector(".chkItemSelectContainer"),removeFromNextUp:"removefromnextup"===itemsContainer.getAttribute("data-commands"),removeFromResume:"removefromresume"===itemsContainer.getAttribute("data-commands"),openAlbum:!contextMenuExcludes.includes("viewalbum"),openArtist:!contextMenuExcludes.includes("viewartist")},options)).then(function(result){return"playallfromhere"===(result=result||{}).command||"queueallfromhere"===result.command?executeAction(null,card,options.positionTo,result.command):void((result.updated||result.deleted)&&notifyRefreshNeeded(card,itemsContainer))},onRejected)})})})}function onRejected(){}function executeAction(originalEvent,card,target,action){target=target||card;var item=getItemFromElement(card=getItemElementFromChildNode(card)),serverId=item.ServerId,type=item.Type;if("programdialog"===action)!function(item){require(["recordingCreator"],function(recordingCreator){recordingCreator.show(item)})}(item);else if("record"===action)!function(serverId,id,type,timerId,timerStatus,seriesTimerId){{var programId;("Program"===type||timerId||seriesTimerId)&&(programId="Program"===type?id:null,recordingHelper.toggleRecording(serverId,programId,timerId,timerStatus,seriesTimerId))}}(serverId,item.Id,type,item.TimerId,item.Status,item.SeriesTimerId);else{if("custom"!==action){var options={};return options.positionTo=target,options.itemElement=card,options.eventType=originalEvent.type,options.eventTarget=originalEvent.target,"menu"===action||"info"===action?(originalEvent&&"click"===originalEvent.type&&(options.positionY="bottom",options.positionX="right"),showContextMenu(card,options),Promise.resolve()):commandProcessor.executeCommand(action,item,options).then(function(id,card){return function(){switch(id){case"canceltimer":case"cancelseriestimer":case"delete":notifyRefreshNeeded(card)}return Promise.resolve()}}(action,card),returnResolvedPromise)}var customAction=target.getAttribute("data-customaction");card.dispatchEvent(new CustomEvent("action-"+customAction,{detail:{playlistItemId:item.PlaylistItemId,item:item},cancelable:!1,bubbles:!0}))}}function returnResolvedPromise(){return Promise.resolve()}function onClick(e){var card=e.target.closest(".itemAction");if(card){var actionElement=card,action=actionElement.getAttribute("data-action");if(action||(actionElement=actionElement.closest("[data-action]"))&&(action=actionElement.getAttribute("data-action")),action&&(executeAction(e,card,actionElement,action),"multiselect"!==action&&"openlink"!==action&&"togglechanneldisabled"!==action))return"default"!==action&&e.preventDefault(),e.stopPropagation(),!1}}function onCommand(e){var target,itemsContainer,scroller,card,cmd=e.detail.command;"play"===cmd||"playpause"===cmd?(card=getItemElementFromChildNode(target=e.target))&&((itemsContainer=target.closest(".itemsContainer"))&&"true"===itemsContainer.getAttribute("data-skipplaycommands")||(e.preventDefault(),e.stopPropagation(),executeAction(e,card,card,cmd))):"resume"===cmd||"record"===cmd||"menu"===cmd||"info"===cmd?(card=getItemElementFromChildNode(target=e.target))&&(e.preventDefault(),e.stopPropagation(),executeAction(e,card,card,cmd)):"pageup"===cmd?(itemsContainer=(target=e.target).closest(".itemsContainer"))&&(scroller=itemsContainer.closest("[is=emby-scroller]"))&&"false"===scroller.getAttribute("data-horizontal")&&(itemsContainer.pageUp(target),e.preventDefault(),e.stopPropagation()):"pagedown"===cmd?(itemsContainer=(target=e.target).closest(".itemsContainer"))&&(scroller=itemsContainer.closest("[is=emby-scroller]"))&&"false"===scroller.getAttribute("data-horizontal")&&(itemsContainer.pageDown(target),e.preventDefault(),e.stopPropagation()):"end"===cmd&&(itemsContainer=(target=e.target).closest(".itemsContainer"))&&(scroller=itemsContainer.closest("[is=emby-scroller]"))&&"false"===scroller.getAttribute("data-horizontal")&&(itemsContainer.focusLast(),e.preventDefault(),e.stopPropagation())}return{on:function(context,options){!1!==(options=options||{}).click&&context.addEventListener("click",onClick),!1!==options.command&&inputManager.on(context,onCommand)},off:function(context,options){options=options||{},context.removeEventListener("click",onClick),!1!==options.command&&inputManager.off(context,onCommand)},onClick:onClick,getShortcutAttributesHtml:function(item,options){var type,serverId,itemId,dataAttributes="";return options.isListItem||((type=item.Type)&&(dataAttributes+=' data-type="'+type+'"'),(serverId=item.ServerId||options.serverId)&&(dataAttributes+=' data-serverid="'+serverId+'"')),options.isVirtualList||(itemId=item.Id||item.ItemId)&&(dataAttributes+=' data-id="'+itemId+'"'),dataAttributes},getShortcutAttributes:function(item,options){var type,serverId,itemId,dataAttributes=[];return options.isListItem||((type=item.Type)&&dataAttributes.push({name:"data-type",value:type}),(serverId=item.ServerId||options.serverId)&&dataAttributes.push({name:"data-serverid",value:serverId})),options.isVirtualList||(itemId=item.Id||item.ItemId)&&dataAttributes.push({name:"data-id",value:itemId}),dataAttributes},getItemElementFromChildNode:getItemElementFromChildNode,getItemFromChildNode:function(child,isMainElement){return getItemFromElement(getItemElementFromChildNode(child,isMainElement))}}});