define(["apphost","dom","globalize","connectionManager","layoutManager","focusManager","appSettings","registrationServices","dialogHelper","paper-icon-button-light","formDialogStyle","emby-scroller"],function(appHost,dom,globalize,connectionManager,layoutManager,focusManager,appSettings,registrationServices,dialogHelper){"use strict";var currentDialogOptions;function showSubmissionToast(){require(["toast"],function(toast){toast(globalize.translate("DownloadingDots"))})}function syncNow(){require(["localsync"],function(localSync){localSync.sync()})}function setJobValues(job,form){var txtBitrate=form.querySelector("#txtBitrate"),bitrate=(bitrate=txtBitrate?txtBitrate.value:null)&&1e6*parseFloat(bitrate);job.Bitrate=bitrate;var selectQuality=form.querySelector("#selectQuality");selectQuality&&(job.Quality=selectQuality.value,appSettings.set("sync-lastquality",job.Quality||""));var selectProfile=form.querySelector("#selectProfile");selectProfile&&(job.Profile=selectProfile.value);var selectContainer=form.querySelector("#selectContainer");selectContainer&&(job.Container=selectContainer.value);var selectVideoCodec=form.querySelector("#selectVideoCodec");selectVideoCodec&&(job.VideoCodec=selectVideoCodec.value);var selectAudioCodec=form.querySelector("#selectAudioCodec");selectAudioCodec&&(job.AudioCodec=selectAudioCodec.value);var txtItemLimit=form.querySelector("#txtItemLimit");txtItemLimit&&(job.ItemLimit=txtItemLimit.value||null);var chkSyncNewContent=form.querySelector("#chkSyncNewContent");chkSyncNewContent&&(job.SyncNewContent=chkSyncNewContent.checked);var chkUnwatchedOnly=form.querySelector("#chkUnwatchedOnly");chkUnwatchedOnly&&(job.UnwatchedOnly=chkUnwatchedOnly.checked)}function renderForm(options){return new Promise(function(resolve,reject){require(["emby-checkbox","emby-input","emby-select"],function(){!function(options,defaultTargetId,resolve){var elem=options.elem,dialogOptions=options.dialogOptions,targets=dialogOptions.Targets,html="",mode=options.mode,targetContainerClass="download"===mode?" hide":"",syncTargetLabel="convert"===mode?globalize.translate("LabelConvertTo"):globalize.translate("LabelDownloadTo");options.readOnlySyncTarget?(html+='<div class="inputContainer'+targetContainerClass+'">',html+='<input is="emby-input" type="text" id="selectSyncTarget" readonly label="'+syncTargetLabel+'"/>'):(html+='<div class="selectContainer'+targetContainerClass+'">',html+='<select is="emby-select" id="selectSyncTarget" required="required" label="'+syncTargetLabel+'">',html+=targets.map(function(t){return"<option"+(defaultTargetId===t.Id?' selected="selected"':"")+' value="'+t.Id+'">'+t.Name+"</option>"}).join(""),html+="</select>",targets.length||(html+='<div class="fieldDescription">'+globalize.translate("LabelSyncNoTargetsHelp")+"</div>"),appHost.supports("externallinks")&&(html+='<div class="fieldDescription"><a is="emby-linkbutton" class="button-link lnkLearnMore" href="https://support.emby.media/support/solutions/articles/44001162174-sync" target="_blank">'+globalize.translate("LearnMore")+"</a></div>")),html+="</div>";var settingsDisabled=!1;options.readOnlySyncTarget&&-1===dialogOptions.Options.indexOf("UnwatchedOnly")&&-1===dialogOptions.Options.indexOf("SyncNewContent")&&-1===dialogOptions.Options.indexOf("ItemLimit")&&(settingsDisabled=!0);html+='<div class="fldProfile selectContainer hide">',html+='<select is="emby-select" id="selectProfile" '+(settingsDisabled?"disabled":"")+'  label="'+globalize.translate("LabelProfile")+'">',html+="</select>",html+='<div class="fieldDescription profileDescription"></div>',html+="</div>",html+='<div class="customProfileOptions hide">',html+='<div class="selectContainer">',html+='<select is="emby-select" id="selectContainer" required="required" '+(settingsDisabled?"disabled":"")+'  label="'+globalize.translate("LabelContainer")+'">',html+='<option value="mkv">mkv</option>',html+='<option value="mp4">mp4</option>',html+='<option value="ts">ts</option>',html+="</select>",html+='<div class="fieldDescription containerDescription"></div>',html+="</div>",html+='<div class="selectContainer">',html+='<select is="emby-select" id="selectVideoCodec" required="required" '+(settingsDisabled?"disabled":"")+'  label="'+globalize.translate("LabelVideoCodec")+'">',html+='<option value="h264">h264</option>',html+='<option value="hevc">hevc</option>',html+='<option value="h264,hevc">h264, hevc</option>',html+='<option value="hevc,h264">hevc, h264</option>';html+="</select>",html+='<div class="fieldDescription videoCodecDescription"></div>',html+="</div>",html+='<div class="selectContainer">',html+='<select is="emby-select" id="selectAudioCodec" required="required" '+(settingsDisabled?"disabled":"")+'  label="'+globalize.translate("LabelAudioCodec")+'">',html+='<option value="aac">aac</option>',html+='<option value="mp3">mp3</option>',html+='<option value="aac,mp3">aac, mp3</option>',html+='<option value="aac,mp3,ac3">aac, mp3, ac3</option>';html+="</select>",html+='<div class="fieldDescription audioCodecDescription"></div>',html+="</div>",html+="</div>",html+='<div class="fldQuality selectContainer hide">',html+='<select is="emby-select" id="selectQuality" required="required" '+(settingsDisabled?"disabled":"")+'  label="'+globalize.translate("LabelQuality")+'">',html+="</select>",html+='<div class="fieldDescription qualityDescription"></div>',html+="</div>",html+='<div class="fldBitrate inputContainer hide">',html+='<input is="emby-input" type="number" step=".1" min=".1" '+(settingsDisabled?"readonly":"")+' id="txtBitrate" label="'+globalize.translate("LabelBitrateMbps")+'"/>',html+="</div>",-1!==dialogOptions.Options.indexOf("UnwatchedOnly")&&(html+='<div class="checkboxContainer checkboxContainer-withDescription">',html+="<label>",html+='<input is="emby-checkbox" type="checkbox" id="chkUnwatchedOnly"/>',html+="convert"===mode?"<span>"+globalize.translate("ConvertUnwatchedVideosOnly")+"</span>":"<span>"+globalize.translate("SyncUnwatchedVideosOnly")+"</span>",html+="</label>",html+="convert"===mode?'<div class="fieldDescription checkboxFieldDescription">'+globalize.translate("ConvertUnwatchedVideosOnlyHelp")+"</div>":'<div class="fieldDescription checkboxFieldDescription">'+globalize.translate("SyncUnwatchedVideosOnlyHelp")+"</div>",html+="</div>");-1!==dialogOptions.Options.indexOf("SyncNewContent")&&(html+='<div class="checkboxContainer checkboxContainer-withDescription">',html+="<label>",html+='<input is="emby-checkbox" type="checkbox" id="chkSyncNewContent"/>',html+="convert"===mode?"<span>"+globalize.translate("AutomaticallyConvertNewContent")+"</span>":"<span>"+globalize.translate("AutomaticallySyncNewContent")+"</span>",html+="</label>",html+="convert"===mode?'<div class="fieldDescription checkboxFieldDescription">'+globalize.translate("AutomaticallyConvertNewContentHelp")+"</div>":'<div class="fieldDescription checkboxFieldDescription">'+globalize.translate("AutomaticallySyncNewContentHelp")+"</div>",html+="</div>");-1!==dialogOptions.Options.indexOf("ItemLimit")&&(html+='<div class="inputContainer">',html+='<input is="emby-input" type="number" step="1" min="1" id="txtItemLimit" label="'+globalize.translate("LabelItemLimit")+'"/>',html+="convert"===mode?'<div class="fieldDescription">'+globalize.translate("ConvertItemLimitHelp")+"</div>":'<div class="fieldDescription">'+globalize.translate("DownloadItemLimitHelp")+"</div>",html+="</div>");elem.innerHTML=html;var selectSyncTarget=elem.querySelector("#selectSyncTarget");selectSyncTarget&&(selectSyncTarget.addEventListener("change",function(){var form,targetId;form=elem,targetId=this.value,(0,options.dialogOptionsFn)(targetId).then(function(options){return function(form,options){currentDialogOptions=options;var fldProfile=form.querySelector(".fldProfile"),selectProfile=form.querySelector("#selectProfile");options.ProfileOptions.length&&-1!==options.Options.indexOf("Profile")?(fldProfile&&fldProfile.classList.remove("hide"),selectProfile&&selectProfile.setAttribute("required","required")):(fldProfile&&fldProfile.classList.add("hide"),selectProfile&&selectProfile.removeAttribute("required"));setQualityFieldVisible(form,0<options.QualityOptions.length),selectProfile&&(selectProfile.innerHTML=options.ProfileOptions.map(function(o){var selectedAttribute=o.IsDefault?' selected="selected"':"";return'<option value="'+o.Id+'"'+selectedAttribute+">"+o.Name+"</option>"}).join(""),selectProfile.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectQuality=form.querySelector("#selectQuality");{var lastQuality;selectQuality&&(selectQuality.innerHTML=options.QualityOptions.map(function(o){var selectedAttribute=o.IsDefault?' selected="selected"':"";return'<option value="'+o.Id+'"'+selectedAttribute+">"+o.Name+"</option>"}).join(""),(lastQuality=appSettings.get("sync-lastquality"))&&options.QualityOptions.filter(function(i){return i.Id===lastQuality}).length&&(selectQuality.value=lastQuality),selectQuality.dispatchEvent(new CustomEvent("change",{bubbles:!0})))}}(form,options)}).then(resolve)}),selectSyncTarget.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectProfile=elem.querySelector("#selectProfile");selectProfile&&(selectProfile.addEventListener("change",function(){!function(form,profileId){var options=currentDialogOptions||{},option=(options.ProfileOptions||[]).filter(function(o){return o.Id===profileId})[0],qualityOptions=options.QualityOptions||[];option?(form.querySelector(".profileDescription").innerHTML=option.Description||"",setQualityFieldVisible(form,0<qualityOptions.length&&option.EnableQualityOptions&&-1!==options.Options.indexOf("Quality"))):(form.querySelector(".profileDescription").innerHTML="",setQualityFieldVisible(form,0<qualityOptions.length&&-1!==options.Options.indexOf("Quality")));var customProfileOptions=form.querySelector(".customProfileOptions"),customProfileSelects=customProfileOptions.querySelectorAll("select"),customProfileSelectsRequired=!1;"custom"===profileId?(customProfileOptions.classList.remove("hide"),customProfileSelectsRequired=!0):customProfileOptions.classList.add("hide");for(var i=0,length=customProfileSelects.length;i<length;i++)customProfileSelectsRequired?customProfileSelects[i].setAttribute("required","required"):customProfileSelects[i].removeAttribute("required")}(elem,this.value)}),dialogOptions.ProfileOptions.length&&selectProfile.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectQuality=elem.querySelector("#selectQuality");selectQuality&&(selectQuality.addEventListener("change",function(){onQualityChange(elem,this.value)}),selectQuality.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectContainer=elem.querySelector("#selectContainer");selectContainer&&(selectContainer.addEventListener("change",onContainerChange),selectContainer.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectVideoCodec=elem.querySelector("#selectVideoCodec");selectVideoCodec&&(selectVideoCodec.addEventListener("change",onVideoCodecChange),selectVideoCodec.dispatchEvent(new CustomEvent("change",{bubbles:!0})));var selectAudioCodec=elem.querySelector("#selectAudioCodec");selectAudioCodec&&(selectAudioCodec.addEventListener("change",onAudioCodecChange),selectAudioCodec.dispatchEvent(new CustomEvent("change",{bubbles:!0})));setTimeout(function(){focusManager.autoFocus(elem)},100)}(options,connectionManager.deviceId(),resolve)})})}function validateNetwork(){switch(navigator.connection?navigator.connection.type:null){case"cellular":case"bluetooth":return void require(["dialog","appRouter"],function(dialog,appRouter){var options={title:globalize.translate("HeaderWaitingForWifi"),text:globalize.translate("WifiRequiredToDownload")},items=[];items.push({name:options.confirmText||globalize.translate("ButtonOk"),id:"ok",type:"submit"}),items.push({name:options.cancelText||globalize.translate("HeaderDownloadSettings"),id:"downloadsettings",type:"cancel"}),options.buttons=items,dialog(options).then(function(result){return"ok"===result?Promise.resolve():"downloadsettings"===result?appRouter.show(appRouter.getRouteUrl("downloadsettings")):Promise.reject()})});default:return 1}}function setQualityFieldVisible(form,visible){var fldQuality=form.querySelector(".fldQuality"),selectQuality=form.querySelector("#selectQuality");visible?(fldQuality&&fldQuality.classList.remove("hide"),selectQuality&&(selectQuality.removeAttribute("required"),onQualityChange(form,selectQuality.value))):(fldQuality&&fldQuality.classList.add("hide"),selectQuality&&selectQuality.removeAttribute("required"),onQualityChange(form,""))}function onContainerChange(){this.closest(".selectContainer").querySelector(".fieldDescription").innerHTML=globalize.translate("VideoFilesWillBeConvertedTo",this.value)}function onVideoCodecChange(){var description=this.closest(".selectContainer").querySelector(".fieldDescription"),value=this.value,values=value.split(",");1<values.length?description.innerHTML=globalize.translate("VideoWillBeConvertedToOrCopied",values[0],value):description.innerHTML=globalize.translate("VideoWillBeConvertedTo",value)}function onAudioCodecChange(){var description=this.closest(".selectContainer").querySelector(".fieldDescription"),value=this.value,values=value.split(",");1<values.length?description.innerHTML=globalize.translate("AudioWillBeConvertedToOrCopied",values[0],value):description.innerHTML=globalize.translate("AudioWillBeConvertedTo",value)}function onQualityChange(form,qualityId){var option=((currentDialogOptions||{}).QualityOptions||[]).filter(function(o){return o.Id===qualityId})[0],qualityDescription=form.querySelector(".qualityDescription");qualityDescription.innerHTML=option&&option.Description||"";var fldBitrate=form.querySelector(".fldBitrate"),txtBitrate=form.querySelector("#txtBitrate");"custom"===qualityId?(fldBitrate&&fldBitrate.classList.remove("hide"),txtBitrate&&txtBitrate.setAttribute("required","required")):(fldBitrate&&fldBitrate.classList.add("hide"),txtBitrate&&txtBitrate.removeAttribute("required"))}return{showMenu:function(options){return"download"===options.mode&&appSettings.syncOnlyOnWifi()&&!validateNetwork()?Promise.reject():registrationServices.validateFeature("sync").then(function(){return function(options){var apiClient=connectionManager.getApiClient(options.serverId),userId=apiClient.getCurrentUserId();if(function(options){if("download"!==options.mode)return!1;var firstItem=(options.items||[])[0]||{};return"Audio"===firstItem.Type||("Photo"===firstItem.Type||("MusicAlbum"===firstItem.Type||("MusicArtist"===firstItem.Type||("MusicGenre"===firstItem.Type||"Playlist"===firstItem.Type&&"Audio"===firstItem.MediaType))))}(options))return function(apiClient,userId,targetId,syncOptions){if(!userId)throw new Error("userId cannot be null");if(!syncOptions)throw new Error("syncOptions cannot be null");if(!targetId)throw new Error("targetId cannot be null");var options={userId:userId,TargetId:targetId,ParentId:syncOptions.ParentId,Category:syncOptions.Category,Quality:syncOptions.Quality,Bitrate:syncOptions.Bitrate};return syncOptions.items&&syncOptions.items.length&&(options.ItemIds=(syncOptions.items||[]).map(function(i){return i.Id||i}).join(",")),apiClient.ajax({type:"POST",url:apiClient.getUrl("Sync/Jobs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}).then(function(){showSubmissionToast(),"download"===syncOptions.mode&&syncNow()})}(apiClient,userId,apiClient.deviceId(),{items:options.items,Quality:"custom",Bitrate:appSettings.maxStaticMusicBitrate()});var dialogOptionsFn=function(apiClient,query){return function(targetId){return query.TargetId=targetId,apiClient.getJSON(apiClient.getUrl("Sync/Options",query))}}(apiClient,{UserId:userId,ItemIds:(options.items||[]).map(function(i){return i.Id||i}).join(","),ParentId:options.ParentId,Category:options.Category,IncludeProviders:"convert"===options.mode?"ConvertSyncProvider":null,ExcludeProviders:"convert"===options.mode?null:"ConvertSyncProvider"});return dialogOptionsFn().then(function(dialogOptions){currentDialogOptions=dialogOptions;var dlgElementOptions={removeOnClose:!0,scrollY:!1,autoFocus:!1};layoutManager.tv?dlgElementOptions.size="fullscreen":dlgElementOptions.size="small";var dlg=dialogHelper.createDialog(dlgElementOptions);dlg.classList.add("formDialog");var html="";html+='<div class="formDialogHeader">',html+='<button is="paper-icon-button-light" class="btnCancel autoSize" tabindex="-1"><i class="md-icon">&#xE5C4;</i></button>',html+='<h3 class="formDialogHeaderTitle">';var syncButtonLabel="download"!==options.mode&&"convert"===options.mode?globalize.translate("Convert"):globalize.translate("Download");html+=syncButtonLabel,html+="</h3>",appHost.supports("externallinks")&&(html+='<a is="emby-linkbutton" href="https://support.emby.media/support/solutions/articles/44001162174-sync" target="_blank" class="button-link lnkHelp" style="margin-top:0;display:inline-block;vertical-align:middle;margin-left:auto;"><i class="md-icon">info</i><span>'+globalize.translate("Help")+"</span></a>"),html+="</div>",html+='<div is="emby-scroller" data-horizontal="false" data-centerfocus="card" class="formDialogContent">',html+='<div class="scrollSlider">',html+='<form class="dialogContentInner dialog-content-centered formSubmitSyncRequest padded-left padded-right" style="padding-top:2em;">',html+='<div class="formFields"></div>',html+='<div class="formDialogFooter">',html+='<button is="emby-button" type="submit" class="raised button-submit block formDialogFooterItem"><span>'+syncButtonLabel+"</span></button>",html+="</div>",html+="</form>",html+="</div>",html+="</div>",dlg.innerHTML=html;var submitted=!1;dlg.querySelector("form").addEventListener("submit",function(e){return submitted=function(dlg,apiClient,userId,syncOptions,form){if(!userId)throw new Error("userId cannot be null");if(!syncOptions)throw new Error("syncOptions cannot be null");if(!form)throw new Error("form cannot be null");var selectSyncTarget=form.querySelector("#selectSyncTarget"),target=selectSyncTarget?selectSyncTarget.value:null;if(!target)return require(["toast"],function(toast){toast(globalize.translate("PleaseSelectDeviceToSyncTo"))}),!1;var options={userId:userId,TargetId:target,ParentId:syncOptions.ParentId,Category:syncOptions.Category};return setJobValues(options,form),syncOptions.items&&syncOptions.items.length&&(options.ItemIds=(syncOptions.items||[]).map(function(i){return i.Id||i}).join(",")),apiClient.ajax({type:"POST",url:apiClient.getUrl("Sync/Jobs"),data:JSON.stringify(options),contentType:"application/json",dataType:"json"}).then(function(){dialogHelper.close(dlg),require(["toast"],function(toast){showSubmissionToast(),"download"===syncOptions.mode&&syncNow()})}),!0}(dlg,apiClient,userId,options,this),e.preventDefault(),!1}),dlg.querySelector(".btnCancel").addEventListener("click",function(){dialogHelper.close(dlg)});var promise=dialogHelper.open(dlg);return renderForm({elem:dlg.querySelector(".formFields"),dialogOptions:dialogOptions,dialogOptionsFn:dialogOptionsFn,mode:options.mode}),promise.then(function(){return submitted?Promise.resolve():Promise.reject()})})}(options)})},renderForm:renderForm,setJobValues:setJobValues}});