define(["connectionManager","serverNotifications","events","dom","imageLoader","loading","globalize","apphost","layoutManager","dialogHelper","listViewStyle","paper-icon-button-light","emby-button","formDialogStyle","emby-linkbutton","emby-scroller"],function(connectionManager,serverNotifications,events,dom,imageLoader,loading,globalize,appHost,layoutManager,dialogHelper){"use strict";function syncNow(){require(["localsync"],function(localSync){localSync.sync()})}function renderJob(context,job,dialogOptions){require(["syncDialog"],function(syncDialog){syncDialog.renderForm({elem:context.querySelector(".syncJobFormContent"),dialogOptions:dialogOptions,dialogOptionsFn:function(dialogOptions){return function(targetId){return Promise.resolve(dialogOptions)}}(dialogOptions),readOnlySyncTarget:!0}).then(function(){!function(context,job,editOptions){var selectProfile=context.querySelector("#selectProfile");selectProfile&&(selectProfile.value=job.Profile||"",triggerChange(selectProfile));var selectQuality=context.querySelector("#selectQuality");selectQuality&&(selectQuality.value=job.Quality||"",triggerChange(selectQuality));var selectContainer=context.querySelector("#selectContainer");selectContainer&&(selectContainer.value=job.Container||"",triggerChange(selectContainer));var selectVideoCodec=context.querySelector("#selectVideoCodec");selectVideoCodec&&(selectVideoCodec.value=job.VideoCodec||"",triggerChange(selectVideoCodec));var selectAudioCodec=context.querySelector("#selectAudioCodec");selectAudioCodec&&(selectAudioCodec.value=job.AudioCodec||"",triggerChange(selectAudioCodec));var chkUnwatchedOnly=context.querySelector("#chkUnwatchedOnly");chkUnwatchedOnly&&(chkUnwatchedOnly.checked=job.UnwatchedOnly);var chkSyncNewContent=context.querySelector("#chkSyncNewContent");chkSyncNewContent&&(chkSyncNewContent.checked=job.SyncNewContent);var txtItemLimit=context.querySelector("#txtItemLimit");txtItemLimit&&(txtItemLimit.value=job.ItemLimit);var txtBitrate=context.querySelector("#txtBitrate");job.Bitrate?txtBitrate.value=job.Bitrate/1e6:txtBitrate.value="";var target=editOptions.Targets.filter(function(t){return t.Id===job.TargetId})[0],targetName=target?target.Name:"",selectSyncTarget=context.querySelector("#selectSyncTarget");selectSyncTarget&&(selectSyncTarget.value=targetName)}(context,job,dialogOptions)})})}var supportsNativeLazyLoading="loading"in HTMLImageElement.prototype;function renderJobItems(context,items,apiClient){var html="";html+="<h1>"+globalize.translate("Items")+"</h1>",html+="<div>";html+=items.map(function(i){return function(jobItem,apiClient){var nextAction,html="",status=jobItem.Status;"Failed"===status||"Cancelled"===status?nextAction="retry":"Queued"===status||"Transferring"===status||"Converting"===status||"ReadyToTransfer"===status?nextAction="cancel":"Synced"!==status||jobItem.IsMarkedForRemoval||(nextAction="remove");var listItemClass="listItem listItem-border";layoutManager.tv&&nextAction&&(listItemClass+=" btnJobItemMenu"),layoutManager.tv&&(listItemClass+=" listItem-button");var imgUrl,tagName=layoutManager.tv?"button":"div";return html+="<"+tagName+' type="button" class="'+listItemClass+'" data-itemid="'+jobItem.Id+'" data-status="'+jobItem.Status+'" data-action="'+nextAction+'">',jobItem.PrimaryImageItemId&&(imgUrl=apiClient.getImageUrl(jobItem.PrimaryImageItemId,{type:"Primary",width:80,tag:jobItem.PrimaryImageTag})),imgUrl?(html+='<div class="listItemImageContainer">',html+=supportsNativeLazyLoading?'<img class="listItemImage" loading="lazy" src="'+imgUrl+'" />':'<img class="listItemImage lazy" loading="lazy" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" data-src="'+imgUrl+'" />'):(html+='<div class="listItemImageContainer defaultCardBackground defaultCardBackground0">',html+='<i class="md-icon listItemIcon">sync</i>'),html+="</div>",html+='<div class="listItemBody three-line">',html+='<h3 class="listItemBodyText">',html+=jobItem.ItemName,html+="</h3>","Failed"===jobItem.Status?html+='<div class="listItemBodyText-secondary listItemBodyText" style="color:red;">':html+='<div class="listItemBodyText-secondary listItemBodyText">',html+=globalize.translate("SyncJobItemStatus"+jobItem.Status),"Synced"===jobItem.Status&&jobItem.IsMarkedForRemoval&&(html+="<br/>",html+=globalize.translate("RemovingFromDevice")),html+="</div>",html+='<div class="listItemBodyText-secondary listItemBodyText" style="padding-top:5px;">',html+='<div style="background:#e0e0e0;height:2px;"><div style="background:#52B54B;width:'+(jobItem.Progress||0)+'%;height:100%;"></div></div>',html+="</div>",html+="</div>",layoutManager.tv||("retry"===nextAction?html+='<button type="button" is="paper-icon-button-light" class="btnJobItemMenu" data-action="'+nextAction+'"><i class="md-icon">&#xE001;</i></button>':"cancel"!==nextAction&&"remove"!==nextAction||(html+='<button type="button" is="paper-icon-button-light" class="btnJobItemMenu" data-action="'+nextAction+'"><i class="md-icon">&#xE15C;</i></button>')),html+="</"+tagName+">"}(i,apiClient,0)}).join(""),html+="</div>";var elem=context.querySelector(".jobItems");elem.innerHTML=html,imageLoader.lazyChildren(elem)}function showJobItemMenu(elem,jobId,apiClient){var action=elem.getAttribute("data-action"),context=elem.closest(".formDialog"),jobItemId=elem.closest(".listItem").getAttribute("data-itemid");"retry"===action?function(context,jobId,jobItemId,apiClient){!function(callback){require(["confirm"],function(confirm){confirm({text:globalize.translate("ConfirmRemoveDownload"),confirmText:globalize.translate("RemoveDownload"),cancelText:globalize.translate("KeepDownload"),primary:"cancel"}).then(callback)})}(function(){apiClient.ajax({type:"POST",url:apiClient.getUrl("Sync/JobItems/"+jobItemId+"/Enable")}).then(function(){appHost.supports("sync")&&syncNow(),loadJob(context,jobId,apiClient)})})}(context,jobId,jobItemId,apiClient):"cancel"!==action&&"remove"!==action||function(context,jobId,jobItemId,apiClient){!function(callback){require(["confirm"],function(confirm){confirm({text:globalize.translate("ConfirmRemoveDownload"),confirmText:globalize.translate("RemoveDownload"),cancelText:globalize.translate("KeepDownload"),primary:"cancel"}).then(callback)})}(function(){loading.show(),apiClient.ajax({type:"DELETE",url:apiClient.getUrl("Sync/JobItems/"+jobItemId)}).then(function(){appHost.supports("sync")&&syncNow(),loadJob(context,jobId,apiClient)})})}(context,jobId,jobItemId,apiClient)}function triggerChange(select){select.dispatchEvent(new CustomEvent("change",{bubbles:!0}))}function loadJob(context,id,apiClient){loading.show(),apiClient.getJSON(apiClient.getUrl("Sync/Jobs/"+id)).then(function(job){return apiClient.getJSON(apiClient.getUrl("Sync/Options",{UserId:job.UserId,ItemIds:job.RequestedItemIds&&job.RequestedItemIds.length?job.RequestedItemIds.join(""):null,ParentId:job.ParentId,Category:job.Category,TargetId:job.TargetId})).then(function(options){return apiClient.getJSON(apiClient.getUrl("Sync/JobItems",{JobId:id,AddMetadata:!0})).then(function(result){renderJob(context,job,options),renderJobItems(context,result.Items,apiClient),loading.hide()})})},function(error){loading.hide(),dialogHelper.close(context)})}return{show:function(options){var apiClient=connectionManager.getApiClient(options.serverId),id=options.jobId,dlgElementOptions={removeOnClose:!0,scrollY:!1,autoFocus:!1};layoutManager.tv?dlgElementOptions.size="fullscreen":dlgElementOptions.size="medium";var dlg=dialogHelper.createDialog(dlgElementOptions);dlg.classList.add("formDialog");var html="";function onSyncJobMessage(e,apiClient,job){String(job.Id)===id&&apiClient.getJSON(apiClient.getUrl("Sync/JobItems",{JobId:id,AddMetadata:!0})).then(function(result){renderJobItems(dlg,result.Items,apiClient),loading.hide()},function(error){loading.hide()})}html+='<div class="formDialogHeader">',html+='<button is="paper-icon-button-light" class="btnCancel autoSize" tabindex="-1"><i class="md-icon">&#xE5C4;</i></button>',html+='<h3 class="formDialogHeaderTitle">',html+=globalize.translate("Sync"),html+="</h3>",appHost.supports("externallinks")&&(html+='<a href="https://support.emby.media/support/solutions/articles/44001162174-sync" target="_blank" is="emby-linkbutton" class="button-link lnkHelp" style="margin-top:0;display:inline-block;vertical-align:middle;margin-left:auto;"><i class="md-icon">info</i><span>'+globalize.translate("Help")+"</span></a>"),html+="</div>",html+='<div is="emby-scroller" data-horizontal="false" data-centerfocus="card" class="formDialogContent">',html+='<div class="scrollSlider">',html+='<form class="dialogContentInner dialog-content-centered syncJobForm padded-left padded-right" style="padding-top:2em;">',html+='<div class="syncJobFormContent"></div>',html+='<div class="jobItems"></div>',html+='<div class="formDialogFooter">',html+='<button is="emby-button" type="submit" class="raised button-submit block formDialogFooterItem"><span>'+globalize.translate("Save")+"</span></button>",html+="</div>",html+="</form>",html+="</div>",html+="</div>",dlg.innerHTML=html,dlg.querySelector("form").addEventListener("submit",function(e){return function(context,id,apiClient){loading.show(),apiClient.getJSON(apiClient.getUrl("Sync/Jobs/"+id)).then(function(job){require(["syncDialog"],function(syncDialog){syncDialog.setJobValues(job,context),apiClient.ajax({url:apiClient.getUrl("Sync/Jobs/"+id),type:"POST",data:JSON.stringify(job),contentType:"application/json"}).then(function(){appHost.supports("sync")&&syncNow(),loading.hide(),dialogHelper.close(context)})})},function(error){loading.hide(),dialogHelper.close(context)})}(dlg,id,apiClient),e.preventDefault(),!1}),dlg.querySelector(".btnCancel").addEventListener("click",function(){dialogHelper.close(dlg)}),loadJob(dlg,id,apiClient),function(context,jobId,apiClient){context.querySelector(".jobItems").addEventListener("click",function(e){var btnJobItemMenu=e.target.closest(".btnJobItemMenu");btnJobItemMenu&&showJobItemMenu(btnJobItemMenu,jobId,apiClient)})}(dlg,id,apiClient);var promise=dialogHelper.open(dlg);return events.on(serverNotifications,"SyncJobUpdated",onSyncJobMessage),promise.then(function(){return events.off(serverNotifications,"SyncJobUpdated",onSyncJobMessage),Promise.reject()})}}});