define(["focusManager","queryString","browser","layoutManager","pluginManager","userSettings","events"],function(focusManager,queryString,browser,layoutManager,pluginManager,userSettings,events){"use strict";var currentViewInfo,mainAnimatedPages,allPages=[],currentUrls=[],selectedPageIndex=-1;function disableRestoreOnCurrentViews(){for(var views=allPages,i=0,length=views.length;i<length;i++){var view=views[i];view&&(view.allowRestore=!1)}}function setControllerClass(view,options){if(options.controllerFactory)return Promise.resolve();var controllerUrl=view.getAttribute("data-controller");return controllerUrl?(0===controllerUrl.indexOf("__plugin/")&&(controllerUrl=controllerUrl.substring("__plugin/".length)),controllerUrl=pluginManager.getConfigurationResourceUrl(controllerUrl),require([controllerUrl]).then(function(deps){options.controllerFactory=deps[0]})):Promise.resolve()}function normalizeNewView(options,isPluginpage){var viewHtml=options.view,hasScript=!!isPluginpage&&viewHtml.includes("<script"),elem=function(html,hasScript){hasScript&&(html=(html=html.replaceAll("\x3c!--<script","<script")).replaceAll("<\/script>--\x3e","<\/script>"));var wrapper=document.createElement("div");return wrapper.innerHTML=html,wrapper.querySelector('.view,div[data-role="page"]')}(viewHtml,hasScript),hasScript=hasScript&&null!=elem.querySelector("script"),hasjQuery=!1;return isPluginpage&&(hasjQuery=viewHtml.includes("jQuery")||viewHtml.includes("$(")||viewHtml.includes("$.")),{elem:elem,hasScript:hasScript,hasjQuery:hasjQuery}}function onBeforeChange(previousView,newView,isRestored,isBack,options){previousView&&dispatchViewEvent(previousView,null,"viewbeforehide",newView),console.log("viewManager.onBeforeChange - processing path: isBack: "+isBack);var eventDetail=getViewEventDetail(newView,options,isRestored,isBack,previousView);return newView.initComplete||(newView.initComplete=!0,options.controllerFactory&&(newView.controller=new options.controllerFactory(newView,eventDetail.detail.params)),dispatchViewEvent(newView,eventDetail,"viewinit")),dispatchViewEvent(newView,eventDetail,"viewbeforeshow"),newView.controller}function onViewChange(previousView,newViewInfo,options,isRestore,isBack){previousView&&dispatchViewEvent(previousView,null,"viewhide");var newView=(currentViewInfo=newViewInfo).view,controller=newView.controller;return((controller?controller.transitionPromise:null)||Promise.resolve()).then(function(){var eventDetail=getViewEventDetail(newView,options,isRestore,isBack);return isRestore?newView.activeElement&&document.body.contains(newView.activeElement)&&focusManager.isCurrentlyFocusable(newView.activeElement)?focusManager.focus(newView.activeElement):layoutManager.tv&&focusManager.autoFocus(newView):!1!==options.autoFocus&&focusManager.autoFocus(newView),newView.dispatchEvent(new CustomEvent("viewshow",eventDetail)),newView.dispatchEvent(new CustomEvent("pageshow",eventDetail)),newView})}function getProperties(view){var props=view.getAttribute("data-properties");return props?props.split(","):[]}function dispatchViewEvent(view,eventInfo,eventName,newView){eventInfo=eventInfo||{detail:{type:view.getAttribute("data-type"),properties:getProperties(view),newView:newView},bubbles:!0,cancelable:!1};var eventResult=view.dispatchEvent(new CustomEvent(eventName,eventInfo));return view.dispatchEvent(new CustomEvent(eventName.replace("view","page"),eventInfo)),eventResult}function getViewEventDetail(view,options,isRestore,isBack,previousView){var url=options.url,index=url.indexOf("?"),params=-1===index?{}:queryString.parse(url.substring(index+1));return options.type=view.getAttribute("data-type"),options.properties=getProperties(view),options.isRestored=isRestore,options.isBack=isBack,options.params=params,options.previousView=previousView,{detail:options,bubbles:!0,cancelable:!1}}function ViewManager(){}return events.on(layoutManager,"modechange",disableRestoreOnCurrentViews),events.on(userSettings,"change",function(e,name){"language"!==name&&"datetimelocale"!==name&&"tvhome"!==name||disableRestoreOnCurrentViews()}),ViewManager.prototype.loadView=function(options,signal){var previousView=currentViewInfo?currentViewInfo.view:null;previousView&&(previousView.activeElement=document.activeElement);var pageIndex=selectedPageIndex+1;3<=pageIndex&&(pageIndex=0);var isPluginpage=options.isPluginPage,newViewInfo=normalizeNewView(options,isPluginpage),newView=newViewInfo.elem,dependencies=(dependencies="string"==typeof newView?null:newView.getAttribute("data-require"))?dependencies.split(","):[];return isPluginpage&&(dependencies.push("legacy/dashboard"),dependencies.push("css!legacy/dashboard")),newViewInfo.hasjQuery&&dependencies.push("jQuery"),require(dependencies).then(function(){var currentPage=allPages[pageIndex];currentPage&&function(view){view.activeElement=null,view.controller=null,view.dispatchEvent(new CustomEvent("viewdestroy",{cancelable:!1}))}(currentPage);var windowScroll,view=newView;"string"==typeof view&&((view=document.createElement("div")).innerHTML=newView),view.classList.add("page"),(2===(windowScroll=options.windowScroll)&&!layoutManager.tv&&browser.iOS1||!0===windowScroll)&&view.classList.add("page-windowScroll"),mainAnimatedPages||((mainAnimatedPages=document.querySelector(".mainAnimatedPages")).innerHTML=""),currentPage?newViewInfo.hasScript&&window.$?(view=window.$(view).appendTo(mainAnimatedPages)[0],mainAnimatedPages.removeChild(currentPage)):mainAnimatedPages.replaceChild(view,currentPage):newViewInfo.hasScript&&window.$?view=window.$(view).appendTo(mainAnimatedPages)[0]:mainAnimatedPages.appendChild(view),options.type&&view.setAttribute("data-type",options.type);var properties=[];return options.fullscreen&&properties.push("fullscreen"),properties.length&&view.setAttribute("data-properties",properties.join(",")),setControllerClass(allPages[pageIndex]=view,options).then(function(){var controller=onBeforeChange(previousView,view,!1,options.isBack,options);return currentUrls[selectedPageIndex=pageIndex]=options.url,!previousView||controller&&controller.hidesPreviousView||previousView.classList.add("hide"),window.$&&(window.$.mobile=window.$.mobile||{},window.$.mobile.activePage=view),options.view=view,onViewChange(previousView,options,options,!1,options.isBack)})})},ViewManager.prototype.tryRestoreView=function(options,signal){var previousView=currentViewInfo?currentViewInfo.view:null;previousView&&(previousView.activeElement=document.activeElement);var url=options.url,index=currentUrls.indexOf(url);if(-1!==index){var view=allPages[index];if(view&&!1!==view.allowRestore)return setControllerClass(view,options).then(function(){console.log("viewManager.tryRestoreView - processing path: isBack: "+options.isBack);var controller=onBeforeChange(previousView,view,!0,options.isBack,options);return view.classList.remove("hide"),selectedPageIndex=index,!previousView||controller&&controller.hidesPreviousView||previousView.classList.add("hide"),window.$&&(window.$.mobile=window.$.mobile||{},window.$.mobile.activePage=view),options.view=view,onViewChange(previousView,options,options,!0,options.isBack)})}return Promise.reject()},ViewManager.prototype.currentView=function(){return currentViewInfo?currentViewInfo.view:null},ViewManager.prototype.currentViewInfo=function(){return currentViewInfo},new ViewManager});