define(["baseTab","globalize","imageLoader","cardBuilder","loading","connectionManager","apphost","layoutManager","focusManager","emby-itemscontainer","emby-scroller"],function(BaseTab,globalize,imageLoader,cardBuilder,loading,connectionManager,appHost,layoutManager,focusManager){"use strict";function getRecommendationHtml(recommendation){var html="",title="";switch(recommendation.RecommendationType){case"SimilarToRecentlyPlayed":title=globalize.translate("BecauseYouWatchedValue",recommendation.BaselineItemName);break;case"SimilarToLikedItem":title=globalize.translate("BecauseYouLikeValue",recommendation.BaselineItemName);break;case"HasDirectorFromRecentlyPlayed":case"HasLikedDirector":title=globalize.translate("DirectedByValue",recommendation.BaselineItemName);break;case"HasActorFromRecentlyPlayed":case"HasLikedActor":title=globalize.translate("StarringValue",recommendation.BaselineItemName)}return html+='<div class="verticalSection focusable" data-focusabletype="nearest">',html+='<h2 class="sectionTitle sectionTitle-cards padded-left">'+title+"</h2>",html+='<div is="emby-scroller" class="padded-top-focusscale padded-bottom-focusscale" data-mousewheel="false" data-centerfocus="true">',html+='<div is="emby-itemscontainer" class="scrollSlider focuscontainer-x padded-left padded-right itemsContainer">',html+="</div>",html+="</div>",html+="</div>"}function loadSuggestions(page,apiClient){var url=apiClient.getUrl("Movies/Recommendations",{userId:apiClient.getCurrentUserId(),categoryLimit:6,ItemLimit:12,Fields:"PrimaryImageAspectRatio,ProductionYear,BasicSyncInfo",ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Banner,Thumb",GroupProgramsBySeries:!0});apiClient.getJSON(url).then(function(recommendations){var suggestionsElement=page.querySelector(".suggestions");suggestionsElement.innerHTML=recommendations.map(getRecommendationHtml).join("");for(var itemsContainer,recommendation,itemsContainers=suggestionsElement.querySelectorAll(".itemsContainer"),i=0,length=recommendations.length;i<length;i++)itemsContainer=itemsContainers[i],recommendation=recommendations[i],cardBuilder.buildCards(recommendation.Items,{shape:"autooverflow",scalable:!0,overlayPlayButton:!0,fields:["ParentNameOrName","ProductionYear"],centerText:!0,itemsContainer:itemsContainer})})}function MovieSuggestionsTab(view,params){BaseTab.apply(this,arguments),this.view=view,this.params=params,this.apiClient=connectionManager.getApiClient(params.serverId),this.resumeItemsContainer=view.querySelector(".resumeSection .itemsContainer"),this.resumeItemsContainer.fetchData=function(query){var apiClient=this.apiClient,parentId=this.params.parentId;return apiClient.getResumableItems(apiClient.getCurrentUserId(),Object.assign({IncludeItemTypes:"Movie",Fields:"PrimaryImageAspectRatio,BasicSyncInfo,ProductionYear",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Thumb"},query||{}))}.bind(this),this.resumeItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{preferThumb:!0,shape:"backdrop",scalable:!0,fields:["Name","ProductionYear"],overlayText:!1,centerText:!0,overlayPlayButton:!0,cardLayout:!1},virtualScrollLayout:"horizontal-grid"}}.bind(this),this.resumeItemsContainer.parentContainer=view.querySelector(".resumeSection"),this.latestItemsContainer=view.querySelector(".latestSection .itemsContainer"),this.latestItemsContainer.fetchData=function(){var apiClient=this.apiClient,parentId=this.params.parentId;return apiClient.getLatestItems({IncludeItemTypes:apiClient.isMinServerVersion("4.6.0.45")?null:"Movie",Limit:24,Fields:"PrimaryImageAspectRatio,BasicSyncInfo,ProductionYear",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Thumb"})}.bind(this),this.latestItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{shape:"autooverflow",scalable:!0,fields:["Name","ProductionYear"],overlayText:!1,centerText:!0,overlayPlayButton:!0,cardLayout:!1},virtualScrollLayout:"horizontal-grid"}}.bind(this),this.latestItemsContainer.parentContainer=view.querySelector(".latestSection"),params.parentId&&(this.resumeItemsContainer.setAttribute("data-parentid",params.parentId),this.latestItemsContainer.setAttribute("data-parentid",params.parentId)),layoutManager.tv||function(view,params,apiClient){require(["categorySyncButton"],function(categorySyncButton){apiClient.getCurrentUser().then(function(user){categorySyncButton.init(view.querySelector(".btnSyncLatest"),user,params.serverId,params.parentId)})})}(view,params,this.apiClient)}return Object.assign(MovieSuggestionsTab.prototype,BaseTab.prototype),MovieSuggestionsTab.prototype.onResume=function(options){BaseTab.prototype.onResume.apply(this,arguments);var apiClient=this.apiClient,promises=[];promises.push(this.resumeItemsContainer.resume(options)),promises.push(this.latestItemsContainer.resume(options)),options&&options.refresh&&loadSuggestions(this.view,apiClient);var view=this.view;Promise.all(promises).then(function(){options.autoFocus&&focusManager.autoFocus(view)})},MovieSuggestionsTab.prototype.onPause=function(){BaseTab.prototype.onPause.apply(this,arguments),this.resumeItemsContainer.pause(),this.latestItemsContainer.pause()},MovieSuggestionsTab.prototype.destroy=function(){BaseTab.prototype.destroy.apply(this,arguments),this.view=null,this.params=null,this.apiClient=null},MovieSuggestionsTab});