define(["tabbedView","connectionManager","require","globalize","emby-itemscontainer","emby-tabs","emby-button","emby-scroller"],function(TabbedView,connectionManager,require,globalize){"use strict";function HomeVideosView(view,params){TabbedView.call(this,view,params)}return Object.assign(HomeVideosView.prototype,TabbedView.prototype),HomeVideosView.prototype.getTabs=function(){var item,subviews=this.item.Subviews||("musicvideos"===(item=this.item).CollectionType?["videos","folders"]:"homevideos"===item.CollectionType?["videos","photos","folders","folders"]:"movies"===item.CollectionType?["videos","trailers","collections","genres","folders"]:[]);return[{name:globalize.translate("Shows"),id:"series",enabled:subviews.includes("series")},{name:this.item.CollectionType&&"movies"!==this.item.CollectionType?globalize.translate("Videos"):globalize.translate("Movies"),id:"videos",enabled:subviews.includes("videos")||subviews.includes("movies")},{name:globalize.translate("Suggestions"),id:"suggestions",enabled:"movies"===this.item.CollectionType},{name:globalize.translate("Trailers"),id:"trailers",enabled:"movies"===this.item.CollectionType},{name:globalize.translate("Photos"),id:"photos",enabled:subviews.includes("photos")},{name:globalize.translate("HeaderAlbumArtists"),id:"albumartists",enabled:subviews.includes("albumartists")},{name:globalize.translate("Artists"),id:"artists",enabled:subviews.includes("artists")},{name:globalize.translate("Playlists"),id:"playlists",enabled:subviews.includes("playlists")},{name:globalize.translate("Collections"),id:"collections",enabled:subviews.includes("collections")},{name:globalize.translate("Genres"),id:"genres",enabled:subviews.includes("genres")},{name:globalize.translate("Tags"),id:"tags",enabled:subviews.includes("tags")},{name:globalize.translate("Favorites"),id:"favorites",enabled:"movies"===this.item.CollectionType},{name:globalize.translate("Folders"),id:"folders"}]},HomeVideosView.prototype.loadTabController=function(id){switch(id){case"suggestions":return require(["./moviesuggestions"]);case"photos":return require(["./photos"]);case"trailers":return require(["./trailers"]);case"albumartists":case"artists":return require(["artistsTab"]);case"collections":return require(["collectionsTab"]);case"playlists":return require(["playlistsTab"]);case"genres":return require(["genresTab"]);case"tags":return require(["tagsTab"]);case"videos":case"favorites":return require(["videosTab"]);case"folders":return require(["foldersTab"]);case"series":return require(["seriesTab"]);default:throw new Error("tab not found: "+id)}},HomeVideosView.prototype.getDefaultTabId=function(){var item=this.item;return("homevideos"!==item.CollectionType||connectionManager.getApiClient(item).isMinServerVersion("4.6.0.9"))&&item.CollectionType?null:"folders"},HomeVideosView.prototype.getTabControllerOptions=function(id){var options=TabbedView.prototype.getTabControllerOptions.apply(this,arguments);return"favorites"===id?"movies"===this.item.CollectionType&&(options.itemType="Movie",options.enableAlphaPicker=!0,options.mode="favorites"):"genres"===id?options.queryIncludeItemTypes=[]:"videos"===id&&(options.itemType="musicvideos"===this.item.CollectionType?"MusicVideo":this.item.CollectionType&&"movies"!==this.item.CollectionType?"Video":"Movie",options.enableAlphaPicker="Episode"!==options.itemType),options},HomeVideosView});