/*
 * Decompiled with CFR 0.152.
 */
package firrtl.analyses;

import firrtl.Flow;
import firrtl.InstanceKind$;
import firrtl.Mappers;
import firrtl.Mappers$;
import firrtl.Mappers$CircuitMagnet$;
import firrtl.Mappers$CircuitMap$;
import firrtl.Mappers$ExprMagnet$;
import firrtl.Mappers$ExprMap$;
import firrtl.Mappers$ModuleMagnet$;
import firrtl.Mappers$ModuleMap$;
import firrtl.Mappers$StmtMagnet$;
import firrtl.Mappers$StmtMap$;
import firrtl.PortKind$;
import firrtl.SinkFlow$;
import firrtl.SourceFlow$;
import firrtl.Utils$;
import firrtl.WInvalid$;
import firrtl.analyses.ConnectionGraph;
import firrtl.analyses.IRLookup;
import firrtl.analyses.TokenTagger;
import firrtl.annotations.CircuitTarget;
import firrtl.annotations.InstanceTarget;
import firrtl.annotations.ModuleTarget;
import firrtl.annotations.ReferenceTarget;
import firrtl.annotations.TargetToken;
import firrtl.graph.DiGraph$;
import firrtl.graph.MutableDiGraph;
import firrtl.ir.Attach;
import firrtl.ir.Block;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.DoPrim;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.Field;
import firrtl.ir.FirrtlNode;
import firrtl.ir.Flip$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Literal;
import firrtl.ir.Mux;
import firrtl.ir.Orientation;
import firrtl.ir.Port;
import firrtl.ir.Print;
import firrtl.ir.Reference;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.SubField;
import firrtl.ir.SubIndex;
import firrtl.ir.Type;
import firrtl.ir.ValidIf;
import firrtl.passes.MemPortUtils$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.MapLike;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class ConnectionGraph$ {
    public static ConnectionGraph$ MODULE$;

    static {
        new ConnectionGraph$();
    }

    public ConnectionGraph apply(Circuit circuit) {
        return this.buildCircuitGraph(circuit);
    }

    public ReferenceTarget asTarget(ModuleTarget m, TokenTagger tagger, FirrtlNode e) {
        ReferenceTarget referenceTarget;
        FirrtlNode firrtlNode = e;
        if (firrtlNode instanceof Literal) {
            Literal literal = (Literal)firrtlNode;
            referenceTarget = m.ref(tagger.getRef(literal.value().toString()));
        } else if (firrtlNode instanceof Reference) {
            Reference reference = (Reference)firrtlNode;
            referenceTarget = m.ref(reference.name());
        } else if (firrtlNode instanceof SubIndex) {
            SubIndex subIndex = (SubIndex)firrtlNode;
            referenceTarget = this.asTarget(m, tagger, subIndex.expr()).index(subIndex.value());
        } else if (firrtlNode instanceof SubField) {
            SubField subField = (SubField)firrtlNode;
            referenceTarget = this.asTarget(m, tagger, subField.expr()).field(subField.name());
        } else if (firrtlNode instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)firrtlNode;
            referenceTarget = m.ref(tagger.getRef(doPrim.op().serialize()));
        } else if (firrtlNode instanceof Mux) {
            referenceTarget = m.ref(tagger.getRef("mux"));
        } else if (firrtlNode instanceof ValidIf) {
            referenceTarget = m.ref(tagger.getRef("validif"));
        } else if (WInvalid$.MODULE$.equals(firrtlNode)) {
            referenceTarget = m.ref(tagger.getRef("invalid"));
        } else if (firrtlNode instanceof Print) {
            referenceTarget = m.ref(tagger.getRef("print"));
        } else if (firrtlNode instanceof Stop) {
            referenceTarget = m.ref(tagger.getRef("print"));
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(13).append("Unsupported: ").append(firrtlNode).toString());
        }
        return referenceTarget;
    }

    public boolean withinSameInstance(ReferenceTarget source, ReferenceTarget localSink) {
        String string = source.encapsulatingModule();
        String string2 = localSink.encapsulatingModule();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean enteringParentInstance(ReferenceTarget source, ReferenceTarget localSink) {
        return ConnectionGraph$.b1$1(source) && ConnectionGraph$.b2$1(source, localSink) && ConnectionGraph$.b3$1(localSink, source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enteringNonParentInstance(ReferenceTarget source, ReferenceTarget localSink) {
        if (!source.path().nonEmpty()) return false;
        String string = ((InstanceTarget)source.noComponents().targetParent()).encapsulatingModule();
        String string2 = localSink.module();
        if (string == null) {
            if (string2 != null) {
                return true;
            }
        } else if (!string.equals(string2)) return true;
        String string3 = localSink.ref();
        String string4 = ((TargetToken.Instance)((Tuple2)source.path().last())._1()).value();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enteringChildInstance(ReferenceTarget source, ReferenceTarget localSink) {
        String port;
        ReferenceTarget referenceTarget = source;
        if (referenceTarget == null) return false;
        Seq<TargetToken> seq = referenceTarget.component();
        Option option = package$.MODULE$.$plus$colon().unapply(seq);
        if (option.isEmpty()) return false;
        TargetToken targetToken = (TargetToken)option.get()._1();
        Seq<TargetToken> comps = option.get()._2();
        if (!(targetToken instanceof TargetToken.Field)) return false;
        TargetToken.Field field2 = (TargetToken.Field)targetToken;
        String string = port = field2.value();
        String string2 = localSink.ref();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<TargetToken> seq2 = comps;
        Seq<TargetToken> seq3 = localSink.component();
        if (seq2 == null) {
            if (seq3 == null) return true;
            return false;
        } else {
            if (!seq2.equals(seq3)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean leavingRootInstance(ReferenceTarget source, ReferenceTarget localSink) {
        ReferenceTarget referenceTarget = source;
        if (referenceTarget == null) return false;
        Seq<Tuple2<TargetToken.Instance, TargetToken.OfModule>> seq = referenceTarget.path();
        String port = referenceTarget.ref();
        Seq<TargetToken> comps = referenceTarget.component();
        Some<Seq<Tuple2<TargetToken.Instance, TargetToken.OfModule>>> some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty()) return false;
        if (some.get() == null) return false;
        if (((SeqLike)some.get()).lengthCompare(0) != 0) return false;
        String string = port;
        Object object = ((TargetToken)localSink.component().head()).value();
        if (string == null) {
            if (object != null) {
                return false;
            }
        } else if (!string.equals(object)) return false;
        Seq<TargetToken> seq2 = comps;
        Object Repr = localSink.component().tail();
        if (seq2 == null) {
            if (Repr == null) return true;
            return false;
        } else {
            if (!seq2.equals(Repr)) return false;
            return true;
        }
    }

    private ConnectionGraph buildCircuitGraph(Circuit circuit) {
        MutableDiGraph mdg = new MutableDiGraph();
        LinkedHashMap declarations = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Nil$.MODULE$);
        CircuitTarget circuitTarget = new CircuitTarget(circuit.main());
        Map<ModuleTarget, DefModule> moduleMap = ((TraversableOnce)circuit.modules().map((Function1<DefModule, Tuple2> & Serializable & scala.Serializable)m -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(circuitTarget.module(m.name())), m), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Mappers$CircuitMap$.MODULE$.map$extension(Mappers$.MODULE$.CircuitMap(circuit), (Function1<DefModule, DefModule> & Serializable & scala.Serializable)module -> this.buildModule$1(circuitTarget, (DefModule)module, mdg, declarations), (Function1<Function1, Mappers.CircuitMagnet> & Serializable & scala.Serializable)f -> Mappers$CircuitMagnet$.MODULE$.forModules((Function1<DefModule, DefModule>)f));
        return new ConnectionGraph(circuit, DiGraph$.MODULE$.apply(mdg), new IRLookup(declarations.mapValues((Function1<LinkedHashMap, Map> & Serializable & scala.Serializable)x$7 -> x$7.toMap(Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms()), moduleMap));
    }

    private static final boolean b1$1(ReferenceTarget source$2) {
        return source$2.path().nonEmpty();
    }

    private static final boolean b2$1(ReferenceTarget source$2, ReferenceTarget localSink$1) {
        String string = ((InstanceTarget)source$2.noComponents().targetParent()).encapsulatingModule();
        String string2 = localSink$1.module();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final boolean b3$1(ReferenceTarget localSink$1, ReferenceTarget source$2) {
        String string = localSink$1.ref();
        String string2 = ((TargetToken.Instance)((Tuple2)source$2.path().last())._1()).value();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void addLabeledVertex$1(ReferenceTarget v, FirrtlNode f, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        mdg$1.addVertex(v);
        ((MapLike)declarations$1.getOrElseUpdate(v.moduleTarget(), (Function0<LinkedHashMap> & Serializable & scala.Serializable)() -> LinkedHashMap$.MODULE$.empty())).update(v, f);
    }

    private final DefModule buildModule$1(CircuitTarget c, DefModule module, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        ModuleTarget m = c.module(module.name());
        TokenTagger tokenTagger = new TokenTagger();
        return Mappers$ModuleMap$.MODULE$.map$extension(Mappers$.MODULE$.ModuleMap(Mappers$ModuleMap$.MODULE$.map$extension(Mappers$.MODULE$.ModuleMap(module), (Function1<Port, Port> & Serializable & scala.Serializable)port -> ConnectionGraph$.buildPort$1(m, port, mdg$1, declarations$1), (Function1<Function1, Mappers.ModuleMagnet> & Serializable & scala.Serializable)f -> Mappers$ModuleMagnet$.MODULE$.forPorts((Function1<Port, Port>)f))), (Function1<Statement, Statement> & Serializable & scala.Serializable)stmt -> this.buildStatement$1(m, tokenTagger, (Statement)stmt, mdg$1, declarations$1), (Function1<Function1, Mappers.ModuleMagnet> & Serializable & scala.Serializable)f -> Mappers$ModuleMagnet$.MODULE$.forStmt((Function1<Statement, Statement>)f));
    }

    private static final Port buildPort$1(ModuleTarget m, Port port, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        ReferenceTarget p = m.ref(port.name());
        ConnectionGraph$.addLabeledVertex$1(p, port, mdg$1, declarations$1);
        return port;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$buildCircuitGraph$10(ModuleTarget m$2, TokenTagger tagger$1, ModuleTarget o$1, MutableDiGraph mdg$1, Tuple2 x) {
        Tuple2 tuple2 = x;
        if (tuple2 == null) throw new MatchError(tuple2);
        Expression instExp = (Expression)tuple2._1();
        Expression modExp = (Expression)tuple2._2();
        Tuple2<Expression, Expression> tuple22 = new Tuple2<Expression, Expression>(instExp, modExp);
        Tuple2<Expression, Expression> tuple23 = tuple22;
        Expression instExp2 = tuple23._1();
        Expression modExp2 = tuple23._2();
        ReferenceTarget it = MODULE$.asTarget(m$2, tagger$1, instExp2);
        ReferenceTarget mt = MODULE$.asTarget(o$1, tagger$1, modExp2);
        Tuple2<Flow, Flow> tuple24 = new Tuple2<Flow, Flow>(Utils$.MODULE$.flow(instExp2), Utils$.MODULE$.flow(modExp2));
        if (tuple24 != null) {
            Flow flow = tuple24._1();
            Flow flow2 = tuple24._2();
            if (SourceFlow$.MODULE$.equals(flow) && SinkFlow$.MODULE$.equals(flow2)) {
                mdg$1.addPairWithEdge(it, mt);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple24 == null) throw scala.sys.package$.MODULE$.error("Something went wrong...");
        Flow flow = tuple24._1();
        Flow flow3 = tuple24._2();
        if (!SinkFlow$.MODULE$.equals(flow)) throw scala.sys.package$.MODULE$.error("Something went wrong...");
        if (!SourceFlow$.MODULE$.equals(flow3)) throw scala.sys.package$.MODULE$.error("Something went wrong...");
        mdg$1.addPairWithEdge(mt, it);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void buildInstance$1(ModuleTarget m, TokenTagger tagger, String name, String ofModule, Type tpe, MutableDiGraph mdg$1) {
        Seq<Expression> instPorts = Utils$.MODULE$.create_exps(new Reference(name, tpe, InstanceKind$.MODULE$, SinkFlow$.MODULE$));
        Seq modulePorts = ((BundleType)tpe).fields().flatMap((Function1<Field, Seq> & Serializable & scala.Serializable)x0$1 -> {
            Field field2 = x0$1;
            if (field2 != null) {
                String name = field2.name();
                Orientation orientation = field2.flip();
                Type tpe = field2.tpe();
                if (Default$.MODULE$.equals(orientation)) {
                    return Utils$.MODULE$.create_exps(new Reference(name, tpe, PortKind$.MODULE$, SourceFlow$.MODULE$));
                }
            }
            if (field2 == null) throw Utils$.MODULE$.error(new StringBuilder(17).append("Unexpected flip: ").append(field2.flip()).toString(), Utils$.MODULE$.error$default$2());
            String name = field2.name();
            Orientation orientation = field2.flip();
            Type tpe = field2.tpe();
            if (!Flip$.MODULE$.equals(orientation)) throw Utils$.MODULE$.error(new StringBuilder(17).append("Unexpected flip: ").append(field2.flip()).toString(), Utils$.MODULE$.error$default$2());
            return Utils$.MODULE$.create_exps(new Reference(name, tpe, PortKind$.MODULE$, SinkFlow$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(instPorts.size() == modulePorts.size());
        ModuleTarget o = m.circuitTarget().module(ofModule);
        ((IterableLike)instPorts.zip(modulePorts, Seq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x -> {
            ConnectionGraph$.$anonfun$buildCircuitGraph$10(m, tagger, o, mdg$1, x);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$buildCircuitGraph$13(MutableDiGraph mdg$1, Seq sources$1, ReferenceTarget sink) {
        mdg$1.addVertex(sink);
        sources$1.foreach((Function1<ReferenceTarget, Object> & Serializable & scala.Serializable)source -> {
            mdg$1.addEdge(source, sink);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$buildCircuitGraph$11(Set readers$1, Set readwriters$1, ReferenceTarget mem$1, DefMemory d$1, MutableDiGraph mdg$1, Field x0$1) {
        Field field2 = x0$1;
        if (field2 != null) {
            String name = field2.name();
            if (field2.tpe() instanceof BundleType && (readers$1.contains(name) || readwriters$1.contains(name))) {
                ReferenceTarget port = mem$1.field(name);
                Seq sources = ((TraversableLike)new $colon$colon<Nothing$>((Nothing$)((Object)port.field("clk")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)port.field("en")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)port.field("addr")), Nil$.MODULE$)))).$plus$plus(readwriters$1.contains(name) ? new $colon$colon<Nothing$>((Nothing$)((Object)port.field("wmode")), Nil$.MODULE$) : Nil$.MODULE$, Seq$.MODULE$.canBuildFrom());
                ReferenceTarget data = readers$1.contains(name) ? port.field("data") : port.field("rdata");
                Seq<ReferenceTarget> sinks = data.leafSubTargets(d$1.dataType());
                sources.foreach((Function1<ReferenceTarget, ReferenceTarget> & Serializable & scala.Serializable)v -> mdg$1.addVertex(v));
                sinks.foreach((Function1<ReferenceTarget, Object> & Serializable & scala.Serializable)sink -> {
                    ConnectionGraph$.$anonfun$buildCircuitGraph$13(mdg$1, sources, sink);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void buildMemory$1(ModuleTarget mt, DefMemory d, MutableDiGraph mdg$1) {
        Set readers = d.readers().toSet();
        Set readwriters = d.readwriters().toSet();
        ReferenceTarget mem = mt.ref(d.name());
        MemPortUtils$.MODULE$.memType(d).fields().foreach((Function1<Field, Object> & Serializable & scala.Serializable)x0$1 -> {
            ConnectionGraph$.$anonfun$buildCircuitGraph$11(readers, readwriters, mem, d, mdg$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void buildRegister$1(ModuleTarget m, TokenTagger tagger, DefRegister d, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        ReferenceTarget regTarget = m.ref(d.name());
        ReferenceTarget clockTarget = regTarget.clock();
        ReferenceTarget resetTarget = regTarget.reset();
        ReferenceTarget initTarget = regTarget.init();
        mdg$1.addVertex(clockTarget);
        this.buildExpression$1(m, tagger, clockTarget, d.clock(), mdg$1, declarations$1);
        mdg$1.addVertex(resetTarget);
        this.buildExpression$1(m, tagger, resetTarget, d.reset(), mdg$1, declarations$1);
        Seq<ReferenceTarget> allRegTargets = regTarget.leafSubTargets(d.tpe());
        Seq allInitTargets = initTarget.leafSubTargets(d.tpe()).zip(Utils$.MODULE$.create_exps(d.init()), Seq$.MODULE$.canBuildFrom());
        ((IterableLike)allRegTargets.zip(allInitTargets, Seq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Expression> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            ReferenceTarget r;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    r = (ReferenceTarget)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple22);
            }
            ReferenceTarget i = (ReferenceTarget)tuple2._1();
            Expression e = (Expression)tuple2._2();
            mdg$1.addVertex(i);
            mdg$1.addVertex(r);
            mdg$1.addEdge(clockTarget, r);
            mdg$1.addEdge(resetTarget, r);
            mdg$1.addEdge(i, r);
            Expression expression = this.buildExpression$1(m, tagger, i, e, mdg$1, declarations$1);
            return expression;
        });
    }

    public static final /* synthetic */ void $anonfun$buildCircuitGraph$17(MutableDiGraph mdg$1, ReferenceTarget sourceTarget$1, ReferenceTarget st) {
        mdg$1.addVertex(st);
        mdg$1.addEdge(sourceTarget$1, st);
    }

    public static final /* synthetic */ void $anonfun$buildCircuitGraph$21(MutableDiGraph mdg$1, Seq x0$2) {
        Seq seq = x0$2;
        Some<Seq> some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        ReferenceTarget l = (ReferenceTarget)((SeqLike)some.get()).apply(0);
        ReferenceTarget r = (ReferenceTarget)((SeqLike)some.get()).apply(1);
        mdg$1.addEdge(l, r);
        mdg$1.addEdge(r, l);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Statement buildStatement$1(ModuleTarget m, TokenTagger tagger, Statement stmt2, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        Object object;
        Statement statement = stmt2;
        if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            ConnectionGraph$.addLabeledVertex$1(m.ref(defWire.name()), stmt2, mdg$1, declarations$1);
            object = BoxedUnit.UNIT;
        } else if (statement instanceof DefNode) {
            DefNode defNode = (DefNode)statement;
            ReferenceTarget sinkTarget = m.ref(defNode.name());
            ConnectionGraph$.addLabeledVertex$1(sinkTarget, stmt2, mdg$1, declarations$1);
            Seq<ReferenceTarget> nodeTargets = sinkTarget.leafSubTargets(defNode.value().tpe());
            ((IterableLike)nodeTargets.zip(Utils$.MODULE$.create_exps(defNode.value()), Seq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Expression> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                ReferenceTarget n = (ReferenceTarget)tuple2._1();
                Expression e = (Expression)tuple2._2();
                mdg$1.addVertex(n);
                Expression expression = this.buildExpression$1(m, tagger, n, e, mdg$1, declarations$1);
                return expression;
            });
            object = BoxedUnit.UNIT;
        } else if (statement instanceof Connect) {
            Connect connect = (Connect)statement;
            ReferenceTarget sinkTarget = this.asTarget(m, tagger, connect.loc());
            mdg$1.addVertex(sinkTarget);
            object = this.buildExpression$1(m, tagger, sinkTarget, connect.expr(), mdg$1, declarations$1);
        } else if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            ReferenceTarget sourceTarget = this.asTarget(m, tagger, WInvalid$.MODULE$);
            ConnectionGraph$.addLabeledVertex$1(sourceTarget, stmt2, mdg$1, declarations$1);
            mdg$1.addVertex(sourceTarget);
            ReferenceTarget sinkTarget = this.asTarget(m, tagger, isInvalid.expr());
            sinkTarget.allSubTargets(isInvalid.expr().tpe()).foreach((Function1<ReferenceTarget, Object> & Serializable & scala.Serializable)st -> {
                ConnectionGraph$.$anonfun$buildCircuitGraph$17(mdg$1, sourceTarget, st);
                return BoxedUnit.UNIT;
            });
            object = BoxedUnit.UNIT;
        } else if (statement instanceof DefInstance) {
            DefInstance defInstance = (DefInstance)statement;
            String name = defInstance.name();
            String ofModule = defInstance.module();
            Type tpe = defInstance.tpe();
            ConnectionGraph$.addLabeledVertex$1(m.ref(name), stmt2, mdg$1, declarations$1);
            ConnectionGraph$.buildInstance$1(m, tagger, name, ofModule, tpe, mdg$1);
            object = BoxedUnit.UNIT;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            ConnectionGraph$.addLabeledVertex$1(m.ref(defRegister.name()), defRegister, mdg$1, declarations$1);
            this.buildRegister$1(m, tagger, defRegister, mdg$1, declarations$1);
            object = BoxedUnit.UNIT;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            ConnectionGraph$.addLabeledVertex$1(m.ref(defMemory.name()), defMemory, mdg$1, declarations$1);
            ConnectionGraph$.buildMemory$1(m, defMemory, mdg$1);
            object = BoxedUnit.UNIT;
        } else {
            if (statement instanceof Conditionally) {
                throw scala.sys.package$.MODULE$.error("Unsupported! Only works on Middle Firrtl");
            }
            if (statement instanceof Block) {
                Block block = (Block)statement;
                object = Mappers$StmtMap$.MODULE$.map$extension(Mappers$.MODULE$.StmtMap(block), (Function1<Statement, Statement> & Serializable & scala.Serializable)stmt -> this.buildStatement$1(m, tagger, (Statement)stmt, mdg$1, declarations$1), (Function1<Function1, Mappers.StmtMagnet> & Serializable & scala.Serializable)f -> Mappers$StmtMagnet$.MODULE$.forStmt((Function1<Statement, Statement>)f));
            } else if (statement instanceof Attach) {
                Attach attach = (Attach)statement;
                Seq attachTargets = attach.exprs().map((Function1<Expression, ReferenceTarget> & Serializable & scala.Serializable)r -> {
                    ReferenceTarget at = MODULE$.asTarget(m, tagger, (FirrtlNode)r);
                    mdg$1.addVertex(at);
                    return at;
                }, Seq$.MODULE$.canBuildFrom());
                attachTargets.combinations(2).foreach((Function1<Seq, Object> & Serializable & scala.Serializable)x0$2 -> {
                    ConnectionGraph$.$anonfun$buildCircuitGraph$21(mdg$1, x0$2);
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            } else if (statement instanceof Print) {
                Print print = (Print)statement;
                ConnectionGraph$.addLabeledVertex$1(this.asTarget(m, tagger, print), print, mdg$1, declarations$1);
                object = BoxedUnit.UNIT;
            } else if (statement instanceof Stop) {
                Stop stop = (Stop)statement;
                ConnectionGraph$.addLabeledVertex$1(this.asTarget(m, tagger, stop), stop, mdg$1, declarations$1);
                object = BoxedUnit.UNIT;
            } else if (EmptyStmt$.MODULE$.equals(statement)) {
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError(statement);
            }
        }
        return stmt2;
    }

    private final Expression buildExpression$1(ModuleTarget m, TokenTagger tagger, ReferenceTarget sinkTarget, Expression expr2, MutableDiGraph mdg$1, LinkedHashMap declarations$1) {
        Object object;
        ReferenceTarget sourceTarget = this.asTarget(m, tagger, expr2);
        mdg$1.addVertex(sourceTarget);
        mdg$1.addEdge(sourceTarget, sinkTarget);
        Expression expression = expr2;
        boolean bl = expression instanceof DoPrim ? true : (expression instanceof Mux ? true : (expression instanceof ValidIf ? true : expression instanceof Literal));
        if (bl) {
            ConnectionGraph$.addLabeledVertex$1(sourceTarget, expr2, mdg$1, declarations$1);
            object = Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(expr2), (Function1<Expression, Expression> & Serializable & scala.Serializable)expr -> this.buildExpression$1(m, tagger, sourceTarget, (Expression)expr, mdg$1, declarations$1), (Function1<Function1, Mappers.ExprMagnet> & Serializable & scala.Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f));
        } else {
            object = BoxedUnit.UNIT;
        }
        return expr2;
    }

    private ConnectionGraph$() {
        MODULE$ = this;
    }
}

