/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.MemoryArrayInit;
import firrtl.MemoryInitValue;
import firrtl.MemoryScalarInit;
import firrtl.Namespace;
import firrtl.Namespace$;
import firrtl.Utils$;
import firrtl.backends.experimental.smt.ArrayConstant;
import firrtl.backends.experimental.smt.ArrayExpr;
import firrtl.backends.experimental.smt.ArrayIte;
import firrtl.backends.experimental.smt.ArrayRead;
import firrtl.backends.experimental.smt.ArrayStore;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.BVComparison;
import firrtl.backends.experimental.smt.BVEqual;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVIte;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVOp;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.Compare$;
import firrtl.backends.experimental.smt.FirrtlExpressionSemantics$;
import firrtl.backends.experimental.smt.Op$;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.State;
import firrtl.backends.experimental.smt.UnsupportedFeatureException;
import firrtl.ir.DefMemory;
import firrtl.ir.GroundType;
import firrtl.ir.ReadUnderWrite$;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcZZ$sp;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001\u0002&L\tQC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\to\u0002\u0011\t\u0011)A\u0005q\")A\u0010\u0001C\u0001{\u00161\u00111\u0001\u0001\u0001\u0003\u000bAa\u0001 \u0001\u0005\u0002\u0005u\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003/\u0002A\u0011BA-\r\u0019\t9\u0007\u0001\u0003\u0002j!Q\u00111\r\u0005\u0003\u0002\u0003\u0006I!a\u000e\t\rqDA\u0011AA6\u0011%\ty\u0007\u0003b\u0001\n\u0003\t\t\bC\u0004\u0002t!\u0001\u000b\u0011B3\t\u0013\u0005U\u0004B1A\u0005\u0002\u0005]\u0004\u0002CA@\u0011\u0001\u0006I!!\u001f\t\u0013\u0005\u0005\u0005B1A\u0005\u0002\u0005\r\u0005bBAC\u0011\u0001\u0006I\u0001\u001d\u0005\n\u0003\u000fC!\u0019!C\u0001\u0003\u0007Cq!!#\tA\u0003%\u0001\u000fC\u0005\u0002\f\"\u0011\r\u0011\"\u0001\u0002\u000e\"A\u0011Q\u0013\u0005!\u0002\u0013\ty\tC\u0005\u0002\u0018\"\u0011\r\u0011\"\u0001\u0002\u001a\"A\u0011\u0011\u0016\u0005!\u0002\u0013\tY\nC\u0005\u0002,\"\u0011\r\u0011\"\u0001\u0002.\"A\u0011Q\u0017\u0005!\u0002\u0013\ty\u000b\u0003\u0006\u00028\"A)\u0019!C\u0001\u0003sCq!!1\t\t\u0003\t\u0019MB\u0004\u0002L\u0002\tI!!4\t\u0015\u0005=7D!A!\u0002\u0013\t)\u0007\u0003\u0006\u0002pm\u0011)\u0019!C\u0001\u0003cB\u0011\"a\u001d\u001c\u0005\u0003\u0005\u000b\u0011B3\t\u0015\u0005E7D!A!\u0002\u0013\t\u0019\u000e\u0003\u0004}7\u0011\u0005\u0011\u0011\u001c\u0005\n\u0003G\\\"\u0019!C\u0001\u0003KD\u0001\"!<\u001cA\u0003%\u0011q\u001d\u0005\n\u0003_\\\"\u0019!C\u0001\u0003KD\u0001\"!=\u001cA\u0003%\u0011q\u001d\u0005\n\u0003\u000f\\\"\u0019!C\u0001\u0003KD\u0001\"a=\u001cA\u0003%\u0011q\u001d\u0005\b\u0003k\\B\u0011CA|\u0011%\u0011\ta\u0007b\u0001\n\u0003\ti\u000b\u0003\u0005\u0003\u0004m\u0001\u000b\u0011BAX\u0011\u001d\u0011)a\u0007C\u0001\u0005\u000fAqA!\u0004\u001c\t\u0003\u0011y\u0001C\u0004\u0003\u0012m!\tAa\u0005\t\u0013\te1$%A\u0005\u0002\tm\u0001\"\u0003B\u00197E\u0005I\u0011\u0001B\u000e\r\u0019\u0011\u0019\u0004\u0001\u0003\u00036!Q\u0011qZ\u0018\u0003\u0002\u0003\u0006I!!\u001a\t\u0015\u0005=tF!A!\u0002\u0013)W\u0004\u0003\u0006\u0002R>\u0012\t\u0011)A\u0005\u0003'Da\u0001`\u0018\u0005\u0002\t]\u0002\"\u0003B!_\t\u0007I\u0011AAs\u0011!\u0011\u0019e\fQ\u0001\n\u0005\u001d\b\"\u0003B#_\t\u0007I\u0011AAW\u0011!\u00119e\fQ\u0001\n\u0005=\u0006\"\u0003B%_\t\u0007I\u0011\u0001B&\u0011\u001d\u0011ie\fQ\u0001\nMDqAa\u00140\t\u0003\u0011\t\u0006C\u0004\u0003P=\"\tA!\u001a\t\u000f\t-t\u0006\"\u0001\u0003n\u00191!\u0011\f\u0001\u0005\u00057B!\"a4>\u0005\u0003\u0005\u000b\u0011BA3\u0011)\ty'\u0010B\u0001B\u0003%Q-\b\u0005\u000b\u0003#l$\u0011!Q\u0001\n\u0005M\u0007B\u0002?>\t\u0003\u0011i\u0006C\u0004\u0003t\u0001!IA!\u001e\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"I!q\u0011\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0005\u0013\u0003\u0001\u0015!\u0003\u0002<\"I!1\u0012\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0005\u001b\u0003\u0001\u0015!\u0003\u0002<\"9!q\u0012\u0001\u0005\n\tE\u0005b\u0002BL\u0001\u0011%!\u0011\u0014\u0002\u000f\u001b\u0016lwN]=F]\u000e|G-\u001b8h\u0015\taU*A\u0002t[RT!AT(\u0002\u0019\u0015D\b/\u001a:j[\u0016tG/\u00197\u000b\u0005A\u000b\u0016\u0001\u00032bG.,g\u000eZ:\u000b\u0003I\u000baAZ5seRd7\u0001A\n\u0004\u0001U[\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g\r\u0005\u0002]?6\tQLC\u0001_\u0003\u0019awnZ4fe&\u0011\u0001-\u0018\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0006nC.,'+\u00198e_6\u0004RAV2faNL!\u0001Z,\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u00014n\u001d\t97\u000e\u0005\u0002i/6\t\u0011N\u0003\u0002k'\u00061AH]8pizJ!\u0001\\,\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Y^\u0003\"AV9\n\u0005I<&aA%oiB\u0011A/^\u0007\u0002\u0017&\u0011ao\u0013\u0002\u0007\u0005Z+\u0005\u0010\u001d:\u0002\u00139\fW.Z:qC\u000e,\u0007CA={\u001b\u0005\t\u0016BA>R\u0005%q\u0015-\\3ta\u0006\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005}~\f\t\u0001\u0005\u0002u\u0001!)\u0011m\u0001a\u0001E\")qo\u0001a\u0001q\nA1i\u001c8oK\u000e$8\u000f\u0005\u0004\u0002\b\u0005E\u0011q\u0003\b\u0005\u0003\u0013\tiAD\u0002i\u0003\u0017I\u0011\u0001W\u0005\u0004\u0003\u001f9\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)B\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tya\u0016\t\u0006-\u0006eQm]\u0005\u0004\u000379&A\u0002+va2,'\u0007F\u0002\u007f\u0003?AQ!Y\u0003A\u0002\t\f\u0001b\u001c8NK6|'/\u001f\u000b\t\u0003K\t\u0019$a\u0011\u0002HA9a+!\u0007\u0002(\u0005=\u0002CBA\u0004\u0003#\tI\u0003E\u0002u\u0003WI1!!\fL\u0005\u0015\u0019F/\u0019;f!\r\t\t\u0004B\u0007\u0002\u0001!9\u0011Q\u0007\u0004A\u0002\u0005]\u0012A\u00023fM6+W\u000e\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti$U\u0001\u0003SJLA!!\u0011\u0002<\tIA)\u001a4NK6|'/\u001f\u0005\b\u0003\u000b2\u0001\u0019AA\u0018\u0003!\u0019wN\u001c8fGR\u001c\bbBA%\r\u0001\u0007\u00111J\u0001\nS:LGOV1mk\u0016\u0004RAVA'\u0003#J1!a\u0014X\u0005\u0019y\u0005\u000f^5p]B\u0019\u00110a\u0015\n\u0007\u0005U\u0013KA\bNK6|'/_%oSR4\u0016\r\\;f\u0003\u001d9W\r^%oSR$b!a\u0017\u0002b\u0005%\u0007c\u0001;\u0002^%\u0019\u0011qL&\u0003\u0013\u0005\u0013(/Y=FqB\u0014\bbBA2\u000f\u0001\u0007\u0011QM\u0001\u0002[B\u0019\u0011\u0011\u0007\u0005\u0003\u000f5+W.\u00138g_N\u0011\u0001\"\u0016\u000b\u0005\u0003K\ni\u0007C\u0004\u0002d)\u0001\r!a\u000e\u0002\t9\fW.Z\u000b\u0002K\u0006)a.Y7fA\u0005)A-\u001a9uQV\u0011\u0011\u0011\u0010\t\u0005\u0003\u000f\tY(\u0003\u0003\u0002~\u0005U!A\u0002\"jO&sG/\u0001\u0004eKB$\b\u000eI\u0001\nI\u0006$\u0018mV5ei\",\u0012\u0001]\u0001\u000bI\u0006$\u0018mV5ei\"\u0004\u0013AC5oI\u0016Dx+\u001b3uQ\u0006Y\u0011N\u001c3fq^KG\r\u001e5!\u0003\r\u0019\u00180\\\u000b\u0003\u0003\u001f\u00032\u0001^AI\u0013\r\t\u0019j\u0013\u0002\f\u0003J\u0014\u0018-_*z[\n|G.\u0001\u0003ts6\u0004\u0013A\u00029sK\u001aL\u00070\u0006\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001\u00027b]\u001eT!!!*\u0002\t)\fg/Y\u0005\u0004]\u0006}\u0015a\u00029sK\u001aL\u0007\u0010I\u0001\u0011MVdG.\u00113ee\u0016\u001c8OU1oO\u0016,\"!a,\u0011\u0007Y\u000b\t,C\u0002\u00024^\u0013qAQ8pY\u0016\fg.A\tgk2d\u0017\t\u001a3sKN\u001c(+\u00198hK\u0002\nq\u0001Z3qi\"\u0014e+\u0006\u0002\u0002<B\u0019A/!0\n\u0007\u0005}6JA\u0005C-2KG/\u001a:bY\u0006q\u0011n\u001d,bY&$\u0017\t\u001a3sKN\u001cHcA:\u0002F\"1\u0011q\u0019\u000eA\u0002M\fA!\u00193ee\"9\u0011\u0011J\u0004A\u0002\u0005E#aB'f[B{'\u000f^\n\u00037U\u000ba!\\3n_JL\u0018AB5oaV$8\u000fE\u0003W\u0003+,7/C\u0002\u0002X^\u0013\u0011BR;oGRLwN\\\u0019\u0015\u0011\u0005m\u0017Q\\Ap\u0003C\u00042!!\r\u001c\u0011\u001d\ty\r\ta\u0001\u0003KBa!a\u001c!\u0001\u0004)\u0007bBAiA\u0001\u0007\u00111[\u0001\u0003K:,\"!a:\u0011\u0007Q\fI/C\u0002\u0002l.\u0013\u0001B\u0011,Ts6\u0014w\u000e\\\u0001\u0004K:\u0004\u0013\u0001\u00023bi\u0006\fQ\u0001Z1uC\u0002\nQ!\u00193ee\u0002\n\u0011\"\\1lK\u001aKW\r\u001c3\u0015\r\u0005\u001d\u0018\u0011`A\u007f\u0011\u0019\tYp\na\u0001K\u0006)a-[3mI\"1\u0011q`\u0014A\u0002A\fQa^5ei\"\f\u0001\"\u001a8JgR\u0013X/Z\u0001\nK:L5\u000f\u0016:vK\u0002\na\"\\1lKJ\u000bg\u000eZ8n\t\u0006$\u0018\rF\u0002t\u0005\u0013AaAa\u0003+\u0001\u0004)\u0017AB:vM\u001aL\u00070A\u0004sK\u0006$w\n\u001c3\u0015\u0003M\fAA]3bIR)1O!\u0006\u0003\u0018!I\u0011q\u0019\u0017\u0011\u0002\u0003\u0007\u0011q\u001d\u0005\n\u0003Gd\u0003\u0013!a\u0001\u0003O\faB]3bI\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001e)\"\u0011q\u001dB\u0010W\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0016/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=\"Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0004:fC\u0012$C-\u001a4bk2$HE\r\u0002\n/JLG/\u001a)peR\u001c2aLAn)!\u0011IDa\u000f\u0003>\t}\u0002cAA\u0019_!9\u0011qZ\u001aA\u0002\u0005\u0015\u0004BBA8g\u0001\u0007Q\rC\u0004\u0002RN\u0002\r!a5\u0002\t5\f7o[\u0001\u0006[\u0006\u001c8\u000eI\u0001\u000b[\u0006\u001c8.S:UeV,\u0017aC7bg.L5\u000f\u0016:vK\u0002\nq\u0001Z8Xe&$X-F\u0001t\u0003!!wn\u0016:ji\u0016\u0004\u0013\u0001\u00043pKN\u001cuN\u001c4mS\u000e$HcA:\u0003T!9!Q\u000b\u001eA\u0002\t]\u0013!\u0001:\u0011\u0007\u0005ERH\u0001\u0005SK\u0006$\u0007k\u001c:u'\ri\u00141\u001c\u000b\t\u0005/\u0012yF!\u0019\u0003d!9\u0011qZ!A\u0002\u0005\u0015\u0004BBA8\u0003\u0002\u0007Q\rC\u0004\u0002R\u0006\u0003\r!a5\u0015\u0007M\u00149\u0007C\u0004\u0003jm\u0002\rA!\u000f\u0002\u0003]\fqa\u001e:ji\u0016$v\u000e\u0006\u0003\u0002\\\t=\u0004b\u0002B9y\u0001\u0007\u00111L\u0001\u0006CJ\u0014\u0018-_\u0001\u0004C:$G#B:\u0003x\tm\u0004B\u0002B=\u0005\u0002\u00071/A\u0001b\u0011\u0019\u0011iH\u0011a\u0001g\u0006\t!-\u0001\u0002peR)1Oa!\u0003\u0006\"1!\u0011P\"A\u0002MDaA! D\u0001\u0004\u0019\u0018\u0001\u0002+sk\u0016\fQ\u0001\u0016:vK\u0002\nQAR1mg\u0016\faAR1mg\u0016\u0004\u0013aA1mYR\u00191Oa%\t\u000f\tu\u0004\n1\u0001\u0003\u0016B)\u0011qAA\tg\u0006\u0019\u0011M\\=\u0015\u0007M\u0014Y\nC\u0004\u0003~%\u0003\rA!&")
public class MemoryEncoding
implements LazyLogging {
    public final Function2<String, Object, BVExpr> firrtl$backends$experimental$smt$MemoryEncoding$$makeRandom;
    private final Namespace namespace;
    private final BVLiteral firrtl$backends$experimental$smt$MemoryEncoding$$True;
    private final BVLiteral False;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Tuple2<Iterable<State>, Iterable<Tuple2<String, BVExpr>>> onMemory(DefMemory defMem, Iterable<Tuple2<String, BVExpr>> connects, Option<MemoryInitValue> initValue) {
        ArrayExpr arrayExpr;
        Predef$.MODULE$.assert(defMem.dataType() instanceof GroundType, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Memory ").append(defMem).append(" is of type ").append(defMem.dataType()).append(" which is not a ground type!").toString());
        Predef$.MODULE$.assert(defMem.readwriters().isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Combined read/write ports are not supported! Please split them up.");
        MemInfo m = new MemInfo(this, defMem);
        Map inputs = ((TraversableOnce)connects.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(MemoryEncoding.$anonfun$onMemory$3(m, x$9)))).toMap(Predef$.MODULE$.$conforms());
        Option<SMTExpr> init = initValue.map((Function1<MemoryInitValue, ArrayExpr> & Serializable & scala.Serializable)x$10 -> this.getInit(m, (MemoryInitValue)x$10));
        Seq writers = defMem.writers().map((Function1<String, WritePort> & Serializable & scala.Serializable)w -> new WritePort(this, m, (String)w, inputs), Seq$.MODULE$.canBuildFrom());
        Seq readers = defMem.readers().map((Function1<String, ReadPort> & Serializable & scala.Serializable)r -> new ReadPort(this, m, (String)r, inputs), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(defMem.writeLatency() == 1, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Only memories with write-latency of one are supported.");
        if (writers.isEmpty()) {
            arrayExpr = m.sym();
        } else {
            if (writers.length() > 2) {
                throw new UnsupportedFeatureException(new StringBuilder(31).append("memories with 3+ write ports (").append(m.name()).append(")").toString());
            }
            ArrayExpr validData = writers.foldLeft(m.sym(), (Function2<ArrayExpr, WritePort, ArrayExpr> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2<ArrayExpr, WritePort> tuple2 = new Tuple2<ArrayExpr, WritePort>((ArrayExpr)x0$1, (WritePort)x1$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                ArrayExpr sym = tuple2._1();
                WritePort w = tuple2._2();
                ArrayExpr arrayExpr = w.writeTo(sym);
                return arrayExpr;
            });
            if (writers.length() == 1) {
                arrayExpr = validData;
            } else {
                Predef$.MODULE$.assert(writers.length() == 2);
                BVExpr conflict = ((WritePort)writers.head()).doesConflict((WritePort)writers.last());
                BVExpr conflictData = ((MemPort)writers.head()).makeRandomData("_write_write_collision");
                ArrayStore conflictStore = new ArrayStore(m.sym(), ((MemPort)writers.head()).addr(), conflictData);
                arrayExpr = new ArrayIte(conflict, conflictStore, validData);
            }
        }
        ArraySymbol next = arrayExpr;
        State state = new State(m.sym(), init, new Some<SMTExpr>(next));
        Predef$.MODULE$.assert(defMem.readLatency() >= 0);
        if (defMem.readLatency() > 1) {
            throw new UnsupportedFeatureException(new StringBuilder(32).append("memories with read latency 2+ (").append(m.name()).append(")").toString());
        }
        Seq readPortSignals = defMem.readLatency() == 0 ? readers.map((Function1<ReadPort, Tuple2> & Serializable & scala.Serializable)r -> {
            Enumeration.Value value = defMem.readUnderWrite();
            Enumeration.Value value2 = ReadUnderWrite$.MODULE$.New();
            if (value == null ? value2 != null : !((Object)value).equals(value2)) {
                this.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(144).append("WARN: Memory ").append(m.name()).append(" with combinatorial read port will always return the most recently written entry.").append(" The read-under-write => ").append(defMem.readUnderWrite()).append(" setting will be ignored.").toString());
            }
            BVExpr data = r.read(r.read$default$1(), r.read$default$2());
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(r.data().name()), data);
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        Seq readPortSignalsAndStates = defMem.readLatency() == 1 ? readers.map((Function1<ReadPort, Tuple2> & Serializable & scala.Serializable)r -> {
            Tuple2<List, Seq<Nothing$>> tuple2;
            Enumeration.Value value = defMem.readUnderWrite();
            Enumeration.Value value2 = ReadUnderWrite$.MODULE$.New();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
                BVSymbol enPrev = new BVSymbol($this.namespace.newName(new StringBuilder(5).append(r.en().name()).append("_prev").toString()), r.en().width());
                BVSymbol addrPrev = new BVSymbol($this.namespace.newName(new StringBuilder(5).append(r.addr().name()).append("_prev").toString()), r.addr().width());
                Tuple2<String, BVExpr> signal = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(r.data().name()), r.read(addrPrev, enPrev));
                Seq states = new $colon$colon<Nothing$>((Nothing$)((Object)new State(enPrev, None$.MODULE$, new Some<SMTExpr>(r.en()))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new State(addrPrev, None$.MODULE$, new Some<SMTExpr>(r.addr()))), Nil$.MODULE$));
                tuple2 = new Tuple2<$colon$colon<Nothing$>, Seq>(new $colon$colon<Nothing$>((Nothing$)((Object)signal), Nil$.MODULE$), states);
            } else {
                Enumeration.Value value4 = ReadUnderWrite$.MODULE$.Undefined();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                    BVExpr bVExpr;
                    BVExpr anyWriteToTheSameAddress;
                    BVExpr bVExpr2 = anyWriteToTheSameAddress = this.any(writers.map((Function1<WritePort, BVExpr> & Serializable & scala.Serializable)x$11 -> x$11.doesConflict((ReadPort)r), Seq$.MODULE$.canBuildFrom()));
                    BVLiteral bVLiteral = this.False();
                    if (!(bVExpr2 != null ? !bVExpr2.equals(bVLiteral) : bVLiteral != null)) {
                        bVExpr = r.read(r.read$default$1(), r.read$default$2());
                    } else {
                        BVExpr readUnderWriteData = r.makeRandomData("_read_under_write_undefined");
                        bVExpr = new BVIte(anyWriteToTheSameAddress, readUnderWriteData, r.read(r.read$default$1(), r.read$default$2()));
                    }
                    BVExpr next = bVExpr;
                    tuple2 = new Tuple2<Nil$, $colon$colon<Nothing$>>(Nil$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new State(r.data(), None$.MODULE$, new Some<SMTExpr>(next))), Nil$.MODULE$));
                } else {
                    Enumeration.Value value6 = ReadUnderWrite$.MODULE$.Old();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                        tuple2 = new Tuple2<Nil$, $colon$colon<Nothing$>>(Nil$.MODULE$, new $colon$colon<Nothing$>((Nothing$)((Object)new State(r.data(), None$.MODULE$, new Some<SMTExpr>(r.read(r.read$default$1(), r.read$default$2())))), Nil$.MODULE$));
                    } else {
                        throw new MatchError(value);
                    }
                }
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        Seq allReadPortSignals = readPortSignals.$plus$plus(readPortSignalsAndStates.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x$12 -> (Seq)x$12._1(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq readPortStates = readPortSignalsAndStates.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)x$13 -> (Seq)x$13._2(), Seq$.MODULE$.canBuildFrom());
        State state2 = state;
        return new Tuple2<Iterable<State>, Iterable<Tuple2<String, BVExpr>>>(readPortStates.$plus$colon(state2, Seq$.MODULE$.canBuildFrom()), allReadPortSignals);
    }

    private ArrayExpr getInit(MemInfo m, MemoryInitValue initValue) {
        ArrayExpr arrayExpr;
        MemoryInitValue memoryInitValue = initValue;
        if (memoryInitValue instanceof MemoryScalarInit) {
            MemoryScalarInit memoryScalarInit = (MemoryScalarInit)memoryInitValue;
            BigInt value = memoryScalarInit.value();
            arrayExpr = new ArrayConstant(new BVLiteral(value, m.dataWidth()), m.indexWidth());
        } else if (memoryInitValue instanceof MemoryArrayInit) {
            MemoryArrayInit memoryArrayInit = (MemoryArrayInit)memoryInitValue;
            Seq<BigInt> values = memoryArrayInit.values();
            Predef$.MODULE$.assert(BoxesRunTime.equals(BoxesRunTime.boxToInteger(values.length()), m.depth()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Memory ").append(m.name()).append(" of depth ").append(m.depth()).append(" cannot be initialized with an array of length ").append(values.length()).append("!").toString());
            LinkedHashMap histogram = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Nil$.MODULE$);
            values.foreach((Function1<BigInt, Object> & Serializable & scala.Serializable)v -> {
                histogram.update(v, BoxesRunTime.boxToInteger(1 + BoxesRunTime.unboxToInt(histogram.getOrElse(v, (JFunction0$mcI$sp & scala.Serializable)() -> 0))));
                return BoxedUnit.UNIT;
            });
            BigInt baseValue = (BigInt)((Tuple2)histogram.maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger(x$15._2$mcI$sp()), Ordering$Int$.MODULE$))._1();
            ArrayConstant base = new ArrayConstant(new BVLiteral(baseValue, m.dataWidth()), m.indexWidth());
            arrayExpr = ((TraversableOnce)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filterNot((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(MemoryEncoding.$anonfun$getInit$5(baseValue, x$16)))).foldLeft(base, (Function2<ArrayExpr, Tuple2, ArrayExpr> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                ArrayExpr array;
                block3: {
                    Tuple2<ArrayExpr, Tuple2> tuple22;
                    block2: {
                        tuple22 = new Tuple2<ArrayExpr, Tuple2>((ArrayExpr)x0$1, (Tuple2)x1$1);
                        if (tuple22 == null) break block2;
                        array = tuple22._1();
                        tuple2 = tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError(tuple22);
                }
                BigInt value = (BigInt)tuple2._1();
                int index = tuple2._2$mcI$sp();
                ArrayStore arrayStore = new ArrayStore(array, new BVLiteral(BigInt$.MODULE$.int2bigInt(index), m.indexWidth()), new BVLiteral(value, m.dataWidth()));
                return arrayStore;
            });
        } else {
            throw new RuntimeException(new StringBuilder(32).append("Unsupported memory init option: ").append(memoryInitValue).toString());
        }
        return arrayExpr;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BVExpr firrtl$backends$experimental$smt$MemoryEncoding$$and(BVExpr a, BVExpr b) {
        void var3_12;
        Tuple2<BVExpr, BVExpr> tuple2 = new Tuple2<BVExpr, BVExpr>(a, b);
        if (tuple2 != null) {
            BVExpr bVExpr = tuple2._1();
            BVExpr bVExpr2 = tuple2._2();
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$$True();
            BVExpr bVExpr3 = bVExpr;
            if (!(bVLiteral != null ? !((Object)bVLiteral).equals(bVExpr3) : bVExpr3 != null)) {
                BVLiteral bVLiteral2 = this.firrtl$backends$experimental$smt$MemoryEncoding$$True();
                BVExpr bVExpr4 = bVExpr2;
                if (!(bVLiteral2 != null ? !((Object)bVLiteral2).equals(bVExpr4) : bVExpr4 != null)) {
                    BVLiteral bVLiteral3 = this.firrtl$backends$experimental$smt$MemoryEncoding$$True();
                    return var3_12;
                }
            }
        }
        if (tuple2 != null) {
            BVExpr bVExpr = tuple2._1();
            BVExpr x = tuple2._2();
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$$True();
            BVExpr bVExpr5 = bVExpr;
            if (!(bVLiteral != null ? !((Object)bVLiteral).equals(bVExpr5) : bVExpr5 != null)) {
                BVExpr bVExpr6 = x;
                return var3_12;
            }
        }
        if (tuple2 != null) {
            BVExpr x = tuple2._1();
            BVExpr bVExpr = tuple2._2();
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$$True();
            BVExpr bVExpr7 = bVExpr;
            if (!(bVLiteral != null ? !((Object)bVLiteral).equals(bVExpr7) : bVExpr7 != null)) {
                BVExpr bVExpr8 = x;
                return var3_12;
            }
        }
        BVOp bVOp = new BVOp(Op$.MODULE$.And(), a, b);
        return var3_12;
    }

    private BVExpr or(BVExpr a, BVExpr b) {
        return new BVOp(Op$.MODULE$.Or(), a, b);
    }

    public BVLiteral firrtl$backends$experimental$smt$MemoryEncoding$$True() {
        return this.firrtl$backends$experimental$smt$MemoryEncoding$$True;
    }

    private BVLiteral False() {
        return this.False;
    }

    private BVExpr all(Iterable<BVExpr> b2) {
        return b2.isEmpty() ? this.False() : (BVExpr)b2.reduce((Function2<BVExpr, BVExpr, BVExpr> & Serializable & scala.Serializable)(a, b) -> this.firrtl$backends$experimental$smt$MemoryEncoding$$and((BVExpr)a, (BVExpr)b));
    }

    private BVExpr any(Iterable<BVExpr> b2) {
        return b2.isEmpty() ? this.firrtl$backends$experimental$smt$MemoryEncoding$$True() : (BVExpr)b2.reduce((Function2<BVExpr, BVExpr, BVExpr> & Serializable & scala.Serializable)(a, b) -> this.or((BVExpr)a, (BVExpr)b));
    }

    public static final /* synthetic */ boolean $anonfun$onMemory$3(MemInfo m$1, Tuple2 x$9) {
        return ((String)x$9._1()).startsWith(m$1.prefix());
    }

    public static final /* synthetic */ boolean $anonfun$getInit$5(BigInt baseValue$1, Tuple2 x$16) {
        return BoxesRunTime.equals(x$16._1(), baseValue$1);
    }

    public MemoryEncoding(Function2<String, Object, BVExpr> makeRandom, Namespace namespace) {
        this.firrtl$backends$experimental$smt$MemoryEncoding$$makeRandom = makeRandom;
        this.namespace = namespace;
        LazyLogging.$init$(this);
        this.firrtl$backends$experimental$smt$MemoryEncoding$$True = new BVLiteral(BigInt$.MODULE$.int2bigInt(1), 1);
        this.False = new BVLiteral(BigInt$.MODULE$.int2bigInt(0), 1);
    }

    public MemoryEncoding(Function2<String, Object, BVExpr> makeRandom) {
        this(makeRandom, Namespace$.MODULE$.apply(Namespace$.MODULE$.apply$default$1()));
    }

    private class MemInfo {
        private BVLiteral depthBV;
        private DefMemory m;
        private final String name;
        private final BigInt depth;
        private final int dataWidth;
        private final int indexWidth;
        private final ArraySymbol sym;
        private final String prefix;
        private final boolean fullAddressRange;
        private volatile boolean bitmap$0;
        public final /* synthetic */ MemoryEncoding $outer;

        public String name() {
            return this.name;
        }

        public BigInt depth() {
            return this.depth;
        }

        public int dataWidth() {
            return this.dataWidth;
        }

        public int indexWidth() {
            return this.indexWidth;
        }

        public ArraySymbol sym() {
            return this.sym;
        }

        public String prefix() {
            return this.prefix;
        }

        public boolean fullAddressRange() {
            return this.fullAddressRange;
        }

        private BVLiteral depthBV$lzycompute() {
            MemInfo memInfo = this;
            synchronized (memInfo) {
                if (!this.bitmap$0) {
                    this.depthBV = new BVLiteral(this.m.depth(), this.indexWidth());
                    this.bitmap$0 = true;
                }
            }
            this.m = null;
            return this.depthBV;
        }

        public BVLiteral depthBV() {
            return !this.bitmap$0 ? this.depthBV$lzycompute() : this.depthBV;
        }

        public BVExpr isValidAddress(BVExpr addr) {
            return this.fullAddressRange() ? this.firrtl$backends$experimental$smt$MemoryEncoding$MemInfo$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$True() : new BVComparison(Compare$.MODULE$.Greater(), this.depthBV(), addr, false);
        }

        public /* synthetic */ MemoryEncoding firrtl$backends$experimental$smt$MemoryEncoding$MemInfo$$$outer() {
            return this.$outer;
        }

        public MemInfo(MemoryEncoding $outer, DefMemory m) {
            this.m = m;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.name = m.name();
            this.depth = m.depth();
            this.dataWidth = FirrtlExpressionSemantics$.MODULE$.getWidth(m.dataType());
            this.indexWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(Utils$.MODULE$.getUIntWidth(m.depth().$minus(BigInt$.MODULE$.int2bigInt(1)))), 1);
            this.sym = new ArraySymbol(m.name(), this.indexWidth(), this.dataWidth());
            this.prefix = new StringBuilder(1).append(m.name()).append(".").toString();
            BigInt bigInt = package$.MODULE$.BigInt().apply(1).$less$less(this.indexWidth());
            BigInt bigInt2 = m.depth();
            this.fullAddressRange = !(bigInt != null ? !((Object)bigInt).equals(bigInt2) : bigInt2 != null);
        }
    }

    private abstract class MemPort {
        private final MemInfo memory;
        private final String name;
        private final BVSymbol en;
        private final BVSymbol data;
        private final BVSymbol addr;
        private final boolean enIsTrue;
        public final /* synthetic */ MemoryEncoding $outer;

        public String name() {
            return this.name;
        }

        public BVSymbol en() {
            return this.en;
        }

        public BVSymbol data() {
            return this.data;
        }

        public BVSymbol addr() {
            return this.addr;
        }

        public BVSymbol makeField(String field2, int width) {
            return new BVSymbol(new StringBuilder(1).append(this.memory.prefix()).append(this.name()).append(".").append(field2).toString(), width);
        }

        public boolean enIsTrue() {
            return this.enIsTrue;
        }

        public BVExpr makeRandomData(String suffix) {
            return this.firrtl$backends$experimental$smt$MemoryEncoding$MemPort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$makeRandom.apply(new StringBuilder(1).append(this.memory.name()).append("_").append(this.name()).append(suffix).toString(), BoxesRunTime.boxToInteger(this.memory.dataWidth()));
        }

        public BVExpr readOld() {
            return this.read(this.addr(), this.en());
        }

        public BVExpr read(BVSymbol addr, BVSymbol en) {
            BVExpr bVExpr;
            ArrayRead dataWithRangeCheck;
            BVExpr bVExpr2;
            boolean canBeOutOfRange = !this.memory.fullAddressRange();
            boolean canBeDisabled = !this.enIsTrue();
            ArrayRead data = new ArrayRead(this.memory.sym(), addr);
            if (canBeOutOfRange) {
                BVExpr outOfRangeData = this.makeRandomData("_addr_out_of_range");
                bVExpr2 = new BVIte(this.memory.isValidAddress(addr), data, outOfRangeData);
            } else {
                bVExpr2 = dataWithRangeCheck = data;
            }
            if (canBeDisabled) {
                BVExpr disabledData = this.makeRandomData("_not_enabled");
                bVExpr = new BVIte(en, dataWithRangeCheck, disabledData);
            } else {
                bVExpr = dataWithRangeCheck;
            }
            ArrayRead dataWithEnabledCheck = bVExpr;
            return dataWithEnabledCheck;
        }

        public BVSymbol read$default$1() {
            return this.addr();
        }

        public BVSymbol read$default$2() {
            return this.en();
        }

        public /* synthetic */ MemoryEncoding firrtl$backends$experimental$smt$MemoryEncoding$MemPort$$$outer() {
            return this.$outer;
        }

        public MemPort(MemoryEncoding $outer, MemInfo memory, String name, Function1<String, BVExpr> inputs) {
            this.memory = memory;
            this.name = name;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.en = this.makeField("en", 1);
            this.data = this.makeField("data", memory.dataWidth());
            this.addr = this.makeField("addr", memory.indexWidth());
            Predef$.MODULE$.assert(inputs.apply(this.en().name()).width() == this.en().width());
            Predef$.MODULE$.assert(inputs.apply(this.addr().name()).width() == this.addr().width());
            BVExpr bVExpr = inputs.apply(this.en().name());
            BVLiteral bVLiteral = $outer.firrtl$backends$experimental$smt$MemoryEncoding$$True();
            this.enIsTrue = !(bVExpr != null ? !bVExpr.equals(bVLiteral) : bVLiteral != null);
        }
    }

    private class ReadPort
    extends MemPort {
        public /* synthetic */ MemoryEncoding firrtl$backends$experimental$smt$MemoryEncoding$ReadPort$$$outer() {
            return this.$outer;
        }

        public ReadPort(MemoryEncoding $outer, MemInfo memory, String name, Function1<String, BVExpr> inputs) {
            super($outer, memory, name, inputs);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    private class WritePort
    extends MemPort {
        private final MemInfo memory;
        private final BVSymbol mask;
        private final boolean maskIsTrue;
        private final BVExpr doWrite;

        public BVSymbol mask() {
            return this.mask;
        }

        public boolean maskIsTrue() {
            return this.maskIsTrue;
        }

        public BVExpr doWrite() {
            return this.doWrite;
        }

        public BVExpr doesConflict(ReadPort r) {
            BVEqual sameAddress = new BVEqual(r.addr(), this.addr());
            BVExpr bVExpr = this.doWrite();
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$True();
            return !(bVExpr != null ? !bVExpr.equals(bVLiteral) : bVLiteral != null) ? sameAddress : this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$and(this.doWrite(), sameAddress);
        }

        public BVExpr doesConflict(WritePort w) {
            BVExpr bothWrite = this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$and(this.doWrite(), w.doWrite());
            BVEqual sameAddress = new BVEqual(this.addr(), w.addr());
            BVExpr bVExpr = bothWrite;
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$True();
            return !(bVExpr != null ? !bVExpr.equals(bVLiteral) : bVLiteral != null) ? sameAddress : this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$and(bothWrite, sameAddress);
        }

        public ArrayExpr writeTo(ArrayExpr array) {
            BVExpr doUpdate = this.memory.fullAddressRange() ? this.doWrite() : this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$and(this.doWrite(), this.memory.isValidAddress(this.addr()));
            ArrayStore update2 = new ArrayStore(array, this.addr(), this.data());
            BVExpr bVExpr = doUpdate;
            BVLiteral bVLiteral = this.firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer().firrtl$backends$experimental$smt$MemoryEncoding$$True();
            return !(bVExpr != null ? !bVExpr.equals(bVLiteral) : bVLiteral != null) ? update2 : new ArrayIte(doUpdate, update2, array);
        }

        public /* synthetic */ MemoryEncoding firrtl$backends$experimental$smt$MemoryEncoding$WritePort$$$outer() {
            return this.$outer;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public WritePort(MemoryEncoding $outer, MemInfo memory, String name, Function1<String, BVExpr> inputs) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            this.memory = memory;
                            super($outer, memory, name, inputs);
                            Predef$.MODULE$.assert(inputs.apply(this.data().name()).width() == this.data().width());
                            this.mask = this.makeField("mask", 1);
                            Predef$.MODULE$.assert(inputs.apply(this.mask().name()).width() == this.mask().width());
                            v0 = inputs.apply(this.mask().name());
                            var6_5 = $outer.firrtl$backends$experimental$smt$MemoryEncoding$$True();
                            this.maskIsTrue = !(v0 != null ? v0.equals(var6_5) == false : var6_5 != null);
                            var7_6 = new Tuple2$mcZZ$sp(this.enIsTrue(), this.maskIsTrue());
                            if (var7_6 == null) break block2;
                            var8_7 = var7_6._1$mcZ$sp();
                            var9_8 = var7_6._2$mcZ$sp();
                            if (!var8_7 || !var9_8) break block2;
                            var5_9 /* !! */  = $outer.firrtl$backends$experimental$smt$MemoryEncoding$$True();
                            break block3;
                        }
                        if (var7_6 == null) break block4;
                        var10_10 = var7_6._1$mcZ$sp();
                        var11_11 = var7_6._2$mcZ$sp();
                        if (!var10_10 || var11_11) break block4;
                        var5_9 /* !! */  = this.mask();
                        break block3;
                    }
                    if (var7_6 == null) break block5;
                    var12_12 = var7_6._1$mcZ$sp();
                    var13_13 = var7_6._2$mcZ$sp();
                    if (var12_12 || !var13_13) break block5;
                    var5_9 /* !! */  = this.en();
                    break block3;
                }
                if (var7_6 == null) ** GOTO lbl-1000
                var14_14 = var7_6._1$mcZ$sp();
                var15_15 = var7_6._2$mcZ$sp();
                if (!var14_14 && !var15_15) {
                    var5_9 /* !! */  = $outer.firrtl$backends$experimental$smt$MemoryEncoding$$and(this.en(), this.mask());
                } else lbl-1000:
                // 2 sources

                {
                    throw new MatchError(var7_6);
                }
            }
            this.doWrite = var5_9 /* !! */ ;
        }
    }
}

