/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.Namespace;
import firrtl.Namespace$;
import firrtl.backends.experimental.smt.AsyncResetException;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVImplies;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.FirrtlExpressionSemantics$;
import firrtl.backends.experimental.smt.ModuleScanner$Context$;
import firrtl.backends.experimental.smt.TranslationContext;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Attach;
import firrtl.ir.BundleType;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.Expression;
import firrtl.ir.Field;
import firrtl.ir.Formal$;
import firrtl.ir.GroundType;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.Print;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.StringLit;
import firrtl.ir.SubField;
import firrtl.ir.Type;
import firrtl.ir.Verification;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B#G\t=C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006e\u0002!\ta\u001d\u0005\tm\u0002\u0011\r\u0011\"\u0001Mo\"9\u0011q\u0001\u0001!\u0002\u0013A\bBCA\u0005\u0001\t\u0007I\u0011\u0001'\u0002\f!A\u0011q\u0002\u0001!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0011\r\u0011\"\u0001M\u0003'A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0003\u0005\u000b\u0003;\u0001!\u0019!C\u0001\u0019\u0006-\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0004\t\u0015\u0005\u0005\u0002A1A\u0005\u00021\u000bY\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u0007\u0011)\t)\u0003\u0001b\u0001\n\u0003a\u00151\u0002\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u000e!Q\u0011\u0011\u0006\u0001C\u0002\u0013\u0005A*a\u000b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003[A!\"a\u000e\u0001\u0005\u0004%\t\u0001TA\u001d\u0011!\tI\u0005\u0001Q\u0001\n\u0005m\u0002BCA&\u0001\t\u0007I\u0011\u0001'\u0002N!A\u0011q\u000b\u0001!\u0002\u0013\ty\u0005\u0003\u0006\u0002Z\u0001\u0011\r\u0011\"\u0001M\u0003\u0017A\u0001\"a\u0017\u0001A\u0003%\u0011Q\u0002\u0005\u000b\u0003;\u0002!\u0019!C\u0001\u0019\u0006-\u0001\u0002CA0\u0001\u0001\u0006I!!\u0004\t\u0015\u0005\u0005\u0004A1A\u0005\u00021\u000b\u0019\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA3\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA;\u0011)\ti\b\u0001b\u0001\n\u0003a\u0015q\u0010\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002\u0002\"A\u00111\u0012\u0001\u0005\u00021\u000bi\t\u0003\u0005\u0002 \u0002!\t\u0001TAQ\u0011%\ti\u000b\u0001b\u0001\n\u0013\ty\u000b\u0003\u0005\u0002L\u0002\u0001\u000b\u0011BAY\u0011%\ti\r\u0001b\u0001\n\u0013\ty\u000b\u0003\u0005\u0002P\u0002\u0001\u000b\u0011BAY\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a;\u0001\t\u0013\ti\u000fC\u0004\u0002r\u0002!I!a=\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u00191!Q\u0002\u0001E\u0005\u001fA!Ba\t*\u0005+\u0007I\u0011\u0001B\u0013\u0011%\u00119#\u000bB\tB\u0003%\u0001\r\u0003\u0004sS\u0011\u0005!\u0011\u0006\u0005\b\u0005cIC\u0011\tB\u001a\u0011%\u0011I$KA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003@%\n\n\u0011\"\u0001\u0003B!I!qK\u0015\u0002\u0002\u0013\u0005#\u0011\f\u0005\n\u00057J\u0013\u0011!C\u0001\u0005;B\u0011Ba\u0018*\u0003\u0003%\tA!\u0019\t\u0013\t5\u0014&!A\u0005B\t=\u0004\"\u0003B=S\u0005\u0005I\u0011\u0001B>\u0011%\u0011))KA\u0001\n\u0003\u00129\tC\u0005\u0003\n&\n\t\u0011\"\u0011\u0003\f\"I!QR\u0015\u0002\u0002\u0013\u0005#qR\u0004\n\u0005'\u0003\u0011\u0011!E\u0005\u0005+3\u0011B!\u0004\u0001\u0003\u0003EIAa&\t\rILD\u0011\u0001BS\u0011%\u0011I)OA\u0001\n\u000b\u0012Y\tC\u0005\u0003(f\n\t\u0011\"!\u0003*\"I!QV\u001d\u0002\u0002\u0013\u0005%q\u0016\u0005\b\u0005w\u0003A\u0011\u0002B_\u0011\u001d\u0011Y\f\u0001C\u0005\u0005\u000fDqA!4\u0001\t\u0013\u0011y\rC\u0004\u0003Z\u0002!IAa7\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!Q\u001e\u0001\u0005\n\t=\bb\u0002Bz\u0001\u0011%!Q\u001f\u0002\u000e\u001b>$W\u000f\\3TG\u0006tg.\u001a:\u000b\u0005\u001dC\u0015aA:ni*\u0011\u0011JS\u0001\rKb\u0004XM]5nK:$\u0018\r\u001c\u0006\u0003\u00172\u000b\u0001BY1dW\u0016tGm\u001d\u0006\u0002\u001b\u00061a-\u001b:si2\u001c\u0001aE\u0002\u0001!Z\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013a!\u00118z%\u00164\u0007CA,[\u001b\u0005A&\"A-\u0002\r1|wmZ3s\u0013\tY\u0006LA\u0006MCjLHj\\4hS:<\u0017AC7bW\u0016\u0014\u0016M\u001c3p[B)\u0011K\u00181l]&\u0011qL\u0015\u0002\n\rVt7\r^5p]J\u0002\"!\u00195\u000f\u0005\t4\u0007CA2S\u001b\u0005!'BA3O\u0003\u0019a$o\\8u}%\u0011qMU\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002h%B\u0011\u0011\u000b\\\u0005\u0003[J\u00131!\u00138u!\ty\u0007/D\u0001G\u0013\t\thI\u0001\u0004C-\u0016C\bO]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q,\bCA8\u0001\u0011\u0015a&\u00011\u0001^\u0003\u0019Ig\u000e];ugV\t\u0001\u0010\u0005\u0003z}\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003{J\u000b!bY8mY\u0016\u001cG/[8o\u0013\ty(PA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA8\u0002\u0004%\u0019\u0011Q\u0001$\u0003\u0011\t36+_7c_2\fq!\u001b8qkR\u001c\b%A\u0004pkR\u0004X\u000f^:\u0016\u0005\u00055\u0001cA=\u007fA\u0006Aq.\u001e;qkR\u001c\b%\u0001\u0004dY>\u001c7n]\u000b\u0003\u0003+\u0001B!_A\fA&\u0019\u0011\u0011\u0004>\u0003\u001b1Kgn[3e\u0011\u0006\u001c\bnU3u\u0003\u001d\u0019Gn\\2lg\u0002\nQa^5sKN\faa^5sKN\u0004\u0013!\u00028pI\u0016\u001c\u0018A\u00028pI\u0016\u001c\b%\u0001\u0006nK6\u001c\u0016n\u001a8bYN\f1\"\\3n'&<g.\u00197tA\u0005I!/Z4jgR,'o]\u000b\u0003\u0003[\u0001B!\u001f@\u00020A9\u0011+!\raW:t\u0017bAA\u001a%\n1A+\u001e9mKR\n!B]3hSN$XM]:!\u0003!iW-\\8sS\u0016\u001cXCAA\u001e!\u0011Ih0!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011M\u0003\tI'/\u0003\u0003\u0002H\u0005\u0005#!\u0003#fM6+Wn\u001c:z\u0003%iW-\\8sS\u0016\u001c\b%\u0001\u0005d_:tWm\u0019;t+\t\ty\u0005\u0005\u0003z}\u0006E\u0003#B)\u0002T\u0001t\u0017bAA+%\n1A+\u001e9mKJ\n\u0011bY8o]\u0016\u001cGo\u001d\u0011\u0002\u000f\u0005\u001c8/\u001a:ug\u0006A\u0011m]:feR\u001c\b%A\u0004bgN,X.Z:\u0002\u0011\u0005\u001c8/^7fg\u0002\nQ!\u001b8g_N,\"!!\u001a\u0011\tet\u0018q\r\t\u0007#\u0006M\u0003-!\u001b\u0011\t\u0005}\u00121N\u0005\u0005\u0003[\n\tE\u0001\u0003J]\u001a|\u0017AB5oM>\u001c\b%\u0001\tv]V\u001cX\rZ'f[>+H\u000f];ugV\u0011\u0011Q\u000f\t\u0006s\u0006]\u0004m[\u0005\u0004\u0003sR(!\u0004'j].,G\rS1tQ6\u000b\u0007/A\tv]V\u001cX\rZ'f[>+H\u000f];ug\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003\u000bk\u0011\u0001T\u0005\u0004\u0003\u000fc%!\u0003(b[\u0016\u001c\b/Y2f\u0003)q\u0017-\\3ta\u0006\u001cW\rI\u0001\u0007_:\u0004vN\u001d;\u0015\t\u0005=\u0015Q\u0013\t\u0004#\u0006E\u0015bAAJ%\n!QK\\5u\u0011\u001d\t9j\ba\u0001\u00033\u000b\u0011\u0001\u001d\t\u0005\u0003\u007f\tY*\u0003\u0003\u0002\u001e\u0006\u0005#\u0001\u0002)peR\f1b\u001c8Ti\u0006$X-\\3oiR!\u0011qRAR\u0011\u001d\t)\u000b\ta\u0001\u0003O\u000b\u0011a\u001d\t\u0005\u0003\u007f\tI+\u0003\u0003\u0002,\u0006\u0005#!C*uCR,W.\u001a8u\u0003=\u0011X-\u00193J]B,HOR5fY\u0012\u001cXCAAY!\u0019\t\u0019,!/\u0002>6\u0011\u0011Q\u0017\u0006\u0004\u0003oc\u0018!C5n[V$\u0018M\u00197f\u0013\u0011\tY,!.\u0003\t1K7\u000f\u001e\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0017\u0001\u00026bm\u0006L1![Aa\u0003A\u0011X-\u00193J]B,HOR5fY\u0012\u001c\b%\u0001\txe&$X-\u00138qkR4\u0015.\u001a7eg\u0006\trO]5uK&s\u0007/\u001e;GS\u0016dGm\u001d\u0011\u0002\u0019\u001d,G/T3n\u0013:\u0004X\u000f^:\u0015\t\u0005U\u0017q\u001d\t\u0006\u0003/\f\t\u000f\u0019\b\u0005\u00033\fiND\u0002d\u00037L\u0011aU\u0005\u0004\u0003?\u0014\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003G\f)O\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tyN\u0015\u0005\b\u0003S,\u0003\u0019AA\u001f\u0003\u0005i\u0017!D4fi6+WnT;uaV$8\u000f\u0006\u0003\u0002V\u0006=\bbBAuM\u0001\u0007\u0011QH\u0001#S:\u001cXM\u001d;Ek6l\u00170Q:tS\u001et7OR8s\u001b\u0016lwN]=PkR\u0004X\u000f^:\u0015\t\u0005=\u0015Q\u001f\u0005\b\u0003o<\u0003\u0019AA}\u0003\u0011qW\r\u001f;\u0011\t\u0005}\u00121`\u0005\u0005\u0003{\f\tE\u0001\u0006FqB\u0014Xm]:j_:\f\u0011DZ5oIVsWo]3e\u001b\u0016lwN]=PkR\u0004X\u000f^+tKR!!1\u0001B\u0005)\u0011\tyI!\u0002\t\u000f\t\u001d\u0001\u0006q\u0001\u0002\u000e\u0005!Qo]3t\u0011\u001d\u0011Y\u0001\u000ba\u0001\u0003s\f\u0011!\u001a\u0002\b\u0007>tG/\u001a=u'!I\u0003K!\u0005\u0003\u0018\tu\u0001cA8\u0003\u0014%\u0019!Q\u0003$\u0003%Q\u0013\u0018M\\:mCRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004#\ne\u0011b\u0001B\u000e%\n9\u0001K]8ek\u000e$\bcA)\u0003 %\u0019!\u0011\u0005*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\t\f7/\u001a(b[\u0016,\u0012\u0001Y\u0001\nE\u0006\u001cXMT1nK\u0002\"BAa\u000b\u00030A\u0019!QF\u0015\u000e\u0003\u0001AaAa\t-\u0001\u0004\u0001\u0017!C4fiJ\u000bg\u000eZ8n)\rq'Q\u0007\u0005\u0007\u0005oi\u0003\u0019A6\u0002\u000b]LG\r\u001e5\u0002\t\r|\u0007/\u001f\u000b\u0005\u0005W\u0011i\u0004\u0003\u0005\u0003$9\u0002\n\u00111\u0001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0011+\u0007\u0001\u0014)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\tFU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011QX\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002W\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B2\u0005S\u00022!\u0015B3\u0013\r\u00119G\u0015\u0002\u0004\u0003:L\b\u0002\u0003B6e\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\b\u0005\u0004\u0003t\tU$1M\u0007\u0002y&\u0019!q\u000f?\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005{\u0012\u0019\tE\u0002R\u0005\u007fJ1A!!S\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u001b5\u0003\u0003\u0005\rAa\u0019\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a[\u0001\ti>\u001cFO]5oOR\u0011\u0011QX\u0001\u0007KF,\u0018\r\\:\u0015\t\tu$\u0011\u0013\u0005\n\u0005W:\u0014\u0011!a\u0001\u0005G\nqaQ8oi\u0016DH\u000fE\u0002\u0003.e\u001aR!\u000fBM\u0005;\u0001rAa'\u0003\"\u0002\u0014Y#\u0004\u0002\u0003\u001e*\u0019!q\u0014*\u0002\u000fI,h\u000e^5nK&!!1\u0015BO\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0005+\u000bQ!\u00199qYf$BAa\u000b\u0003,\"1!1\u0005\u001fA\u0002\u0001\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u00032\n]\u0006\u0003B)\u00034\u0002L1A!.S\u0005\u0019y\u0005\u000f^5p]\"I!\u0011X\u001f\u0002\u0002\u0003\u0007!1F\u0001\u0004q\u0012\u0002\u0014\u0001D8o\u000bb\u0004(/Z:tS>tGc\u00028\u0003@\n\u0005'1\u0019\u0005\b\u0005\u0017q\u0004\u0019AA}\u0011\u0019\u00119D\u0010a\u0001W\"1!Q\u0019 A\u0002\u0001\fAB]1oI>l\u0007K]3gSb$RA\u001cBe\u0005\u0017DqAa\u0003@\u0001\u0004\tI\u0010\u0003\u0004\u0003F~\u0002\r\u0001Y\u0001\n[N<Gk\u001c(b[\u0016$R\u0001\u0019Bi\u0005+DaAa5A\u0001\u0004\u0001\u0017A\u00029sK\u001aL\u0007\u0010\u0003\u0004\u0003X\u0002\u0003\r\u0001Y\u0001\u0004[N<\u0017!B3se>\u0014H\u0003BAH\u0005;DaAa6B\u0001\u0004\u0001\u0017\u0001D5t\u000fJ|WO\u001c3UsB,G\u0003\u0002B?\u0005GDqA!:C\u0001\u0004\u00119/A\u0002ua\u0016\u0004B!a\u0010\u0003j&!!1^A!\u0005\u0011!\u0016\u0010]3\u0002\u000f%\u001c8\t\\8dWR!!Q\u0010By\u0011\u001d\u0011)o\u0011a\u0001\u0005O\fA\"[:Bgft7MU3tKR$BA! \u0003x\"9!Q\u001d#A\u0002\t\u001d\b")
public class ModuleScanner
implements LazyLogging {
    private volatile ModuleScanner$Context$ Context$module;
    public final Function2<String, Object, BVExpr> firrtl$backends$experimental$smt$ModuleScanner$$makeRandom;
    private final ArrayBuffer<BVSymbol> inputs;
    private final ArrayBuffer<String> outputs;
    private final LinkedHashSet<String> clocks;
    private final ArrayBuffer<String> wires;
    private final ArrayBuffer<String> nodes;
    private final ArrayBuffer<String> memSignals;
    private final ArrayBuffer<Tuple4<String, Object, BVExpr, BVExpr>> registers;
    private final ArrayBuffer<DefMemory> memories;
    private final ArrayBuffer<Tuple2<String, BVExpr>> connects;
    private final ArrayBuffer<String> asserts;
    private final ArrayBuffer<String> assumes;
    private final ArrayBuffer<Tuple2<String, Info>> infos;
    private final LinkedHashMap<String, Object> unusedMemOutputs;
    private final Namespace namespace;
    private final List<String> readInputFields;
    private final List<String> writeInputFields;
    private final Logger logger;

    private ModuleScanner$Context$ Context() {
        if (this.Context$module == null) {
            this.Context$lzycompute$1();
        }
        return this.Context$module;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ArrayBuffer<BVSymbol> inputs() {
        return this.inputs;
    }

    public ArrayBuffer<String> outputs() {
        return this.outputs;
    }

    public LinkedHashSet<String> clocks() {
        return this.clocks;
    }

    public ArrayBuffer<String> wires() {
        return this.wires;
    }

    public ArrayBuffer<String> nodes() {
        return this.nodes;
    }

    public ArrayBuffer<String> memSignals() {
        return this.memSignals;
    }

    public ArrayBuffer<Tuple4<String, Object, BVExpr, BVExpr>> registers() {
        return this.registers;
    }

    public ArrayBuffer<DefMemory> memories() {
        return this.memories;
    }

    public ArrayBuffer<Tuple2<String, BVExpr>> connects() {
        return this.connects;
    }

    public ArrayBuffer<String> asserts() {
        return this.asserts;
    }

    public ArrayBuffer<String> assumes() {
        return this.assumes;
    }

    public ArrayBuffer<Tuple2<String, Info>> infos() {
        return this.infos;
    }

    private LinkedHashMap<String, Object> unusedMemOutputs() {
        return this.unusedMemOutputs;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public void onPort(Port p) {
        if (this.isAsyncReset(p.tpe())) {
            throw new AsyncResetException(new StringBuilder(18).append("Found AsyncReset ").append(p.name()).append(".").toString());
        }
        this.namespace().newName(p.name());
        this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p.name()), p.info())}));
        Direction direction = p.direction();
        if (Input$.MODULE$.equals(direction)) {
            BoxedUnit boxedUnit;
            if (this.isClock(p.tpe())) {
                this.clocks().add(p.name());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.inputs().append(Predef$.MODULE$.wrapRefArray((Object[])new BVSymbol[]{new BVSymbol(p.name(), FirrtlExpressionSemantics$.MODULE$.getWidth(p.tpe()))}));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (Output$.MODULE$.equals(direction)) {
            BoxedUnit boxedUnit;
            if (!this.isClock(p.tpe())) {
                this.outputs().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{p.name()}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError(direction);
        }
    }

    public void onStatement(Statement s2) {
        Statement statement = s2;
        if (statement instanceof DefWire) {
            BoxedUnit boxedUnit;
            DefWire defWire = (DefWire)statement;
            Info info = defWire.info();
            String name2 = defWire.name();
            Type tpe = defWire.tpe();
            this.namespace().newName(name2);
            if (!this.isClock(tpe)) {
                this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name2), info)}));
                this.wires().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{name2}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (statement instanceof DefNode) {
            BoxedUnit boxedUnit;
            DefNode defNode = (DefNode)statement;
            Info info = defNode.info();
            String name3 = defNode.name();
            Expression expr = defNode.value();
            this.namespace().newName(name3);
            if (!this.isClock(expr.tpe())) {
                this.insertDummyAssignsForMemoryOutputs(expr);
                this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name3), info)}));
                BVExpr e = this.onExpression(expr, name3);
                this.nodes().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{name3}));
                this.connects().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, BVExpr>(name3, e)}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            Info info = defRegister.info();
            String name4 = defRegister.name();
            Type tpe = defRegister.tpe();
            Expression reset = defRegister.reset();
            Expression init = defRegister.init();
            this.namespace().newName(name4);
            this.insertDummyAssignsForMemoryOutputs(reset);
            this.insertDummyAssignsForMemoryOutputs(init);
            this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name4), info)}));
            int width = FirrtlExpressionSemantics$.MODULE$.getWidth(tpe);
            BVExpr resetExpr = this.onExpression(reset, 1, new StringBuilder(6).append(name4).append("_reset").toString());
            BVExpr initExpr = this.onExpression(init, width, new StringBuilder(5).append(name4).append("_init").toString());
            this.registers().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4<String, Integer, BVExpr, BVExpr>(name4, BoxesRunTime.boxToInteger(width), resetExpr, initExpr)}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            this.namespace().newName(defMemory.name());
            this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(defMemory.name()), defMemory.info())}));
            Iterable<String> outputs = this.getMemOutputs(defMemory);
            ((IterableLike)this.getMemInputs(defMemory).$plus$plus(outputs, Iterable$.MODULE$.canBuildFrom())).foreach((Function1<String, Object> & Serializable & scala.Serializable)x$17 -> {
                ModuleScanner.$anonfun$onStatement$1(this, x$17);
                return BoxedUnit.UNIT;
            });
            int dataWidth = FirrtlExpressionSemantics$.MODULE$.getWidth(defMemory.dataType());
            outputs.foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
                ModuleScanner.$anonfun$onStatement$2(this, dataWidth, name);
                return BoxedUnit.UNIT;
            });
            this.memories().append(Predef$.MODULE$.wrapRefArray((Object[])new DefMemory[]{defMemory}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Connect) {
            BoxedUnit boxedUnit;
            Connect connect = (Connect)statement;
            Info info = connect.info();
            Expression loc = connect.loc();
            Expression expr = connect.expr();
            if (!this.isGroundType(loc.tpe())) {
                this.error("All connects should have been lowered to ground type!");
            }
            if (!this.isClock(loc.tpe())) {
                String name5 = loc.serialize();
                this.insertDummyAssignsForMemoryOutputs(expr);
                this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name5), info)}));
                this.connects().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, BVExpr>(name5, this.onExpression(expr, FirrtlExpressionSemantics$.MODULE$.getWidth(loc.tpe()), name5))}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            Info info = isInvalid.info();
            Expression loc = isInvalid.expr();
            if (!this.isGroundType(loc.tpe())) {
                this.error("All connects should have been lowered to ground type!");
            }
            String name6 = loc.serialize();
            this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name6), info)}));
            this.connects().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, BVExpr>(name6, this.firrtl$backends$experimental$smt$ModuleScanner$$makeRandom.apply(new StringBuilder(8).append(name6).append("_INVALID").toString(), BoxesRunTime.boxToInteger(FirrtlExpressionSemantics$.MODULE$.getWidth(loc.tpe()))))}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefInstance) {
            DefInstance defInstance = (DefInstance)statement;
            Info info = defInstance.info();
            String name7 = defInstance.name();
            String module = defInstance.module();
            Type tpe = defInstance.tpe();
            this.namespace().newName(name7);
            if (!(tpe instanceof BundleType)) {
                this.error(new StringBuilder(35).append("Instance ").append(name7).append(" of ").append(module).append(" has an invalid type: ").append(tpe.serialize()).toString());
            }
            this.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(126).append("WARN: treating instance ").append(name7).append(" of ").append(module).append(" as blackbox. ").append("Please flatten your hierarchy if you want to include submodules in the formal model.").toString());
            Seq<Field> ports = ((BundleType)tpe).fields();
            ((IterableLike)ports.filterNot((Function1<Field, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean(this.isAsyncReset(p.tpe())))).foreach((Function1<Field, Object> & Serializable & scala.Serializable)p -> {
                Serializable serializable;
                if (!(p.tpe() instanceof GroundType)) {
                    this.error(new StringBuilder(40).append("Instance ").append(name7).append(" of ").append(module).append(" has an invalid port type: ").append(p).toString());
                }
                Orientation orientation = p.flip();
                Default$ default$ = Default$.MODULE$;
                boolean isOutput = !(orientation != null ? !orientation.equals(default$) : default$ != null);
                String pName = new StringBuilder(1).append(name7).append(".").append(p.name()).toString();
                this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pName), info)}));
                if (isOutput) {
                    if (this.isClock(p.tpe())) {
                        serializable = BoxesRunTime.boxToBoolean(this.clocks().add(pName));
                    } else {
                        this.inputs().append(Predef$.MODULE$.wrapRefArray((Object[])new BVSymbol[]{new BVSymbol(pName, FirrtlExpressionSemantics$.MODULE$.getWidth(p.tpe()))}));
                        serializable = BoxedUnit.UNIT;
                    }
                } else if (!this.isClock(p.tpe())) {
                    this.outputs().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{pName}));
                    serializable = BoxedUnit.UNIT;
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                return serializable;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Verification) {
            BoxedUnit boxedUnit;
            Verification verification = (Verification)statement;
            Enumeration.Value op = verification.op();
            Info info = verification.info();
            Expression pred = verification.pred();
            Expression en = verification.en();
            StringLit msg = verification.msg();
            Enumeration.Value value = op;
            Enumeration.Value value2 = Formal$.MODULE$.Cover();
            if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
                this.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(35).append("WARN: Cover statement was ignored: ").append(verification.serialize()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.insertDummyAssignsForMemoryOutputs(pred);
                this.insertDummyAssignsForMemoryOutputs(en);
                String name8 = this.namespace().newName(this.msgToName(op.toString(), msg.string()));
                BVExpr predicate = this.onExpression(pred, new StringBuilder(10).append(name8).append("_predicate").toString());
                BVExpr enabled = this.onExpression(en, new StringBuilder(8).append(name8).append("_enabled").toString());
                BVImplies e = new BVImplies(enabled, predicate);
                this.infos().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name8), info)}));
                this.connects().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name8), e)}));
                Enumeration.Value value3 = op;
                Enumeration.Value value4 = Formal$.MODULE$.Assert();
                if (!(value3 != null ? !((Object)value3).equals(value4) : value4 != null)) {
                    this.asserts().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{name8}));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.assumes().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{name8}));
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else if (statement instanceof Conditionally) {
            Conditionally conditionally = (Conditionally)statement;
            this.error(new StringBuilder(59).append("When conditions are not supported. Please run ExpandWhens: ").append(conditionally.serialize()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof PartialConnect) {
            PartialConnect partialConnect = (PartialConnect)statement;
            this.error(new StringBuilder(62).append("PartialConnects are not supported. Please run ExpandConnects: ").append(partialConnect.serialize()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Attach) {
            Attach attach = (Attach)statement;
            this.error(new StringBuilder(51).append("Analog wires are not supported in the SMT backend: ").append(attach.serialize()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Stop) {
            Stop stop = (Stop)statement;
            this.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(61).append("WARN: Stop statements are currently not supported. Ignoring: ").append(stop.serialize()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Print) {
            Print print = (Print)statement;
            this.logger().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(52).append("WARN: Print statements are not supported. Ignoring: ").append(print.serialize()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            statement.foreachStmt((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
                this.onStatement(s);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private List<String> readInputFields() {
        return this.readInputFields;
    }

    private List<String> writeInputFields() {
        return this.writeInputFields;
    }

    private Iterable<String> getMemInputs(DefMemory m) {
        Predef$.MODULE$.assert(m.readwriters().isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Combined read/write ports are not supported!");
        String p = new StringBuilder(1).append(m.name()).append(".").toString();
        return ((TraversableLike)m.writers().flatMap((Function1<String, List> & Serializable & scala.Serializable)w -> this.writeInputFields().map((Function1<String, String> & Serializable & scala.Serializable)x$18 -> new StringBuilder(1).append(p).append((String)w).append(".").append((String)x$18).toString(), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus(m.readers().flatMap((Function1<String, List> & Serializable & scala.Serializable)r -> this.readInputFields().map((Function1<String, String> & Serializable & scala.Serializable)x$19 -> new StringBuilder(1).append(p).append((String)r).append(".").append((String)x$19).toString(), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    private Iterable<String> getMemOutputs(DefMemory m) {
        Predef$.MODULE$.assert(m.readwriters().isEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Combined read/write ports are not supported!");
        String p = new StringBuilder(1).append(m.name()).append(".").toString();
        return m.readers().map((Function1<String, String> & Serializable & scala.Serializable)r -> new StringBuilder(5).append(p).append((String)r).append(".data").toString(), Seq$.MODULE$.canBuildFrom());
    }

    private void insertDummyAssignsForMemoryOutputs(Expression next) {
        block1: {
            if (!this.unusedMemOutputs().nonEmpty()) break block1;
            ArrayBuffer uses = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
            this.findUnusedMemoryOutputUse(next, uses);
            if (uses.nonEmpty()) {
                GenSet useSet = uses.toSet();
                this.unusedMemOutputs().foreach(arg_0 -> ModuleScanner.$anonfun$insertDummyAssignsForMemoryOutputs$1$adapted(this, (Set)useSet, arg_0));
                useSet.foreach((Function1<String, Option> & Serializable & scala.Serializable)name -> this.unusedMemOutputs().remove((String)name));
            }
        }
    }

    private void findUnusedMemoryOutputUse(Expression e2, ArrayBuffer<String> uses) {
        Expression expression = e2;
        if (expression instanceof SubField) {
            BoxedUnit boxedUnit;
            SubField subField = (SubField)expression;
            String name = subField.serialize();
            if (this.unusedMemOutputs().contains(name)) {
                uses.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            expression.foreachExpr((Function1<Expression, BoxedUnit>)(Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
                this.findUnusedMemoryOutputUse(e, uses);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private BVExpr onExpression(Expression e, int width, String randomPrefix) {
        Context ctx = new Context(this, randomPrefix);
        return FirrtlExpressionSemantics$.MODULE$.toSMT(e, width, false, ctx);
    }

    private BVExpr onExpression(Expression e, String randomPrefix) {
        Context ctx = new Context(this, randomPrefix);
        return FirrtlExpressionSemantics$.MODULE$.toSMT(e, ctx);
    }

    private String msgToName(String prefix, String msg) {
        return new StringBuilder(1).append(prefix).append("_").append(msg.replace(" ", "_").replace("|", "")).toString();
    }

    private void error(String msg) {
        throw new RuntimeException(msg);
    }

    private boolean isGroundType(Type tpe) {
        return tpe instanceof GroundType;
    }

    private boolean isClock(Type tpe) {
        Type type = tpe;
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    private boolean isAsyncReset(Type tpe) {
        Type type = tpe;
        AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
        return !(type != null ? !type.equals(asyncResetType$) : asyncResetType$ != null);
    }

    private final void Context$lzycompute$1() {
        ModuleScanner moduleScanner = this;
        synchronized (moduleScanner) {
            if (this.Context$module == null) {
                this.Context$module = new ModuleScanner$Context$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$onStatement$1(ModuleScanner $this, String x$17) {
        $this.memSignals().append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$17}));
    }

    public static final /* synthetic */ void $anonfun$onStatement$2(ModuleScanner $this, int dataWidth$1, String name) {
        $this.unusedMemOutputs().update(name, BoxesRunTime.boxToInteger(dataWidth$1));
    }

    public static final /* synthetic */ void $anonfun$insertDummyAssignsForMemoryOutputs$1(ModuleScanner $this, Set useSet$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            int width = tuple2._2$mcI$sp();
            if (useSet$1.contains(name)) {
                $this.connects().append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), new BVSymbol(name, width))}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public ModuleScanner(Function2<String, Object, BVExpr> makeRandom) {
        this.firrtl$backends$experimental$smt$ModuleScanner$$makeRandom = makeRandom;
        LazyLogging.$init$(this);
        this.inputs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.outputs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.clocks = (LinkedHashSet)LinkedHashSet$.MODULE$.apply(Nil$.MODULE$);
        this.wires = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.nodes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.memSignals = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.registers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.memories = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.connects = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.asserts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.assumes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.infos = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        this.unusedMemOutputs = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Nil$.MODULE$);
        this.namespace = Namespace$.MODULE$.apply(Namespace$.MODULE$.apply$default$1());
        this.readInputFields = new $colon$colon<Nothing$>((Nothing$)((Object)"en"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"addr"), Nil$.MODULE$));
        this.writeInputFields = new $colon$colon<Nothing$>((Nothing$)((Object)"en"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"mask"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"addr"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"data"), Nil$.MODULE$))));
    }

    public static final /* synthetic */ Object $anonfun$insertDummyAssignsForMemoryOutputs$1$adapted(ModuleScanner $this, Set useSet$1, Tuple2 x0$1) {
        ModuleScanner.$anonfun$insertDummyAssignsForMemoryOutputs$1($this, useSet$1, x0$1);
        return BoxedUnit.UNIT;
    }

    private class Context
    implements TranslationContext,
    Product,
    scala.Serializable {
        private final String baseName;
        public final /* synthetic */ ModuleScanner $outer;

        @Override
        public BVExpr getReference(String name, Type tpe) {
            return TranslationContext.getReference$(this, name, tpe);
        }

        @Override
        public BVExpr getRandom(Type tpe) {
            return TranslationContext.getRandom$(this, tpe);
        }

        public String baseName() {
            return this.baseName;
        }

        @Override
        public BVExpr getRandom(int width) {
            return this.firrtl$backends$experimental$smt$ModuleScanner$Context$$$outer().firrtl$backends$experimental$smt$ModuleScanner$$makeRandom.apply(this.baseName(), BoxesRunTime.boxToInteger(width));
        }

        public Context copy(String baseName) {
            return new Context(this.firrtl$backends$experimental$smt$ModuleScanner$Context$$$outer(), baseName);
        }

        public String copy$default$1() {
            return this.baseName();
        }

        @Override
        public String productPrefix() {
            return "Context";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.baseName();
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Context;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Context)) return false;
            if (((Context)object).firrtl$backends$experimental$smt$ModuleScanner$Context$$$outer() != this.firrtl$backends$experimental$smt$ModuleScanner$Context$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Context context = (Context)x$1;
            String string = this.baseName();
            String string2 = context.baseName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!context.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ModuleScanner firrtl$backends$experimental$smt$ModuleScanner$Context$$$outer() {
            return this.$outer;
        }

        public Context(ModuleScanner $outer, String baseName) {
            this.baseName = baseName;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TranslationContext.$init$(this);
            Product.$init$(this);
        }
    }
}

